/********************************************************************************
                                   QueryToolDoc.cpp
                               -------------------
           begin                : lun jui 14 19:50:56 CEST 2003
       copyright                : (C) 2003 by Thomas Silvi
           email                : thomas.silvi@laposte.net
*********************************************************************************/

/********************************************************************************
*                                                                               *
*   This file is part of the Escort Tools Suite program.                        *
*                                                                               *
*   Escort Tools Suite is free software; you can redistribute it and/or modify  *
*   it under the terms of the GNU General Public License as published by        *
*   the Free Software Foundation; either version 2 of the License, or           *
*   (at your option) any later version.                                         *
*                                                                               *
*   Escort Tools Suite is distributed in the hope that it will be useful,       *
*   but WITHOUT ANY WARRANTY; without even the implied warranty of              *
*   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the               *
*   GNU General Public License for more details.                                *
*                                                                               *
*   You should have received a copy of the GNU General Public License           *
*   along with Escort Tools Suite; if not, write to the Free Software           *
*   Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA   *
*                                                                               *
*********************************************************************************/

#include "QueryToolDoc.h"
#include "QueryTool.h"

#include <string.h>

#include <klocale.h>


QueryToolDoc::QueryToolDoc(QueryTool *pApp)
{
	app = pApp;
	name = "";
		
	engine = new QueryEngine();

}

QueryToolDoc::~QueryToolDoc()
{
	if (app!=0)
	{
		app->unregister(name);
		app = 0;
	}
	
	if (engine != 0)
	{
		delete engine;
		engine = 0;
	}
}

bool QueryToolDoc::connect(ConnectionParameters pCp, QString &pErrorMessage)
{
	// return true if no problem
	
    bool result;
    ConnStatusType cst;

    result = true;

    engine->connect(pCp, pErrorMessage);

    cst = engine->getConnectionState();

    switch (cst)
    {
		case CONNECTION_OK :
		{
			result = true;
			break;
		}
		case CONNECTION_BAD :
		{
			result = false;
			break;
		}
		default :
		{
			result = false;
			break;
		}
    }
    
    if (result == true)
    {
		// document name = hostname:port:database:login
		
		QString sTmpId;
		
		sTmpId.setNum(pCp.getId());
		
		name = pCp.getHostName();
		
		if (name.isEmpty())
		{
			name = pCp.getHostAddr();
		}
		
		name += ":" + pCp.getPort() + ":"
			+ pCp.getDatabase() + ":" + pCp.getLogin() + ":" + sTmpId;
    }

    return result;
}

void QueryToolDoc::disconnect()
{
	if (engine == 0)
	{
		return;
	}

	engine->disconnect();
	
	return;
}

QString QueryToolDoc::getName() const
{
	return name;
}

QueryTool * QueryToolDoc::getApp()
{
	return app;
}

QueryEngine * QueryToolDoc::getEngine()
{
	return engine;
}


