/********************************************************************************
                                   QueryToolView.h
                               -------------------
           begin                : lun jui 14 19:50:56 CEST 2003
       copyright                : (C) 2003 by Thomas Silvi
           email                : thomas.silvi@laposte.net
*********************************************************************************/

/********************************************************************************
*                                                                               *
*   This file is part of the Escort Tools Suite program.                        *
*                                                                               *
*   Escort Tools Suite is free software; you can redistribute it and/or modify  *
*   it under the terms of the GNU General Public License as published by        *
*   the Free Software Foundation; either version 2 of the License, or           *
*   (at your option) any later version.                                         *
*                                                                               *
*   Escort Tools Suite is distributed in the hope that it will be useful,       *
*   but WITHOUT ANY WARRANTY; without even the implied warranty of              *
*   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the               *
*   GNU General Public License for more details.                                *
*                                                                               *
*   You should have received a copy of the GNU General Public License           *
*   along with Escort Tools Suite; if not, write to the Free Software           *
*   Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA   *
*                                                                               *
*********************************************************************************/

#ifndef QUERY_TOOL_VIEW_H
#define QUERY_TOOL_VIEW_H

#include "QueryToolDoc.h"
#include "TextEditQuery.h"
#include "BatchExecutorThread.h"
#include "OutputView.h"
#include "QueryToolViewConfig.h"

#include <libpq-fe.h>

#include <qwidget.h>
#include <qframe.h>
#include <qvbox.h>
#include <qtabwidget.h>
#include <qdatetime.h>

#include <ktextedit.h>
#include <klineedit.h>

class QueryToolView : public QVBox
{
	Q_OBJECT
	
	public:

	QueryToolView(QueryToolDoc* pDoc, QWidget* pParent, const char *pName, int pWflags);
	~QueryToolView();
	
	QueryToolDoc *getDocument() const;
	void setDocument(QueryToolDoc *pDoc);
	void openInput(QString &pDirectory, QString &pFileName);
	void saveInput(QString &pDirectory, QString &pFileName);
	void saveOutput(QString &pDirectory, QString &pFileName);
	QString getDirectoryOpen();
	QString getFileNameOpenInput();
	QString getDirectorySaveInput();
	QString getFileNameSaveInput();
	QString getDirectorySaveOutput();
	QString getFileNameSaveOutput();
	signed char getActiveTab();
	void setApp(KApplication *pApp);
	bool isBatchRunning();
	QDateTime getCreationDate() const;
	QueryToolViewConfig * getQueryToolViewConfig() const;
	void applyQueryToolViewConfig (QueryToolViewConfig * pViewConfig);
	bool askIfDisconnect();
	
	public slots:
	
	void executeInput();
	void notice(QString &pMessage);
	void initOutput();
	void initNoticeMessages();
	void switchToInput();
	void switchToOutput();
	void switchToNoticeMessages();
	void switchView();
	void stopBatch();
	void setStatusBarMsg(QString pMsg);
	void showResuts(PGresult *pResults);
	void printOutput(QString pStr);
	void batchExecuted();

	protected:

	void resetOutput();
	void resetNoticeMessages();
	void closeEvent(QCloseEvent *pEvent);

	bool batchIsBeingExecuted;
	QueryToolDoc *doc;
	BatchExecutorThread *batchExecutor;
	QTabWidget *tw_queryIO;
	TextEditQuery *queryInput;
	OutputView *queryOutput;
	KTextEdit *noticeMessages;
	KLineEdit *statusBarMesg;
	QString directoryOpen;
	QString fileNameOpenInput;
	QString directorySaveInput;
	QString fileNameSaveInput;
	QString directorySaveOutput;
	QString fileNameSaveOutput;
	KApplication *app;
	QDateTime creationDate;
	
};

void globalNoticeProcessor(void *arg, const char *message);

#endif
