# /* Robert Meolic, 27. 7. 2005 */
# /* Ph.D. */

set dir [pwd]; cd ../circuits; source init.tcl; cd $dir
ccs_read dme-martin.ccs

# -----------------------------------------------

outline ""
outline "=============================="
outline "CREATE ABSTRACTED PROCESSES"
outline "=============================="
outline ""

pa_copy_process DME-false ABS-DME-false-ua NULL "la rr" "tau tau"
pa_copy_process DME-false ABS-DME-false-la NULL "ua rr" "tau tau"
pa_copy_process DME-false ABS-DME-false-rr NULL "ua la" "tau tau"

pa_copy_process DME-true ABS-DME-true-ua NULL "la rr" "tau tau"
pa_copy_process DME-true ABS-DME-true-la NULL "ua rr" "tau tau"
pa_copy_process DME-true ABS-DME-true-rr NULL "ua la" "tau tau"

pa_encode_process "ABS-DME-false-ua"
pa_encode_process "ABS-DME-false-la"
pa_encode_process "ABS-DME-false-rr"

pa_encode_process "ABS-DME-true-ua"
pa_encode_process "ABS-DME-true-la"
pa_encode_process "ABS-DME-true-rr"

versis_trace_minimization 0 ABS-DME-false-ua
versis_trace_minimization 0 ABS-DME-false-la
versis_trace_minimization 0 ABS-DME-false-rr

versis_trace_minimization 0 ABS-DME-true-ua
versis_trace_minimization 0 ABS-DME-true-la
versis_trace_minimization 0 ABS-DME-true-rr

pa_copy_process TRACE_ABS-DME-false-ua DME-false-ua NULL "" ""
pa_copy_process TRACE_ABS-DME-false-la DME-false-la NULL "" ""
pa_copy_process TRACE_ABS-DME-false-rr DME-false-rr NULL "" ""

pa_copy_process TRACE_ABS-DME-true-ua DME-true-ua NULL "" ""
pa_copy_process TRACE_ABS-DME-true-la DME-true-la NULL "" ""
pa_copy_process TRACE_ABS-DME-true-rr DME-true-rr NULL "" ""

pa_encode_process "DME-false-ua"
pa_encode_process "DME-false-la"
pa_encode_process "DME-false-rr"

pa_encode_process "DME-true-ua"
pa_encode_process "DME-true-la"
pa_encode_process "DME-true-rr"

# -----------------------------------------------

outline ""
outline "======================"
outline "INFO ABOUT PROCESSES"
outline "======================"
outline ""

pa_encode_process "DME-false DME-true"
pa_encode_process "C-00 RSQB-000 RSQB-001 MEZ-000"

outline "C element has [pa_state_number C-00] states / [pa_transition_number C-00] transitions / [bdd_node_number D_C-00] BDD nodes."
outline "RS flip-flop-false has [pa_state_number RSQB-000] states / [pa_transition_number RSQB-000] transitions / [bdd_node_number D_RSQB-000] BDD nodes."
outline "RS flip-flop-true has [pa_state_number RSQB-001] states / [pa_transition_number RSQB-001] transitions / [bdd_node_number D_RSQB-001] BDD nodes."
outline "MEz element has [pa_state_number MEZ-000] states / [pa_transition_number MEZ-000] transitions / [bdd_node_number D_MEZ-000] BDD nodes."
outline ""
outline "DME-false has [pa_state_number DME-false] states / [pa_transition_number DME-false] transitions / [bdd_node_number D_DME-false] BDD nodes."
outline "DME-true has [pa_state_number DME-true] states / [pa_transition_number DME-true] transitions / [bdd_node_number D_DME-true] BDD nodes."
outline ""
outline "DME-false-ua has [pa_state_number DME-false-ua] states / [pa_transition_number DME-false-ua] transitions / [bdd_node_number D_DME-false-ua] BDD nodes."
outline "DME-false-la has [pa_state_number DME-false-la] states / [pa_transition_number DME-false-la] transitions / [bdd_node_number D_DME-false-la] BDD nodes."
outline "DME-false-rr has [pa_state_number DME-false-rr] states / [pa_transition_number DME-false-rr] transitions / [bdd_node_number D_DME-false-rr] BDD nodes."
outline "DME-true-ua has [pa_state_number DME-true-ua] states / [pa_transition_number DME-true-ua] transitions / [bdd_node_number D_DME-true-ua] BDD nodes."
outline "DME-true-la has [pa_state_number DME-true-la] states / [pa_transition_number DME-true-la] transitions / [bdd_node_number D_DME-true-la] BDD nodes."
outline "DME-true-rr has [pa_state_number DME-true-rr] states / [pa_transition_number DME-true-rr] transitions / [bdd_node_number D_DME-true-rr] BDD nodes."
outline ""

# -----------------------------------------------

outline "==========================================="
outline "LOOKING FOR HAZARDS in DME-false on line UA"
outline "==========================================="
outline ""

mc_check_actl_file 0 DME-false-ua "dme-cell-static.actl"
mc_check_actl_file 0 DME-false-ua "dme-cell-dynamic.actl"
mc_check_actl_file 0 DME-false-ua "dme-cell-steady.actl"

# -----------------------------------------------

outline "==========================================="
outline "LOOKING FOR HAZARDS in DME-false on line LA"
outline "==========================================="
outline ""

mc_check_actl_file 0 DME-false-la "dme-cell-static.actl"
mc_check_actl_file 0 DME-false-la "dme-cell-dynamic.actl"
mc_check_actl_file 0 DME-false-la "dme-cell-steady.actl"

# -----------------------------------------------

outline "==========================================="
outline "LOOKING FOR HAZARDS in DME-false on line RR"
outline "==========================================="
outline ""

mc_check_actl_file 0 DME-false-rr "dme-cell-static.actl"
mc_check_actl_file 0 DME-false-rr "dme-cell-dynamic.actl"
mc_check_actl_file 0 DME-false-rr "dme-cell-steady.actl"

# -----------------------------------------------

outline "==========================================="
outline "LOOKING FOR HAZARDS in DME-true on line UA"
outline "==========================================="
outline ""

mc_check_actl_file 0 DME-true-ua "dme-cell-static.actl"
mc_check_actl_file 0 DME-true-ua "dme-cell-dynamic.actl"
mc_check_actl_file 0 DME-true-ua "dme-cell-steady.actl"

# -----------------------------------------------

outline "==========================================="
outline "LOOKING FOR HAZARDS in DME-true on line LA"
outline "==========================================="
outline ""

mc_check_actl_file 0 DME-true-la "dme-cell-static.actl"
mc_check_actl_file 0 DME-true-la "dme-cell-dynamic.actl"
mc_check_actl_file 0 DME-true-la "dme-cell-steady.actl"

# -----------------------------------------------

outline "==========================================="
outline "LOOKING FOR HAZARDS in DME-true on line RR"
outline "==========================================="
outline ""

mc_check_actl_file 0 DME-true-rr "dme-cell-static.actl"
mc_check_actl_file 0 DME-true-rr "dme-cell-dynamic.actl"
mc_check_actl_file 0 DME-true-rr "dme-cell-steady.actl"
