/**CFile*******************************************************************
  PackageName [pa]
  Synopsis    [Package 'pa' is a framework for implementation of
               process algebrae similar to Milner's CCS and Hoare's CSP.]

  FileName    [paParser.l]
  Revision    [$Revision: 53 $]
  Date        [$Date: 2012-05-16 11:42:47 +0200 (sre, 16 maj 2012) $]
  Authors     [Robert Meolic (meolic@uni-mb.si)]
  Description [File paParser.l is a flex file of parser for textual
               description of LTSs.]
  SeeAlso     [pa.h, paInt.h, paParser.y]

  Copyright   [This file is part of EST (Efficient Symbolic Tools).
               Copyright (C) 2003, 2012
               UM-FERI, Smetanova ulica 17, SI-2000 Maribor, Slovenia

               EST is free software; you can redistribute it and/or modify
               it under the terms of the GNU General Public License as
               published by the Free Software Foundation; either version 2
               of the License, or (at your option) any later version.

               EST is distributed in the hope that it will be useful,
               but WITHOUT ANY WARRANTY; without even the implied warranty of
               MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
               GNU General Public License for more details.

               You should have received a copy of the GNU General Public
               License along with this program; if not, write to the Free
               Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
               Boston, MA 02110-1301 USA.]
  ************************************************************************/

PROCESS         process|Process|PROCESS
SORT            sort|Sort|SORT
TRANSITIONS     transitions|Transitions|TRANSITIONS
INITIAL_STATE	("Initial"[ \t]*"state")|("initial"([ \t]*)"state")|("INITIAL"[ \t]*"STATE")
FINAL_STATES	("Final"[ \t]*"states")|("final"([ \t]*)"states")|("FINAL"[ \t]*"STATES")

NAME            [-_A-Za-z0-9][-_A-Za-z0-9]*
ACTION          {NAME}[?!]|"tau"|"Tau"|"TAU"

OUTLINE 	#.*

%%
  int ch, inComm;

"/*"              { for(inComm=1; inComm; )
                    { switch(ch=input())
 			{ case '\n' : break;
			  case '*'  : if (( ch=input()) == '/')
					inComm=0;
				      else  unput(ch);
				break;
                        }
                    }
                  }

[ ]	          {/* preskok praznih mest */}

[\t\n\r]       	  {/* preskok praznega prostora */}

"'"	          {/* qoutes are ignored */}

"\""	          {/* qoutes are ignored */}

{INITIAL_STATE}	  {return INITIAL_STATE;}

{FINAL_STATES}	  {return FINAL_STATES;}

{PROCESS}         {return PROCESS;}

{SORT}            {return SORT;}

{TRANSITIONS}     {return TRANSITIONS;}

GATES             {return GATES;}

ACTIONS           {return ACTIONS;}

{ACTION}	  {
                   yylval.word = strdup(yytext);
                   return ACTION;
                  }

{NAME}		  {
                   yylval.word = strdup(yytext);
                   return NAME;
                  }

","	          {return yytext[0];}
"."	          {return yytext[0];}
"+"	          {return yytext[0];}
"="	          {return yytext[0];}

{OUTLINE}	  {
                   yylval.word = strdup(yytext);
                   return OUTLINE;
                  }

.                 {
                   return UNKNOWN;
                  }
%%
