/**CHeaderFile*************************************************************
  PackageName [strucval]
  Synopsis    [Structure-driven validation of hardware and software systems]

  FileName    [strucvalInt.h]
  Revision    [$Revision: 76 $]
  Date        [$Date: 2013-04-26 14:26:09 +0200 (pet, 26 apr 2013) $]
  Authors     [Robert Meolic (meolic@uni-mb.si)]
  Description [File strucvalInt.h contains declaration of all internal
               data structures.]
  SeeAlso     [strucval.h]

  Copyright   [This file is part of EST (Efficient Symbolic Tools).
               Copyright (C) 2003, 2013
               UM-FERI, Smetanova ulica 17, SI-2000 Maribor, Slovenia

               EST is free software; you can redistribute it and/or modify
               it under the terms of the GNU General Public License as
               published by the Free Software Foundation; either version 2
               of the License, or (at your option) any later version.

               EST is distributed in the hope that it will be useful,
               but WITHOUT ANY WARRANTY; without even the implied warranty of
               MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
               GNU General Public License for more details.

               You should have received a copy of the GNU General Public
               License along with this program; if not, write to the Free
               Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
               Boston, MA 02110-1301 USA.]
  ************************************************************************/

#ifndef _STRUCVALINT
#define _STRUCVALINT

#include "strucval.h"

#ifdef USE_BDD_STUBS
#  include <bddDecls.h>
#endif

#ifdef USE_PA_STUBS
#  include <paDecls.h>
#endif

#ifdef USE_VERSIS_STUBS
#  include <versisDecls.h>
#endif

#ifdef USE_MC_STUBS
#  include <mcDecls.h>
#endif

#ifdef TCLOUT
#  include <gui.h>
#  define printf Gui_Printf
#  ifdef USE_GUI_STUBS
#    include <guiDecls.h>
#  endif
#endif

/*-----------------------------------------------------------------------*/
/* Constant declarations                                                 */
/*-----------------------------------------------------------------------*/

/*-----------------------------------------------------------------------*/
/* Structure declarations                                                */
/*-----------------------------------------------------------------------*/

/*-----------------------------------------------------------------------*/
/* Variable declarations                                                 */
/*-----------------------------------------------------------------------*/

/**AutomaticStart*********************************************************/

/*-----------------------------------------------------------------------*/
/* Function prototypes                                                   */
/*-----------------------------------------------------------------------*/

extern void Strucval_SyncProduct_Thr(Est_String name, Est_String lts,
				 Est_String wca, Est_String actions);

extern void StrucvalReduceStates(Pa_Composition *c, Bdd_Edge finalBddWCA);

/**AutomaticEnd***********************************************************/

#endif  /* _STRUCVALINT */
