/*
 * Decompiled with CFR 0.152.
 */
package org.natto;

import java.io.File;
import java.io.FileInputStream;
import java.lang.reflect.Constructor;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Properties;
import java.util.Set;
import org.natto.ExecSecurity;
import org.natto.GenGui;
import org.natto.Infofiles;
import org.natto.PoliteScheduler;
import org.natto.PrefPrograms;
import org.natto.StaticTools;
import org.natto.Task;
import org.natto.TaskExecution;
import org.natto.TextGui;
import org.natto.jobDescription;

public class Executor {
    private static String myVer = "0.77";
    private static String myDirectory = "";
    private static int interval = 5000;
    private static int writeAfter = 6;
    private static int maxAge = 300;
    private List currentJobs = new ArrayList();
    private List submittedJobs = new ArrayList();
    private int maxRunning = 1;
    private static String myId = "";
    private static HashMap infos = null;
    private static GenGui onGui = null;
    private static Infofiles myInfof = null;

    public static void main(String[] args) {
        Executor myExe = null;
        boolean optsOK = false;
        if (args.length == 0) {
            optsOK = true;
            myExe = new Executor(true);
            myExe.start(true);
        }
        if (args.length == 2) {
            String optiOn = args[0];
            String fileName = args[1];
            if (optiOn.equals("-H") || optiOn.equals("-C")) {
                optsOK = true;
                boolean coreCount = false;
                if (optiOn.equals("-C")) {
                    coreCount = true;
                }
                myExe = new Executor(false);
                String[] suiTables = myExe.getIdsSuitableForTask(fileName, coreCount);
                for (int i = 0; i < suiTables.length; ++i) {
                    System.out.println(suiTables[i]);
                }
            } else if (optiOn.equals("-S")) {
                myExe = new Executor(false);
                myExe.start(false);
                myExe.submitTask(fileName, "", fileName);
            }
        }
        if (!optsOK) {
            System.err.println("Invalid parameters. This program supports \n-H filename list hosts that can execute filename\n-C filename list cores that can execute filename\n-S filename submit task");
        }
    }

    public static String getId() {
        return myId;
    }

    public String[] getIdsSuitableForTask(String exTension, boolean coreWeigth) {
        ArrayList<String> okItems = new ArrayList<String>();
        if (exTension == null || "".equals(exTension)) {
            return new String[0];
        }
        if (infos == null) {
            System.err.println("Your infofile data is null. Please check that you have executed checkInfoFiles.");
            return new String[0];
        }
        if (infos.isEmpty()) {
            System.err.println("Your infofile data is empty. Maybe you are not running any executors in this directory.");
            return new String[0];
        }
        int dotPos = exTension.lastIndexOf(".");
        if (dotPos > -1) {
            exTension = exTension.substring(dotPos);
        }
        Set keySet = infos.keySet();
        for (String fName : keySet) {
            Properties myProp = (Properties)infos.get(fName);
            if (!myProp.containsKey(exTension)) continue;
            if (coreWeigth) {
                String coresStr = myProp.getProperty("cores", "0");
                int cores = Integer.parseInt(coresStr);
                String tasksStr = myProp.getProperty("tasks", "0");
                int tasks = Integer.parseInt(tasksStr);
                for (int i = 0; i < cores - tasks; ++i) {
                    okItems.add(fName);
                }
                continue;
            }
            okItems.add(fName);
        }
        String[] myArray = new String[okItems.size()];
        okItems.toArray(myArray);
        return myArray;
    }

    public String submitTask(String myFileName, String myCmd, String taskName) {
        jobDescription newJobDesc = new jobDescription(myDirectory);
        File file1 = new File(myFileName);
        if (!file1.canRead()) {
            return "File does not exists or it is not readable.";
        }
        return newJobDesc.writeJobDescription(file1, null, null, infos, "", myCmd);
    }

    public Executor(boolean useGUI) {
        new Executor(useGUI, null);
    }

    public Executor(boolean useGUI, String useThisDir) {
        String thisdir = useThisDir;
        String myName = "Executor";
        if (useThisDir == null) {
            try {
                File jarFile = new File(Executor.class.getProtectionDomain().getCodeSource().getLocation().toURI().getPath());
                thisdir = jarFile.getParent();
                String tmpName = jarFile.getName();
                if (tmpName.indexOf(".jar") > 0) {
                    myName = myName.replace(".jar", "");
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        myDirectory = thisdir;
        onGui = new TextGui(myName + " " + myVer, thisdir);
        if (useGUI) {
            try {
                Class<?> myGuiClass = Class.forName("org.natto.swingGUI.MainGui");
                Constructor<?> guiConst = myGuiClass.getConstructor(String.class, String.class);
                onGui = (GenGui)guiConst.newInstance(myName + " " + myVer, thisdir);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        myInfof = new Infofiles();
        infos = Infofiles.checkInfoFiles(thisdir, "", maxAge);
    }

    public void start(boolean runLoop) {
        onGui.setMessage("Please wait while we look for command line programs.");
        String userHome = System.getProperty("user.home");
        String exPropName = userHome + "/.executor.preferences";
        HashMap supportedPrgs = PrefPrograms.getSupportedPrograms(exPropName);
        System.out.println(supportedPrgs.size() + " applications supported by this node.");
        onGui.setMessage("");
        if (runLoop) {
            this.execLoop(myDirectory, supportedPrgs);
        } else {
            myInfof.writeInfoFile(myDirectory, 0, supportedPrgs);
            infos = Infofiles.checkInfoFiles(myDirectory, "", maxAge);
            System.out.println();
        }
    }

    public void execLoop(String thisdir, HashMap prgs) {
        int oldNumInfos = 0;
        int roundsSinceWrite = 0;
        boolean goOn = true;
        String iFname = null;
        ExecSecurity mySecurity = ExecSecurity.getInstance();
        while (goOn) {
            boolean securityOn = mySecurity.securityOn();
            onGui.setMessage("");
            if (roundsSinceWrite == writeAfter) {
                roundsSinceWrite = 0;
            }
            if (roundsSinceWrite == 0) {
                int numJobsThatIrun = this.currentJobs.size();
                iFname = myInfof.writeInfoFile(thisdir, numJobsThatIrun, prgs);
            }
            myId = iFname;
            if (iFname == null) {
                onGui.setMessage("Fatal: Cannot write info file.");
                goOn = false;
            }
            ++roundsSinceWrite;
            String mySecId = mySecurity.getMyIdentity();
            infos = Infofiles.checkInfoFiles(thisdir, mySecId, maxAge);
            Properties myOwnInfo = (Properties)infos.get(iFname);
            this.maxRunning = Integer.parseInt(myOwnInfo.getProperty("cores", "1"));
            long cores = myInfof.getInfoNumProperty(infos, "cores");
            if (infos.size() != oldNumInfos) {
                onGui.doTell(infos.size() + " hosts and " + cores + " cores available.");
                oldNumInfos = infos.size();
                System.out.println("myinfo " + myOwnInfo);
            }
            onGui.updateInfosActivate(infos);
            this.checkRunningJobs(thisdir);
            File file = new File(thisdir);
            File[] files = file.listFiles();
            for (int i = 0; i < files.length; ++i) {
                Thread inProcessing;
                String fn = files[i].getName();
                if (fn.endsWith(".run")) {
                    TaskExecution.notifyAboutSubmittedJobs(myId, interval, thisdir, fn, onGui, securityOn);
                }
                if (!fn.endsWith(".jd") && !fn.endsWith(".jd.asc") || securityOn && fn.endsWith(".jd")) continue;
                int extLen = 3;
                if (fn.endsWith(".jd.asc")) {
                    extLen = 7;
                }
                String baseName = fn.substring(0, fn.length() - extLen);
                String rfName = baseName + ".run";
                Task onDiskTask = new Task(thisdir + "/" + rfName);
                if (onDiskTask.getStatus() != Task.IDLE || this.currentJobs.size() >= this.maxRunning) continue;
                if (mySecurity.securityOn()) {
                    String verifyErr = mySecurity.verifySignature(thisdir + "/" + fn);
                    if (!verifyErr.equals("")) {
                        onGui.setMessage(fn + "\ncannot verify");
                        continue;
                    }
                    onGui.setMessage(fn + " signature ok");
                }
                if ((inProcessing = this.checkStartJdFile(fn, thisdir, myId, infos)) == null) continue;
                Task currentJob = new Task(thisdir + "/" + rfName, inProcessing, myId);
                this.currentJobs.add(currentJob);
            }
            try {
                Thread.sleep(interval);
            }
            catch (InterruptedException ex) {
                ex.printStackTrace();
            }
        }
    }

    void checkRunningJobs(String jobDir) {
        for (int i = 0; i < this.currentJobs.size(); ++i) {
            Task currentJob = (Task)this.currentJobs.get(i);
            int jobStat = currentJob.getStatus();
            if (jobStat != Task.DONE && jobStat != Task.NOTIFIED) continue;
            this.currentJobs.remove(i);
        }
    }

    Thread checkStartJdFile(String jdFname, String thisdir, String myId, HashMap infos) {
        boolean okTotake;
        Properties myOwnInfo = (Properties)infos.get(myId);
        ValidatedJd checkedJd = this.canRunJobDescription(jdFname, thisdir, myOwnInfo);
        String jobTarget = checkedJd.target;
        if (!"".equals(jobTarget)) {
            System.out.println("I am " + myId + " target is " + jobTarget);
            okTotake = jobTarget.equalsIgnoreCase(myId);
        } else {
            okTotake = PoliteScheduler.yesIshouldTakeit(jdFname, myId, infos);
        }
        if (okTotake) {
            int dotJdpos = jdFname.indexOf(".jd");
            if (dotJdpos < 0) {
                return null;
            }
            String baseName = jdFname.substring(0, dotJdpos);
            if (checkedJd.retval == JdRetType.JD_OK) {
                return Executor.uncompressExecuteValidJd(thisdir, checkedJd, baseName);
            }
        }
        return null;
    }

    ValidatedJd canRunJobDescription(String fname, String thisdir, Properties myProps) {
        File jobfile = new File(thisdir, fname);
        if (!jobfile.exists() || !jobfile.canRead()) {
            System.out.println("File " + fname + " not there or readable.");
            return new ValidatedJd(JdRetType.JD_READ_ERROR, "", "", "", "", "", "");
        }
        Properties jobProp = new Properties();
        try {
            jobProp.load(new FileInputStream(jobfile));
        }
        catch (Exception e) {
            e.printStackTrace();
            System.out.println("Reading the job description file failed.");
            System.out.println(e.getMessage());
            return new ValidatedJd(JdRetType.JD_READ_ERROR, "", "", "", "", "", "");
        }
        String binaryf = jobProp.getProperty("binaryinputfilename");
        if (binaryf == null) {
            System.out.println("binaryinputfilename property missing");
            return new ValidatedJd(JdRetType.JD_FORMAT_ERROR, "", "", "", "", "", "");
        }
        String cmdLine = jobProp.getProperty("workercommandline");
        if (cmdLine == null) {
            System.out.println("workercommandline property missing");
            return new ValidatedJd(JdRetType.JD_FORMAT_ERROR, "", "", "", "", "", "");
        }
        if (!cmdLine.startsWith("INTERNAL")) {
            cmdLine = Executor.getFullCmd(cmdLine, thisdir, binaryf, myProps);
        }
        if (cmdLine.equals("")) {
            System.out.println("Could not run job. Maybe this system has no program to handle file " + binaryf);
            return new ValidatedJd(JdRetType.CANNOT_HANDLE, "", "", "", "", "", "");
        }
        String dataf = jobProp.getProperty("datainputfilename");
        String args = jobProp.getProperty("arguments");
        String clientId = jobProp.getProperty("clientid");
        String targetId = jobProp.getProperty("targethost");
        if (targetId == null) {
            targetId = "";
        }
        return new ValidatedJd(JdRetType.JD_OK, clientId, binaryf, dataf, cmdLine, args, targetId);
    }

    static String getFullCmd(String cmd, String myDir, String binFileN, Properties myProps) {
        if (StaticTools.fileIsELF(myDir + "/" + binFileN)) {
            String osName = System.getProperty("os.name");
            if (osName.startsWith("Linux")) {
                return cmd;
            }
            return "";
        }
        String prgPath = "";
        try {
            int dotPos = binFileN.indexOf(".");
            String binExt = binFileN.substring(dotPos, binFileN.length());
            if (myProps == null) {
                System.out.println("No properties. This should not happen.");
                return "";
            }
            String prgInfo = myProps.getProperty(binExt);
            if (prgInfo == null) {
                return "";
            }
            int spacePos = prgInfo.indexOf(" ");
            if (spacePos > -1) {
                prgPath = prgInfo.substring(spacePos + 1, prgInfo.length());
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return prgPath;
    }

    static Thread uncompressExecuteValidJd(String dir, ValidatedJd myJd, String outBase) {
        String binfn = myJd.binary;
        String datafn = myJd.data;
        String cmd = myJd.cmd;
        String args = myJd.args;
        String[] filesinZips = new String[]{};
        if (binfn.toLowerCase().endsWith(".zip")) {
            filesinZips = Executor.checkUnzipFileStr(dir, binfn);
        }
        if (filesinZips == null) {
            return null;
        }
        if (datafn != null && datafn.toLowerCase().endsWith(".zip")) {
            filesinZips = Executor.checkUnzipFileStr(dir, datafn);
        }
        return TaskExecution.execCommand(dir, cmd, binfn, args, outBase, interval, myId);
    }

    private static String[] checkUnzipFileStr(String dir, String semicSep) {
        ArrayList<String> combinedZipFileList = new ArrayList<String>();
        if (semicSep == null || "".equals(semicSep.trim())) {
            return new String[0];
        }
        String[] myFilenames = semicSep.split(";");
        for (int i = 0; i < myFilenames.length; ++i) {
            File myFile = new File(dir + "/" + myFilenames[i]);
            if (!myFile.exists()) {
                System.out.println("File " + myFilenames[i] + " not in " + dir);
                return null;
            }
            String[] filesInZip = StaticTools.unZip(dir + "/" + myFilenames[i]);
            combinedZipFileList.addAll(Arrays.asList(filesInZip));
        }
        return combinedZipFileList.toArray(new String[0]);
    }

    class ValidatedJd {
        private JdRetType retval;
        private String client = "";
        private String binary = "";
        private String data = "";
        private String cmd = "";
        private String args = "";
        private String target = "";

        ValidatedJd(JdRetType ret, String cli, String bin, String dat, String cm, String a, String t) {
            this.retval = ret;
            this.client = cli;
            this.binary = bin;
            this.data = dat;
            this.cmd = cm;
            this.args = a;
            this.target = t;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum JdRetType {
        CANNOT_HANDLE,
        JD_READ_ERROR,
        JD_FORMAT_ERROR,
        JD_OK;

    }
}

