"""Unittests for funcall.py"""

import unittest
import testmod
import lazyarray, objects, eval, funcall

class FuncallTest(unittest.TestCase):
	"""Test funcall.call"""
	def testAdd(self):
		"""Test adding an array to a scalar"""
		five = objects.ExNum(5)
		la = lazyarray.LazyArray(3)
		la.set_values_precomputed((objects.ExNum(1),
								   objects.ExNum(2),
								   objects.ExNum(6)))
		exa = objects.ExArray(la)
		
		result = funcall.call(eval.op_plus, (five, exa))
		assert result.len() == 3, result
		result_tuple = testmod.result_to_tuple(result)
		assert result_tuple == (6, 7, 11), result_tuple

if __name__ == '__main__': unittest.main()