/***************************************************************
 *                    simula+@metz.ensam.fr                    *
 *                   GNU/linux version 0.1.8                   *
 *            software under General Public License            *
 ***************************************************************
 * copyright  2002,2003,2004,2005,2006 CREUSE Emmanuel
 * copyright  2002,2003,2004,2005,2006 SOUALEM Nadir
 * copyright  Laboratoire de Physique et Mcanique des Matriaux (LPMM - UMR 7554)
 * copyright  Laboratoire de Mathmatiques et ses Applications de Valenciennes (LAMAV - EA 4015)
 ***************************************************************/

/*
    triangle-test belongs to Mathematical Object Libraries (FEMOL++)
    FEMOL++ is part of Simula+

    Simula+ is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    Simula+ is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with Simula+; if not, write to the Free Software
    Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
*/

#ifndef __cplusplus
#error Must use C++ for the type triangle-test.
#endif

#if !defined(__TRIANGLE_TEST_H)
#define _triangle_test_h

#if !defined(__IOSTREAM_H)
#include <iostream>
#endif

#if !defined(__STDIO_H)
#include <stdio.h>
#endif

#if !defined (__STDLIB_H)
#include <stdlib.h>
#endif

#if !defined(__TRIANGLE_H)
#include "../../../FEMOL++/meshes/triangle.h"
#endif

#if !defined(__AFFICHE_H)
#include "../../affiche.h"
#endif


//==========================
int test_triangle (int detail)
//==========================
{
  int result=1;
  triangle<int> A1,A2,A3;
  triangle<float> B1,B2,B3;
  triangle<double> C1,C2,C3;
  triangle<long double> D1,D2,D3,E1;
  node<int> O(2),A(2),B(2);
  node<float> C(2),D(2),E(2);
  node<double> F(2),G(2),H(2);
  node<long double> I(2),J(2),K(2);
  A[1]=1; B[1]=0;C[1]=0.3333; D[1]=-.567777;E[1]=5678.345;
  A[2]=0; B[2]=1;C[2]=0.0009; D[2]=-345.789;E[2]=3450.567;
  A.boundary_condition()=0;
  B.boundary_condition()=1;
  C.boundary_condition()=2;
  D.boundary_condition()=2;
  A.boundary_condition()=0;
  F[1]=1.123456; G[1]=0.000000145;H[1]=0.7777777777777;
  F[2]=0.456789; G[2]=-0.00000091;H[2]=0.9876546786709;
  F.boundary_condition()=0;
  G.boundary_condition()=1;
  H.boundary_condition()=1;
  I[1]=1.45e+06; J[1]=1.67893e-15;K[1]=3.233398000000045;
  I[2]=3.56e+12; J[2]=-1.6702e-17;K[2]=-0.00093333333338;
  I.boundary_condition()=2;
  J.boundary_condition()=1;
  K.boundary_condition()=2;
A1=triangle<int>(O,A,B);
B1=triangle<float>(C,D,E);
C1=triangle<double>(F,G,H);
D1=triangle<long double>(I,J,K);

 node<long double> ** TAB;
TAB=new node<long double> *[3] ;
TAB[0]=&I ; TAB[1]=&J ; TAB[2]=&K ;
E1=triangle<long double>(TAB);




A2=A1;
if (detail) affiche("operator = for triangle<int> test1",(A2==A1));
else
result*=(A2==A1);


A3=A2;
if (detail) affiche("operator = for triangle<int> test2",(A3==A2));
else
result*=(A2==A3);


B2=B1;
if (detail) affiche("operator = for triangle<float> test1",(B2==B1));
else
result*=(B2==B1);



B3=B2;
if (detail) affiche("operator = for triangle<float> test2",(B2==B3));
else
result*=(B2==B3);




C2=C1;
if (detail) affiche("operator = for triangle<double> test1",(C2==C1));
else
result*=(C2==C1);






C3=C2;
if (detail) affiche("operator = for triangle<double> test2",(C3==C2));
else
result*=(C3==C2);


D2=D1;
if (detail) affiche("operator = for triangle<long double> test1",(D2==D1));
else
result*=(D2==D1);



D3=D2;
if (detail) affiche("operator = for triangle<long double> test2",(D3==D2));
else
result*=(D3==D2);

if (detail) affiche("operator = for triangle<long double> test3",(D1==E1));
else
result*=(D1==E1);



A1[1]=B;
A1[2]=O;
A1[3]=A;
A2[1]=B;
A2[2]=O;
A2[3]=A;

if (detail) affiche("operator [] for triangle<int> ",(A2[1]==A1[1])&&(A2[2]==A1[2])
&&(A2[3]==A1[3]));
else
for(int i=1;i<=3;i++)
result*=(A2[i]==A1[i]);



B1[1]=E;
B1[2]=C;
B1[3]=D;
B2[1]=E;
B2[2]=C;
B2[3]=D;

if (detail) affiche("operator [] for triangle<float> ",(B2[1]==B1[1])&&(B2[2]==B1[2])
&&(B2[3]==B1[3]));
else
for(int i=1;i<=3;i++)
result*=(B2[i]==B1[i]);


C1[1]=H;
C1[2]=F;
C1[3]=G;
C2[1]=H;
C2[2]=F;
C2[3]=G;

if (detail) affiche("operator [] for triangle<double> ",(C2[1]==C1[1])&&(C2[2]==C1[2])
&&(C2[3]==C1[3]));
else
for(int i=1;i<=3;i++)
result*=(C2[i]==C1[i]);


D1[1]=K;
D1[2]=I;
D1[3]=J;
D2[1]=K;
D2[2]=I;
D2[3]=J;

if (detail) affiche("operator [] for triangle<long double> ",(D2[1]==D1[1])&&(D2[2]==D1[2])
&&(D2[3]==D1[3]));
else
for(int i=1;i<=3;i++)
result*=(D2[i]==D1[i]);


//Test constructeur par recopie
  triangle<long double> toto(I,J,K);
  triangle<long double> titi(toto);

if (detail) affiche ("copy constructor for triangle",(titi==toto));
else result*=(titi==toto);

node<long double> R1(2),R2(2),R3(2);
R1[1]=0.0;R1[2]=0.0;
R2[1]=1.0;R2[2]=0.0;
R3[1]=0.0;R3[2]=1.0;
triangle<long double> Ref(R1,R2,R3);

if (detail) affiche ("function AbsDet",abs(Ref.AbsDet()-1.0)<=epsilon);
else result*=(abs(Ref.AbsDet()-1.0)<=epsilon);

R1[1]=2.0;R1[2]=4.0; 
R2[1]=3.0;R2[2]=7.0;
R3[1]=8.0;R3[2]=9.0;
triangle<long double> tri(R1,R2,R3);

matrix<long double> Mk_locale(2,2);
Mk_locale(1,1)=1 ; Mk_locale(1,2)=6 ; Mk_locale(2,1)=3 ; Mk_locale(2,2)=5 ;


if (detail) affiche ("function Mk", Mk_locale==tri.Mk());
else result*=(Mk_locale==tri.Mk());

if (detail) affiche ("function InvMk", Mk_locale.inv()==tri.InvMk());
else result*=(Mk_locale.inv()==tri.InvMk());

if (detail) affiche ("function nb_nodes", 3==tri.nb_nodes());
else result*=(3==tri.nb_nodes());

node<long double> NEU1(2),NEU2(2),NEU3(2);
NEU1[1]=0.0 ; NEU1[2]=0.0 ;
NEU2[1]=1.0 ; NEU2[2]=0.0 ;
NEU3[1]=0.0 ; NEU3[2]=1.0 ;
triangle<long double> TRI1=triangle<long double>(NEU1,NEU2,NEU3);
node<long double> NEU4(2),NEU5(2),NEU6(2);
NEU4[1]=cos(2*pi()/3.0) ; NEU4[2]=sin(2*pi()/3.0) ;
NEU5[1]=cos(4*pi()/3.0) ; NEU5[2]=sin(4*pi()/3.0) ;
NEU6[1]=cos(6*pi()/3.0) ; NEU6[2]=sin(6*pi()/3.0) ;
triangle<long double> TRI2=triangle<long double>(NEU4,NEU5,NEU6);

if (detail) affiche ("function diam", (abs(sqrt(2.0)-TRI1.diam())<=epsilon)&&
(abs(2.0-TRI2.diam())<=epsilon));
else result*=((abs(sqrt(2.0)-TRI1.diam())<=epsilon)&&(abs(2.0-TRI2.diam())<=epsilon));



  cout << "============================================================== \n";
  if (result) cout<< "                    triangle test passed \n";
  else cout << "                    triangle test failed \n";
  cout << "============================================================== \n";
  return result;
}
#endif
