/*******************************************************************************************
 *                 Finite Element Object Library                                           *
 *     class creu:  declarations for particulary matrix (for hanging nodes process)        *
 *                    simula+@metz.ensam.fr                                                *
 *                   GNU/linux version 0.0.3                                               *
 *            software under General Public License                                        *
 *******************************************************************************************
 * copyright  2006 BLANCHARD Jrmy 
 * copyright  2006 Laboratoire de Mathmatiques et ses Applications de Valenciennes (LAMAV - EA 4015)
 ***************************************************************/

/*! \class creu
    \brief particulary matrix library \n

    \htmlonly 
    <FONT color="#838383">

    creu belongs to Finite Element Method Object Libraries (FEMOL++) </br>
    FEMOL++ is part of Simula+ <br><br>

    Simula+ is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version. <br><br>

    Simula+ is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details. <br><br>

    You should have received a copy of the GNU General Public License
    along with Simula+; if not, write to the Free Software
    Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA

    </FONT>
    \endhtmlonly


    \authors copyright \htmlonly &#169; \endhtmlonly 2006 Jrmy BLANCHARD \n
	     copyright \htmlonly &#169; \endhtmlonly 2006 Laboratoire de Mathmatiques et ses Applications de Valenciennes (LAMAV - EA 4015)
    \version 0.0.3
    \date 2006-2006
    \bug none
    \warning none
*/

#ifndef __cplusplus
#error Must use C++ for the type creu
#endif

#if !defined(_CREU_H)
#define _CREU_H


#if !defined(__IOSTREAM_H)
#include <iostream>
#endif

#if !defined(__STDLIB_H)
#include <stdlib.h>
#endif

#if !defined(__ASSERT_H)
#include <assert.h>
#endif

#if !defined(__VECTORS_H)
#include "../../MOL++/vectors.h"
#endif

#if !defined(__MATRIX_H)
#include "../../MOL++/matrix.h"
#endif

using namespace std;


//===========================
template <class T> class creu
//===========================
{
  protected:
    int size;  // number of rows of the matrix
    vector<T> *mrows;  

  public:
    creu () {size = 0;}  // default constructor
    creu (vector<int>);  // this constructor allocates memory
    creu (const creu<T>&);  // copy constructor
    creu (creu<T>*);  // copy constructor with temporary objects
    ~creu ();  // destructor   
    template <class M> friend ostream& operator << (ostream&, const creu<M>&);
    virtual creu<T>& operator = (const creu<T>&);
    template <class M> friend bool operator == (const creu<M>&, const creu<M>&);
    vector<T>& operator [] (int) const;
    template <class M> friend vector<int> vect (const creu<M>&);
    template <class M> friend void ajout (creu<M>*, int, int);
};


//-------------------------------------------------------------
template <class T> creu<T>::creu(vector<int> v)
//-------------------------------------------------------------
{
 size=v.dim();
 assert (size>0);
 for (int i=1; i<=size; i++)
   {assert (v[i]>0);}
 mrows=new vector<T>[size];
 for (int i=0; i<size; i++)
  {mrows[i]=&vector<T>(v[i+1]);}
}

//---------------------------------------------------------
template <class T> creu<T>::creu (const creu<T>& c)
//---------------------------------------------------------
{
assert (c.size);
size=c.size;
mrows=new vector<T>[size];
for (int i=0; i<size; i++)
  {mrows[i]=c.mrows[i];}
}

//------------------------------------------------
template <class T> creu<T>::creu(creu<T>* c)
//------------------------------------------------
{
size=(*c).size; // copy the size of the temporary objet
mrows=(*c).mrows;       // copy the address of the temporary objet
(*c).size=0;    // set temporary object size to zero (so the data stored at p won't be delete by the destructor)
}

//--------------------------------------
template <class T> creu<T>::~creu ()
//--------------------------------------
{
//destruction of the memory allocated for the creu
if (size) delete [] mrows; // free memory only if it's been affected
size=0;
}

//----------------------------------------------------------------------
template <class T> ostream& operator << (ostream& s, const creu<T>& c)
//----------------------------------------------------------------------
{
assert (c.size);
for (int i=0; i<c.size; i++)
  {s << c.mrows[i];}
return s;
}


//----------------------------------------------------------------------
template <class T> creu<T>& creu<T>::operator = (const creu<T>& c)
//----------------------------------------------------------------------
{
assert(c.size);
size=c.size;
mrows=c.mrows;
return(*this);
}

//-----------------------------------------------------------------------------
template <class M> bool operator == (const creu<M>& a, const creu<M>& b)
//-----------------------------------------------------------------------------
{
assert (a.size);		// a must exists
bool Bool = (a.size==b.size);	// a & b must be in the same space
for (int i=0; i<a.size && Bool; i++)
  {Bool *= (a.mrows[i]==b.mrows[i]);}
return Bool;
}

//--------------------------------------------------------
template <class T> vector<T>& creu<T>::operator [] (int i) const
//--------------------------------------------------------
{
assert ((i>0) && (i<=size));
return mrows[i-1];
}

//----------------------------------------------------------
template <class T> vector<int> vect (const creu<T>& c)
//----------------------------------------------------------
{
vector<int> v(c.size);
for (int i=1; i<=c.size; i++)
  {v[i]=(c.mrows[i-1]).dim();}
return v;
}


//----------------------------------------------------------
template <class T> void ajout (creu<T>* c, int a, int b)
//----------------------------------------------------------
{
vector<int> v=vect(*c); v[a]=v[a]+b;
creu<T>* C; C=new creu<T>(v);
int i=1;
while (i!=a)
  {(*C)[i]=(*c)[i]; i=i+1;}
for (int k=1; k<=((*c)[i]).dim(); k++)
  {(*C)[i][k]=(*c)[i][k];}
for (int k=i+1; k<=v.dim(); k++)
  {(*C)[k]=(*c)[k];}
*c=*C;
}




#endif
