/*******************************************************************
 *                 Finite Element Method Object Library            *
 *           class mesh_tri_2d_hn : declaration for mesh_tri_2d_hn *
 *                    simula+@metz.ensam.fr                        *
 *	             GNU/linux version 0.0.5	                       *
 *            software under General Public License                *
 *******************************************************************
 * copyright  2006 BLANCHARD Jrmy
 * copyright  Laboratoire de Mathmatiques et ses Applications de Valenciennes (LAMAV - EA 4015)
 ***************************************************************/

/*! \class mesh_tri_2d_hn
    \brief mesh_tri_2d_hn library \n

    \htmlonly 
    <FONT color="#838383">

    mesh_tri_2d_hn belongs to Finite Element Method Object Libraries (FEMOL++) </br>
    FEMOL++ is part of Simula+ <br><br>

    Simula+ is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version. <br><br>

    Simula+ is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details. <br><br>

    You should have received a copy of the GNU General Public License
    along with Simula+; if not, write to the Free Software
    Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA

    </FONT>
    \endhtmlonly

    \authors copyright \htmlonly &#169; \endhtmlonly  2006 BLANCHARD Jrmy \n
	     copyright \htmlonly &#169; \endhtmlonly Laboratoire de Mathmatiques et ses Applications de Valenciennes (LAMAV - EA 4015)
    \version 0.0.5
    \date 2006
    \bug none
    \warning none
*/


#ifndef __cplusplus
#error Must use C++ for the type mesh_tri_2d_hn
#endif

#ifndef _mesh_tri_2d_hn_h
#define _mesh_tri_2d_hn_h

#if !defined(__VECTORS_H)
#include "../../MOL++/vectors.h"
#endif

#if !defined(__MATRIX_H)
#include "../../MOL++/matrix.h"
#endif

#if !defined(__ASSERT_H)
#include <assert.h>
#endif

#if !defined(__MESH_H)
#include "mesh.h"
#endif

#if !defined(__INTEGRATION_H)
#include "../../MOL++/integration.h"
#endif

#if !defined(__CREU_H)
#include "creu.h"
#endif

using namespace std;

//=============================
template <class T> class mesh_tri_2d_hn:public mesh<triangle<T>,T>
//=============================

{
  protected :

   using mesh<triangle<T>,T>::alive;
   using mesh<triangle<T>,T>::dimspace_;
   using mesh<triangle<T>,T>::nbvertex_;
   using mesh<triangle<T>,T>::nbelement_;
   using mesh<triangle<T>,T>::vertices;
   using mesh<triangle<T>,T>::element;

    int nbsegments_;
    matrix<int> SetOfEdges_;
    vector<int> Type_of_edge_;
    creu<int>* EdgesPerTriangle_;
    vector<int> NbTrianglesPerEdge_;
    matrix<int> TrianglesPerEdge_;
    vector<T> hminT_;
    vector<T> hE_;
    vector<T> hminE_;
    vector<T> NormEdge_;
    matrix<T> NormalUnitVector_;
  public :
    mesh_tri_2d_hn();
    mesh_tri_2d_hn(const char*, const char*);
    mesh_tri_2d_hn(const char*);
    mesh_tri_2d_hn(const mesh_tri_2d_hn<T>&);
    ~mesh_tri_2d_hn();
    mesh_tri_2d_hn<T>& operator=(const mesh_tri_2d_hn<T>&);
    int nbsegments()const{return(nbsegments_);};
    matrix<int> SetOfEdges()const{return(SetOfEdges_);};
    vector<int> Type_of_edge()const{return(Type_of_edge_);};
    creu<int> EdgesPerTriangle()const{return(*EdgesPerTriangle_);};
    vector<int> NbTrianglesPerEdge()const {return(NbTrianglesPerEdge_);};
    matrix<int> TrianglesPerEdge()const {return(TrianglesPerEdge_);};
    vector<T> hminT()const{return(hminT_);};
    vector<T> hE()const{return(hE_);};
    vector<T> hminE()const{return(hminE_);};
    vector<T> NormEdge()const{return(NormEdge_);};
    matrix<T> NormalUnitVector()const{return(NormalUnitVector_);};
    template <class FT> friend  int operator ==  (const mesh_tri_2d_hn<FT>&,const mesh_tri_2d_hn<FT>&);
    template <class FT> friend  int operator !=  (const mesh_tri_2d_hn<FT>&,const mesh_tri_2d_hn<FT>&);
    void refine_mesh(vector<int> &); // refine the mesh
};


/*!
  \brief Default constructor of the mesh_tri_2d_hn class
*/
//=============================
template <class T>
mesh_tri_2d_hn<T>::mesh_tri_2d_hn() :mesh<triangle<T>,T>()
//=============================
{
  nbsegments_=0;
}


/*!
  \brief Constructor with 2 files of the mesh_tri_2d_hn class
  (the first correspond at coordonate of vertices and the second at triangles) 
*/
//=============================
template <class T>
mesh_tri_2d_hn<T>::mesh_tri_2d_hn(const char*file1, const char*file2) :mesh<triangle<T>,T>(file1,file2)
//=============================
{


matrix<int> VertexOfEdge(3,2);
VertexOfEdge(1,1)=2; VertexOfEdge(1,2)=3;
VertexOfEdge(2,1)=3; VertexOfEdge(2,2)=1;
VertexOfEdge(3,1)=1; VertexOfEdge(3,2)=2;

int tmp,m,n; int exists,Exists,Exists1; int type; T xi,xj,yi,yj,a,b,xm,xn; nbsegments_=0; int nbex=nbsegments_; int compte=nbsegments_;
int nbe=3*nbelement_;//majorant du nombre de segments

vector<int> v(nbe,true,2);
creu<int>* HypSetOfedges; HypSetOfedges=new creu<int>(v); 
(*HypSetOfedges)[1][1]=1; (*HypSetOfedges)[1][2]=1;
creu<int>* HypSetOfedges2; HypSetOfedges2=new creu<int>(v);

matrix<int> HypType_of_edge_(nbe,1);

vector<int> w(nbelement_,true,3); //creu<int>* EdgesPerTriangle_;
EdgesPerTriangle_=new creu<int>(w); 
creu<int>* HypEdgesPerTriangle_; HypEdgesPerTriangle_=new creu<int>(w);

for (int k=1; k<=nbelement_; k++)
{
	for (int edge_number=1; edge_number<=3; edge_number++)
	{
      int i=number(element[k-1][VertexOfEdge(edge_number,1)]);
	  int j=number(element[k-1][VertexOfEdge(edge_number,2)]);
	  if (j<i)
	    {tmp=i;i=j;j=tmp;}
	  exists=0; Exists=0; Exists1=0;
	  xi=vertices[i-1][1]; yi=vertices[i-1][2];
	  xj=vertices[j-1][1]; yj=vertices[j-1][2];
	  type=1;
	  if (xi==xj) 
	  {
	    for (int e=0; e<=nbex; e++)
	    {
	      m=(*HypSetOfedges)[e+1][1]; n=(*HypSetOfedges)[e+1][2];
	      if (i==m && j==n) {exists=1; HypType_of_edge_(e+1,1)=0; (*EdgesPerTriangle_)[k][edge_number]=e+1; break;}
          if (vertices[m-1][1]==xi && vertices[n-1][1]==xi)
          {
            xm=vertices[m-1][2]; xn=vertices[n-1][2];
            if (yi>=min(xm,xn) && yi<=max(xm,xn) && yj>=min(xm,xn) && yj<=max(xm,xn))
            {
              if (Exists==0)//securit
              {
                if ((*HypSetOfedges)[e+1].dim()==2) {compte=compte+1;}
                v[e+1]=v[e+1]+1; ajout(HypSetOfedges,e+1,1); (*HypSetOfedges)[e+1][v[e+1]]=nbsegments_+1;
                HypType_of_edge_(e+1,1)=0; type=0; exists=0; Exists=1;
              }
            }
            if (xm>=min(yi,yj) && xm<=max(yi,yj) && xn>=min(yi,yj) && xn<=max(yi,yj))
            {
              v[nbsegments_+1]=v[nbsegments_+1]+1; ajout(HypSetOfedges,nbsegments_+1,1);
              (*HypSetOfedges)[nbsegments_+1][v[nbsegments_+1]]=e+1;
              HypType_of_edge_(e+1,1)=0; type=0; exists=0; Exists1=1;
            }
          }
        }
      }     
      else
      {
        a=(yj-yi)/(xj-xi); b=yi-(a*xi);
        for (int e=0; e<=nbex; e++)
        {  
          m=(*HypSetOfedges)[e+1][1]; n=(*HypSetOfedges)[e+1][2];
          if (i==m && j==n) {exists=1; HypType_of_edge_(e+1,1)=0; (*EdgesPerTriangle_)[k][edge_number]=e+1; break;}
          xm=vertices[m-1][1]; xn=vertices[n-1][1];
          if (vertices[m-1][2]==(a*xm)+b && vertices[n-1][2]==(a*xn)+b)
          {
            if (xi>=min(xm,xn) && xi<=max(xm,xn) && xj>=min(xm,xn) && xj<=max(xm,xn))
            {
              if (Exists==0)//scurit
              {
                if ((*HypSetOfedges)[e+1].dim()==2) {compte=compte+1;}
                v[e+1]=v[e+1]+1; ajout(HypSetOfedges,e+1,1); (*HypSetOfedges)[e+1][v[e+1]]=nbsegments_+1; 
                HypType_of_edge_(e+1,1)=0; type=0; exists=0; Exists=1;
              }
            }
            if (xm>=min(xi,xj) && xm<=max(xi,xj) && xn>=min(xi,xj) && xn<=max(xi,xj))
            {
              v[nbsegments_+1]=v[nbsegments_+1]+1; ajout(HypSetOfedges,nbsegments_+1,1);
              (*HypSetOfedges)[nbsegments_+1][v[nbsegments_+1]]=e+1;
              HypType_of_edge_(e+1,1)=0; type=0; exists=0; Exists1=1;
            }
          } 
        }
      }
      if (exists==0)
      {
        (*HypSetOfedges)[nbsegments_+1][1]=i; (*HypSetOfedges)[nbsegments_+1][2]=j;
        HypType_of_edge_(nbsegments_+1,1)=type;
        (*EdgesPerTriangle_)[k][edge_number]=nbsegments_+1;
        if (Exists1==1) {compte=compte+1;}
        nbsegments_=nbsegments_+1;
      }
      nbex=nbsegments_-1;
    }
}


SetOfEdges_=matrix<int>(nbsegments_-compte,2);
Type_of_edge_=vector<int>(nbsegments_-compte);
vector<int> Passage(nbsegments_);
compte=0;
for (int k=1; k<=nbsegments_; k++)
{
  if ((*HypSetOfedges)[k].dim()==2)
  {
    compte=compte+1; SetOfEdges_[compte]=(*HypSetOfedges)[k]; 
    Passage[k]=compte; Type_of_edge_[compte]=HypType_of_edge_(k,1);
  }
}


nbsegments_=compte; 
NbTrianglesPerEdge_=vector<int>(nbsegments_);
TrianglesPerEdge_=matrix<int>(nbsegments_,2); 

hE_=vector<T> (nbsegments_);
hminT_=vector<T>(nbelement_);
T deuxfoissurf, longueur_segment, basemax;
int num_seg, NumNoeudA, NumNoeudB;
vector<T> AB(2);
  
for (int k=1; k<=nbelement_; k++)
{
  // Remplissage des vecteurs hE_ et hminT_
  deuxfoissurf=element[k-1].AbsDet();
  basemax=0.0;
  for (int i=1; i<=3; i++)
  {
    if (Passage[(*EdgesPerTriangle_)[k][i]]==0)
    {
      compte=(*HypSetOfedges)[(*EdgesPerTriangle_)[k][i]].dim();
      exists=(*EdgesPerTriangle_)[k][i];
      (*EdgesPerTriangle_)[k][i]=Passage[(*HypSetOfedges)[exists][3]];
      NbTrianglesPerEdge_[(*EdgesPerTriangle_)[k][i]]++;
      TrianglesPerEdge_((*EdgesPerTriangle_)[k][i],NbTrianglesPerEdge_[(*EdgesPerTriangle_)[k][i]])=k;
      ajout(EdgesPerTriangle_,k,compte-3);
      // Remplissage des vecteurs hE_ et hminT_
      NumNoeudA=(*HypSetOfedges)[exists][1];
      NumNoeudB=(*HypSetOfedges)[exists][2];
      AB=vertices[NumNoeudB-1]-vertices[NumNoeudA-1];
      longueur_segment=AB.norm();
      hE_[(*EdgesPerTriangle_)[k][i]]+=0.5*deuxfoissurf/longueur_segment;
      for (int j=1; j<=compte-3; j++)
      {
        w[k]=w[k]+1; (*EdgesPerTriangle_)[k][w[k]]=Passage[(*HypSetOfedges)[exists][3+j]]; 
        NbTrianglesPerEdge_[(*EdgesPerTriangle_)[k][w[k]]]++;
        TrianglesPerEdge_((*EdgesPerTriangle_)[k][w[k]],NbTrianglesPerEdge_[(*EdgesPerTriangle_)[k][w[k]]])=k;
        // Remplissage des vecteurs hE_ et hminT_
        hE_[(*EdgesPerTriangle_)[k][w[k]]]+=0.5*deuxfoissurf/longueur_segment;
      }  
    }
    else
    {
      exists=(*EdgesPerTriangle_)[k][i]; (*EdgesPerTriangle_)[k][i]=Passage[exists]; 
      NbTrianglesPerEdge_[(*EdgesPerTriangle_)[k][i]]++;
      TrianglesPerEdge_((*EdgesPerTriangle_)[k][i],NbTrianglesPerEdge_[(*EdgesPerTriangle_)[k][i]])=k;
      // Remplissage des vecteurs hE_ et hminT_
      num_seg=(*EdgesPerTriangle_)[k][i];
      NumNoeudA=SetOfEdges_(num_seg,1);
      NumNoeudB=SetOfEdges_(num_seg,2);
      AB=vertices[NumNoeudB-1]-vertices[NumNoeudA-1];
      longueur_segment=AB.norm();
      if (Type_of_edge_[num_seg]!=0)
        {hE_[num_seg]=deuxfoissurf/longueur_segment;}
      else
        {hE_[num_seg]+=0.5*deuxfoissurf/longueur_segment;}
    }
    if (longueur_segment>basemax) {basemax=longueur_segment;}
  }
  hminT_[k]=deuxfoissurf/basemax;
}

//------------------------------------
// Remplissage du vecteur hminE_
//------------------------------------
hminE_=vector<T>(nbsegments_);
for (int i=1; i<=nbelement_; i++)
{
  for (int j=1; j<=((*EdgesPerTriangle_)[i].dim()); j++)
  {
    num_seg=(*EdgesPerTriangle_)[i][j];
    if (Type_of_edge_[num_seg]==1)
      {hminE_[num_seg]=hminT_[i];}
    else
      {hminE_[num_seg]+=0.5*hminT_[i];} 
  }
}


//------------------------------------------------------------------
// Remplissage de NormEdge_ et NormalUnitVector_
//------------------------------------------------------------------
NormEdge_=vector<T>(nbsegments_);
NormalUnitVector_=matrix<T>(nbsegments_,2);

for (int num_seg=1; num_seg<=nbsegments_; num_seg++)
{
  vector<T> AB(vertices[SetOfEdges_(num_seg,2)-1]-vertices[SetOfEdges_(num_seg,1)-1]);
  T E=AB.norm();
  NormEdge_[num_seg]=E;
  NormalUnitVector_[num_seg]=AB.ortho2D()/E;
}

 
}


/*!
  \brief Constructor with one file of the mesh_tri_2d_hn class
  (the file correspond at coordonate of vertices and triangles) 
*/
//=============================
template <class T>
mesh_tri_2d_hn<T>::mesh_tri_2d_hn(const char*file1) :mesh<triangle<T>,T>(file1)
//=============================
/*!
  Pour comprendre ce que reprsente un lment de type "creu<T>" , se rfrer  sa classe dans le dossier MOL++!
  
  L'algorithme qui suit se dcompose en trois parties :
  - dans un premier temps, je stocke tous les cts de chaque triangle 
    et en mme temps je m'arrange (pour les cts  plusieurs segments)  pouvoir retrouver 
    les numros des segments qui composent ces cts et  calculer le nombre total de segments!;
    je cre galement l'lment creu<int> "EdgesPerTriangle_" o  la i-me ligne est stocke les numros
    provisoires des cts du i-me triangle!
  - dans un second temps, je garde uniquement les cts forms d'un seul segment et j'obtient donc
    la matrice SetOfEdges_ ainsi que le vecteur Type_of_edge_;
  - dans un troisime temps, je modifie l'lment creu<int> "EdgesPerTriangle_" afin d'numrer 
    pour chaque triangle l'ensemble des segments qui le compose (car dans ce type de maillage,
    un triangle n'est pas forcment compos de 3 segments! (il est alatoire pour chaque triangle!);
    pour ce faire, j'utilise la fonction "ajout" de la classe "creu.h" qui permet d'ajouter un ou
    plusieurs lments  n'importe quelle ligne d'un lment de type "creu<T>"!;
    je gnre en mme temps les descripteurs "NbTrianglesPerEdge", "TrianglesPerEdge", "hE" et "hminT"!
  
  Les descripteurs "hminE", "NormEdge" et "NormalUnitVector" sont crs comme dans la classe "mesh_tri_2d.h"!      
*/
{

//-----------------
// Partie 1 :
//-----------------
matrix<int> VertexOfEdge(3,2);
VertexOfEdge(1,1)=2; VertexOfEdge(1,2)=3;
VertexOfEdge(2,1)=3; VertexOfEdge(2,2)=1;
VertexOfEdge(3,1)=1; VertexOfEdge(3,2)=2;

int tmp,m,n; int exists,Exists,Exists1; int type; T xi,xj,yi,yj,a,b,xm,xn; nbsegments_=0; int nbex=nbsegments_; int compte=nbsegments_;
int nbe=3*nbelement_;//majorant du nombre de segments

vector<int> v(nbe,true,2);
creu<int>* HypSetOfedges; HypSetOfedges=new creu<int>(v); 
(*HypSetOfedges)[1][1]=1; (*HypSetOfedges)[1][2]=1;
creu<int>* HypSetOfedges2; HypSetOfedges2=new creu<int>(v);

matrix<int> HypType_of_edge_(nbe,1);

vector<int> w(nbelement_,true,3); //creu<int>* EdgesPerTriangle_;
EdgesPerTriangle_=new creu<int>(w); 
creu<int>* HypEdgesPerTriangle_; HypEdgesPerTriangle_=new creu<int>(w);

for (int k=1; k<=nbelement_; k++)
{
	for (int edge_number=1; edge_number<=3; edge_number++)
	{
      int i=number(element[k-1][VertexOfEdge(edge_number,1)]);
	  int j=number(element[k-1][VertexOfEdge(edge_number,2)]);
	  if (j<i)
	    {tmp=i;i=j;j=tmp;}
	  exists=0; Exists=0; Exists1=0;
	  xi=vertices[i-1][1]; yi=vertices[i-1][2];
	  xj=vertices[j-1][1]; yj=vertices[j-1][2];
	  type=1;
	  if (xi==xj) 
	  {
	    for (int e=0; e<=nbex; e++)
	    {
	      m=(*HypSetOfedges)[e+1][1]; n=(*HypSetOfedges)[e+1][2];
	      if (i==m && j==n) {exists=1; HypType_of_edge_(e+1,1)=0; (*EdgesPerTriangle_)[k][edge_number]=e+1; break;}
          if (vertices[m-1][1]==xi && vertices[n-1][1]==xi)
          {
            xm=vertices[m-1][2]; xn=vertices[n-1][2];
            if (yi>=min(xm,xn) && yi<=max(xm,xn) && yj>=min(xm,xn) && yj<=max(xm,xn))
            {
              if (Exists==0)//securit
              {
                if ((*HypSetOfedges)[e+1].dim()==2) {compte=compte+1;}
                v[e+1]=v[e+1]+1; ajout(HypSetOfedges,e+1,1); (*HypSetOfedges)[e+1][v[e+1]]=nbsegments_+1;
                HypType_of_edge_(e+1,1)=0; type=0; exists=0; Exists=1;
              }
            }
            if (xm>=min(yi,yj) && xm<=max(yi,yj) && xn>=min(yi,yj) && xn<=max(yi,yj))
            {
              v[nbsegments_+1]=v[nbsegments_+1]+1; ajout(HypSetOfedges,nbsegments_+1,1);
              (*HypSetOfedges)[nbsegments_+1][v[nbsegments_+1]]=e+1;
              HypType_of_edge_(e+1,1)=0; type=0; exists=0; Exists1=1;
            }
          }
        }
      }     
      else
      {
        a=(yj-yi)/(xj-xi); b=yi-(a*xi);
        for (int e=0; e<=nbex; e++)
        {  
          m=(*HypSetOfedges)[e+1][1]; n=(*HypSetOfedges)[e+1][2];
          if (i==m && j==n) {exists=1; HypType_of_edge_(e+1,1)=0; (*EdgesPerTriangle_)[k][edge_number]=e+1; break;}
          xm=vertices[m-1][1]; xn=vertices[n-1][1];
          if (vertices[m-1][2]==(a*xm)+b && vertices[n-1][2]==(a*xn)+b)
          {
            if (xi>=min(xm,xn) && xi<=max(xm,xn) && xj>=min(xm,xn) && xj<=max(xm,xn))
            {
              if (Exists==0)//scurit
              {
                if ((*HypSetOfedges)[e+1].dim()==2) {compte=compte+1;}
                v[e+1]=v[e+1]+1; ajout(HypSetOfedges,e+1,1); (*HypSetOfedges)[e+1][v[e+1]]=nbsegments_+1; 
                HypType_of_edge_(e+1,1)=0; type=0; exists=0; Exists=1;
              }
            }
            if (xm>=min(xi,xj) && xm<=max(xi,xj) && xn>=min(xi,xj) && xn<=max(xi,xj))
            {
              v[nbsegments_+1]=v[nbsegments_+1]+1; ajout(HypSetOfedges,nbsegments_+1,1);
              (*HypSetOfedges)[nbsegments_+1][v[nbsegments_+1]]=e+1;
              HypType_of_edge_(e+1,1)=0; type=0; exists=0; Exists1=1;
            }
          } 
        }
      }
      if (exists==0)
      {
        (*HypSetOfedges)[nbsegments_+1][1]=i; (*HypSetOfedges)[nbsegments_+1][2]=j;
        HypType_of_edge_(nbsegments_+1,1)=type;
        (*EdgesPerTriangle_)[k][edge_number]=nbsegments_+1;
        if (Exists1==1) {compte=compte+1;}
        nbsegments_=nbsegments_+1;
      }
      nbex=nbsegments_-1;
    }
}


//----------------
// Partie 2 : 
//----------------
SetOfEdges_=matrix<int>(nbsegments_-compte,2);
Type_of_edge_=vector<int>(nbsegments_-compte);
vector<int> Passage(nbsegments_);
compte=0;
for (int k=1; k<=nbsegments_; k++)
{
  if ((*HypSetOfedges)[k].dim()==2)
  {
    compte=compte+1; SetOfEdges_[compte]=(*HypSetOfedges)[k]; 
    Passage[k]=compte; Type_of_edge_[compte]=HypType_of_edge_(k,1);
  }
}


//-----------------
// Partie 3 : 
//-----------------
nbsegments_=compte; 
NbTrianglesPerEdge_=vector<int>(nbsegments_);
TrianglesPerEdge_=matrix<int>(nbsegments_,2); 

hE_=vector<T> (nbsegments_);
hminT_=vector<T>(nbelement_);
T deuxfoissurf, longueur_segment, basemax;
int num_seg, NumNoeudA, NumNoeudB;
vector<T> AB(2);
  
for (int k=1; k<=nbelement_; k++)
{
  // Remplissage des vecteurs hE_ et hminT_
  deuxfoissurf=element[k-1].AbsDet();
  basemax=0.0;
  for (int i=1; i<=3; i++)
  {
    if (Passage[(*EdgesPerTriangle_)[k][i]]==0)
    {
      compte=(*HypSetOfedges)[(*EdgesPerTriangle_)[k][i]].dim();
      exists=(*EdgesPerTriangle_)[k][i];
      (*EdgesPerTriangle_)[k][i]=Passage[(*HypSetOfedges)[exists][3]];
      NbTrianglesPerEdge_[(*EdgesPerTriangle_)[k][i]]++;
      TrianglesPerEdge_((*EdgesPerTriangle_)[k][i],NbTrianglesPerEdge_[(*EdgesPerTriangle_)[k][i]])=k;
      ajout(EdgesPerTriangle_,k,compte-3);
      // Remplissage des vecteurs hE_ et hminT_
      NumNoeudA=(*HypSetOfedges)[exists][1];
      NumNoeudB=(*HypSetOfedges)[exists][2];
      AB=vertices[NumNoeudB-1]-vertices[NumNoeudA-1];
      longueur_segment=AB.norm();
      hE_[(*EdgesPerTriangle_)[k][i]]+=0.5*deuxfoissurf/longueur_segment;
      for (int j=1; j<=compte-3; j++)
      {
        w[k]=w[k]+1; (*EdgesPerTriangle_)[k][w[k]]=Passage[(*HypSetOfedges)[exists][3+j]]; 
        NbTrianglesPerEdge_[(*EdgesPerTriangle_)[k][w[k]]]++;
        TrianglesPerEdge_((*EdgesPerTriangle_)[k][w[k]],NbTrianglesPerEdge_[(*EdgesPerTriangle_)[k][w[k]]])=k;
        // Remplissage des vecteurs hE_ et hminT_
        hE_[(*EdgesPerTriangle_)[k][w[k]]]+=0.5*deuxfoissurf/longueur_segment;
      }  
    }
    else
    {
      exists=(*EdgesPerTriangle_)[k][i]; (*EdgesPerTriangle_)[k][i]=Passage[exists]; 
      NbTrianglesPerEdge_[(*EdgesPerTriangle_)[k][i]]++;
      TrianglesPerEdge_((*EdgesPerTriangle_)[k][i],NbTrianglesPerEdge_[(*EdgesPerTriangle_)[k][i]])=k;
      // Remplissage des vecteurs hE_ et hminT_
      num_seg=(*EdgesPerTriangle_)[k][i];
      NumNoeudA=SetOfEdges_(num_seg,1);
      NumNoeudB=SetOfEdges_(num_seg,2);
      AB=vertices[NumNoeudB-1]-vertices[NumNoeudA-1];
      longueur_segment=AB.norm();
      if (Type_of_edge_[num_seg]!=0)
        {hE_[num_seg]=deuxfoissurf/longueur_segment;}
      else
        {hE_[num_seg]+=0.5*deuxfoissurf/longueur_segment;}
    }
    if (longueur_segment>basemax) {basemax=longueur_segment;}
  }
  hminT_[k]=deuxfoissurf/basemax;
}


//------------------------------------
// Remplissage du vecteur hminE_
//------------------------------------
hminE_=vector<T>(nbsegments_);
for (int i=1; i<=nbelement_; i++)
{
  for (int j=1; j<=((*EdgesPerTriangle_)[i].dim()); j++)
  {
    num_seg=(*EdgesPerTriangle_)[i][j];
    if (Type_of_edge_[num_seg]==1)
      {hminE_[num_seg]=hminT_[i];}
    else
      {hminE_[num_seg]+=0.5*hminT_[i];} 
  }
}


//------------------------------------------------------------------
// Remplissage de NormEdge_ et NormalUnitVector_
//------------------------------------------------------------------
NormEdge_=vector<T>(nbsegments_);
NormalUnitVector_=matrix<T>(nbsegments_,2);

for (int num_seg=1; num_seg<=nbsegments_; num_seg++)
{
  vector<T> AB(vertices[SetOfEdges_(num_seg,2)-1]-vertices[SetOfEdges_(num_seg,1)-1]);
  T E=AB.norm();
  NormEdge_[num_seg]=E;
  NormalUnitVector_[num_seg]=AB.ortho2D()/E;
}

 
}


/*!
  \brief Copy constructor 
*/
//=============================
template <class T>
mesh_tri_2d_hn<T>::mesh_tri_2d_hn(const mesh_tri_2d_hn<T>& EF) :mesh<triangle<T>,T>(EF)
//=============================
{
nbsegments_=EF.nbsegments_;
SetOfEdges_=EF.SetOfEdges_;
Type_of_edge_=EF.Type_of_edge_;
EdgesPerTriangle_=EF.EdgesPerTriangle_;
NbTrianglesPerEdge_=EF.NbTrianglesPerEdge_;
TrianglesPerEdge_=EF.TrianglesPerEdge_;
hminT_=EF.hminT_;
hminE_=EF.hminE_;
hE_=EF.hE_;
NormEdge_=EF.NormEdge_;
NormalUnitVector_=EF.NormalUnitVector_;
}


/*!
  \brief Destructor

  Deletes all protected facts of maillage
*/
//=============================
template <class T>
mesh_tri_2d_hn<T>:: ~mesh_tri_2d_hn()
//=============================
{
SetOfEdges_.~matrix<int>();
Type_of_edge_.~vector<int>();
// Modif E. Creus -  07/11/06
// Je mets la ligne ci-dessous en commentaire car
// celle ci n'est pas correcte, destruction mal faite
//(*EdgesPerTriangle_).~creu<int>();
NbTrianglesPerEdge_.~vector<int>();
TrianglesPerEdge_.~matrix<int>();
hminT_.~vector<T>();
hminE_.~vector<T>();
hE_.~vector<T>();
NormEdge_.~vector<T>();
NormalUnitVector_.~matrix<T>();   
nbsegments_=0;
}


/*!
  \brief Standard operator = for maillage
  
  ie operator = for all protected facts
*/
//========================================================
template <class T>
mesh_tri_2d_hn<T>& mesh_tri_2d_hn<T>::operator =(const mesh_tri_2d_hn<T>& EF)
//========================================================
{
(*this).mesh<triangle<T>,T>::operator=(EF);
nbsegments_=EF.nbsegments_;
SetOfEdges_=EF.SetOfEdges_;
Type_of_edge_=EF.Type_of_edge_;
EdgesPerTriangle_=EF.EdgesPerTriangle_;
NbTrianglesPerEdge_=EF.NbTrianglesPerEdge_;
TrianglesPerEdge_=EF.TrianglesPerEdge_;
hminT_=EF.hminT_;
hminE_=EF.hminE_;
hE_=EF.hE_;
NormEdge_=EF.NormEdge_;
NormalUnitVector_=EF.NormalUnitVector_;
return(*this);
}


/*!
  \brief Compares two maillage
  
  ie compares all protected facts
*/
//==========================================================================
template <class FT>
int operator ==(const mesh_tri_2d_hn<FT>& EF1,const mesh_tri_2d_hn<FT>& EF2)
//==========================================================================
{
int boolean=1;
boolean*=(mesh<triangle<FT>,FT>(EF1)==mesh<triangle<FT>,FT>(EF2));
boolean*=(EF1.nbsegments_==EF2.nbsegments_);
boolean*=(EF1.SetOfEdges_==EF2.SetOfEdges_);
boolean*=(EF1.Type_of_edge_==EF2.Type_of_edge_);
boolean*=(EF1.EdgesPerTriangle()==EF2.EdgesPerTriangle());
boolean*=(EF1.NbTrianglesPerEdge_==EF2.NbTrianglesPerEdge_);
boolean*=(EF1.TrianglesPerEdge_==EF2.TrianglesPerEdge_);
boolean*=(EF1.hminT_==EF2.hminT_);
boolean*=(EF1.hminE_==EF2.hminE_);
boolean*=(EF1.hE_==EF2.hE_);
boolean*=(EF1.NormEdge_==EF2.NormEdge_);
boolean*=(EF1.NormalUnitVector_==EF2.NormalUnitVector_);
return(boolean);
}


/*!
  \brief Compares two maillage
  
  ie compares all protected facts
*/
//==========================================================================
template <class FT>
int operator !=(const mesh_tri_2d_hn<FT>& EF1,const mesh_tri_2d_hn<FT>& EF2)
//==========================================================================
{
return(!(EF1==EF2));
}


/*!
  \brief Refine maillage
*/
//=============================
template <class T>
void mesh_tri_2d_hn<T>::refine_mesh(vector<int> & TABTRI)
//=============================
/*!
  Cet algorithme se dcompose en 2 parties :
  - dans un premier temps, je cre le vecteur TABSEG qui incrmente de un la i-me composante
    si le i-me segment est parcouru parmi les mailles  raffiner;
  - dans un second temps, je parcours l'ensemble des cts des triangles  raffiner  l'aide de 
    la donne protge "element"; 
    pour un t-ime triangle, je compare alors ces cts avec ses segments rpertoris ( l'aide 
    de la fonction "EdgesPerTriangle_");
    si le ct ne correspond pas au segment, c'est que le ct contient plusieurs segments et que
    forcment le milieu du ct est cr! Pour retrouver son numro, j'utilise la fonction "EdgesPerTriangle_";
    si le ct correspond au segment, on peut crer le milieu de ce segment en faisant attention 
    aux doublons!(pour cela utiliser les valeurs de TABSEG)  
*/
{


//=============================
// Phase 1: Dtermination de TABSEG
//=============================

matrix<int> TABSEG(nbsegments_,2);
int NbMailleRefine=TABTRI.dim();
for (int k=1; k<=NbMailleRefine; k++)
{
  for (int i=1; i<=(*EdgesPerTriangle_)[TABTRI[k]].dim(); i++)
  {
    TABSEG((*EdgesPerTriangle_)[TABTRI[k]][i],1)=TABSEG((*EdgesPerTriangle_)[TABTRI[k]][i],1)+1;
  }
}


//==============================
// Phase 2:
//==============================
int nbvertex_new=nbvertex_+(3*NbMailleRefine);
int nbelement_new=nbelement_+(3*NbMailleRefine);
matrix<int> VertexOfEdge(3,2);
VertexOfEdge(1,1)=2; VertexOfEdge(1,2)=3;
VertexOfEdge(2,1)=3; VertexOfEdge(2,2)=1;
VertexOfEdge(3,1)=1; VertexOfEdge(3,2)=2;
int i,j,l,m; int s=nbvertex_; int compteur; T x,y; int OK=0;
vector<int> N(3); matrix<int> tri(3,3); 
matrix<int> reno(nbelement_new,3);
for (int i=1; i<=nbelement_; i++)
{
  for (int j=1; j<=3; j++)
    {reno(i,j)=&element[i-1][j]-vertices+1;}
}

node<T>* vertices_new;
//EC vertices_new=new node<T>[nbvertex_new](2);
 vertices_new = new node<T>[nbvertex_new];
  for (int i=0; i<nbvertex_new; i++)
       vertices_new[i] = node<T>(2);


node<T> noeud(2);
for (int i=0; i<nbvertex_; i++)
  {vertices_new[i]=vertices[i];}


for (int t=1; t<=NbMailleRefine; t++)
{
  compteur=4;
  for (int k=1; k<=3; k++)
  {
    i=number(element[TABTRI[t]-1][VertexOfEdge(k,1)]);
    j=number(element[TABTRI[t]-1][VertexOfEdge(k,2)]);
    x=(vertices[i-1][1]+vertices[j-1][1])/2.0;
    y=(vertices[i-1][2]+vertices[j-1][2])/2.0;
    l=SetOfEdges_((*EdgesPerTriangle_)[TABTRI[t]][k],1);
    m=SetOfEdges_((*EdgesPerTriangle_)[TABTRI[t]][k],2);
    if (l==min(i,j) && m==max(i,j))
    {
      if (TABSEG((*EdgesPerTriangle_)[TABTRI[t]][k],1)==1)
      {
        if (TABSEG((*EdgesPerTriangle_)[TABTRI[t]][k],2)==0)
        {
          s=s+1; noeud[1]=x; noeud[2]=y;
          if (Type_of_edge_[(*EdgesPerTriangle_)[TABTRI[t]][k]]!=0)
            {noeud.boundary_condition()=1;}
          else
            {noeud.boundary_condition()=0;}
          vertices_new[s-1]=noeud; N[k]=s;
        } 
        else
          {N[k]=TABSEG((*EdgesPerTriangle_)[TABTRI[t]][k],2);}
      }
      else
      {
        s=s+1; noeud[1]=x; noeud[2]=y;
        if (Type_of_edge_[(*EdgesPerTriangle_)[TABTRI[t]][k]]!=0)
          {noeud.boundary_condition()=1;}
        else
          {noeud.boundary_condition()=0;}
        vertices_new[s-1]=noeud; N[k]=s; 
        TABSEG((*EdgesPerTriangle_)[TABTRI[t]][k],1)=1;
        TABSEG((*EdgesPerTriangle_)[TABTRI[t]][k],2)=s;
      }
    }
    else
    {
      if (vertices[l-1][1]==x && vertices[l-1][2]==y)
        {N[k]=l;}
      else
      {
        if (vertices[m-1][1]==x && vertices[m-1][2]==y)
          {N[k]=m;}
        else
        {
          OK=0;
          while (OK==0)
          {
            l=SetOfEdges_((*EdgesPerTriangle_)[TABTRI[t]][compteur],1);
            m=SetOfEdges_((*EdgesPerTriangle_)[TABTRI[t]][compteur],2);
            if (vertices[l-1][1]==x && vertices[l-1][2]==y)
              {N[k]=l; OK=1;}
            else
            {
              if (vertices[m-1][1]==x && vertices[m-1][2]==y)
                {N[k]=m; OK=1;}
              else
                {compteur=compteur+1;}
            }
          }
        }
      }     
    }
  }
  tri(1,1)=number(element[TABTRI[t]-1][3]); tri(1,2)=N[1]; tri(1,3)=N[2];
  tri(2,1)=number(element[TABTRI[t]-1][1]); tri(2,2)=N[2]; tri(2,3)=N[3];
  tri(3,1)=number(element[TABTRI[t]-1][2]); tri(3,2)=N[3]; tri(3,3)=N[1];
  reno(TABTRI[t],1)=N[1]; 
  reno(TABTRI[t],2)=N[2];
  reno(TABTRI[t],3)=N[3];
  for (int i=1; i<=3; i++)
  {
    reno(nbelement_+((t-1)*3)+i,1)=tri(i,1); 
    reno(nbelement_+((t-1)*3)+i,2)=tri(i,2);
    reno(nbelement_+((t-1)*3)+i,3)=tri(i,3);
  }
}

ofstream out_file("newfichier.txt");
  assert (!out_file.fail());

  out_file<<2<<endl;
  out_file<<s<<endl;
  for (int i=1; i<= s; i++)
   {
    for (int j=1; j<= 2; j++)
    {
     out_file<<vertices_new[i-1][j] << "   ";
    };
   out_file<<vertices_new[i-1].boundary_condition() <<endl; 
  };

out_file<<nbelement_new<<endl;

for (int i=1; i<= nbelement_new; i++)
{
 for (int j=1; j<=3; j++)
{
  out_file<<reno(i,j) << "   "; 
}
out_file<<endl; 
}
out_file<<endl; 
out_file.close();


}


#endif

