#include <iomanip.h>
#include <iostream.h>
#include <fstream.h>
#include <assert.h>
#include <string.h>

main()
{

  double x_centre=0.0;
  double y_centre=0.0;
  double rayon=1.0;
  int nseg=160; 

  ofstream out_file("fourthdisk5.poly",ios::trunc);
  assert (!out_file.fail());
  double angle,x,y;
  double dl=1.0/nseg;
  double angle_base=dl/rayon;
  int n;
  n=int(3.14159265/(2.0*angle_base));
  out_file << n+2*nseg << " " << 2 << " " << 0 << " " << 1 << endl;
  
  
  for (int i=0; i<=nseg-1; i++)
   {
   x=i*dl;
   y=0.0;
   out_file << i+1 << "  " << x << "  " << y << "  " << "1" << endl; 
  }
  
  for (int i=n; i>=0; i--)
   {
   angle=(3.14159264/2.0)*i/n;
   x=x_centre+rayon*cos(3.14159264/2.0-angle);
   y=y_centre+rayon*sin(3.14159264/2.0-angle);
   out_file << nseg+(n-i)+1 << "  " << x << "  " << y << "  " << "1" << endl; 
   }
  
   for (int i=nseg-1; i>0; i--)
   {
   x=0.0;
   y=i*dl;
   out_file << nseg+n+1+(nseg-1-i)+1 << " " << x << "  " << y << "  " << "1" << endl; 
  }
  
  
   out_file << endl;
   out_file << n+2*nseg << " " << 1 << endl;
   
    for (int i=1; i<=n+2*nseg-1; i++)
   {
   out_file << i << " " << i << " " << i+1 << " " << "1" << endl; 
   }
   
   out_file << n+2*nseg << " " << n+2*nseg << "  " << " 1" << " " << "1" << endl; 
   
   out_file << 0 << endl;
   out_file << 1 << endl;
   out_file << 1 << " " << 0.25 << " " << 0.25 << " " << 1 << " " << dl*dl << endl;
}