/***************************************************************
 *                    simula+@metz.ensam.fr                    *
 *                   GNU/linux version 0.1.4                   *
 *            software under General Public License            *
 ***************************************************************
 * copyright  2004 CREUSE Emmanuel
 * copyright  2004 PIRAUT Frdric
 * copyright  Laboratoire de Physique et Mcanique des Matriaux (LPMM - UMR 7554)
 * copyright  Laboratoire de Mathmatiques et ses Applications de Valenciennes (LAMAV - EA 4015)
 ***************************************************************/

/*
    p1c3d-test belongs to Mathematical Object Libraries (FEMOL++)
    FEMOL++ is part of Simula+

    Simula+ is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    Simula+ is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with Simula+; if not, write to the Free Software
    Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
*/



#ifndef __cplusplus
#error Must use C++ for the type p1c3d-test
#endif

#if !defined(__P1C3D_TEST_H)
#define _p1c3d_test_h

#if !defined(__IOSTREAM_H)
#include <iostream>
#endif

#if !defined(__ASSERT_H)
#include <assert.h>
#endif

#if !defined(__TIME_H)
#include <time.h>
#endif

#if !defined(__VECTORS_H)
#include "../../../MOL++/vectors.h"
#endif

#if !defined(__MATHS_H)
#include "../../../MOL++/maths.h"
#endif

#if !defined(__MESH_H)
#include "../../../FEMOL++/meshes/mesh.h"
#endif

#if !defined(__CONVERT_H)
#include "../../../FEMOL++/meshes/convert.h"
#endif

#if !defined(__TETRAHEDRE_H)
#include "../../../FEMOL++/meshes/triangle.h"
#endif

#if !defined(__AFFICHE_H)
#include "../../affiche.h"
#endif

#if !defined(__P1C3D_H)
#include "../../../FEMOL++/elements/p1c3d.h"
#endif

#if !defined(__LINEAR_SYSTEM_H)
#include "../../../MOL++/linear systems.h"
#endif

/*long double f_test_p1c(long double x, long double y, long double z)
{
return(3*sin(x)*sin(y)*sin(z)*sin(pi()*x)*sin(pi()*y)*sin(pi()*z)-2*pi()*cos(x)*sin(y)*sin(z)*cos(pi()*x)*sin(pi()*y)*sin(pi()*z)-2*pi()*cos(y)*sin(x)*sin(z)*cos(pi()*y)*sin(pi()*x)*sin(pi()*z)-2*pi()*cos(z)*sin(x)*sin(y)*cos(pi()*z)*sin(pi()*x)*sin(pi()*y)+3*pi()*pi()*sin(x)*sin(y)*sin(z)*sin(pi()*x)*sin(pi()*y)*sin(pi()*z));
}

long double u_test_p1c(long double x, long double y, long double z)
{
return(sin(x)*sin(y)*sin(z)*sin(pi()*x)*sin(pi()*y)*sin(pi()*z));
}


long double dudx_test_p1c(long double x, long double y, long double z)
{
return(cos(x)*sin(y)*sin(z)*sin(pi()*x)*sin(pi()*y)*sin(pi()*z)+pi()*sin(x)*sin(y)*sin(z)*cos(pi()*x)*sin(pi()*y)*sin(pi()*z));
}
long double dudy_test_p1c(long double x, long double y, long double z)
{
return(cos(y)*sin(x)*sin(z)*sin(pi()*x)*sin(pi()*y)*sin(pi()*z)+pi()*sin(x)*sin(y)*sin(z)*cos(pi()*y)*sin(pi()*x)*sin(pi()*z));
}
long double dudz_test_p1c(long double x, long double y, long double z)
{
return(cos(z)*sin(x)*sin(y)*sin(pi()*x)*sin(pi()*y)*sin(pi()*z)+pi()*sin(x)*sin(y)*sin(z)*cos(pi()*z)*sin(pi()*x)*sin(pi()*y));
}*/
long double f_test_p1c(long double x, long double y, long double z)
{return (0.);
}
long double u_test_p1c(long double x, long double y, long double z)
{return (x*x+y*y-2*z*z);
}
long double dudx_test_p1c(long double x, long double y, long double z)
{return (2*x);}
long double dudy_test_p1c(long double x, long double y, long double z)
{return (2*y);}
long double dudz_test_p1c(long double x, long double y, long double z)
{return (-4*z);}
//==========================
int test_p1c3d (int detail)
//==========================
{make_convertion3dtetra("data/CubeUnite/cube4.dat","data/cube40.txt");

int result=1;
p1c3d<long double> Th("data/tetra1.txt","data/tetra2.txt");
p1c3d<long double> Th2("data/tetra.txt");
p1c3d<long double> Uh("data/cube1.txt","data/cube2.txt");
p1c3d<long double> Uh2("data/cube.txt");
p1c3d<long double> Uh3,Uh4,Th3,Th4;


if (detail) affiche("operator == for p1c3d test2 ",(Uh==Uh2));
else
result*=(Uh==Uh2);
if (detail) affiche("operator == for p1c3d test1 ",(Th==Th2));
else
result*=(Th==Th2);

if (detail) affiche("operator == for p1c3d test3 ",!(Uh==Th));
else
result*=!(Uh==Th);

if (detail) affiche("operator != for p1c3d test1 ",(Th!=Uh));
else
result*=(Th!=Uh);

p1c3d<long double> Vh(Uh);
if (detail) affiche("copy constructor",(Vh==Uh));
else
result*=(Vh==Uh);Th3=Th;
if (detail) affiche("operator = for p1c3d test1 ",(Th==Th3));
else
result*=(Th==Th3);


Th4=Th2;
if (detail) affiche("operator = for p1c3d test2 ",(Th4==Th2));
else
result*=(Th4==Th2);


Uh3=Uh;
if (detail) affiche("operator = for p1c3d test3 ",(Uh==Uh3));
else
result*=(Uh==Uh3);


Uh4=Uh2;
if (detail) affiche("operator = for p1c3d test4 ",(Uh4==Uh2));
else
result*=(Uh4==Uh2);


if (detail) affiche("function DofNumber ",(4==Uh.DofNumber()));
else
result*=(4==Uh.DofNumber());


matrix<long double> MASS(4,4);
MASS(1,1)=1./60.;MASS(2,2)=1./60.;MASS(3,3)=1./60.;MASS(4,4)=1./60.;
MASS(1,2)=1./120.;MASS(1,3)=1./120.;MASS(1,4)=1./120.;MASS(2,1)=1./120.;
MASS(2,3)=1./120.;MASS(2,4)=1./120.;MASS(3,4)=1./120.;MASS(3,2)=1./120.;
MASS(4,3)=1./120.;MASS(4,2)=1./120.;MASS(4,1)=1./120.;MASS(3,1)=1./120.;

if (detail) affiche("function RefMassMatrix ",(MASS==Uh.RefMassMatrix()));
else
result*=(MASS==Uh.RefMassMatrix());


if (detail) affiche("function GlobalDofNumber ",(8==Uh.GlobalDofNumber()));
else
result*=(8==Uh.GlobalDofNumber());

if (detail)
affiche("operator()",((Uh(2,1)==6)&&(Uh(2,2)==5)&&(Uh(2,3)==1)&&(Uh(3,2)==7)));
 else
 result*=(((Uh(2,1)==6)&&(Uh(2,2)==5)&&(Uh(2,3)==1)&&(Uh(3,2)==7)));


if (detail) affiche("function LocalMassMatrix",
(Uh.LocalMassMatrix(2)==((long double)(1.)*Uh.RefMassMatrix())));
else
result*=(Uh.LocalMassMatrix(2)==((long double)(1.)*Uh.RefMassMatrix()));

matrix<long double> matloc1(4,4);
 matloc1(1,1)=1.0/3.0;
 matloc1(1,2)=-1.0/6.0;
 matloc1(1,3)=0.0;
 matloc1(1,4)=-1.0/6.0;
 matloc1(2,1)=-1.0/6.0;
 matloc1(2,2)=1.0/3.0;
 matloc1(2,3)=-1.0/6.0;
 matloc1(2,4)=0.0;
 matloc1(3,1)=0.0;
 matloc1(3,2)=-1.0/6.0;
 matloc1(3,3)=1.0/6.0;
 matloc1(3,4)=0.0;
 matloc1(4,1)=-1.0/6.0;
 matloc1(4,2)=0.0;
 matloc1(4,3)=0.0;
 matloc1(4,4)=1.0/6.0;
 
if (detail) affiche("function LocalStiffnessMatrix1",(Uh.LocalStiffnessMatrix(1)==matloc1));
 else
 result*=(Uh.LocalStiffnessMatrix(1)==matloc1);
 

matrix<long double> matloc2(4,4);
 matloc2(1,1)=1.0/3.0;
 matloc2(1,2)=-1.0/6.0;
 matloc2(1,3)=-1.0/6.0;
 matloc2(1,4)=0.0;
 matloc2(2,1)=-1.0/6.0;
 matloc2(2,2)=1.0/6.0;
 matloc2(2,3)=0.0;
 matloc2(2,4)=0.0;
 matloc2(3,1)=-1.0/6.0;
 matloc2(3,2)=0.0;
 matloc2(3,3)=1.0/3.0;
 matloc2(3,4)=-1.0/6.0;
 matloc2(4,1)=0.0;
 matloc2(4,2)=0.0;
 matloc2(4,3)=-1.0/6.0;
 matloc2(4,4)=1.0/6.0;
 if (detail) affiche("function LocalStiffnessMatrix2",(Uh.LocalStiffnessMatrix(2)==matloc2));
 else
 result*=(Uh.LocalStiffnessMatrix(2)==matloc2);
 

matrix<long double> matloc3(4,4);
 matloc3(1,1)=1.0/6.0;
 matloc3(1,2)=-1.0/6.0;
 matloc3(1,3)=0.0;
 matloc3(1,4)=0.0;
 matloc3(2,1)=-1.0/6.0;
 matloc3(2,2)=1.0/3.0;
 matloc3(2,3)=-1.0/6.0;
 matloc3(2,4)=0.0;
 matloc3(3,1)=0.0;
 matloc3(3,2)=-1.0/6.0;
 matloc3(3,3)=1.0/3.0;
 matloc3(3,4)=-1.0/6.0;
 matloc3(4,1)=0.0;
 matloc3(4,2)=0.0;
 matloc3(4,3)=-1.0/6.0;
 matloc3(4,4)=1.0/6.0;
 if (detail) affiche("function LocalStiffnessMatrix3",(Uh.LocalStiffnessMatrix(3)==matloc3));
 else
 result*=(Uh.LocalStiffnessMatrix(3)==matloc3);

 matrix<long double> m(Uh.GlobalDofNumber(),Uh.GlobalDofNumber());
 m(1,1)=2.0/3.0;
 m(1,2)=-1.0/3.0;
 m(1,3)=0.0;
 m(1,4)=0.0;
 m(1,5)=0.0;
 m(1,6)=-1.0/6.0;
 m(1,7)=-1.0/6.0;
 m(1,8)=0.0;
 m(2,1)=-1.0/3.0;
 m(2,2)=7.0/6.0;
 m(2,3)=0.0;
 m(2,4)=-1.0/2.0;
 m(2,5)=1.0/6.0;
 m(2,6)=0.0;
 m(2,7)=0.0;
 m(2,8)=-1.0/2.0;
 m(3,1)=0.0;
 m(3,2)=0.0;
 m(3,3)=1.0/2.0;
 m(3,4)=-1.0/6.0;
 m(3,5)=-1.0/6.0;
 m(3,6)=0.0;
 m(3,7)=0.0;
 m(3,8)=-1.0/6.0;
 m(4,1)=0.0;
 m(4,2)=-1.0/2.0;
 m(4,3)=-1.0/6.0;
 m(4,4)=5.0/6.0;
 m(4,5)=-1.0/6.0;
 m(4,6)=-1.0/6.0;
 m(4,7)=0.0;
 m(4,8)=1.0/6.0;
 m(5,1)=0.0;
 m(5,2)=1.0/6.0;
 m(5,3)=-1.0/6.0;
 m(5,4)=-1.0/6.0;
 m(5,5)=1.0;
 m(5,6)=-1.0/3.0;
 m(5,7)=-1.0/3.0;
 m(5,8)=-1.0/6.0;
 m(6,1)=-1.0/6.0;
 m(6,2)=0.0;
 m(6,3)=0.0;
 m(6,4)=-1.0/6.0;
 m(6,5)=-1.0/3.0;
 m(6,6)=2.0/3.0;
 m(6,7)=0.0;
 m(6,8)=0.0;
 m(7,1)=-1.0/6.0;
 m(7,2)=0.0;
 m(7,3)=0.0;
 m(7,4)=0.0;
 m(7,5)=-1.0/3.0;
 m(7,6)=0.0;
 m(7,7)=2.0/3.0;
 m(7,8)=-1.0/6.0;
 m(8,1)=0.0;
 m(8,2)=-1.0/2.0;
 m(8,3)=-1.0/6.0;
 m(8,4)=1.0/6.0;
 m(8,5)=-1.0/6.0;
 m(8,6)=0.0;
 m(8,7)=-1.0/6.0;
 m(8,8)=5.0/6.0;
 
if (detail) affiche("function DUDV",(Uh.DUDV()==m));
 else
 result*=(Uh.DUDV()==m); 
 
 int NbIntPts=13;
 vector<long double> b(Uh2.GlobalDofNumber());
 matrix<long double> A(Uh2.GlobalDofNumber(),Uh2.GlobalDofNumber());
 //sparse_matrix<long double> A(Uh2.GlobalDofNumber(),Uh2.GlobalDofNumber(),30);
vector<long double> s=Uh2.B(f_test_p1c,NbIntPts),uh;
 A=Uh2.DUDV();
 Uh2.Dirichlet(A,s,u_test_p1c);
 // uh=gauss(A)*s;
 vector<long double> s0(Uh2.GlobalDofNumber());
 long double eps1=1e-8;
 int iter_grad_conj;
 uh=conjugate_gradient(A,s,s0,iter_grad_conj,eps1);
int boolean=1;
 long double L=0.182574;
 long double H=1.41421;
 long double eps=1e-4;
 boolean=(abs(L-Uh2.error_L2(u_test_p1c,uh,NbIntPts))<=eps);
if (detail) affiche("l2 error",boolean);
else
result*=boolean;

boolean=(abs(H-Uh2.error_semi_H1(dudx_test_p1c,dudy_test_p1c,dudz_test_p1c,uh,NbIntPts))<=eps);
if (detail) affiche("semi h1 error",boolean);
else
result*=boolean;
 


/*int NbIntPts=13;
 vector<long double> b(Uh2.GlobalDofNumber());
 matrix<long double> A(Uh2.GlobalDofNumber(),Uh2.GlobalDofNumber());
 vector<long double> s=Uh2.B(f_test_p1c,NbIntPts),uh;
 A=Uh2.DUDV();
 //cout<<Uh.B(f_test_p1c,NbIntPts);
 Uh2.Dirichlet(A,s,u_test_p1c);
 //cout<<A;
 uh=gauss(A)*s;
//cout<<"solution approchee"<<"\n"<<uh;
 cout<<"erreur L2"<<"\n"<<Uh2.error_L2(u_test_p1c,uh,NbIntPts)<<endl;

cout<<"erreur H1"<<"\n"<<Uh2.error_semi_H1(dudx_test_p1c,dudy_test_p1c,dudz_test_p1c,uh,NbIntPts);
*/





/*                          TEST1
           Probleme de Dirichlet pour le Laplacien avec:
	      f(x,y,z)=0
	      u|(bord)=0
	   [u(x,y,z)= x*x+y*y-2*z*z] 


    |----------------------------------------------------
    |   h     |         L2       |        H1            |	   
    |----------------------------------------------------	                         
    |         |                  |                      |
    |	0.5   |    0.182574      |     1.41421          |
    |  	      |                  |                      |
    |---------------------------------------------------|	                
    |         |                  |                      |
    |  0.25   |    0.071775      |     1.04654          |
    |  	      |                  |                      |	 
    |---------------------------------------------------|	                         
    |  	      |                  |                      |
    |  0.125  |    0.0205302     |     0.569784         |
    |	      |                  |                      |
    |---------------------------------------------------|	                         
    |	      |                  |                      |
    |  0.0625 |    0.00542556    |     0.291784         |
    |	      |                  |                      |
    |---------------------------------------------------|	 




                         TEST2
           Probleme de Dirichlet pour le Laplacien avec:
	      f(x,y,z)=-exp(x)-exp(y)-exp(z)
	      u|(bord)=f
	   [u(x,y,z)= exp(x)+exp(y)+exp(z)] 
                 
    |----------------------------------------------------
    |   h     |         L2       |        H1            |	   
    |----------------------------------------------------
    |         |                  |                      |
    |	0.5   |    0.436564      |     0.852119         |
    |  	      |                  |                      |
    |---------------------------------------------------|	                
    |         |                  |                      |
    |  0.25   |    0.132401      |     0.618151         |
    |  	      |                  |                      |	 
    |---------------------------------------------------|
    |  	      |                  |                      |
    |  0.125  |    0.0358582     |     0.338356         |
    |	      |                  |                      |	 
    |---------------------------------------------------|	                         
    |	      |                  |                      |
    |  0.0625 |    0.00928601    |     0.173804         |
    |	      |                  |                      |	 
    |---------------------------------------------------|
    
 

                         TEST3
           Probleme de Dirichlet pour le Laplacien avec:
	    f(x,y,z)=3*sin(x)*sin(y)*sin(z)*sin(pi()*x)*sin(pi()*y)*sin(pi()*z)
	             -2*pi()*cos(x)*sin(y)*sin(z)*cos(pi()*x)*sin(pi()*y)*
		     sin(pi()*z)-2*pi()*cos(y)*sin(x)*sin(z)*cos(pi()*y)*
		     sin(pi()*x)*sin(pi()*z)-2*pi()*cos(z)*sin(x)*sin(y)*
		     cos(pi()*z)*sin(pi()*x)*sin(pi()*y)+3*pi()*pi()*sin(x)*
		     sin(y)*sin(z)*sin(pi()*x)*sin(pi()*y)*sin(pi()*z))
	    u|(bord)=0
	   [u(x,y,z)= sin(x)*sin(pi*x)*sin(y)*sin(pi*y)*sin(z)*sin(pi*z)]
 
    |---------------------------------------------------|	   
    |   h     |         L2       |        H1            |	   
    |---------------------------------------------------|	                         
    |         |                  |                      |
    |	0.5   |    0.0434132     |     0.270253         |
    |  	      |                  |                      |
    |---------------------------------------------------|	                
    |         |                  |                      |
    |  0.25   |    0.0396966     |     0.262686         |
    |  	      |                  |                      |	 
    |---------------------------------------------------|
    |  	      |                  |                      |
    |  0.125  |    0.018497      |     0.177742         |
    |	      |                  |                      |
    |---------------------------------------------------|	                         
    |	      |                  |                      |
    |  0.0625 |    0.00660347    |     0.104188         |
    |	      |                  |                      |	 
    |---------------------------------------------------|
    
	 
	                 TEST4
           Probleme de Dirichlet pour le Laplacien avec:
	      f(x,y,z)=0
	     [u(r,teta,phi)=r^(2/3)*sin((2/3)*teta)*phi] 

    |---------------------------------------------------|	   
    |   h     |         L2       |        H1            |	   
    |---------------------------------------------------|
    |         |                  |                      |
    |	0.5   |    0.0763851     |     0.578281         |
    |  	      |                  |                      |
    |---------------------------------------------------|	                
    |         |                  |                      |
    |  0.25   |    0.0264005     |     0.314975         |
    |  	      |                  |                      |	 
    |---------------------------------------------------|
    |  	      |                  |                      |
    |  0.125  |    0.00802086    |     0.17082          |
    |	      |                  |                      |	 
    |---------------------------------------------------|	                         
    |	      |                  |                      |
    |  0.0625 |    0.00233854    |     0.0925273        |
    |	      |                  |                      |	 
    |---------------------------------------------------|		 




*/	   

cout<< "============================================================== \n";
  if (result) cout<< "                    p1c3d test passed \n";
  else cout << "                    p1c3d test failed \n";
  cout << "============================================================== \n";

return result;
}
#endif
/*main()
{
  test_p1c3d(1);
}
*/
