/***************************************************************
 *                    simula+@metz.ensam.fr                    *
 *                   GNU/linux version 0.1.4                   *
 *            software under General Public License            *
 ***************************************************************
 * copyright  2002,2003,2004,2005,2006 CREUSE Emmanuel
 * copyright  2002,2003,2004,2005,2006 SOUALEM Nadir
 * copyright  Laboratoire de Physique et Mcanique des Matriaux (LPMM - UMR 7554)
 * copyright  Laboratoire de Mathmatiques et ses Applications de Valenciennes (LAMAV - EA 4015)
 ***************************************************************/

/*
    mesh-test belongs to Mathematical Object Libraries (FEMOL++)
    FEMOL++ is part of Simula+

    Simula+ is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    Simula+ is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with Simula+; if not, write to the Free Software
    Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
*/
    
#ifndef __cplusplus
#error Must use C++ for the type mesh-test
#endif

#if !defined(__MESH_TEST_H)
#define _mesh_test_h

#if !defined(__IOSTREAM_H)
#include <iostream>
#endif

#if !defined(__ASSERT_H)
#include <assert.h>
#endif

#if !defined(__ASSERT_H)
#include <time.h>
#endif

#if !defined(__VECTORS_H)
#include "../../../MOL++/vectors.h"
#endif

#if !defined(__MESH_H)
#include "../../../FEMOL++/meshes/mesh.h"
#endif

#if !defined(__TRIANGLE_H)
#include "../../../FEMOL++/meshes/triangle.h"
#endif

#if !defined(__TETRAHEDRE_H)
#include "../../../FEMOL++/meshes/tetrahedre.h"
#endif


#if !defined(__AFFICHE_H)
#include "../../affiche.h"
#endif

//==========================
int test_mesh (int detail)
//==========================
{
int result=1;
     mesh<triangle<long double>,long double> Th("data/2.txt","data/21.txt");
     mesh<triangle<long double>,long double> Th2("data/22.txt");
     mesh<triangle<long double>,long double> Uh("data/8.txt","data/81.txt");
     mesh<triangle<long double>,long double> Uh2("data/82.txt"); 
     mesh<triangle<long double>,long double> Th3,Th4,Uh3,Uh4;

 if (detail) affiche("operator == for mesh test1 ",(Th==Th2));
 else
 result*=(Th==Th2);


if (detail) affiche("operator == for mesh test2 ",(Uh==Uh2));
else
result*=(Uh==Uh2);

mesh<triangle<long double>,long double> Vh(Uh);
if (detail) affiche("copy constructor",(Vh==Uh));
else
result*=(Vh==Uh);


Th3=Th;
if (detail) affiche("operator = for mesh test1 ",(Th==Th3));
else
result*=(Th==Th3);


Th4=Th2;
if (detail) affiche("operator = for mesh test2 ",(Th4==Th2));
else
result*=(Th4==Th2);


Uh3=Uh;
if (detail) affiche("operator = for mesh test3 ",(Uh==Uh3));
else
result*=(Uh==Uh3);


Uh4=Uh2;
if (detail) affiche("operator = for mesh test4 ",(Uh4==Uh2));
else
result*=(Uh4==Uh2);


if (detail) affiche("function nbvertex()",(Th.nbvertex()==9));
else
result*=(Th.nbvertex()==9);


if (detail) affiche("function nbelement()",(Uh2.nbelement()==128));
else
result*=(Uh2.nbelement()==128);

if (detail) affiche("function dimspace()",(Uh.dimspace()==Uh2.dimspace()));
else
result*=(Uh.dimspace()==Uh2.dimspace());

if (detail) affiche("function number() test1",(Uh.number(Uh[43][1])==
Uh2.number(Uh2[43][1])));
else
result*=(Uh.number(Uh[43][1])==Uh2.number(Uh2[43][1]));

if (detail) affiche("function number() test1bis",(Uh.number(Uh[43][1])!=0));
else
result*=(Uh.number(Uh[43][1])!=0);

if (detail) affiche("function number() test2",(Uh.number(Uh[23][3])==
Uh2.number(Uh2[23][3])));
else
result*=(Uh.number(Uh[23][3])==Uh2.number(Uh2[23][3]));

if (detail) affiche("function number() test2bis",(Uh.number(Uh[23][3])!=0));
else
result*=(Uh.number(Uh[23][3])!=0);


if (detail) affiche("function number() test3",(Uh.number(Uh[17][2])==
Uh2.number(Uh2[17][2])));
else
result*=(Uh.number(Uh[17][2])==Uh2.number(Uh2[17][2]));

if (detail) affiche("function number() test3bis",(Uh.number(Uh[17][2])!=0));
else
result*=(Uh.number(Uh[17][2])!=0);

node<long double> A(2);
A[1]=0;
A[2]=0;
node<long double> B(2);
B[1]=0;
B[2]=-1.5;
node<long double> C(2);
C[1]=-12.5604567999999902;
C[2]=-123.888888432222222;

triangle<long double> K(A,B,C);
mesh<triangle<long double>,long double> Kh(Uh);
Kh[23]=triangle<long double>(A,B,C);
Kh[35]=triangle<long double>(A,B,C);
if (detail) affiche("operator [] for mesh",((Kh[23]==Kh[35])&&(Kh[23]==K)));
else
result*=((Kh[23]==Kh[35])&&(Kh[23]==K));

Kh(28)=B;
Kh(65)=C;
if (detail) affiche("operator () for mesh",(Kh(28)==B)&&(Kh(65)==C));
else
result*=(Kh(28)==B)&&(Kh(65)==C);

//---------------------------------------
//Tests sur les maillages de tetrahedres
//---------------------------------------
mesh<tetrahedre<long double>,long double> TAUH("data/tetra1.txt","data/tetra2.txt");
mesh<tetrahedre<long double>,long double> TAUHB("data/tetra.txt");

if (detail) affiche("operator == for mesh tetra3D test1 ",(TAUH==TAUHB));
else
result*=(TAUH==TAUHB);

mesh<tetrahedre<long double>,long double> TAUHC(TAUH);
if (detail) affiche("copy constructor for mesh tetra3D",(TAUH==TAUHC));
else
result*=(TAUH==TAUHC);

 mesh<tetrahedre<long double>,long double> TAUHD;
TAUHD=TAUH;
if (detail) affiche("operator = for mesh tetra3D test1 ",(TAUHD==TAUH));
else
result*=(TAUHD==TAUH);

if (detail) affiche("function nbvertex() for mesh tetra3D ",(TAUH.nbvertex()==5));
else
result*=(TAUH.nbvertex()==5);


if (detail) affiche("function nbelement() for mesh tetra3D",(TAUH.nbelement()==2));
else
result*=(TAUH.nbelement()==2);

if (detail) affiche("function dimspace() for mesh tetra3D",(TAUH.dimspace()==3));
else
result*=(TAUH.dimspace()==3);

if (detail) affiche("function number() for mesh tetra3D",(TAUH.number(TAUH[2][2])==3));
else
result*=(TAUH.number(TAUH[2][2])==3);

node<long double> A1(3);
A1[1]=0;
A1[2]=0;
A1[3]=0;
node<long double> B1(3);
B1[1]=0;
B1[2]=-1.5;
B1[3]=2.0;
node<long double> C1(3);
C1[1]=-12.5604567999999902;
C1[2]=-123.888888432222222;
C1[3]=56.325;
node<long double> D1(3);
D1[1]=2.3698574;
D1[2]=7.8569875;
D1[3]=-4.69875;

tetrahedre<long double> K1(A1,B1,C1,D1);
mesh<tetrahedre<long double>,long double> TAUHE(TAUH);
TAUHE[2]=tetrahedre<long double>(A1,B1,C1,D1);
if (detail) affiche("operator [] for mesh tetra3D",(TAUHE[2]==K1));
else
result*=(TAUHE[2]==K1);

TAUHE(3)=B1;
if (detail) affiche("operator () for mesh tetra3D",(TAUHE(3)==B1));
else
result*=(TAUHE(3)==B1);




cout << "============================================================== \n";
  if (result) cout<< "                    mesh test passed \n";
  else cout << "                    mesh test failed \n";
  cout << "============================================================== \n";
  
return(result);
}
#endif

