/***************************************************************
 *                    simula+@metz.ensam.fr                    *
 *                   GNU/linux version 0.1.0                   *
 *            software under General Public License            *
 ***************************************************************
 * copyright  2005,2006 CREUSE Emmanuel
 * copyright  2005,2006 SOUALEM Nadir
 * copyright  2006 COCHEZ Sarah
 * copyright  2006 BOULAAJINE Lahcen
 * copyright  Laboratoire de Physique et Mcanique des Matriaux (LPMM - UMR 7554)
 * copyright  Laboratoire de Mathmatiques et ses Applications de Valenciennes (LAMAV - EA 4015)
 ***************************************************************/

/*
    mesh_tri_2d-test belongs to Mathematical Object Libraries (FEMOL++)
    FEMOL++ is part of Simula+

    Simula+ is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    Simula+ is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with Simula+; if not, write to the Free Software
    Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
*/

#ifndef __cplusplus
#error Must use C++ for the type mesh-test
#endif

#if !defined(__MESH_TEST_H)
#define _mesh_test_h

#if !defined(__IOSTREAM_H)
#include <iostream>
#endif

#if !defined(__ASSERT_H)
#include <assert.h>
#endif

#if !defined(__ASSERT_H)
#include <time.h>
#endif

#if !defined(__VECTORS_H)
#include "../../../MOL++/vectors.h"
#endif

#if !defined(__MESH_TRI_2D_H)
#include "../../../FEMOL++/meshes/mesh_tri_2d.h"
#endif

#if !defined(__TRIANGLE_H)
#include "../../../FEMOL++/meshes/triangle.h"
#endif

#if !defined(__TETRAHEDRE_H)
#include "../../../FEMOL++/meshes/tetrahedre.h"
#endif


#if !defined(__AFFICHE_H)
#include "../../affiche.h"
#endif

#if !defined(__CONVERT_H)
#include "../../../FEMOL++/meshes/convert.h"
#endif

//==========================
int test_mesh_tri_2d (int detail)
//==========================
{
int result=1;

make_convertion2dtri("data/Lshape2d/2dLshape8.dat","tampon.res","lshape2d");
mesh_tri_2d<long double> UUh("tampon.res");
//UUh.visu2d();


mesh_tri_2d<long double> Th("data/2.txt","data/21.txt");
mesh_tri_2d<long double> Th2("data/22.txt");
mesh_tri_2d<long double> Uh("data/8.txt","data/81.txt");
mesh_tri_2d<long double> Uh2("data/82.txt");

//Uh2.visu2d();

mesh_tri_2d<long double> Th3,Th4,Uh3,Uh4,Uh5;

if (detail) affiche("operator == for mesh_tri_2d test1 ",(Th==Th2));
else
result*=(Th==Th2);


if (detail) affiche("operator == for mesh_tri_2d test2 ",(Uh==Uh2));
else
result*=(Uh==Uh2);

mesh_tri_2d<long double> Vh(Uh);
if (detail) affiche("copy constructor",(Vh==Uh));
else
result*=(Vh==Uh);


Th3=Th;
if (detail) affiche("operator = for mesh_tri_2d test1 ",(Th==Th3));
else
result*=(Th==Th3);


Th4=Th2;
if (detail) affiche("operator = for mesh_tri_2d test2 ",(Th4==Th2));
else
result*=(Th4==Th2);


Uh3=Uh;
if (detail) affiche("operator = for mesh_tri_2d test3 ",(Uh==Uh3));
else
result*=(Uh==Uh3);


Uh4=Uh2;
if (detail) affiche("operator = for mesh_tri_2d test4 ",(Uh4==Uh2));
else
result*=(Uh4==Uh2);

vector<int> TABTRI(Uh2.nbelement());
for (int i=1; i<=Uh2.nbelement();i+=10)
 TABTRI[i] = -1;
 
Uh2.refine_mesh(TABTRI);
//Uh2.visu2d();
mesh_tri_2d<long double> Sh("data/output_file_refine_mesh.dat");

if (detail) affiche("refine_mesh ",(Sh==Uh2));
else
result*=(Sh==Uh2);


Uh5=Th2;
if (detail) affiche("operator = for mesh_tri_2d test5 ",(Uh5==Th2));
else
result*=(Uh5==Th2);
//Th2.visu2d();

long double angle=0.5;
int nb_refine=5;
for (int num_refine=1; num_refine<=nb_refine; num_refine++)
{vector<int> TABTRI(Th2.nbelement());
for (int i=1; i<=Th2.nbelement();i+=4)
 TABTRI[i] = -1;
 
Th2.refine_mesh_angle(TABTRI,angle);
//Th2.visu2d();
}
mesh_tri_2d<long double> Sh2("data/output_file_refine_mesh_angle.dat");

if (detail) affiche("refine_mesh_angle ",(Sh2==Th2));
else
result*=(Sh2==Th2);


matrix<int> SetOfEdgesLoc(16,2);
SetOfEdgesLoc(1,1)=8; SetOfEdgesLoc(1,2)=9;
SetOfEdgesLoc(2,1)=5; SetOfEdgesLoc(2,2)=8;
SetOfEdgesLoc(3,1)=5; SetOfEdgesLoc(3,2)=9;
SetOfEdgesLoc(4,1)=3; SetOfEdgesLoc(4,2)=6;
SetOfEdgesLoc(5,1)=2; SetOfEdgesLoc(5,2)=6;
SetOfEdgesLoc(6,1)=2; SetOfEdgesLoc(6,2)=3;
SetOfEdgesLoc(7,1)=7; SetOfEdgesLoc(7,2)=8;
SetOfEdgesLoc(8,1)=4; SetOfEdgesLoc(8,2)=7;
SetOfEdgesLoc(9,1)=4; SetOfEdgesLoc(9,2)=8;
SetOfEdgesLoc(10,1)=6; SetOfEdgesLoc(10,2)=9;
SetOfEdgesLoc(11,1)=5; SetOfEdgesLoc(11,2)=6;
SetOfEdgesLoc(12,1)=4; SetOfEdgesLoc(12,2)=5;
SetOfEdgesLoc(13,1)=2; SetOfEdgesLoc(13,2)=5;
SetOfEdgesLoc(14,1)=1; SetOfEdgesLoc(14,2)=4;
SetOfEdgesLoc(15,1)=1; SetOfEdgesLoc(15,2)=5;
SetOfEdgesLoc(16,1)=1; SetOfEdgesLoc(16,2)=2;

if (detail) affiche("SetOfEdges_ for mesh_tri_2d test6 ",(Th.SetOfEdges()==SetOfEdgesLoc));
else
result*=(Th.SetOfEdges()==SetOfEdgesLoc);

matrix<int> NormalDirectionLoc(8,3);
NormalDirectionLoc(1,1)=1; NormalDirectionLoc(1,2)=1; NormalDirectionLoc(1,3)=-1;
NormalDirectionLoc(2,1)=-1; NormalDirectionLoc(2,2)=1; NormalDirectionLoc(2,3)=-1;
NormalDirectionLoc(3,1)=1; NormalDirectionLoc(3,2)=1; NormalDirectionLoc(3,3)=-1;
NormalDirectionLoc(4,1)=-1; NormalDirectionLoc(4,2)=1; NormalDirectionLoc(4,3)=-1;
NormalDirectionLoc(5,1)=-1; NormalDirectionLoc(5,2)=1; NormalDirectionLoc(5,3)=-1;
NormalDirectionLoc(6,1)=1; NormalDirectionLoc(6,2)=1; NormalDirectionLoc(6,3)=-1;
NormalDirectionLoc(7,1)=1; NormalDirectionLoc(7,2)=1; NormalDirectionLoc(7,3)=-1;
NormalDirectionLoc(8,1)=-1; NormalDirectionLoc(8,2)=1; NormalDirectionLoc(8,3)=-1;

if (detail) affiche("NormalDirection_ for mesh_tri_2d test7 ",(Th.NormalDirection()==NormalDirectionLoc));
else
result*=(Th.NormalDirection()==NormalDirectionLoc);

matrix<int> EdgesPerTriangleLoc(8,3);
EdgesPerTriangleLoc(1,1)=1; EdgesPerTriangleLoc(1,2)=2; EdgesPerTriangleLoc(1,3)=3;
EdgesPerTriangleLoc(2,1)=4; EdgesPerTriangleLoc(2,2)=5; EdgesPerTriangleLoc(2,3)=6;
EdgesPerTriangleLoc(3,1)=7; EdgesPerTriangleLoc(3,2)=8; EdgesPerTriangleLoc(3,3)=9;
EdgesPerTriangleLoc(4,1)=10; EdgesPerTriangleLoc(4,2)=3; EdgesPerTriangleLoc(4,3)=11;
EdgesPerTriangleLoc(5,1)=2; EdgesPerTriangleLoc(5,2)=9; EdgesPerTriangleLoc(5,3)=12;
EdgesPerTriangleLoc(6,1)=11; EdgesPerTriangleLoc(6,2)=13; EdgesPerTriangleLoc(6,3)=5;
EdgesPerTriangleLoc(7,1)=12; EdgesPerTriangleLoc(7,2)=14; EdgesPerTriangleLoc(7,3)=15;
EdgesPerTriangleLoc(8,1)=13; EdgesPerTriangleLoc(8,2)=15; EdgesPerTriangleLoc(8,3)=16;

if (detail) affiche("EdgesPerTriangle_ for mesh_tri_2d test8 ",(Th.EdgesPerTriangle()==EdgesPerTriangleLoc));
else
result*=(Th.EdgesPerTriangle()==EdgesPerTriangleLoc);

remove("tampon.res");

cout << "============================================================== \n";
  if (result) cout<< "                    mesh_tri_2d test passed \n";
  else cout << "                    mesh_tri_2d test failed \n";
  cout << "============================================================== \n";
  
return(result);
}
#endif

