/***************************************************************
 *                    simula+@metz.ensam.fr                    *
 *                   GNU/linux version 2.6.0                   *
 *            software under General Public License            *
 ***************************************************************
 * copyright © 2004 CREUSE Emmanuel
 * copyright © 2011 COLLARD Christophe
 * copyright © 2004,2011 Centre National de la Recherche Scientifique
 * copyright © 2004 Arts et Métiers ParisTech
 * copyright © 2004 Université de Valenciennes et du Hainaut Cambrésis
 * copyright © 2004 Laboratoire de Physique et Mécanique des Matériaux (LPMM - UMR 7554)
 * copyright © 2004 Laboratoire de Mathématiques et ses Applications de Valenciennes (LAMAV - EA 4015)
 * copyright © 2011 Centre d'Elaboration de Matériaux et d'Etudes Structurales (CEMES - CNRS)
 ***************************************************************/

/*
    tetrap0-test belongs to Mathematical Object Libraries (FEMOL++)
    FEMOL++ is part of Simula+

    Simula+ is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    Simula+ is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with Simula+; if not, write to the Free Software
    Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
*/

#ifndef __cplusplus
#error Must use C++ for the type tetrap0-test
#endif

#if !defined(__TETRAP0_TEST_H)
#define _tetrap0_test_h


#if !defined(__IOSTREAM_H)
#include <iostream>
#endif

#if !defined(__ASSERT_H)
#include <assert.h>
#endif

#if !defined(__ASSERT_H)
#include <time.h>
#endif

#if !defined(__VECTORS_H)
#include "MOL++/vectors.h"
#endif

#if !defined(__INTEGRATION_H)
#include "MOL++/integration.h"
#endif

#if !defined(__MESH_H)
#include "FEMOL++/meshes/mesh.h"
#endif

#if !defined(__AFFICHE_H)
#include "affiche.h"
#endif

#if !defined(__TETRAP0_H)
#include "FEMOL++/elements/tetrap0.h"
#endif


using namespace std;
using namespace mol;
using namespace femol;

long double f_test_tetrap0 (long double x, long double y, long double z)
{
  return pow (x, 2) + 4 * pow (y, 3) + pow (z, 5) + 2;
}


//===========================
int test_tetrap0 (int detail)
//===========================
{
  int result = 1;

  if (detail < 0) 
    { cout << "============================================================== \n";
      cout << blue << "                     tetrap0 test skipped" << reset;
      cout << "============================================================== \n";
      return result;
    }

  tetrap0<long double> Th ("data/tetra1.txt", "data/tetra2.txt");
  tetrap0<long double> Th2 ("data/tetra.txt");
  tetrap0<long double> Th4;

  if (detail) affiche ("operator ==", Th == Th2);
  else result *= (Th == Th2);

  tetrap0<long double> Th3 (Th);
  if (detail) affiche ("copy constructor", Th == Th3);
  else result *= (Th == Th3);

  Th4 = Th2;
  if (detail) affiche ("operator =", Th4 == Th2);
  else result *= (Th4 == Th2);

  if (detail) affiche ("function DofNumber", 1 == Th.DofNumber());
  else result *= (1 == Th.DofNumber());

  if (detail) affiche ("function GlobalDofNumber", 2 == Th.GlobalDofNumber());
  else result *= (2 == Th.GlobalDofNumber());

  if (detail) affiche ("operator ()", Th (2,1) == 2);
  else result *= (Th(2,1) == 2);

  matrix<long double> M(3,3);
  M(1,1) = -1;  M(1,2) = -1;  M(1,3) = 0;
  M(2,1) = 1;   M(2,2) = 0;   M(2,3) = 1;
  M(3,1) = 0;   M(3,2) = 1;   M(3,3) = 1;
  vector<long double> A1(3), VEC(3, true, 0.3), IMAGE(3);
  A1[1] = 1;
  IMAGE = M * VEC + A1;

  if (detail) affiche ("function Fk", IMAGE == Th.Fk (0.3, 0.3, 0.3, 2));
  else result *= (IMAGE == Th.Fk (0.3, 0.3, 0.3, 2));

  integration<long double> itg;
  itg.Gauss (10, 0, 1);

  if (detail) affiche ("Integrate_f", abs (Th.Integrate_f (f_test_tetrap0, 1, itg) - 649.0 / 1680.0) < 1e-09);
  else result *= (abs (Th.Integrate_f (f_test_tetrap0, 1, itg) - 649.0 / 1680.0) < 1e-09);

  cout << "============================================================== \n";
  if (result) cout << green << "                     tetrap0 test passed" << reset;
  else cout << red << "                     tetrap0 test failed" << reset;
  cout << "============================================================== \n";

  return result;
}


#endif
