/***************************************************************
 *                    simula.plus@cemes.fr                     *
 *                   GNU/linux version 3.0.0                   *
 *            software under General Public License            *
 ***************************************************************
 * copyright © 2003,2004,2005,2006 CREUSE Emmanuel
 * copyright © 2003,2004,2005,2006 SOUALEM Nadir
 * copyright © 2012 COLLARD Christophe
 * copyright © 2003,2004,2005,2006,2012 Centre National de la Recherche Scientifique
 * copyright © 2003,2004,2005,2006 Arts et Métiers ParisTech
 * copyright © 2003,2004,2005,2006 Université de Valenciennes et du Hainaut Cambrésis
 * copyright © 2003,2004,2005,2006 Laboratoire de Physique et Mécanique des Matériaux (LPMM - UMR 7554)
 * copyright © 2003,2004,2005,2006 Laboratoire de Mathématiques et ses Applications de Valenciennes (LAMAV - EA 4015)
 * copyright © 2012 Centre d'Elaboration de Matériaux et d'Etudes Structurales (CEMES - CNRS)
 ***************************************************************/

/*
    p2c2d-test belongs to Mathematical Object Libraries (FEMOL++)
    FEMOL++ is part of Simula+

    Simula+ is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    Simula+ is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with Simula+; if not, write to the Free Software
    Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
*/

#ifndef __cplusplus
#error Must use C++ for the type p2c2d-test
#endif

#ifndef __p2c2d_test_hpp
#define __p2c2d_test_hpp

#ifndef __iostream
#include <iostream>
#endif

#ifndef __assert_h
#include <assert.h>
#endif

#ifndef __time_h
#include <time.h>
#endif

#ifndef __maths_hpp
#include "MOL++/maths.hpp"
#endif

#ifndef __vectors_hpp
#include "MOL++/vectors.hpp"
#endif

#ifndef __mesh_tri_2d_hpp
#include "FEMOL++/meshes/mesh_tri_2d.hpp"
#endif

#ifndef __triangle_hpp
#include "FEMOL++/meshes/triangle.hpp"
#endif

#ifndef __p2c2d_hpp
#include "FEMOL++/elements/p2c2d.hpp"
#endif

#ifndef __affiche_hpp
#include "tests/affiche.hpp"
#endif

long double f_test_p2c (long double x, long double y)
{
  return -exp(x) - exp(y);
}

long double u_test_p2c (long double x, long double y)
{
  return exp(x) + exp(y);
}

long double dudx_test_p2c (long double x, long double y)
{
  return exp(x);
}

long double dudy_test_p2c (long double x, long double y)
{
  return exp(y);
}

long double f1_test_p2c (long double x, long double y)
{
  return 1.;
}

using namespace std;
using namespace mol;
using namespace femol;


//=========================
int test_p2c2d (int detail)
//=========================
{
  int result = 1;

  if (detail < 0) 
    { cout << "============================================================== \n";
      cout << blue << "                      p2c2d test skipped" << reset;
      cout << "============================================================== \n";
      return result;
    }

  p2c2d<long double> Th ("data/2.txt", "data/21.txt");
  p2c2d<long double> Th2 ("data/22.txt");
  p2c2d<long double> Uh ("data/8.txt", "data/81.txt");
  p2c2d<long double> Uh2 ("data/82.txt");
  p2c2d<long double> Th3, Th4, Uh3, Uh4;

  if (detail) affiche ("operator ==", Th == Th2  &&  Uh == Uh2  &&  !(Uh == Th));
  else result *= (Th == Th2  &&  Uh == Uh2  &&  !(Uh == Th));

  if (detail) affiche ("operator !=", Th != Uh  &&  !(Th != Th2));
  else result *= (Th != Uh  &&  !(Th != Th2));

  p2c2d<long double> Vh (Uh);
  if (detail) affiche ("copy constructor", Vh == Uh);
  else result *= (Vh == Uh);

  Th3 = Th;
  Th4 = Th2;
  Uh3 = Uh;
  Uh4 = Uh2;
  if (detail) affiche ("operator =", Th==Th3 && Th4==Th2 && Uh==Uh3 && Uh4==Uh2);
  else result *= (Th==Th3 && Th4==Th2 && Uh==Uh3 && Uh4==Uh2);

  matrix<long double> MASS(6,6), STIFF(3,3);

  MASS(1,1) = 1/60.;
  MASS(1,2) = -1/360.;
  MASS(1,3) = -1/360.;
  MASS(1,4) = -1/90.;

  MASS(2,1) = -1/360.;
  MASS(2,2) = 1/60.;
  MASS(2,3) = -1/360.;
  MASS(2,5) = -1/90.;

  MASS(3,1) = -1/360.;
  MASS(3,2) = -1/360.;
  MASS(3,3) = 1/60.;
  MASS(3,6) = -1/90.;

  MASS(4,1) = -1/90.;
  MASS(4,4) = 4/45.;
  MASS(4,5) = 2/45.;
  MASS(4,6) = 2/45.;

  MASS(5,2) = -1/90.;
  MASS(5,4) = 2/45.;
  MASS(5,5) = 4/45.;
  MASS(5,6) = 2/45.;

  MASS(6,3) = -1/90.;
  MASS(6,4) = 2/45.;
  MASS(6,5) = 2/45.;
  MASS(6,6) = 4/45.;

  if (detail) affiche ("RefMassMatrix", MASS == Uh.RefMassMatrix());
  else result *= (MASS == Uh.RefMassMatrix());

  if (detail) affiche ("DofNumber", 6 == Uh.DofNumber());
  else result *= (6 == Uh.DofNumber());

  if (detail) affiche ("GlobalDofNumber", 289 == Uh.GlobalDofNumber());
  else result *= (289 == Uh.GlobalDofNumber());

  if (detail) affiche ("operator ()", Uh(43,1) == Uh2(43,1)  &&  Uh(43,1)  &&  Uh(23,3) == Uh2(23,3)  &&  Uh(23,3)  &&  Uh(17,2) == Uh2(17,2)  &&  Uh(17,2));
  else result *= (Uh(43,1) == Uh2(43,1)  &&  Uh(43,1)  &&  Uh(23,3) == Uh2(23,3)  &&  Uh(23,3)  &&  Uh(17,2) == Uh2(17,2)  &&  Uh(17,2));

  if (detail) affiche ("LocalMassMatrix", Uh.LocalMassMatrix(1) == ((long double)(1/64.) * Uh.RefMassMatrix()));
  else result *= (Uh.LocalMassMatrix(1) == ((long double)(1/64.) * Uh.RefMassMatrix()));

  int NbIntPts=10;
  matrix<long double> m (289, 289);
  vector<long double> b (289);
  long double epsilon_loc = 1e-10;
  int boolean = 1;

  m(1,1) = 1;
  m(2,2) = 1;
  m(3,3) = 1;
  m(4,4) = 1;
  m(5,5) = 1;
  m(6,6) = 1;
  m(7,7) = 1;
  m(8,8) = 1;
  m(9,9) = 1;
  m(10,10) = 1;
  m(11,11) = 3.9999999999999999998; m(11,12) = 0.33333333333333333332; m(11,20) = 0.33333333333333333326; m(11,113) = -1.3333333333333333333; m(11,119) = -1.3333333333333333332; m(11,120) = -1.333333333333333333; m(11,198) = -1.3333333333333333332;
  m(12,11) = 0.33333333333333333332; m(12,12) = 3.9999999999999999998; m(12,13) = 0.33333333333333333332; m(12,21) = 0.33333333333333333326; m(12,119) = -1.3333333333333333333; m(12,184) = -1.3333333333333333332; m(12,225) = -1.3333333333333333332; m(12,240) = -1.333333333333333333;
  m(13,12) = 0.33333333333333333332; m(13,13) = 3.9999999999999999998; m(13,14) = 0.33333333333333333332; m(13,22) = 0.33333333333333333326; m(13,156) = -1.3333333333333333332; m(13,157) = -1.333333333333333333; m(13,202) = -1.3333333333333333332; m(13,225) = -1.3333333333333333333;
  m(14,13) = 0.33333333333333333332; m(14,14) = 3.9999999999999999996; m(14,15) = 0.33333333333333333332; m(14,23) = 0.33333333333333333326; m(14,156) = -1.3333333333333333333; m(14,211) = -1.3333333333333333332; m(14,262) = -1.333333333333333333; m(14,267) = -1.3333333333333333332;
  m(15,14) = 0.33333333333333333332; m(15,15) = 3.9999999999999999996; m(15,16) = 0.33333333333333333332; m(15,24) = 0.33333333333333333326; m(15,153) = -1.3333333333333333332; m(15,154) = -1.333333333333333333; m(15,247) = -1.3333333333333333332; m(15,267) = -1.3333333333333333333;
  m(16,15) = 0.33333333333333333332; m(16,16) = 3.9999999999999999998; m(16,17) = 0.33333333333333333332; m(16,25) = 0.33333333333333333326; m(16,129) = -1.3333333333333333332; m(16,150) = -1.3333333333333333332; m(16,151) = -1.333333333333333333; m(16,153) = -1.3333333333333333333;
  m(17,16) = 0.33333333333333333332; m(17,17) = 3.9999999999999999996; m(17,26) = 0.33333333333333333326; m(17,106) = -1.3333333333333333332; m(17,150) = -1.3333333333333333333; m(17,258) = -1.3333333333333333332; m(17,275) = -1.333333333333333333;
  m(18,18) = 1;
  m(19,19) = 1;
  m(20,11) = 0.33333333333333333326; m(20,20) = 3.9999999999999999998; m(20,21) = 0.33333333333333333332; m(20,29) = 0.33333333333333333326; m(20,134) = -1.3333333333333333332; m(20,136) = -1.3333333333333333333; m(20,166) = -1.3333333333333333332; m(20,198) = -1.333333333333333333;
  m(21,12) = 0.33333333333333333326; m(21,20) = 0.33333333333333333332; m(21,21) = 3.9999999999999999998; m(21,22) = 0.33333333333333333332; m(21,30) = 0.33333333333333333326; m(21,164) = -1.3333333333333333332; m(21,166) = -1.3333333333333333333; m(21,184) = -1.333333333333333333; m(21,194) = -1.3333333333333333332;
  m(22,13) = 0.33333333333333333326; m(22,21) = 0.33333333333333333332; m(22,22) = 3.9999999999999999998; m(22,23) = 0.33333333333333333332; m(22,31) = 0.33333333333333333326; m(22,182) = -1.3333333333333333332; m(22,194) = -1.3333333333333333333; m(22,201) = -1.3333333333333333332; m(22,202) = -1.333333333333333333;
  m(23,14) = 0.33333333333333333326; m(23,22) = 0.33333333333333333332; m(23,23) = 3.9999999999999999998; m(23,24) = 0.33333333333333333332; m(23,32) = 0.33333333333333333326; m(23,146) = -1.3333333333333333332; m(23,201) = -1.3333333333333333333; m(23,208) = -1.3333333333333333332; m(23,211) = -1.333333333333333333;
  m(24,15) = 0.33333333333333333326; m(24,23) = 0.33333333333333333332; m(24,24) = 3.9999999999999999998; m(24,25) = 0.33333333333333333332; m(24,33) = 0.33333333333333333326; m(24,207) = -1.3333333333333333332; m(24,208) = -1.3333333333333333333; m(24,246) = -1.3333333333333333332; m(24,247) = -1.333333333333333333;
  m(25,16) = 0.33333333333333333326; m(25,24) = 0.33333333333333333332; m(25,25) = 3.9999999999999999998; m(25,26) = 0.33333333333333333332; m(25,34) = 0.33333333333333333326; m(25,128) = -1.3333333333333333332; m(25,129) = -1.333333333333333333; m(25,175) = -1.3333333333333333332; m(25,246) = -1.3333333333333333333;
  m(26,17) = 0.33333333333333333326; m(26,25) = 0.33333333333333333332; m(26,26) = 3.9999999999999999998; m(26,35) = 0.33333333333333333326; m(26,105) = -1.3333333333333333332; m(26,106) = -1.333333333333333333; m(26,128) = -1.3333333333333333333; m(26,229) = -1.3333333333333333332;
  m(27,27) = 1;
  m(28,28) = 1;
  m(29,20) = 0.33333333333333333326; m(29,29) = 3.9999999999999999996; m(29,30) = 0.33333333333333333332; m(29,38) = 0.33333333333333333326; m(29,99) = -1.3333333333333333332; m(29,101) = -1.3333333333333333333; m(29,134) = -1.333333333333333333; m(29,193) = -1.3333333333333333332;
  m(30,21) = 0.33333333333333333326; m(30,29) = 0.33333333333333333332; m(30,30) = 3.9999999999999999998; m(30,31) = 0.33333333333333333332; m(30,39) = 0.33333333333333333326; m(30,92) = -1.3333333333333333332; m(30,164) = -1.333333333333333333; m(30,191) = -1.3333333333333333332; m(30,193) = -1.3333333333333333333;
  m(31,22) = 0.33333333333333333326; m(31,30) = 0.33333333333333333332; m(31,31) = 3.9999999999999999998; m(31,32) = 0.33333333333333333332; m(31,40) = 0.33333333333333333326; m(31,89) = -1.3333333333333333332; m(31,92) = -1.3333333333333333333; m(31,181) = -1.3333333333333333332; m(31,182) = -1.333333333333333333;
  m(32,23) = 0.33333333333333333326; m(32,31) = 0.33333333333333333332; m(32,32) = 3.9999999999999999998; m(32,33) = 0.33333333333333333332; m(32,41) = 0.33333333333333333326; m(32,138) = -1.3333333333333333332; m(32,145) = -1.3333333333333333332; m(32,146) = -1.333333333333333333; m(32,181) = -1.3333333333333333333;
  m(33,24) = 0.33333333333333333326; m(33,32) = 0.33333333333333333332; m(33,33) = 3.9999999999999999998; m(33,34) = 0.33333333333333333332; m(33,42) = 0.33333333333333333326; m(33,127) = -1.3333333333333333332; m(33,145) = -1.3333333333333333333; m(33,207) = -1.333333333333333333; m(33,266) = -1.3333333333333333332;
  m(34,25) = 0.33333333333333333326; m(34,33) = 0.33333333333333333332; m(34,34) = 3.9999999999999999998; m(34,35) = 0.33333333333333333332; m(34,43) = 0.33333333333333333326; m(34,104) = -1.3333333333333333332; m(34,125) = -1.3333333333333333332; m(34,127) = -1.3333333333333333333; m(34,175) = -1.333333333333333333;
  m(35,26) = 0.33333333333333333326; m(35,34) = 0.33333333333333333332; m(35,35) = 3.9999999999999999996; m(35,44) = 0.33333333333333333326; m(35,102) = -1.3333333333333333332; m(35,104) = -1.3333333333333333333; m(35,229) = -1.333333333333333333; m(35,254) = -1.3333333333333333332;
  m(36,36) = 1;
  m(37,37) = 1;
  m(38,29) = 0.33333333333333333326; m(38,38) = 3.9999999999999999998; m(38,39) = 0.33333333333333333332; m(38,47) = 0.33333333333333333326; m(38,95) = -1.3333333333333333332; m(38,99) = -1.333333333333333333; m(38,249) = -1.3333333333333333332; m(38,251) = -1.3333333333333333333;
  m(39,30) = 0.33333333333333333326; m(39,38) = 0.33333333333333333332; m(39,39) = 3.9999999999999999996; m(39,40) = 0.33333333333333333332; m(39,48) = 0.33333333333333333326; m(39,93) = -1.3333333333333333332; m(39,95) = -1.3333333333333333333; m(39,98) = -1.3333333333333333332; m(39,191) = -1.333333333333333333;
  m(40,31) = 0.33333333333333333326; m(40,39) = 0.33333333333333333332; m(40,40) = 3.9999999999999999998; m(40,41) = 0.33333333333333333332; m(40,49) = 0.33333333333333333326; m(40,88) = -1.3333333333333333332; m(40,89) = -1.333333333333333333; m(40,96) = -1.3333333333333333332; m(40,98) = -1.3333333333333333333;
  m(41,32) = 0.33333333333333333326; m(41,40) = 0.33333333333333333332; m(41,41) = 3.9999999999999999998; m(41,42) = 0.33333333333333333332; m(41,50) = 0.33333333333333333326; m(41,88) = -1.3333333333333333333; m(41,137) = -1.3333333333333333332; m(41,138) = -1.333333333333333333; m(41,143) = -1.3333333333333333332;
  m(42,33) = 0.33333333333333333326; m(42,41) = 0.33333333333333333332; m(42,42) = 3.9999999999999999998; m(42,43) = 0.33333333333333333332; m(42,51) = 0.33333333333333333326; m(42,118) = -1.3333333333333333332; m(42,137) = -1.3333333333333333333; m(42,160) = -1.3333333333333333332; m(42,266) = -1.333333333333333333;
  m(43,34) = 0.33333333333333333326; m(43,42) = 0.33333333333333333332; m(43,43) = 3.9999999999999999996; m(43,44) = 0.33333333333333333332; m(43,52) = 0.33333333333333333326; m(43,116) = -1.3333333333333333332; m(43,118) = -1.3333333333333333333; m(43,125) = -1.333333333333333333; m(43,206) = -1.3333333333333333332;
  m(44,35) = 0.33333333333333333326; m(44,43) = 0.33333333333333333332; m(44,44) = 3.9999999999999999996; m(44,53) = 0.33333333333333333326; m(44,102) = -1.333333333333333333; m(44,204) = -1.3333333333333333332; m(44,206) = -1.3333333333333333333; m(44,261) = -1.3333333333333333332;
  m(45,45) = 1;
  m(46,46) = 1;
  m(47,38) = 0.33333333333333333326; m(47,47) = 3.9999999999999999998; m(47,48) = 0.33333333333333333332; m(47,56) = 0.33333333333333333326; m(47,249) = -1.333333333333333333; m(47,268) = -1.3333333333333333332; m(47,273) = -1.3333333333333333332; m(47,274) = -1.3333333333333333333;
  m(48,39) = 0.33333333333333333326; m(48,47) = 0.33333333333333333332; m(48,48) = 3.9999999999999999998; m(48,49) = 0.33333333333333333332; m(48,57) = 0.33333333333333333326; m(48,93) = -1.333333333333333333; m(48,124) = -1.3333333333333333332; m(48,234) = -1.3333333333333333332; m(48,268) = -1.3333333333333333333;
  m(49,40) = 0.33333333333333333326; m(49,48) = 0.33333333333333333332; m(49,49) = 3.9999999999999999998; m(49,50) = 0.33333333333333333332; m(49,58) = 0.33333333333333333326; m(49,96) = -1.333333333333333333; m(49,122) = -1.3333333333333333332; m(49,124) = -1.3333333333333333333; m(49,148) = -1.3333333333333333332;
  m(50,41) = 0.33333333333333333326; m(50,49) = 0.33333333333333333332; m(50,50) = 3.9999999999999999996; m(50,51) = 0.33333333333333333332; m(50,59) = 0.33333333333333333326; m(50,142) = -1.3333333333333333332; m(50,143) = -1.333333333333333333; m(50,148) = -1.3333333333333333333; m(50,227) = -1.3333333333333333332;
  m(51,42) = 0.33333333333333333326; m(51,50) = 0.33333333333333333332; m(51,51) = 3.9999999999999999998; m(51,52) = 0.33333333333333333332; m(51,60) = 0.33333333333333333326; m(51,142) = -1.3333333333333333333; m(51,159) = -1.3333333333333333332; m(51,160) = -1.333333333333333333; m(51,219) = -1.3333333333333333332;
  m(52,43) = 0.33333333333333333326; m(52,51) = 0.33333333333333333332; m(52,52) = 3.9999999999999999998; m(52,53) = 0.33333333333333333332; m(52,61) = 0.33333333333333333326; m(52,116) = -1.333333333333333333; m(52,141) = -1.3333333333333333332; m(52,159) = -1.3333333333333333333; m(52,199) = -1.3333333333333333332;
  m(53,44) = 0.33333333333333333326; m(53,52) = 0.33333333333333333332; m(53,53) = 3.9999999999999999998; m(53,62) = 0.33333333333333333326; m(53,83) = -1.3333333333333333332; m(53,141) = -1.3333333333333333333; m(53,204) = -1.333333333333333333; m(53,265) = -1.3333333333333333332;
  m(54,54) = 1;
  m(55,55) = 1;
  m(56,47) = 0.33333333333333333326; m(56,56) = 3.9999999999999999998; m(56,57) = 0.33333333333333333332; m(56,65) = 0.33333333333333333326; m(56,111) = -1.3333333333333333332; m(56,237) = -1.3333333333333333333; m(56,273) = -1.333333333333333333; m(56,277) = -1.3333333333333333332;
  m(57,48) = 0.33333333333333333326; m(57,56) = 0.33333333333333333332; m(57,57) = 3.9999999999999999996; m(57,58) = 0.33333333333333333332; m(57,66) = 0.33333333333333333326; m(57,233) = -1.3333333333333333332; m(57,234) = -1.333333333333333333; m(57,271) = -1.3333333333333333332; m(57,277) = -1.3333333333333333333;
  m(58,49) = 0.33333333333333333326; m(58,57) = 0.33333333333333333332; m(58,58) = 3.9999999999999999998; m(58,59) = 0.33333333333333333332; m(58,67) = 0.33333333333333333326; m(58,122) = -1.333333333333333333; m(58,231) = -1.3333333333333333332; m(58,233) = -1.3333333333333333333; m(58,235) = -1.3333333333333333332;
  m(59,50) = 0.33333333333333333326; m(59,58) = 0.33333333333333333332; m(59,59) = 3.9999999999999999996; m(59,60) = 0.33333333333333333332; m(59,68) = 0.33333333333333333326; m(59,133) = -1.3333333333333333332; m(59,227) = -1.333333333333333333; m(59,231) = -1.3333333333333333333; m(59,243) = -1.3333333333333333332;
  m(60,51) = 0.33333333333333333326; m(60,59) = 0.33333333333333333332; m(60,60) = 3.9999999999999999998; m(60,61) = 0.33333333333333333332; m(60,69) = 0.33333333333333333326; m(60,131) = -1.3333333333333333332; m(60,133) = -1.3333333333333333333; m(60,218) = -1.3333333333333333332; m(60,219) = -1.333333333333333333;
  m(61,52) = 0.33333333333333333326; m(61,60) = 0.33333333333333333332; m(61,61) = 3.9999999999999999998; m(61,62) = 0.33333333333333333332; m(61,70) = 0.33333333333333333326; m(61,199) = -1.333333333333333333; m(61,213) = -1.3333333333333333332; m(61,218) = -1.3333333333333333333; m(61,272) = -1.3333333333333333332;
  m(62,53) = 0.33333333333333333326; m(62,61) = 0.33333333333333333332; m(62,62) = 3.9999999999999999998; m(62,71) = 0.33333333333333333326; m(62,82) = -1.3333333333333333332; m(62,83) = -1.333333333333333333; m(62,162) = -1.3333333333333333332; m(62,272) = -1.3333333333333333333;
  m(63,63) = 1;
  m(64,64) = 1;
  m(65,56) = 0.33333333333333333326; m(65,65) = 3.9999999999999999998; m(65,66) = 0.33333333333333333332; m(65,110) = -1.3333333333333333332; m(65,111) = -1.333333333333333333; m(65,186) = -1.3333333333333333332; m(65,188) = -1.3333333333333333333;
  m(66,57) = 0.33333333333333333326; m(66,65) = 0.33333333333333333332; m(66,66) = 3.9999999999999999998; m(66,67) = 0.33333333333333333332; m(66,110) = -1.3333333333333333333; m(66,179) = -1.3333333333333333332; m(66,270) = -1.3333333333333333332; m(66,271) = -1.333333333333333333;
  m(67,58) = 0.33333333333333333326; m(67,66) = 0.33333333333333333332; m(67,67) = 3.9999999999999999996; m(67,68) = 0.33333333333333333332; m(67,86) = -1.3333333333333333332; m(67,174) = -1.3333333333333333332; m(67,235) = -1.333333333333333333; m(67,270) = -1.3333333333333333333;
  m(68,59) = 0.33333333333333333326; m(68,67) = 0.33333333333333333332; m(68,68) = 3.9999999999999999998; m(68,69) = 0.33333333333333333332; m(68,173) = -1.3333333333333333332; m(68,174) = -1.3333333333333333333; m(68,243) = -1.333333333333333333; m(68,285) = -1.3333333333333333332;
  m(69,60) = 0.33333333333333333326; m(69,68) = 0.33333333333333333332; m(69,69) = 3.9999999999999999998; m(69,70) = 0.33333333333333333332; m(69,131) = -1.333333333333333333; m(69,242) = -1.3333333333333333332; m(69,281) = -1.3333333333333333332; m(69,285) = -1.3333333333333333333;
  m(70,61) = 0.33333333333333333326; m(70,69) = 0.33333333333333333332; m(70,70) = 3.9999999999999999996; m(70,71) = 0.33333333333333333332; m(70,172) = -1.3333333333333333332; m(70,213) = -1.333333333333333333; m(70,242) = -1.3333333333333333333; m(70,284) = -1.3333333333333333332;
  m(71,62) = 0.33333333333333333326; m(71,70) = 0.33333333333333333332; m(71,71) = 3.9999999999999999998; m(71,161) = -1.3333333333333333332; m(71,162) = -1.333333333333333333; m(71,170) = -1.3333333333333333332; m(71,172) = -1.3333333333333333333;
  m(72,72) = 1;
  m(73,73) = 1;
  m(74,74) = 1;
  m(75,75) = 1;
  m(76,76) = 1;
  m(77,77) = 1;
  m(78,78) = 1;
  m(79,79) = 1;
  m(80,80) = 1;
  m(81,81) = 1;
  m(82,62) = -1.333333333333333333; m(82,82) = 5.3333333333333333335; m(82,84) = -1.3333333333333333334; m(82,163) = -1.3333333333333333333;
  m(83,53) = -1.3333333333333333332; m(83,62) = -1.333333333333333333; m(83,83) = 5.3333333333333333326; m(83,84) = -1.3333333333333333336; m(83,140) = -1.333333333333333333;
  m(84,82) = -1.3333333333333333335; m(84,83) = -1.3333333333333333336; m(84,84) = 5.333333333333333333; m(84,265) = -1.3333333333333333333;
  m(85,85) = 1;
  m(86,67) = -1.3333333333333333332; m(86,86) = 5.3333333333333333326; m(86,87) = -1.3333333333333333336; m(86,210) = -1.333333333333333333;
  m(87,86) = -1.3333333333333333336; m(87,87) = 5.333333333333333333; m(87,173) = -1.333333333333333333; m(87,174) = -1.3333333333333333333;
  m(88,40) = -1.333333333333333333; m(88,41) = -1.3333333333333333333; m(88,88) = 5.3333333333333333335; m(88,90) = -1.3333333333333333334; m(88,149) = -1.3333333333333333333;
  m(89,31) = -1.3333333333333333332; m(89,40) = -1.333333333333333333; m(89,89) = 5.3333333333333333326; m(89,90) = -1.3333333333333333336; m(89,91) = -1.333333333333333333;
  m(90,88) = -1.3333333333333333335; m(90,89) = -1.3333333333333333336; m(90,90) = 5.333333333333333333; m(90,138) = -1.333333333333333333; m(90,181) = -1.3333333333333333333;
  m(91,89) = -1.333333333333333333; m(91,91) = 5.333333333333333333; m(91,92) = -1.3333333333333333333; m(91,98) = -1.3333333333333333335; m(91,191) = -1.3333333333333333336;
  m(92,30) = -1.333333333333333333; m(92,31) = -1.3333333333333333333; m(92,91) = -1.3333333333333333333; m(92,92) = 5.3333333333333333335; m(92,248) = -1.3333333333333333334;
  m(93,39) = -1.3333333333333333332; m(93,48) = -1.333333333333333333; m(93,93) = 5.3333333333333333326; m(93,94) = -1.333333333333333333; m(93,97) = -1.3333333333333333336;
  m(94,93) = -1.333333333333333333; m(94,94) = 5.333333333333333333; m(94,95) = -1.3333333333333333333; m(94,249) = -1.3333333333333333336; m(94,268) = -1.3333333333333333335;
  m(95,38) = -1.333333333333333333; m(95,39) = -1.3333333333333333333; m(95,94) = -1.3333333333333333333; m(95,95) = 5.3333333333333333335; m(95,192) = -1.3333333333333333334;
  m(96,40) = -1.3333333333333333332; m(96,49) = -1.333333333333333333; m(96,96) = 5.3333333333333333326; m(96,97) = -1.333333333333333333; m(96,149) = -1.3333333333333333336;
  m(97,93) = -1.3333333333333333336; m(97,96) = -1.333333333333333333; m(97,97) = 5.333333333333333333; m(97,98) = -1.3333333333333333333; m(97,124) = -1.3333333333333333335;
  m(98,39) = -1.333333333333333333; m(98,40) = -1.3333333333333333333; m(98,91) = -1.3333333333333333334; m(98,97) = -1.3333333333333333333; m(98,98) = 5.3333333333333333335;
  m(99,29) = -1.3333333333333333332; m(99,38) = -1.333333333333333333; m(99,99) = 5.3333333333333333326; m(99,100) = -1.333333333333333333; m(99,192) = -1.3333333333333333336;
  m(100,99) = -1.333333333333333333; m(100,100) = 5.333333333333333333; m(100,101) = -1.3333333333333333333; m(100,251) = -1.3333333333333333335;
  m(101,29) = -1.3333333333333333333; m(101,100) = -1.3333333333333333333; m(101,101) = 5.3333333333333333335; m(101,135) = -1.3333333333333333334;
  m(102,35) = -1.3333333333333333332; m(102,44) = -1.333333333333333333; m(102,102) = 5.3333333333333333326; m(102,103) = -1.333333333333333333; m(102,253) = -1.3333333333333333336;
  m(103,102) = -1.333333333333333333; m(103,103) = 5.333333333333333333; m(103,104) = -1.3333333333333333333; m(103,125) = -1.3333333333333333336; m(103,206) = -1.3333333333333333335;
  m(104,34) = -1.333333333333333333; m(104,35) = -1.3333333333333333333; m(104,103) = -1.3333333333333333333; m(104,104) = 5.3333333333333333335; m(104,176) = -1.3333333333333333334;
  m(105,26) = -1.333333333333333333; m(105,105) = 5.3333333333333333335; m(105,107) = -1.3333333333333333334; m(105,109) = -1.3333333333333333333;
  m(106,17) = -1.3333333333333333332; m(106,26) = -1.333333333333333333; m(106,106) = 5.3333333333333333326; m(106,107) = -1.3333333333333333336; m(106,130) = -1.333333333333333333;
  m(107,105) = -1.3333333333333333335; m(107,106) = -1.3333333333333333336; m(107,107) = 5.333333333333333333; m(107,258) = -1.3333333333333333333;
  m(108,108) = 1;
  m(109,105) = -1.3333333333333333333; m(109,109) = 5.333333333333333333; m(109,229) = -1.3333333333333333336; m(109,254) = -1.3333333333333333335;
  m(110,65) = -1.333333333333333333; m(110,66) = -1.3333333333333333333; m(110,110) = 5.3333333333333333335; m(110,112) = -1.3333333333333333334; m(110,180) = -1.3333333333333333333;
  m(111,56) = -1.3333333333333333332; m(111,65) = -1.333333333333333333; m(111,111) = 5.3333333333333333326; m(111,112) = -1.3333333333333333336; m(111,190) = -1.333333333333333333;
  m(112,110) = -1.3333333333333333335; m(112,111) = -1.3333333333333333336; m(112,112) = 5.333333333333333333; m(112,271) = -1.333333333333333333; m(112,277) = -1.3333333333333333333;
  m(113,11) = -1.3333333333333333333; m(113,113) = 5.3333333333333333335; m(113,115) = -1.3333333333333333334; m(113,224) = -1.3333333333333333333;
  m(114,114) = 1;
  m(115,113) = -1.3333333333333333335; m(115,115) = 5.333333333333333333; m(115,120) = -1.333333333333333333;
  m(116,43) = -1.3333333333333333332; m(116,52) = -1.333333333333333333; m(116,116) = 5.3333333333333333326; m(116,117) = -1.333333333333333333; m(116,205) = -1.3333333333333333336;
  m(117,116) = -1.333333333333333333; m(117,117) = 5.333333333333333333; m(117,118) = -1.3333333333333333333; m(117,159) = -1.3333333333333333335; m(117,160) = -1.3333333333333333336;
  m(118,42) = -1.333333333333333333; m(118,43) = -1.3333333333333333333; m(118,117) = -1.3333333333333333333; m(118,118) = 5.3333333333333333335; m(118,126) = -1.3333333333333333334;
  m(119,11) = -1.333333333333333333; m(119,12) = -1.3333333333333333333; m(119,119) = 5.3333333333333333335; m(119,121) = -1.3333333333333333334; m(119,185) = -1.3333333333333333333;
  m(120,11) = -1.333333333333333333; m(120,115) = -1.333333333333333333; m(120,120) = 5.3333333333333333326; m(120,121) = -1.3333333333333333336;
  m(121,119) = -1.3333333333333333335; m(121,120) = -1.3333333333333333336; m(121,121) = 5.333333333333333333; m(121,240) = -1.333333333333333333;
  m(122,49) = -1.3333333333333333332; m(122,58) = -1.333333333333333333; m(122,122) = 5.3333333333333333326; m(122,123) = -1.333333333333333333; m(122,230) = -1.3333333333333333336;
  m(123,122) = -1.333333333333333333; m(123,123) = 5.333333333333333333; m(123,124) = -1.3333333333333333333; m(123,233) = -1.3333333333333333335; m(123,234) = -1.3333333333333333336;
  m(124,48) = -1.333333333333333333; m(124,49) = -1.3333333333333333333; m(124,97) = -1.3333333333333333334; m(124,123) = -1.3333333333333333333; m(124,124) = 5.3333333333333333335;
  m(125,34) = -1.3333333333333333332; m(125,43) = -1.333333333333333333; m(125,103) = -1.3333333333333333336; m(125,125) = 5.3333333333333333326; m(125,126) = -1.333333333333333333;
  m(126,118) = -1.3333333333333333335; m(126,125) = -1.333333333333333333; m(126,126) = 5.333333333333333333; m(126,127) = -1.3333333333333333333; m(126,266) = -1.3333333333333333336;
  m(127,33) = -1.333333333333333333; m(127,34) = -1.3333333333333333333; m(127,126) = -1.3333333333333333333; m(127,127) = 5.3333333333333333335; m(127,245) = -1.3333333333333333334;
  m(128,25) = -1.333333333333333333; m(128,26) = -1.3333333333333333333; m(128,128) = 5.3333333333333333335; m(128,130) = -1.3333333333333333334; m(128,176) = -1.3333333333333333333;
  m(129,16) = -1.3333333333333333332; m(129,25) = -1.333333333333333333; m(129,129) = 5.3333333333333333326; m(129,130) = -1.3333333333333333336; m(129,167) = -1.333333333333333333;
  m(130,106) = -1.333333333333333333; m(130,128) = -1.3333333333333333335; m(130,129) = -1.3333333333333333336; m(130,130) = 5.333333333333333333; m(130,150) = -1.3333333333333333333;
  m(131,60) = -1.3333333333333333332; m(131,69) = -1.333333333333333333; m(131,131) = 5.3333333333333333326; m(131,132) = -1.333333333333333333; m(131,228) = -1.3333333333333333336;
  m(132,131) = -1.333333333333333333; m(132,132) = 5.333333333333333333; m(132,133) = -1.3333333333333333333; m(132,243) = -1.3333333333333333336; m(132,285) = -1.3333333333333333335;
  m(133,59) = -1.333333333333333333; m(133,60) = -1.3333333333333333333; m(133,132) = -1.3333333333333333333; m(133,133) = 5.3333333333333333335; m(133,226) = -1.3333333333333333334;
  m(134,20) = -1.3333333333333333332; m(134,29) = -1.333333333333333333; m(134,134) = 5.3333333333333333326; m(134,135) = -1.333333333333333333; m(134,165) = -1.3333333333333333336;
  m(135,101) = -1.3333333333333333335; m(135,134) = -1.333333333333333333; m(135,135) = 5.333333333333333333; m(135,136) = -1.3333333333333333333;
  m(136,20) = -1.3333333333333333333; m(136,135) = -1.3333333333333333333; m(136,136) = 5.3333333333333333335; m(136,224) = -1.3333333333333333334;
  m(137,41) = -1.333333333333333333; m(137,42) = -1.3333333333333333333; m(137,137) = 5.3333333333333333335; m(137,139) = -1.3333333333333333334; m(137,144) = -1.3333333333333333333;
  m(138,32) = -1.3333333333333333332; m(138,41) = -1.333333333333333333; m(138,90) = -1.333333333333333333; m(138,138) = 5.3333333333333333326; m(138,139) = -1.3333333333333333336;
  m(139,137) = -1.3333333333333333335; m(139,138) = -1.3333333333333333336; m(139,139) = 5.333333333333333333; m(139,145) = -1.3333333333333333333; m(139,266) = -1.333333333333333333;
  m(140,83) = -1.333333333333333333; m(140,140) = 5.333333333333333333; m(140,141) = -1.3333333333333333333; m(140,199) = -1.3333333333333333336; m(140,272) = -1.3333333333333333335;
  m(141,52) = -1.333333333333333333; m(141,53) = -1.3333333333333333333; m(141,140) = -1.3333333333333333333; m(141,141) = 5.3333333333333333335; m(141,205) = -1.3333333333333333334;
  m(142,50) = -1.333333333333333333; m(142,51) = -1.3333333333333333333; m(142,142) = 5.3333333333333333335; m(142,144) = -1.3333333333333333334; m(142,226) = -1.3333333333333333333;
  m(143,41) = -1.3333333333333333332; m(143,50) = -1.333333333333333333; m(143,143) = 5.3333333333333333326; m(143,144) = -1.3333333333333333336; m(143,149) = -1.333333333333333333;
  m(144,137) = -1.3333333333333333333; m(144,142) = -1.3333333333333333335; m(144,143) = -1.3333333333333333336; m(144,144) = 5.333333333333333333; m(144,160) = -1.333333333333333333;
  m(145,32) = -1.333333333333333333; m(145,33) = -1.3333333333333333333; m(145,139) = -1.3333333333333333333; m(145,145) = 5.3333333333333333335; m(145,147) = -1.3333333333333333334;
  m(146,23) = -1.3333333333333333332; m(146,32) = -1.333333333333333333; m(146,146) = 5.3333333333333333326; m(146,147) = -1.3333333333333333336; m(146,183) = -1.333333333333333333;
  m(147,145) = -1.3333333333333333335; m(147,146) = -1.3333333333333333336; m(147,147) = 5.333333333333333333; m(147,207) = -1.333333333333333333; m(147,208) = -1.3333333333333333333;
  m(148,49) = -1.333333333333333333; m(148,50) = -1.3333333333333333333; m(148,148) = 5.3333333333333333335; m(148,149) = -1.3333333333333333334; m(148,230) = -1.3333333333333333333;
  m(149,88) = -1.3333333333333333333; m(149,96) = -1.3333333333333333336; m(149,143) = -1.333333333333333333; m(149,148) = -1.3333333333333333335; m(149,149) = 5.333333333333333333;
  m(150,16) = -1.333333333333333333; m(150,17) = -1.3333333333333333333; m(150,130) = -1.3333333333333333333; m(150,150) = 5.3333333333333333335; m(150,152) = -1.3333333333333333334;
  m(151,16) = -1.333333333333333333; m(151,151) = 5.3333333333333333326; m(151,152) = -1.3333333333333333336; m(151,155) = -1.333333333333333333;
  m(152,150) = -1.3333333333333333335; m(152,151) = -1.3333333333333333336; m(152,152) = 5.333333333333333333; m(152,275) = -1.333333333333333333;
  m(153,15) = -1.333333333333333333; m(153,16) = -1.3333333333333333333; m(153,153) = 5.3333333333333333335; m(153,155) = -1.3333333333333333334; m(153,167) = -1.3333333333333333333;
  m(154,15) = -1.333333333333333333; m(154,154) = 5.3333333333333333326; m(154,155) = -1.3333333333333333336; m(154,196) = -1.333333333333333333;
  m(155,151) = -1.333333333333333333; m(155,153) = -1.3333333333333333335; m(155,154) = -1.3333333333333333336; m(155,155) = 5.333333333333333333;
  m(156,13) = -1.333333333333333333; m(156,14) = -1.3333333333333333333; m(156,156) = 5.3333333333333333335; m(156,158) = -1.3333333333333333334; m(156,203) = -1.3333333333333333333;
  m(157,13) = -1.333333333333333333; m(157,157) = 5.3333333333333333326; m(157,158) = -1.3333333333333333336; m(157,168) = -1.333333333333333333;
  m(158,156) = -1.3333333333333333335; m(158,157) = -1.3333333333333333336; m(158,158) = 5.333333333333333333; m(158,262) = -1.333333333333333333;
  m(159,51) = -1.333333333333333333; m(159,52) = -1.3333333333333333333; m(159,117) = -1.3333333333333333334; m(159,159) = 5.3333333333333333335; m(159,200) = -1.3333333333333333333;
  m(160,42) = -1.3333333333333333332; m(160,51) = -1.333333333333333333; m(160,117) = -1.3333333333333333336; m(160,144) = -1.333333333333333333; m(160,160) = 5.3333333333333333326;
  m(161,71) = -1.333333333333333333; m(161,161) = 5.3333333333333333335; m(161,163) = -1.3333333333333333334; m(161,178) = -1.3333333333333333333;
  m(162,62) = -1.3333333333333333332; m(162,71) = -1.333333333333333333; m(162,162) = 5.3333333333333333326; m(162,163) = -1.3333333333333333336; m(162,214) = -1.333333333333333333;
  m(163,82) = -1.3333333333333333333; m(163,161) = -1.3333333333333333335; m(163,162) = -1.3333333333333333336; m(163,163) = 5.333333333333333333;
  m(164,21) = -1.3333333333333333332; m(164,30) = -1.333333333333333333; m(164,164) = 5.3333333333333333326; m(164,165) = -1.333333333333333333; m(164,248) = -1.3333333333333333336;
  m(165,134) = -1.3333333333333333336; m(165,164) = -1.333333333333333333; m(165,165) = 5.333333333333333333; m(165,166) = -1.3333333333333333333; m(165,193) = -1.3333333333333333335;
  m(166,20) = -1.333333333333333333; m(166,21) = -1.3333333333333333333; m(166,165) = -1.3333333333333333333; m(166,166) = 5.3333333333333333335; m(166,185) = -1.3333333333333333334;
  m(167,129) = -1.333333333333333333; m(167,153) = -1.3333333333333333333; m(167,167) = 5.333333333333333333; m(167,246) = -1.3333333333333333335; m(167,247) = -1.3333333333333333336;
  m(168,157) = -1.333333333333333333; m(168,168) = 5.333333333333333333; m(168,225) = -1.3333333333333333335; m(168,240) = -1.3333333333333333336;
  m(169,169) = 1;
  m(170,71) = -1.3333333333333333332; m(170,170) = 5.3333333333333333326; m(170,171) = -1.333333333333333333; m(170,178) = -1.3333333333333333336;
  m(171,170) = -1.333333333333333333; m(171,171) = 5.333333333333333333; m(171,172) = -1.3333333333333333333; m(171,284) = -1.3333333333333333336;
  m(172,70) = -1.333333333333333333; m(172,71) = -1.3333333333333333333; m(172,171) = -1.3333333333333333333; m(172,172) = 5.3333333333333333335; m(172,214) = -1.3333333333333333334;
  m(173,68) = -1.3333333333333333332; m(173,87) = -1.333333333333333333; m(173,173) = 5.3333333333333333326; m(173,221) = -1.3333333333333333336;
  m(174,67) = -1.333333333333333333; m(174,68) = -1.3333333333333333333; m(174,87) = -1.3333333333333333333; m(174,174) = 5.3333333333333333335; m(174,244) = -1.3333333333333333334;
  m(175,25) = -1.3333333333333333332; m(175,34) = -1.333333333333333333; m(175,175) = 5.3333333333333333326; m(175,176) = -1.3333333333333333336; m(175,245) = -1.333333333333333333;
  m(176,104) = -1.3333333333333333335; m(176,128) = -1.3333333333333333333; m(176,175) = -1.3333333333333333336; m(176,176) = 5.333333333333333333; m(176,229) = -1.333333333333333333;
  m(177,177) = 1;
  m(178,161) = -1.3333333333333333333; m(178,170) = -1.3333333333333333336; m(178,178) = 5.333333333333333333;
  m(179,66) = -1.3333333333333333332; m(179,179) = 5.3333333333333333326; m(179,180) = -1.333333333333333333; m(179,210) = -1.3333333333333333336;
  m(180,110) = -1.3333333333333333333; m(180,179) = -1.333333333333333333; m(180,180) = 5.333333333333333333; m(180,186) = -1.3333333333333333336;
  m(181,31) = -1.333333333333333333; m(181,32) = -1.3333333333333333333; m(181,90) = -1.3333333333333333333; m(181,181) = 5.3333333333333333335; m(181,183) = -1.3333333333333333334;
  m(182,22) = -1.3333333333333333332; m(182,31) = -1.333333333333333333; m(182,182) = 5.3333333333333333326; m(182,183) = -1.3333333333333333336; m(182,248) = -1.333333333333333333;
  m(183,146) = -1.333333333333333333; m(183,181) = -1.3333333333333333335; m(183,182) = -1.3333333333333333336; m(183,183) = 5.333333333333333333; m(183,201) = -1.3333333333333333333;
  m(184,12) = -1.3333333333333333332; m(184,21) = -1.333333333333333333; m(184,184) = 5.3333333333333333326; m(184,185) = -1.333333333333333333; m(184,195) = -1.3333333333333333336;
  m(185,119) = -1.3333333333333333333; m(185,166) = -1.3333333333333333335; m(185,184) = -1.333333333333333333; m(185,185) = 5.333333333333333333; m(185,198) = -1.3333333333333333336;
  m(186,65) = -1.3333333333333333332; m(186,180) = -1.3333333333333333336; m(186,186) = 5.3333333333333333326; m(186,187) = -1.333333333333333333;
  m(187,186) = -1.333333333333333333; m(187,187) = 5.333333333333333333; m(187,188) = -1.3333333333333333333;
  m(188,65) = -1.3333333333333333333; m(188,187) = -1.3333333333333333333; m(188,188) = 5.3333333333333333335; m(188,190) = -1.3333333333333333334;
  m(189,189) = 1;
  m(190,111) = -1.333333333333333333; m(190,188) = -1.3333333333333333335; m(190,190) = 5.333333333333333333; m(190,237) = -1.3333333333333333333;
  m(191,30) = -1.3333333333333333332; m(191,39) = -1.333333333333333333; m(191,91) = -1.3333333333333333336; m(191,191) = 5.3333333333333333326; m(191,192) = -1.333333333333333333;
  m(192,95) = -1.3333333333333333335; m(192,99) = -1.3333333333333333336; m(192,191) = -1.333333333333333333; m(192,192) = 5.333333333333333333; m(192,193) = -1.3333333333333333333;
  m(193,29) = -1.333333333333333333; m(193,30) = -1.3333333333333333333; m(193,165) = -1.3333333333333333334; m(193,192) = -1.3333333333333333333; m(193,193) = 5.3333333333333333335;
  m(194,21) = -1.333333333333333333; m(194,22) = -1.3333333333333333333; m(194,194) = 5.3333333333333333335; m(194,195) = -1.3333333333333333334; m(194,248) = -1.3333333333333333333;
  m(195,184) = -1.3333333333333333336; m(195,194) = -1.3333333333333333335; m(195,195) = 5.333333333333333333; m(195,202) = -1.333333333333333333; m(195,225) = -1.3333333333333333333;
  m(196,154) = -1.333333333333333333; m(196,196) = 5.333333333333333333; m(196,262) = -1.3333333333333333336; m(196,267) = -1.3333333333333333335;
  m(197,197) = 1;
  m(198,11) = -1.3333333333333333332; m(198,20) = -1.333333333333333333; m(198,185) = -1.3333333333333333336; m(198,198) = 5.3333333333333333326; m(198,224) = -1.333333333333333333;
  m(199,52) = -1.3333333333333333332; m(199,61) = -1.333333333333333333; m(199,140) = -1.3333333333333333336; m(199,199) = 5.3333333333333333326; m(199,200) = -1.333333333333333333;
  m(200,159) = -1.3333333333333333333; m(200,199) = -1.333333333333333333; m(200,200) = 5.333333333333333333; m(200,218) = -1.3333333333333333335; m(200,219) = -1.3333333333333333336;
  m(201,22) = -1.333333333333333333; m(201,23) = -1.3333333333333333333; m(201,183) = -1.3333333333333333333; m(201,201) = 5.3333333333333333335; m(201,203) = -1.3333333333333333334;
  m(202,13) = -1.3333333333333333332; m(202,22) = -1.333333333333333333; m(202,195) = -1.333333333333333333; m(202,202) = 5.3333333333333333326; m(202,203) = -1.3333333333333333336;
  m(203,156) = -1.3333333333333333333; m(203,201) = -1.3333333333333333335; m(203,202) = -1.3333333333333333336; m(203,203) = 5.333333333333333333; m(203,211) = -1.333333333333333333;
  m(204,44) = -1.3333333333333333332; m(204,53) = -1.333333333333333333; m(204,204) = 5.3333333333333333326; m(204,205) = -1.333333333333333333; m(204,260) = -1.3333333333333333336;
  m(205,116) = -1.3333333333333333336; m(205,141) = -1.3333333333333333335; m(205,204) = -1.333333333333333333; m(205,205) = 5.333333333333333333; m(205,206) = -1.3333333333333333333;
  m(206,43) = -1.333333333333333333; m(206,44) = -1.3333333333333333333; m(206,103) = -1.3333333333333333334; m(206,205) = -1.3333333333333333333; m(206,206) = 5.3333333333333333335;
  m(207,24) = -1.3333333333333333332; m(207,33) = -1.333333333333333333; m(207,147) = -1.333333333333333333; m(207,207) = 5.3333333333333333326; m(207,245) = -1.3333333333333333336;
  m(208,23) = -1.333333333333333333; m(208,24) = -1.3333333333333333333; m(208,147) = -1.3333333333333333333; m(208,208) = 5.3333333333333333335; m(208,212) = -1.3333333333333333334;
  m(209,209) = 1;
  m(210,86) = -1.333333333333333333; m(210,179) = -1.3333333333333333336; m(210,210) = 5.333333333333333333; m(210,270) = -1.3333333333333333333;
  m(211,14) = -1.3333333333333333332; m(211,23) = -1.333333333333333333; m(211,203) = -1.333333333333333333; m(211,211) = 5.3333333333333333326; m(211,212) = -1.3333333333333333336;
  m(212,208) = -1.3333333333333333335; m(212,211) = -1.3333333333333333336; m(212,212) = 5.333333333333333333; m(212,247) = -1.333333333333333333; m(212,267) = -1.3333333333333333333;
  m(213,61) = -1.3333333333333333332; m(213,70) = -1.333333333333333333; m(213,213) = 5.3333333333333333326; m(213,214) = -1.3333333333333333336; m(213,228) = -1.333333333333333333;
  m(214,162) = -1.333333333333333333; m(214,172) = -1.3333333333333333335; m(214,213) = -1.3333333333333333336; m(214,214) = 5.333333333333333333; m(214,272) = -1.3333333333333333333;
  m(215,215) = 1;
  m(216,216) = 5.333333333333333333; m(216,258) = -1.3333333333333333335; m(216,275) = -1.3333333333333333336;
  m(217,217) = 1;
  m(218,60) = -1.333333333333333333; m(218,61) = -1.3333333333333333333; m(218,200) = -1.3333333333333333334; m(218,218) = 5.3333333333333333335; m(218,228) = -1.3333333333333333333;
  m(219,51) = -1.3333333333333333332; m(219,60) = -1.333333333333333333; m(219,200) = -1.3333333333333333336; m(219,219) = 5.3333333333333333326; m(219,226) = -1.333333333333333333;
  m(220,220) = 1;
  m(221,173) = -1.3333333333333333336; m(221,221) = 5.333333333333333333; m(221,281) = -1.333333333333333333; m(221,285) = -1.3333333333333333333;
  m(222,222) = 1;
  m(223,223) = 1;
  m(224,113) = -1.3333333333333333333; m(224,136) = -1.3333333333333333335; m(224,198) = -1.333333333333333333; m(224,224) = 5.333333333333333333;
  m(225,12) = -1.333333333333333333; m(225,13) = -1.3333333333333333333; m(225,168) = -1.3333333333333333334; m(225,195) = -1.3333333333333333333; m(225,225) = 5.3333333333333333335;
  m(226,133) = -1.3333333333333333335; m(226,142) = -1.3333333333333333333; m(226,219) = -1.333333333333333333; m(226,226) = 5.333333333333333333; m(226,227) = -1.3333333333333333336;
  m(227,50) = -1.3333333333333333332; m(227,59) = -1.333333333333333333; m(227,226) = -1.3333333333333333336; m(227,227) = 5.3333333333333333326; m(227,230) = -1.333333333333333333;
  m(228,131) = -1.3333333333333333336; m(228,213) = -1.333333333333333333; m(228,218) = -1.3333333333333333333; m(228,228) = 5.333333333333333333; m(228,242) = -1.3333333333333333335;
  m(229,26) = -1.3333333333333333332; m(229,35) = -1.333333333333333333; m(229,109) = -1.3333333333333333336; m(229,176) = -1.333333333333333333; m(229,229) = 5.3333333333333333326;
  m(230,122) = -1.3333333333333333336; m(230,148) = -1.3333333333333333333; m(230,227) = -1.333333333333333333; m(230,230) = 5.333333333333333333; m(230,231) = -1.3333333333333333335;
  m(231,58) = -1.333333333333333333; m(231,59) = -1.3333333333333333333; m(231,230) = -1.3333333333333333334; m(231,231) = 5.3333333333333333335; m(231,244) = -1.3333333333333333333;
  m(232,232) = 1;
  m(233,57) = -1.333333333333333333; m(233,58) = -1.3333333333333333333; m(233,123) = -1.3333333333333333334; m(233,233) = 5.3333333333333333335; m(233,236) = -1.3333333333333333333;
  m(234,48) = -1.3333333333333333332; m(234,57) = -1.333333333333333333; m(234,123) = -1.3333333333333333336; m(234,234) = 5.3333333333333333326; m(234,269) = -1.333333333333333333;
  m(235,58) = -1.3333333333333333332; m(235,67) = -1.333333333333333333; m(235,235) = 5.3333333333333333326; m(235,236) = -1.333333333333333333; m(235,244) = -1.3333333333333333336;
  m(236,233) = -1.3333333333333333333; m(236,235) = -1.333333333333333333; m(236,236) = 5.333333333333333333; m(236,270) = -1.3333333333333333335; m(236,271) = -1.3333333333333333336;
  m(237,56) = -1.3333333333333333333; m(237,190) = -1.3333333333333333333; m(237,237) = 5.3333333333333333335; m(237,239) = -1.3333333333333333334;
  m(238,238) = 1;
  m(239,237) = -1.3333333333333333335; m(239,239) = 5.333333333333333333; m(239,273) = -1.333333333333333333; m(239,274) = -1.3333333333333333333;
  m(240,12) = -1.333333333333333333; m(240,121) = -1.333333333333333333; m(240,168) = -1.3333333333333333336; m(240,240) = 5.3333333333333333326;
  m(241,241) = 1;
  m(242,69) = -1.333333333333333333; m(242,70) = -1.3333333333333333333; m(242,228) = -1.3333333333333333334; m(242,242) = 5.3333333333333333335; m(242,282) = -1.3333333333333333333;
  m(243,59) = -1.3333333333333333332; m(243,68) = -1.333333333333333333; m(243,132) = -1.3333333333333333336; m(243,243) = 5.3333333333333333326; m(243,244) = -1.333333333333333333;
  m(244,174) = -1.3333333333333333335; m(244,231) = -1.3333333333333333333; m(244,235) = -1.3333333333333333336; m(244,243) = -1.333333333333333333; m(244,244) = 5.333333333333333333;
  m(245,127) = -1.3333333333333333335; m(245,175) = -1.333333333333333333; m(245,207) = -1.3333333333333333336; m(245,245) = 5.333333333333333333; m(245,246) = -1.3333333333333333333;
  m(246,24) = -1.333333333333333333; m(246,25) = -1.3333333333333333333; m(246,167) = -1.3333333333333333334; m(246,245) = -1.3333333333333333333; m(246,246) = 5.3333333333333333335;
  m(247,15) = -1.3333333333333333332; m(247,24) = -1.333333333333333333; m(247,167) = -1.3333333333333333336; m(247,212) = -1.333333333333333333; m(247,247) = 5.3333333333333333326;
  m(248,92) = -1.3333333333333333335; m(248,164) = -1.3333333333333333336; m(248,182) = -1.333333333333333333; m(248,194) = -1.3333333333333333333; m(248,248) = 5.333333333333333333;
  m(249,38) = -1.3333333333333333332; m(249,47) = -1.333333333333333333; m(249,94) = -1.3333333333333333336; m(249,249) = 5.3333333333333333326; m(249,250) = -1.333333333333333333;
  m(250,249) = -1.333333333333333333; m(250,250) = 5.333333333333333333; m(250,251) = -1.3333333333333333333; m(250,274) = -1.3333333333333333335;
  m(251,38) = -1.3333333333333333333; m(251,100) = -1.3333333333333333334; m(251,250) = -1.3333333333333333333; m(251,251) = 5.3333333333333333335;
  m(252,252) = 1;
  m(253,102) = -1.3333333333333333336; m(253,253) = 5.333333333333333333; m(253,254) = -1.3333333333333333333; m(253,261) = -1.3333333333333333335;
  m(254,35) = -1.333333333333333333; m(254,109) = -1.3333333333333333334; m(254,253) = -1.3333333333333333333; m(254,254) = 5.3333333333333333335;
  m(255,255) = 1;
  m(256,256) = 1;
  m(257,257) = 1;
  m(258,17) = -1.333333333333333333; m(258,107) = -1.3333333333333333333; m(258,216) = -1.3333333333333333334; m(258,258) = 5.3333333333333333335;
  m(259,259) = 1;
  m(260,204) = -1.3333333333333333336; m(260,260) = 5.333333333333333333; m(260,261) = -1.3333333333333333333; m(260,265) = -1.3333333333333333335;
  m(261,44) = -1.333333333333333333; m(261,253) = -1.3333333333333333334; m(261,260) = -1.3333333333333333333; m(261,261) = 5.3333333333333333335;
  m(262,14) = -1.333333333333333333; m(262,158) = -1.333333333333333333; m(262,196) = -1.3333333333333333336; m(262,262) = 5.3333333333333333326;
  m(263,263) = 1;
  m(264,264) = 1;
  m(265,53) = -1.333333333333333333; m(265,84) = -1.3333333333333333333; m(265,260) = -1.3333333333333333334; m(265,265) = 5.3333333333333333335;
  m(266,33) = -1.3333333333333333332; m(266,42) = -1.333333333333333333; m(266,126) = -1.3333333333333333336; m(266,139) = -1.333333333333333333; m(266,266) = 5.3333333333333333326;
  m(267,14) = -1.333333333333333333; m(267,15) = -1.3333333333333333333; m(267,196) = -1.3333333333333333334; m(267,212) = -1.3333333333333333333; m(267,267) = 5.3333333333333333335;
  m(268,47) = -1.333333333333333333; m(268,48) = -1.3333333333333333333; m(268,94) = -1.3333333333333333334; m(268,268) = 5.3333333333333333335; m(268,269) = -1.3333333333333333333;
  m(269,234) = -1.333333333333333333; m(269,268) = -1.3333333333333333333; m(269,269) = 5.333333333333333333; m(269,273) = -1.3333333333333333336; m(269,277) = -1.3333333333333333335;
  m(270,66) = -1.333333333333333333; m(270,67) = -1.3333333333333333333; m(270,210) = -1.3333333333333333333; m(270,236) = -1.3333333333333333334; m(270,270) = 5.3333333333333333335;
  m(271,57) = -1.3333333333333333332; m(271,66) = -1.333333333333333333; m(271,112) = -1.333333333333333333; m(271,236) = -1.3333333333333333336; m(271,271) = 5.3333333333333333326;
  m(272,61) = -1.333333333333333333; m(272,62) = -1.3333333333333333333; m(272,140) = -1.3333333333333333334; m(272,214) = -1.3333333333333333333; m(272,272) = 5.3333333333333333335;
  m(273,47) = -1.3333333333333333332; m(273,56) = -1.333333333333333333; m(273,239) = -1.333333333333333333; m(273,269) = -1.3333333333333333336; m(273,273) = 5.3333333333333333326;
  m(274,47) = -1.3333333333333333333; m(274,239) = -1.3333333333333333333; m(274,250) = -1.3333333333333333334; m(274,274) = 5.3333333333333333335;
  m(275,17) = -1.333333333333333333; m(275,152) = -1.333333333333333333; m(275,216) = -1.3333333333333333336; m(275,275) = 5.3333333333333333326;
  m(276,276) = 1;
  m(277,56) = -1.333333333333333333; m(277,57) = -1.3333333333333333333; m(277,112) = -1.3333333333333333333; m(277,269) = -1.3333333333333333334; m(277,277) = 5.3333333333333333335;
  m(278,278) = 1;
  m(279,279) = 1;
  m(280,280) = 1;
  m(281,69) = -1.3333333333333333332; m(281,221) = -1.333333333333333333; m(281,281) = 5.3333333333333333326; m(281,282) = -1.3333333333333333336;
  m(282,242) = -1.3333333333333333333; m(282,281) = -1.3333333333333333336; m(282,282) = 5.333333333333333333; m(282,284) = -1.333333333333333333;
  m(283,283) = 1;
  m(284,70) = -1.3333333333333333332; m(284,171) = -1.3333333333333333336; m(284,282) = -1.333333333333333333; m(284,284) = 5.3333333333333333326;
  m(285,68) = -1.333333333333333333; m(285,69) = -1.3333333333333333333; m(285,132) = -1.3333333333333333334; m(285,221) = -1.3333333333333333333; m(285,285) = 5.3333333333333333335;
  m(286,286) = 1;
  m(287,287) = 1;
  m(288,288) = 1;
  m(289,289) = 1;

  b[1] = 2;
  b[2] = 2.1331484530668263168;
  b[3] = 2.2840254166877414842;
  b[4] = 2.4549914146182013361;
  b[5] = 2.6487212707001281469;
  b[6] = 2.8682459574322224064;
  b[7] = 3.1170000166126746685;
  b[8] = 3.3988752939670979147;
  b[9] = 3.7182818284590452354;
  b[10] = 2.1331484530668263168;
  b[11] = -1.4220835873903928769;
  b[12] = -0.7613254002422188626;
  b[13] = -0.81831290587554756077;
  b[14] = -0.88288820972809102538;
  b[15] = -0.95606161539492092219;
  b[16] = -1.0389779468319205624;
  b[17] = -2.416744553375690148;
  b[18] = 3.8514302815258715522;
  b[19] = 2.2840254166877414842;
  b[20] = -0.76132540024221886265;
  b[21] = 1.7429319898596483303e-05;
  b[22] = 1.8589663389848971629e-05;
  b[23] = 1.9904504821987888867e-05;
  b[24] = 2.1394415356844273594e-05;
  b[25] = 2.3082705174624753204e-05;
  b[26] = -1.3340774192607589347;
  b[27] = 4.0023072451467867194;
  b[28] = 2.4549914146182013361;
  b[29] = -0.81831290587554756082;
  b[30] = 1.8589663389848971056e-05;
  b[31] = 1.9750006881101459154e-05;
  b[32] = 2.1064848313240376859e-05;
  b[33] = 2.255475884809676149e-05;
  b[34] = 2.4243048665877241183e-05;
  b[35] = -1.3910649248940876328;
  b[36] = 4.1732732430772465715;
  b[37] = 2.6487212707001281469;
  b[38] = -0.88288820972809102549;
  b[39] = 1.9904504821987888142e-05;
  b[40] = 2.106484831324037666e-05;
  b[41] = 2.2379689745379293776e-05;
  b[42] = 2.3869600280235677729e-05;
  b[43] = 2.5557890098016158212e-05;
  b[44] = -1.4556402287466310974;
  b[45] = 4.3670030991591733821;
  b[46] = 2.8682459574322224064;
  b[47] = -0.95606161539492092225;
  b[48] = 2.1394415356844273336e-05;
  b[49] = 2.2554758848096761291e-05;
  b[50] = 2.3869600280235678134e-05;
  b[51] = 2.535951081509206278e-05;
  b[52] = 2.7047800632872542532e-05;
  b[53] = -1.5288136344134609944;
  b[54] = 4.586527785891267642;
  b[55] = 3.1170000166126746685;
  b[56] = -1.0389779468319205625;
  b[57] = 2.308270517462475276e-05;
  b[58] = 2.4243048665877241447e-05;
  b[59] = 2.5557890098016157186e-05;
  b[60] = 2.7047800632872542704e-05;
  b[61] = 2.8736090450653023469e-05;
  b[62] = -1.6117299658504606343;
  b[63] = 4.8352818450717199037;
  b[64] = 3.3988752939670979147;
  b[65] = -2.4167445533756901483;
  b[66] = -1.3340774192607589348;
  b[67] = -1.391064924894087633;
  b[68] = -1.4556402287466310977;
  b[69] = -1.5288136344134609945;
  b[70] = -1.6117299658504606345;
  b[71] = -3.4114055193609874193;
  b[72] = 5.1171571224261431501;
  b[73] = 3.7182818284590452354;
  b[74] = 3.8514302815258715522;
  b[75] = 4.0023072451467867194;
  b[76] = 4.1732732430772465715;
  b[77] = 4.3670030991591733821;
  b[78] = 4.586527785891267642;
  b[79] = 4.8352818450717199037;
  b[80] = 5.1171571224261431501;
  b[81] = 5.4365636569180904709;
  b[82] = 6.4227055328997812431;
  b[83] = -0.022862705653093183558;
  b[84] = 6.2523585352964889512;
  b[85] = 4.2671121270931783335;
  b[86] = 5.5434771546902872762;
  b[87] = 5.6681077189992647193;
  b[88] = -0.016661539657355340697;
  b[89] = -0.015652004317737132657;
  b[90] = -0.016139952030002040737;
  b[91] = -0.015191704852171397245;
  b[92] = -0.014703757139906489169;
  b[93] = -0.015835597330158153903;
  b[94] = -0.015429384477535047776;
  b[95] = -0.014876467282204570316;
  b[96] = -0.016726509140420910081;
  b[97] = -0.01626620967485517467;
  b[98] = -0.015713292479524697213;
  b[99] = -0.01397486559444145903;
  b[100] = 3.3848240141686326153;
  b[101] = 3.260193449859655173;
  b[102] = -0.020570627352772439234;
  b[103] = -0.019811721833002310149;
  b[104] = -0.019323774120737402081;
  b[105] = 5.316413402593270231;
  b[106] = -0.018785554977621668853;
  b[107] = 5.2130927257568789716;
  b[108] = 4.0851197696328415982;
  b[109] = 5.4263994895633130477;
  b[110] = -0.018785554977621668948;
  b[111] = -0.017646635397441728357;
  b[112] = -0.01802664945785153977;
  b[113] = 2.8327466398477841539;
  b[114] = 2.0644944589178594297;
  b[115] = 5.4942257411238708226;
  b[116] = -0.020176266923558053909;
  b[117] = -0.019506535153006562493;
  b[118] = -0.018953617957676085033;
  b[119] = -0.012189793219290688919;
  b[120] = 2.8327466398477841548;
  b[121] = 2.9298090209262468687;
  b[122] = -0.017944082618057876989;
  b[123] = -0.017483783152492141574;
  b[124] = -0.016857245887929362798;
  b[125] = -0.019101762100874276483;
  b[126] = -0.018432030330322785066;
  b[127] = -0.017944082618057876986;
  b[128] = -0.018432862310474645897;
  b[129] = -0.017316689725723506097;
  b[130] = -0.018026649457851539771;
  b[131] = -0.021477262868760275706;
  b[132] = -0.02088622665568608758;
  b[133] = -0.020176266923558053912;
  b[134] = -0.013026618416610815571;
  b[135] = 3.143115784732680945;
  b[136] = 3.0331296977626381267;
  b[137] = -0.017736044480039118125;
  b[138] = -0.016661539657355340699;
  b[139] = -0.017214456852685818163;
  b[140] = -0.022103800133323054483;
  b[141] = -0.021477262868760275708;
  b[142] = -0.018879997888443783714;
  b[143] = -0.017736044480039118123;
  b[144] = -0.018288961675369595588;
  b[145] = -0.016726509140420910086;
  b[146] = -0.015713292479524697217;
  b[147] = -0.01626620967485517467;
  b[148] = -0.017805493065760006285;
  b[149] = -0.017214456852685818157;
  b[150] = -0.017646635397441728686;
  b[151] = 4.1394218280691491398;
  b[152] = 4.3207582291377329411;
  b[153] = -0.016266943894762203607;
  b[154] = 3.8090460181969937273;
  b[155] = 3.9690748304658568478;
  b[156] = -0.013974865594441459289;
  b[157] = 3.2601934498596551739;
  b[158] = 3.3848240141686326147;
  b[159] = -0.020097571366080750616;
  b[160] = -0.018879997888443783714;
  b[161] = 6.7970703707871140756;
  b[162] = -0.024242397155772708641;
  b[163] = 6.604041933968365044;
  b[164] = -0.013812845329643732989;
  b[165] = -0.013406632477020626861;
  b[166] = -0.01297602013232360609;
  b[167] = -0.016646957955172014681;
  b[168] = 3.1431157847326809448;
  b[169] = 2.3668379411737963628;
  b[170] = 6.7970703707871140743;
  b[171] = 6.6040419339683650458;
  b[172] = -0.02424239715577270876;
  b[173] = 5.8007740941265714821;
  b[174] = -0.020570627352772439334;
  b[175] = -0.018153514923043632996;
  b[176] = -0.01886347465517166667;
  b[177] = 5.271871286521972109;
  b[178] = 14.031713148505314879;
  b[179] = 5.3164134025932702297;
  b[180] = 5.2130927257568789729;
  b[181] = -0.015652004317737132657;
  b[182] = -0.014703757139906489169;
  b[183] = -0.015191704852171397243;
  b[184] = -0.01297602013232360609;
  b[185] = -0.012569807279700499963;
  b[186] = 5.1160303446784162577;
  b[187] = 9.7629694448145928516;
  b[188] = 4.5137866659564819709;
  b[189] = 3.2535347872132085447;
  b[190] = 4.320758229137732942;
  b[191] = -0.014761092507474376479;
  b[192] = -0.014354879654851270349;
  b[193] = -0.01386693194258636227;
  b[194] = -0.013812845329643732986;
  b[195] = -0.01340663247702062686;
  b[196] = 3.6587153204475027831;
  b[197] = 2.7550546569602985573;
  b[198] = -0.012189793219290688691;
  b[199] = -0.021393840401195020809;
  b[200] = -0.020724108630643529392;
  b[201] = -0.014761092507474376478;
  b[202] = -0.013866931942586362271;
  b[203] = -0.014354879654851270347;
  b[204] = -0.021645132175456216655;
  b[205] = -0.020886226655686087583;
  b[206] = -0.020333309460355610125;
  b[207] = -0.016857245887929362798;
  b[208] = -0.015835597330158153905;
  b[209] = 4.0851197696328415982;
  b[210] = 5.426399489563313049;
  b[211] = -0.014876467282204570313;
  b[212] = -0.015429384477535047774;
  b[213] = -0.022773531903874545905;
  b[214] = -0.02348349163600257958;
  b[215] = 3.7827762873769046649;
  b[216] = 9.7629694448145928481;
  b[217] = 3.5535894580629268733;
  b[218] = -0.021393840401195020812;
  b[219] = -0.020097571366080750611;
  b[220] = 4.4733364854193437927;
  b[221] = 5.9419990252781348878;
  b[222] = 2.0644944589178594297;
  b[223] = 2.2062302494209807106;
  b[224] = 2.9298090209262468693;
  b[225] = -0.013026618416610815813;
  b[226] = -0.01950653515300656249;
  b[227] = -0.01895361795767608503;
  b[228] = -0.022103800133323054487;
  b[229] = -0.01962238017494179575;
  b[230] = -0.018432030330322785066;
  b[231] = -0.019101762100874276478;
  b[232] = 2.3668379411737963628;
  b[233] = -0.018153514923043632994;
  b[234] = -0.017053170807795120808;
  b[235] = -0.019323774120737402081;
  b[236] = -0.018863474655171666667;
  b[237] = 4.1394218280691491389;
  b[238] = 2.988737469582291831;
  b[239] = 3.9690748304658568482;
  b[240] = 3.0331296977626381276;
  b[241] = 2.2062302494209807106;
  b[242] = -0.022862705653093183665;
  b[243] = -0.020333309460355610121;
  b[244] = -0.019811721833002310151;
  b[245] = -0.017483783152492141577;
  b[246] = -0.017053170807795120808;
  b[247] = -0.016020420690609235897;
  b[248] = -0.014243457674340753759;
  b[249] = -0.015049370417125236429;
  b[250] = 3.6587153204475027838;
  b[251] = 3.5174903892959393792;
  b[252] = 4.2671121270931783335;
  b[253] = 5.668107718999264718;
  b[254] = 5.5434771546902872771;
  b[255] = 3.7827762873769046649;
  b[256] = 3.5535894580629268733;
  b[257] = 3.924512077880025946;
  b[258] = 5.1160303446784162586;
  b[259] = 4.4733364854193437927;
  b[260] = 5.941999025278134886;
  b[261] = 5.8007740941265714834;
  b[262] = 3.5174903892959393803;
  b[263] = 2.5488302986341330979;
  b[264] = 4.7070192980413370666;
  b[265] = 6.0923297230276258311;
  b[266] = -0.017805493065760006289;
  b[267] = -0.015049370417125236713;
  b[268] = -0.016020420690609235901;
  b[269] = -0.016646957955172014678;
  b[270] = -0.019622380174941795848;
  b[271] = -0.018432862310474645893;
  b[272] = -0.022773531903874545899;
  b[273] = -0.016266943894762203297;
  b[274] = 3.8090460181969937265;
  b[275] = 4.5137866659564819722;
  b[276] = 3.2535347872132085447;
  b[277] = -0.017316689725723506095;
  b[278] = 3.924512077880025946;
  b[279] = 2.7550546569602985573;
  b[280] = 4.7070192980413370666;
  b[281] = 6.0923297230276258294;
  b[282] = 6.2523585352964889529;
  b[283] = 4.9718166156722537804;
  b[284] = 6.4227055328997812414;
  b[285] = -0.021645132175456216765;
  b[286] = 4.9718166156722537804;
  b[287] = 5.271871286521972109;
  b[288] = 2.988737469582291831;
  b[289] = 2.5488302986341330979;

  matrix<long double> DuDv (Uh.GlobalDofNumber(), Uh.GlobalDofNumber());
  Uh.DUDV (DuDv);

  vector<long double> s = Uh.B (f_test_p2c, NbIntPts);
  Uh.Dirichlet (DuDv, s, u_test_p2c);

  for (int i=1; i<=Uh.GlobalDofNumber(); i++)
    boolean *= (abs (b[i] - s[i]) <= epsilon_loc);

  if (detail) affiche ("Integration right-hand side", boolean);
  else result *= boolean;

  boolean = 1;
  for (int i=1; i<=Uh.GlobalDofNumber(); i++)
    for (int j=1; j<=Uh.GlobalDofNumber(); j++)
      boolean *= (abs (m (i,j) - DuDv (i,j)) <= epsilon_loc);

  if (detail) affiche ("Stifness Matrix", boolean);
  else result *= boolean;

  long double l2_error_loc = 2.8360857771533159629e-05;
  long double semi_h1_error_loc = 0.0014703450498160601222;

  vector<long double> x0 (s.dim());
  vector<long double> uh (s.dim());
  int iter;
  uh = conjugate_gradient (DuDv, s, x0, iter, 1.e-12);

  boolean = (abs (l2_error_loc - Uh.error_L2 (u_test_p2c, uh, NbIntPts)) <= epsilon_loc);
  if (detail) affiche ("l2 error", boolean);
  else result *= boolean;

  boolean = (abs (semi_h1_error_loc - Uh.error_semi_H1 (dudx_test_p2c, dudy_test_p2c, uh,NbIntPts)) <= epsilon_loc);
  if (detail) affiche ("semi h1 error", boolean);
  else result *= boolean;


  cout << "============================================================== \n";
  if (result) cout << green << "                      p2c2d test passed" << reset;
  else cout << red << "                      p2c2d test failed" << reset;
  cout << "============================================================== \n";

  return result;
}


#endif
