/***************************************************************
 *                    simula.plus@cemes.fr                     *
 *                   GNU/linux version 3.0.0                   *
 *            software under General Public License            *
 ***************************************************************
 * copyright © 2004 CREUSE Emmanuel
 * copyright © 2004 KALETA Olivia
 * copyright © 2004 SOUALEM Nadir
 * copyright © 2012 COLLARD Christophe
 * copyright © 2004,2012 Centre National de la Recherche Scientifique
 * copyright © 2004 Arts et Métiers ParisTech
 * copyright © 2004 Université de Valenciennes et du Hainaut Cambrésis
 * copyright © 2004 Laboratoire de Physique et Mécanique des Matériaux (LPMM - UMR 7554)
 * copyright © 2004 Laboratoire de Mathématiques et ses Applications de Valenciennes (LAMAV - EA 4015)
 * copyright © 2012 Centre d'Elaboration de Matériaux et d'Etudes Structurales (CEMES - CNRS)
 ***************************************************************/

/*
    q12d-test belongs to Mathematical Object Libraries (FEMOL++)
    FEMOL++ is part of Simula+

    Simula+ is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    Simula+ is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with Simula+; if not, write to the Free Software
    Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
*/

#ifndef __cplusplus
#error Must use C++ for the type q12d-test
#endif

#ifndef __q12d_test_hpp
#define __q12d_test_hpp

#ifndef __iostream
#include <iostream>
#endif

#ifndef __iomanip
#include <iomanip>
#endif

#ifndef __assert_h
#include <assert.h>
#endif

#ifndef __time_h
#include <time.h>
#endif

#ifndef __maths_hpp
#include "MOL++/maths.hpp"
#endif

#ifndef __vectors_hpp
#include "MOL++/vectors.hpp"
#endif

#ifndef __mesh_hpp
#include "FEMOL++/meshes/mesh.hpp"
#endif

#ifndef __rectangle_hpp
#include "FEMOL++/meshes/rectangle.hpp"
#endif

#ifndef __q12d_hpp
#include "FEMOL++/elements/q12d.hpp"
#endif

#ifndef __affiche_hpp
#include "tests/affiche.hpp"
#endif


long double f_test_q1 (long double x, long double y)
{
  return -exp(x) - exp(y);
}

long double u_test_q1 (long double x, long double y)
{
  return exp(x) + exp(y);
}

long double dudx_test_q1 (long double x, long double y)
{
  return exp(x);
}

long double dudy_test_q1 (long double x, long double y)
{
  return exp(y);
}


//========================
int test_q12d (int detail)
//========================
{
  int result = 1;

  if (detail < 0) 
    { cout << "============================================================== \n";
      cout << blue << "                      q12d test skipped" << reset;
      cout << "============================================================== \n";
      return result;
    }

  q12d<long double> Uh ("data/16rec.txt", "data/16rec1.txt");
  q12d<long double> Uh2 ("data/16rect.txt");
  q12d<long double> Th ("data/32rec.txt", "data/32rec1.txt");
  q12d<long double> Th2 ("data/32rect.txt");
  q12d<long double> Th3, Th4, Uh3, Uh4;

  if (detail) affiche ("operator ==", Th == Th2  &&  Uh == Uh2  &&  !(Uh == Th));
  else result *= (Th == Th2  &&  Uh == Uh2  &&  !(Uh == Th));

  if (detail) affiche ("operator !=", Th != Uh  &&  !(Th != Th2));
  else result *= (Th != Uh  &&  !(Th != Th2));

  q12d<long double> Vh (Uh);
  if (detail) affiche ("copy constructor", Vh == Uh);
  else result *= (Vh == Uh);

  Th3 = Th;
  Th4 = Th2;
  Uh3 = Uh;
  Uh4 = Uh2;
  if (detail) affiche ("operator =", Th==Th3 && Th4==Th2 && Uh==Uh3 && Uh4==Uh2);
  else result *= (Th==Th3 && Th4==Th2 && Uh==Uh3 && Uh4==Uh2);

  matrix<long double> MASS (4,4);

  MASS(1,1) = MASS(2,2) = MASS(3,3) = MASS(4,4) = 1./9.;
  MASS(1,2) = MASS(1,4) = MASS(2,1) = MASS(2,3) = MASS(3,2) = MASS(3,4) = MASS(4,1) = MASS(4,3) = 1./18.;
  MASS(1,3) = MASS(2,4) = MASS(3,1) = MASS(4,2) = 1./36.;

  if (detail) affiche ("RefMassMatrix", MASS == Uh.RefMassMatrix());
  else result *= (MASS == Uh.RefMassMatrix());

  if (detail) affiche ("DofNumber", 4 == Uh.DofNumber());
  else result *= (4 == Uh.DofNumber());

  if (detail) affiche ("GlobalDofNumber", 289 == Uh.GlobalDofNumber());
  else result *= (289 == Uh.GlobalDofNumber());

  if (detail) affiche ("operator ()", (Uh(3,1) == Uh2(3,1)) && (Uh(3,1)) && (Uh(3,3)==Uh2(3,3)) && (Uh(3,3)) && (Uh(1,4)==Uh2(1,4)) && (Uh(1,4)) && (Uh(4,2)==Uh2(4,2)) && (Uh(4,2)));
  else result *= ((Uh(3,1) == Uh2(3,1)) && (Uh(3,1)) && (Uh(3,3)==Uh2(3,3)) && (Uh(3,3)) && (Uh(1,4)==Uh2(1,4)) && (Uh(1,4)) && (Uh(4,2)==Uh2(4,2)) && (Uh(4,2)));

  if (detail) affiche ("LocalMassMatrix", Uh.LocalMassMatrix(1) == ((long double)(1/256.)*Uh.RefMassMatrix()));
  else result *= (Uh.LocalMassMatrix(1) == ((long double)(1./256.)*Uh.RefMassMatrix()));

  int NbIntPts = 10;
  matrix<long double> m (Uh.GlobalDofNumber(), Uh.GlobalDofNumber());
  vector<long double> b (Uh.GlobalDofNumber());
  long double epsilon_loc = 1e-10;
  int boolean = 1;
  m(1,1) = 1;
  m(2,2) = 1;
  m(3,3) = 1;
  m(4,4) = 1;
  m(5,5) = 1;
  m(6,6) = 1;
  m(7,7) = 1;
  m(8,8) = 1;
  m(9,9) = 1;
  m(10,10) = 1;
  m(11,11) = 1;
  m(12,12) = 1;
  m(13,13) = 1;
  m(14,14) = 1;
  m(15,15) = 1;
  m(16,16) = 1;
  m(17,17) = 1;
  m(18,18) = 1;
  m(19,19) = 2.666666666666667;
  m(19,20) = -0.3333333333333333;
  m(19,36) = -0.3333333333333333;
  m(19,37) = -0.3333333333333333;
  m(20,19) = -0.3333333333333333;
  m(20,20) = 2.666666666666667;
  m(20,21) = -0.3333333333333333;
  m(20,36) = -0.3333333333333333;
  m(20,37) = -0.3333333333333333;
  m(20,38) = -0.3333333333333333;
  m(21,20) = -0.3333333333333333;
  m(21,21) = 2.666666666666667;
  m(21,22) = -0.3333333333333333;
  m(21,37) = -0.3333333333333333;
  m(21,38) = -0.3333333333333333;
  m(21,39) = -0.3333333333333333;
  m(22,21) = -0.3333333333333333;
  m(22,22) = 2.666666666666667;
  m(22,23) = -0.3333333333333333;
  m(22,38) = -0.3333333333333333;
  m(22,39) = -0.3333333333333333;
  m(22,40) = -0.3333333333333333;
  m(23,22) = -0.3333333333333333;
  m(23,23) = 2.666666666666667;
  m(23,24) = -0.3333333333333333;
  m(23,39) = -0.3333333333333333;
  m(23,40) = -0.3333333333333333;
  m(23,41) = -0.3333333333333333;
  m(24,23) = -0.3333333333333333;
  m(24,24) = 2.666666666666667;
  m(24,25) = -0.3333333333333333;
  m(24,40) = -0.3333333333333333;
  m(24,41) = -0.3333333333333333;
  m(24,42) = -0.3333333333333333;
  m(25,24) = -0.3333333333333333;
  m(25,25) = 2.666666666666667;
  m(25,26) = -0.3333333333333333;
  m(25,41) = -0.3333333333333333;
  m(25,42) = -0.3333333333333333;
  m(25,43) = -0.3333333333333333;
  m(26,25) = -0.3333333333333333;
  m(26,26) = 2.666666666666667;
  m(26,27) = -0.3333333333333333;
  m(26,42) = -0.3333333333333333;
  m(26,43) = -0.3333333333333333;
  m(26,44) = -0.3333333333333333;
  m(27,26) = -0.3333333333333333;
  m(27,27) = 2.666666666666667;
  m(27,28) = -0.3333333333333333;
  m(27,43) = -0.3333333333333333;
  m(27,44) = -0.3333333333333333;
  m(27,45) = -0.3333333333333333;
  m(28,27) = -0.3333333333333333;
  m(28,28) = 2.666666666666667;
  m(28,29) = -0.3333333333333333;
  m(28,44) = -0.3333333333333333;
  m(28,45) = -0.3333333333333333;
  m(28,46) = -0.3333333333333333;
  m(29,28) = -0.3333333333333333;
  m(29,29) = 2.666666666666667;
  m(29,30) = -0.3333333333333333;
  m(29,45) = -0.3333333333333333;
  m(29,46) = -0.3333333333333333;
  m(29,47) = -0.3333333333333333;
  m(30,29) = -0.3333333333333333;
  m(30,30) = 2.666666666666667;
  m(30,31) = -0.3333333333333333;
  m(30,46) = -0.3333333333333333;
  m(30,47) = -0.3333333333333333;
  m(30,48) = -0.3333333333333333;
  m(31,30) = -0.3333333333333333;
  m(31,31) = 2.666666666666667;
  m(31,32) = -0.3333333333333333;
  m(31,47) = -0.3333333333333333;
  m(31,48) = -0.3333333333333333;
  m(31,49) = -0.3333333333333333;
  m(32,31) = -0.3333333333333333;
  m(32,32) = 2.666666666666667;
  m(32,33) = -0.3333333333333333;
  m(32,48) = -0.3333333333333333;
  m(32,49) = -0.3333333333333333;
  m(32,50) = -0.3333333333333333;
  m(33,32) = -0.3333333333333333;
  m(33,33) = 2.666666666666667;
  m(33,49) = -0.3333333333333333;
  m(33,50) = -0.3333333333333333;
  m(34,34) = 1;
  m(35,35) = 1;
  m(36,19) = -0.3333333333333333;
  m(36,20) = -0.3333333333333333;
  m(36,36) = 2.666666666666667;
  m(36,37) = -0.3333333333333333;
  m(36,53) = -0.3333333333333333;
  m(36,54) = -0.3333333333333333;
  m(37,19) = -0.3333333333333333;
  m(37,20) = -0.3333333333333333;
  m(37,21) = -0.3333333333333333;
  m(37,36) = -0.3333333333333333;
  m(37,37) = 2.666666666666667;
  m(37,38) = -0.3333333333333333;
  m(37,53) = -0.3333333333333333;
  m(37,54) = -0.3333333333333333;
  m(37,55) = -0.3333333333333333;
  m(38,20) = -0.3333333333333333;
  m(38,21) = -0.3333333333333333;
  m(38,22) = -0.3333333333333333;
  m(38,37) = -0.3333333333333333;
  m(38,38) = 2.666666666666667;
  m(38,39) = -0.3333333333333333;
  m(38,54) = -0.3333333333333333;
  m(38,55) = -0.3333333333333333;
  m(38,56) = -0.3333333333333333;
  m(39,21) = -0.3333333333333333;
  m(39,22) = -0.3333333333333333;
  m(39,23) = -0.3333333333333333;
  m(39,38) = -0.3333333333333333;
  m(39,39) = 2.666666666666667;
  m(39,40) = -0.3333333333333333;
  m(39,55) = -0.3333333333333333;
  m(39,56) = -0.3333333333333333;
  m(39,57) = -0.3333333333333333;
  m(40,22) = -0.3333333333333333;
  m(40,23) = -0.3333333333333333;
  m(40,24) = -0.3333333333333333;
  m(40,39) = -0.3333333333333333;
  m(40,40) = 2.666666666666667;
  m(40,41) = -0.3333333333333333;
  m(40,56) = -0.3333333333333333;
  m(40,57) = -0.3333333333333333;
  m(40,58) = -0.3333333333333333;
  m(41,23) = -0.3333333333333333;
  m(41,24) = -0.3333333333333333;
  m(41,25) = -0.3333333333333333;
  m(41,40) = -0.3333333333333333;
  m(41,41) = 2.666666666666667;
  m(41,42) = -0.3333333333333333;
  m(41,57) = -0.3333333333333333;
  m(41,58) = -0.3333333333333333;
  m(41,59) = -0.3333333333333333;
  m(42,24) = -0.3333333333333333;
  m(42,25) = -0.3333333333333333;
  m(42,26) = -0.3333333333333333;
  m(42,41) = -0.3333333333333333;
  m(42,42) = 2.666666666666667;
  m(42,43) = -0.3333333333333333;
  m(42,58) = -0.3333333333333333;
  m(42,59) = -0.3333333333333333;
  m(42,60) = -0.3333333333333333;
  m(43,25) = -0.3333333333333333;
  m(43,26) = -0.3333333333333333;
  m(43,27) = -0.3333333333333333;
  m(43,42) = -0.3333333333333333;
  m(43,43) = 2.666666666666667;
  m(43,44) = -0.3333333333333333;
  m(43,59) = -0.3333333333333333;
  m(43,60) = -0.3333333333333333;
  m(43,61) = -0.3333333333333333;
  m(44,26) = -0.3333333333333333;
  m(44,27) = -0.3333333333333333;
  m(44,28) = -0.3333333333333333;
  m(44,43) = -0.3333333333333333;
  m(44,44) = 2.666666666666667;
  m(44,45) = -0.3333333333333333;
  m(44,60) = -0.3333333333333333;
  m(44,61) = -0.3333333333333333;
  m(44,62) = -0.3333333333333333;
  m(45,27) = -0.3333333333333333;
  m(45,28) = -0.3333333333333333;
  m(45,29) = -0.3333333333333333;
  m(45,44) = -0.3333333333333333;
  m(45,45) = 2.666666666666667;
  m(45,46) = -0.3333333333333333;
  m(45,61) = -0.3333333333333333;
  m(45,62) = -0.3333333333333333;
  m(45,63) = -0.3333333333333333;
  m(46,28) = -0.3333333333333333;
  m(46,29) = -0.3333333333333333;
  m(46,30) = -0.3333333333333333;
  m(46,45) = -0.3333333333333333;
  m(46,46) = 2.666666666666667;
  m(46,47) = -0.3333333333333333;
  m(46,62) = -0.3333333333333333;
  m(46,63) = -0.3333333333333333;
  m(46,64) = -0.3333333333333333;
  m(47,29) = -0.3333333333333333;
  m(47,30) = -0.3333333333333333;
  m(47,31) = -0.3333333333333333;
  m(47,46) = -0.3333333333333333;
  m(47,47) = 2.666666666666667;
  m(47,48) = -0.3333333333333333;
  m(47,63) = -0.3333333333333333;
  m(47,64) = -0.3333333333333333;
  m(47,65) = -0.3333333333333333;
  m(48,30) = -0.3333333333333333;
  m(48,31) = -0.3333333333333333;
  m(48,32) = -0.3333333333333333;
  m(48,47) = -0.3333333333333333;
  m(48,48) = 2.666666666666667;
  m(48,49) = -0.3333333333333333;
  m(48,64) = -0.3333333333333333;
  m(48,65) = -0.3333333333333333;
  m(48,66) = -0.3333333333333333;
  m(49,31) = -0.3333333333333333;
  m(49,32) = -0.3333333333333333;
  m(49,33) = -0.3333333333333333;
  m(49,48) = -0.3333333333333333;
  m(49,49) = 2.666666666666667;
  m(49,50) = -0.3333333333333333;
  m(49,65) = -0.3333333333333333;
  m(49,66) = -0.3333333333333333;
  m(49,67) = -0.3333333333333333;
  m(50,32) = -0.3333333333333333;
  m(50,33) = -0.3333333333333333;
  m(50,49) = -0.3333333333333333;
  m(50,50) = 2.666666666666667;
  m(50,66) = -0.3333333333333333;
  m(50,67) = -0.3333333333333333;
  m(51,51) = 1;
  m(52,52) = 1;
  m(53,36) = -0.3333333333333333;
  m(53,37) = -0.3333333333333333;
  m(53,53) = 2.666666666666667;
  m(53,54) = -0.3333333333333333;
  m(53,70) = -0.3333333333333333;
  m(53,71) = -0.3333333333333333;
  m(54,36) = -0.3333333333333333;
  m(54,37) = -0.3333333333333333;
  m(54,38) = -0.3333333333333333;
  m(54,53) = -0.3333333333333333;
  m(54,54) = 2.666666666666667;
  m(54,55) = -0.3333333333333333;
  m(54,70) = -0.3333333333333333;
  m(54,71) = -0.3333333333333333;
  m(54,72) = -0.3333333333333333;
  m(55,37) = -0.3333333333333333;
  m(55,38) = -0.3333333333333333;
  m(55,39) = -0.3333333333333333;
  m(55,54) = -0.3333333333333333;
  m(55,55) = 2.666666666666667;
  m(55,56) = -0.3333333333333333;
  m(55,71) = -0.3333333333333333;
  m(55,72) = -0.3333333333333333;
  m(55,73) = -0.3333333333333333;
  m(56,38) = -0.3333333333333333;
  m(56,39) = -0.3333333333333333;
  m(56,40) = -0.3333333333333333;
  m(56,55) = -0.3333333333333333;
  m(56,56) = 2.666666666666667;
  m(56,57) = -0.3333333333333333;
  m(56,72) = -0.3333333333333333;
  m(56,73) = -0.3333333333333333;
  m(56,74) = -0.3333333333333333;
  m(57,39) = -0.3333333333333333;
  m(57,40) = -0.3333333333333333;
  m(57,41) = -0.3333333333333333;
  m(57,56) = -0.3333333333333333;
  m(57,57) = 2.666666666666667;
  m(57,58) = -0.3333333333333333;
  m(57,73) = -0.3333333333333333;
  m(57,74) = -0.3333333333333333;
  m(57,75) = -0.3333333333333333;
  m(58,40) = -0.3333333333333333;
  m(58,41) = -0.3333333333333333;
  m(58,42) = -0.3333333333333333;
  m(58,57) = -0.3333333333333333;
  m(58,58) = 2.666666666666667;
  m(58,59) = -0.3333333333333333;
  m(58,74) = -0.3333333333333333;
  m(58,75) = -0.3333333333333333;
  m(58,76) = -0.3333333333333333;
  m(59,41) = -0.3333333333333333;
  m(59,42) = -0.3333333333333333;
  m(59,43) = -0.3333333333333333;
  m(59,58) = -0.3333333333333333;
  m(59,59) = 2.666666666666667;
  m(59,60) = -0.3333333333333333;
  m(59,75) = -0.3333333333333333;
  m(59,76) = -0.3333333333333333;
  m(59,77) = -0.3333333333333333;
  m(60,42) = -0.3333333333333333;
  m(60,43) = -0.3333333333333333;
  m(60,44) = -0.3333333333333333;
  m(60,59) = -0.3333333333333333;
  m(60,60) = 2.666666666666667;
  m(60,61) = -0.3333333333333333;
  m(60,76) = -0.3333333333333333;
  m(60,77) = -0.3333333333333333;
  m(60,78) = -0.3333333333333333;
  m(61,43) = -0.3333333333333333;
  m(61,44) = -0.3333333333333333;
  m(61,45) = -0.3333333333333333;
  m(61,60) = -0.3333333333333333;
  m(61,61) = 2.666666666666667;
  m(61,62) = -0.3333333333333333;
  m(61,77) = -0.3333333333333333;
  m(61,78) = -0.3333333333333333;
  m(61,79) = -0.3333333333333333;
  m(62,44) = -0.3333333333333333;
  m(62,45) = -0.3333333333333333;
  m(62,46) = -0.3333333333333333;
  m(62,61) = -0.3333333333333333;
  m(62,62) = 2.666666666666667;
  m(62,63) = -0.3333333333333333;
  m(62,78) = -0.3333333333333333;
  m(62,79) = -0.3333333333333333;
  m(62,80) = -0.3333333333333333;
  m(63,45) = -0.3333333333333333;
  m(63,46) = -0.3333333333333333;
  m(63,47) = -0.3333333333333333;
  m(63,62) = -0.3333333333333333;
  m(63,63) = 2.666666666666667;
  m(63,64) = -0.3333333333333333;
  m(63,79) = -0.3333333333333333;
  m(63,80) = -0.3333333333333333;
  m(63,81) = -0.3333333333333333;
  m(64,46) = -0.3333333333333333;
  m(64,47) = -0.3333333333333333;
  m(64,48) = -0.3333333333333333;
  m(64,63) = -0.3333333333333333;
  m(64,64) = 2.666666666666667;
  m(64,65) = -0.3333333333333333;
  m(64,80) = -0.3333333333333333;
  m(64,81) = -0.3333333333333333;
  m(64,82) = -0.3333333333333333;
  m(65,47) = -0.3333333333333333;
  m(65,48) = -0.3333333333333333;
  m(65,49) = -0.3333333333333333;
  m(65,64) = -0.3333333333333333;
  m(65,65) = 2.666666666666667;
  m(65,66) = -0.3333333333333333;
  m(65,81) = -0.3333333333333333;
  m(65,82) = -0.3333333333333333;
  m(65,83) = -0.3333333333333333;
  m(66,48) = -0.3333333333333333;
  m(66,49) = -0.3333333333333333;
  m(66,50) = -0.3333333333333333;
  m(66,65) = -0.3333333333333333;
  m(66,66) = 2.666666666666667;
  m(66,67) = -0.3333333333333333;
  m(66,82) = -0.3333333333333333;
  m(66,83) = -0.3333333333333333;
  m(66,84) = -0.3333333333333333;
  m(67,49) = -0.3333333333333333;
  m(67,50) = -0.3333333333333333;
  m(67,66) = -0.3333333333333333;
  m(67,67) = 2.666666666666667;
  m(67,83) = -0.3333333333333333;
  m(67,84) = -0.3333333333333333;
  m(68,68) = 1;
  m(69,69) = 1;
  m(70,53) = -0.3333333333333333;
  m(70,54) = -0.3333333333333333;
  m(70,70) = 2.666666666666667;
  m(70,71) = -0.3333333333333333;
  m(70,87) = -0.3333333333333333;
  m(70,88) = -0.3333333333333333;
  m(71,53) = -0.3333333333333333;
  m(71,54) = -0.3333333333333333;
  m(71,55) = -0.3333333333333333;
  m(71,70) = -0.3333333333333333;
  m(71,71) = 2.666666666666667;
  m(71,72) = -0.3333333333333333;
  m(71,87) = -0.3333333333333333;
  m(71,88) = -0.3333333333333333;
  m(71,89) = -0.3333333333333333;
  m(72,54) = -0.3333333333333333;
  m(72,55) = -0.3333333333333333;
  m(72,56) = -0.3333333333333333;
  m(72,71) = -0.3333333333333333;
  m(72,72) = 2.666666666666667;
  m(72,73) = -0.3333333333333333;
  m(72,88) = -0.3333333333333333;
  m(72,89) = -0.3333333333333333;
  m(72,90) = -0.3333333333333333;
  m(73,55) = -0.3333333333333333;
  m(73,56) = -0.3333333333333333;
  m(73,57) = -0.3333333333333333;
  m(73,72) = -0.3333333333333333;
  m(73,73) = 2.666666666666667;
  m(73,74) = -0.3333333333333333;
  m(73,89) = -0.3333333333333333;
  m(73,90) = -0.3333333333333333;
  m(73,91) = -0.3333333333333333;
  m(74,56) = -0.3333333333333333;
  m(74,57) = -0.3333333333333333;
  m(74,58) = -0.3333333333333333;
  m(74,73) = -0.3333333333333333;
  m(74,74) = 2.666666666666667;
  m(74,75) = -0.3333333333333333;
  m(74,90) = -0.3333333333333333;
  m(74,91) = -0.3333333333333333;
  m(74,92) = -0.3333333333333333;
  m(75,57) = -0.3333333333333333;
  m(75,58) = -0.3333333333333333;
  m(75,59) = -0.3333333333333333;
  m(75,74) = -0.3333333333333333;
  m(75,75) = 2.666666666666667;
  m(75,76) = -0.3333333333333333;
  m(75,91) = -0.3333333333333333;
  m(75,92) = -0.3333333333333333;
  m(75,93) = -0.3333333333333333;
  m(76,58) = -0.3333333333333333;
  m(76,59) = -0.3333333333333333;
  m(76,60) = -0.3333333333333333;
  m(76,75) = -0.3333333333333333;
  m(76,76) = 2.666666666666667;
  m(76,77) = -0.3333333333333333;
  m(76,92) = -0.3333333333333333;
  m(76,93) = -0.3333333333333333;
  m(76,94) = -0.3333333333333333;
  m(77,59) = -0.3333333333333333;
  m(77,60) = -0.3333333333333333;
  m(77,61) = -0.3333333333333333;
  m(77,76) = -0.3333333333333333;
  m(77,77) = 2.666666666666667;
  m(77,78) = -0.3333333333333333;
  m(77,93) = -0.3333333333333333;
  m(77,94) = -0.3333333333333333;
  m(77,95) = -0.3333333333333333;
  m(78,60) = -0.3333333333333333;
  m(78,61) = -0.3333333333333333;
  m(78,62) = -0.3333333333333333;
  m(78,77) = -0.3333333333333333;
  m(78,78) = 2.666666666666667;
  m(78,79) = -0.3333333333333333;
  m(78,94) = -0.3333333333333333;
  m(78,95) = -0.3333333333333333;
  m(78,96) = -0.3333333333333333;
  m(79,61) = -0.3333333333333333;
  m(79,62) = -0.3333333333333333;
  m(79,63) = -0.3333333333333333;
  m(79,78) = -0.3333333333333333;
  m(79,79) = 2.666666666666667;
  m(79,80) = -0.3333333333333333;
  m(79,95) = -0.3333333333333333;
  m(79,96) = -0.3333333333333333;
  m(79,97) = -0.3333333333333333;
  m(80,62) = -0.3333333333333333;
  m(80,63) = -0.3333333333333333;
  m(80,64) = -0.3333333333333333;
  m(80,79) = -0.3333333333333333;
  m(80,80) = 2.666666666666667;
  m(80,81) = -0.3333333333333333;
  m(80,96) = -0.3333333333333333;
  m(80,97) = -0.3333333333333333;
  m(80,98) = -0.3333333333333333;
  m(81,63) = -0.3333333333333333;
  m(81,64) = -0.3333333333333333;
  m(81,65) = -0.3333333333333333;
  m(81,80) = -0.3333333333333333;
  m(81,81) = 2.666666666666667;
  m(81,82) = -0.3333333333333333;
  m(81,97) = -0.3333333333333333;
  m(81,98) = -0.3333333333333333;
  m(81,99) = -0.3333333333333333;
  m(82,64) = -0.3333333333333333;
  m(82,65) = -0.3333333333333333;
  m(82,66) = -0.3333333333333333;
  m(82,81) = -0.3333333333333333;
  m(82,82) = 2.666666666666667;
  m(82,83) = -0.3333333333333333;
  m(82,98) = -0.3333333333333333;
  m(82,99) = -0.3333333333333333;
  m(82,100) = -0.3333333333333333;
  m(83,65) = -0.3333333333333333;
  m(83,66) = -0.3333333333333333;
  m(83,67) = -0.3333333333333333;
  m(83,82) = -0.3333333333333333;
  m(83,83) = 2.666666666666667;
  m(83,84) = -0.3333333333333333;
  m(83,99) = -0.3333333333333333;
  m(83,100) = -0.3333333333333333;
  m(83,101) = -0.3333333333333333;
  m(84,66) = -0.3333333333333333;
  m(84,67) = -0.3333333333333333;
  m(84,83) = -0.3333333333333333;
  m(84,84) = 2.666666666666667;
  m(84,100) = -0.3333333333333333;
  m(84,101) = -0.3333333333333333;
  m(85,85) = 1;
  m(86,86) = 1;
  m(87,70) = -0.3333333333333333;
  m(87,71) = -0.3333333333333333;
  m(87,87) = 2.666666666666667;
  m(87,88) = -0.3333333333333333;
  m(87,104) = -0.3333333333333333;
  m(87,105) = -0.3333333333333333;
  m(88,70) = -0.3333333333333333;
  m(88,71) = -0.3333333333333333;
  m(88,72) = -0.3333333333333333;
  m(88,87) = -0.3333333333333333;
  m(88,88) = 2.666666666666667;
  m(88,89) = -0.3333333333333333;
  m(88,104) = -0.3333333333333333;
  m(88,105) = -0.3333333333333333;
  m(88,106) = -0.3333333333333333;
  m(89,71) = -0.3333333333333333;
  m(89,72) = -0.3333333333333333;
  m(89,73) = -0.3333333333333333;
  m(89,88) = -0.3333333333333333;
  m(89,89) = 2.666666666666667;
  m(89,90) = -0.3333333333333333;
  m(89,105) = -0.3333333333333333;
  m(89,106) = -0.3333333333333333;
  m(89,107) = -0.3333333333333333;
  m(90,72) = -0.3333333333333333;
  m(90,73) = -0.3333333333333333;
  m(90,74) = -0.3333333333333333;
  m(90,89) = -0.3333333333333333;
  m(90,90) = 2.666666666666667;
  m(90,91) = -0.3333333333333333;
  m(90,106) = -0.3333333333333333;
  m(90,107) = -0.3333333333333333;
  m(90,108) = -0.3333333333333333;
  m(91,73) = -0.3333333333333333;
  m(91,74) = -0.3333333333333333;
  m(91,75) = -0.3333333333333333;
  m(91,90) = -0.3333333333333333;
  m(91,91) = 2.666666666666667;
  m(91,92) = -0.3333333333333333;
  m(91,107) = -0.3333333333333333;
  m(91,108) = -0.3333333333333333;
  m(91,109) = -0.3333333333333333;
  m(92,74) = -0.3333333333333333;
  m(92,75) = -0.3333333333333333;
  m(92,76) = -0.3333333333333333;
  m(92,91) = -0.3333333333333333;
  m(92,92) = 2.666666666666667;
  m(92,93) = -0.3333333333333333;
  m(92,108) = -0.3333333333333333;
  m(92,109) = -0.3333333333333333;
  m(92,110) = -0.3333333333333333;
  m(93,75) = -0.3333333333333333;
  m(93,76) = -0.3333333333333333;
  m(93,77) = -0.3333333333333333;
  m(93,92) = -0.3333333333333333;
  m(93,93) = 2.666666666666667;
  m(93,94) = -0.3333333333333333;
  m(93,109) = -0.3333333333333333;
  m(93,110) = -0.3333333333333333;
  m(93,111) = -0.3333333333333333;
  m(94,76) = -0.3333333333333333;
  m(94,77) = -0.3333333333333333;
  m(94,78) = -0.3333333333333333;
  m(94,93) = -0.3333333333333333;
  m(94,94) = 2.666666666666667;
  m(94,95) = -0.3333333333333333;
  m(94,110) = -0.3333333333333333;
  m(94,111) = -0.3333333333333333;
  m(94,112) = -0.3333333333333333;
  m(95,77) = -0.3333333333333333;
  m(95,78) = -0.3333333333333333;
  m(95,79) = -0.3333333333333333;
  m(95,94) = -0.3333333333333333;
  m(95,95) = 2.666666666666667;
  m(95,96) = -0.3333333333333333;
  m(95,111) = -0.3333333333333333;
  m(95,112) = -0.3333333333333333;
  m(95,113) = -0.3333333333333333;
  m(96,78) = -0.3333333333333333;
  m(96,79) = -0.3333333333333333;
  m(96,80) = -0.3333333333333333;
  m(96,95) = -0.3333333333333333;
  m(96,96) = 2.666666666666667;
  m(96,97) = -0.3333333333333333;
  m(96,112) = -0.3333333333333333;
  m(96,113) = -0.3333333333333333;
  m(96,114) = -0.3333333333333333;
  m(97,79) = -0.3333333333333333;
  m(97,80) = -0.3333333333333333;
  m(97,81) = -0.3333333333333333;
  m(97,96) = -0.3333333333333333;
  m(97,97) = 2.666666666666667;
  m(97,98) = -0.3333333333333333;
  m(97,113) = -0.3333333333333333;
  m(97,114) = -0.3333333333333333;
  m(97,115) = -0.3333333333333333;
  m(98,80) = -0.3333333333333333;
  m(98,81) = -0.3333333333333333;
  m(98,82) = -0.3333333333333333;
  m(98,97) = -0.3333333333333333;
  m(98,98) = 2.666666666666667;
  m(98,99) = -0.3333333333333333;
  m(98,114) = -0.3333333333333333;
  m(98,115) = -0.3333333333333333;
  m(98,116) = -0.3333333333333333;
  m(99,81) = -0.3333333333333333;
  m(99,82) = -0.3333333333333333;
  m(99,83) = -0.3333333333333333;
  m(99,98) = -0.3333333333333333;
  m(99,99) = 2.666666666666667;
  m(99,100) = -0.3333333333333333;
  m(99,115) = -0.3333333333333333;
  m(99,116) = -0.3333333333333333;
  m(99,117) = -0.3333333333333333;
  m(100,82) = -0.3333333333333333;
  m(100,83) = -0.3333333333333333;
  m(100,84) = -0.3333333333333333;
  m(100,99) = -0.3333333333333333;
  m(100,100) = 2.666666666666667;
  m(100,101) = -0.3333333333333333;
  m(100,116) = -0.3333333333333333;
  m(100,117) = -0.3333333333333333;
  m(100,118) = -0.3333333333333333;
  m(101,83) = -0.3333333333333333;
  m(101,84) = -0.3333333333333333;
  m(101,100) = -0.3333333333333333;
  m(101,101) = 2.666666666666667;
  m(101,117) = -0.3333333333333333;
  m(101,118) = -0.3333333333333333;
  m(102,102) = 1;
  m(103,103) = 1;
  m(104,87) = -0.3333333333333333;
  m(104,88) = -0.3333333333333333;
  m(104,104) = 2.666666666666667;
  m(104,105) = -0.3333333333333333;
  m(104,121) = -0.3333333333333333;
  m(104,122) = -0.3333333333333333;
  m(105,87) = -0.3333333333333333;
  m(105,88) = -0.3333333333333333;
  m(105,89) = -0.3333333333333333;
  m(105,104) = -0.3333333333333333;
  m(105,105) = 2.666666666666667;
  m(105,106) = -0.3333333333333333;
  m(105,121) = -0.3333333333333333;
  m(105,122) = -0.3333333333333333;
  m(105,123) = -0.3333333333333333;
  m(106,88) = -0.3333333333333333;
  m(106,89) = -0.3333333333333333;
  m(106,90) = -0.3333333333333333;
  m(106,105) = -0.3333333333333333;
  m(106,106) = 2.666666666666667;
  m(106,107) = -0.3333333333333333;
  m(106,122) = -0.3333333333333333;
  m(106,123) = -0.3333333333333333;
  m(106,124) = -0.3333333333333333;
  m(107,89) = -0.3333333333333333;
  m(107,90) = -0.3333333333333333;
  m(107,91) = -0.3333333333333333;
  m(107,106) = -0.3333333333333333;
  m(107,107) = 2.666666666666667;
  m(107,108) = -0.3333333333333333;
  m(107,123) = -0.3333333333333333;
  m(107,124) = -0.3333333333333333;
  m(107,125) = -0.3333333333333333;
  m(108,90) = -0.3333333333333333;
  m(108,91) = -0.3333333333333333;
  m(108,92) = -0.3333333333333333;
  m(108,107) = -0.3333333333333333;
  m(108,108) = 2.666666666666667;
  m(108,109) = -0.3333333333333333;
  m(108,124) = -0.3333333333333333;
  m(108,125) = -0.3333333333333333;
  m(108,126) = -0.3333333333333333;
  m(109,91) = -0.3333333333333333;
  m(109,92) = -0.3333333333333333;
  m(109,93) = -0.3333333333333333;
  m(109,108) = -0.3333333333333333;
  m(109,109) = 2.666666666666667;
  m(109,110) = -0.3333333333333333;
  m(109,125) = -0.3333333333333333;
  m(109,126) = -0.3333333333333333;
  m(109,127) = -0.3333333333333333;
  m(110,92) = -0.3333333333333333;
  m(110,93) = -0.3333333333333333;
  m(110,94) = -0.3333333333333333;
  m(110,109) = -0.3333333333333333;
  m(110,110) = 2.666666666666667;
  m(110,111) = -0.3333333333333333;
  m(110,126) = -0.3333333333333333;
  m(110,127) = -0.3333333333333333;
  m(110,128) = -0.3333333333333333;
  m(111,93) = -0.3333333333333333;
  m(111,94) = -0.3333333333333333;
  m(111,95) = -0.3333333333333333;
  m(111,110) = -0.3333333333333333;
  m(111,111) = 2.666666666666667;
  m(111,112) = -0.3333333333333333;
  m(111,127) = -0.3333333333333333;
  m(111,128) = -0.3333333333333333;
  m(111,129) = -0.3333333333333333;
  m(112,94) = -0.3333333333333333;
  m(112,95) = -0.3333333333333333;
  m(112,96) = -0.3333333333333333;
  m(112,111) = -0.3333333333333333;
  m(112,112) = 2.666666666666667;
  m(112,113) = -0.3333333333333333;
  m(112,128) = -0.3333333333333333;
  m(112,129) = -0.3333333333333333;
  m(112,130) = -0.3333333333333333;
  m(113,95) = -0.3333333333333333;
  m(113,96) = -0.3333333333333333;
  m(113,97) = -0.3333333333333333;
  m(113,112) = -0.3333333333333333;
  m(113,113) = 2.666666666666667;
  m(113,114) = -0.3333333333333333;
  m(113,129) = -0.3333333333333333;
  m(113,130) = -0.3333333333333333;
  m(113,131) = -0.3333333333333333;
  m(114,96) = -0.3333333333333333;
  m(114,97) = -0.3333333333333333;
  m(114,98) = -0.3333333333333333;
  m(114,113) = -0.3333333333333333;
  m(114,114) = 2.666666666666667;
  m(114,115) = -0.3333333333333333;
  m(114,130) = -0.3333333333333333;
  m(114,131) = -0.3333333333333333;
  m(114,132) = -0.3333333333333333;
  m(115,97) = -0.3333333333333333;
  m(115,98) = -0.3333333333333333;
  m(115,99) = -0.3333333333333333;
  m(115,114) = -0.3333333333333333;
  m(115,115) = 2.666666666666667;
  m(115,116) = -0.3333333333333333;
  m(115,131) = -0.3333333333333333;
  m(115,132) = -0.3333333333333333;
  m(115,133) = -0.3333333333333333;
  m(116,98) = -0.3333333333333333;
  m(116,99) = -0.3333333333333333;
  m(116,100) = -0.3333333333333333;
  m(116,115) = -0.3333333333333333;
  m(116,116) = 2.666666666666667;
  m(116,117) = -0.3333333333333333;
  m(116,132) = -0.3333333333333333;
  m(116,133) = -0.3333333333333333;
  m(116,134) = -0.3333333333333333;
  m(117,99) = -0.3333333333333333;
  m(117,100) = -0.3333333333333333;
  m(117,101) = -0.3333333333333333;
  m(117,116) = -0.3333333333333333;
  m(117,117) = 2.666666666666667;
  m(117,118) = -0.3333333333333333;
  m(117,133) = -0.3333333333333333;
  m(117,134) = -0.3333333333333333;
  m(117,135) = -0.3333333333333333;
  m(118,100) = -0.3333333333333333;
  m(118,101) = -0.3333333333333333;
  m(118,117) = -0.3333333333333333;
  m(118,118) = 2.666666666666667;
  m(118,134) = -0.3333333333333333;
  m(118,135) = -0.3333333333333333;
  m(119,119) = 1;
  m(120,120) = 1;
  m(121,104) = -0.3333333333333333;
  m(121,105) = -0.3333333333333333;
  m(121,121) = 2.666666666666667;
  m(121,122) = -0.3333333333333333;
  m(121,138) = -0.3333333333333333;
  m(121,139) = -0.3333333333333333;
  m(122,104) = -0.3333333333333333;
  m(122,105) = -0.3333333333333333;
  m(122,106) = -0.3333333333333333;
  m(122,121) = -0.3333333333333333;
  m(122,122) = 2.666666666666667;
  m(122,123) = -0.3333333333333333;
  m(122,138) = -0.3333333333333333;
  m(122,139) = -0.3333333333333333;
  m(122,140) = -0.3333333333333333;
  m(123,105) = -0.3333333333333333;
  m(123,106) = -0.3333333333333333;
  m(123,107) = -0.3333333333333333;
  m(123,122) = -0.3333333333333333;
  m(123,123) = 2.666666666666667;
  m(123,124) = -0.3333333333333333;
  m(123,139) = -0.3333333333333333;
  m(123,140) = -0.3333333333333333;
  m(123,141) = -0.3333333333333333;
  m(124,106) = -0.3333333333333333;
  m(124,107) = -0.3333333333333333;
  m(124,108) = -0.3333333333333333;
  m(124,123) = -0.3333333333333333;
  m(124,124) = 2.666666666666667;
  m(124,125) = -0.3333333333333333;
  m(124,140) = -0.3333333333333333;
  m(124,141) = -0.3333333333333333;
  m(124,142) = -0.3333333333333333;
  m(125,107) = -0.3333333333333333;
  m(125,108) = -0.3333333333333333;
  m(125,109) = -0.3333333333333333;
  m(125,124) = -0.3333333333333333;
  m(125,125) = 2.666666666666667;
  m(125,126) = -0.3333333333333333;
  m(125,141) = -0.3333333333333333;
  m(125,142) = -0.3333333333333333;
  m(125,143) = -0.3333333333333333;
  m(126,108) = -0.3333333333333333;
  m(126,109) = -0.3333333333333333;
  m(126,110) = -0.3333333333333333;
  m(126,125) = -0.3333333333333333;
  m(126,126) = 2.666666666666667;
  m(126,127) = -0.3333333333333333;
  m(126,142) = -0.3333333333333333;
  m(126,143) = -0.3333333333333333;
  m(126,144) = -0.3333333333333333;
  m(127,109) = -0.3333333333333333;
  m(127,110) = -0.3333333333333333;
  m(127,111) = -0.3333333333333333;
  m(127,126) = -0.3333333333333333;
  m(127,127) = 2.666666666666667;
  m(127,128) = -0.3333333333333333;
  m(127,143) = -0.3333333333333333;
  m(127,144) = -0.3333333333333333;
  m(127,145) = -0.3333333333333333;
  m(128,110) = -0.3333333333333333;
  m(128,111) = -0.3333333333333333;
  m(128,112) = -0.3333333333333333;
  m(128,127) = -0.3333333333333333;
  m(128,128) = 2.666666666666667;
  m(128,129) = -0.3333333333333333;
  m(128,144) = -0.3333333333333333;
  m(128,145) = -0.3333333333333333;
  m(128,146) = -0.3333333333333333;
  m(129,111) = -0.3333333333333333;
  m(129,112) = -0.3333333333333333;
  m(129,113) = -0.3333333333333333;
  m(129,128) = -0.3333333333333333;
  m(129,129) = 2.666666666666667;
  m(129,130) = -0.3333333333333333;
  m(129,145) = -0.3333333333333333;
  m(129,146) = -0.3333333333333333;
  m(129,147) = -0.3333333333333333;
  m(130,112) = -0.3333333333333333;
  m(130,113) = -0.3333333333333333;
  m(130,114) = -0.3333333333333333;
  m(130,129) = -0.3333333333333333;
  m(130,130) = 2.666666666666667;
  m(130,131) = -0.3333333333333333;
  m(130,146) = -0.3333333333333333;
  m(130,147) = -0.3333333333333333;
  m(130,148) = -0.3333333333333333;
  m(131,113) = -0.3333333333333333;
  m(131,114) = -0.3333333333333333;
  m(131,115) = -0.3333333333333333;
  m(131,130) = -0.3333333333333333;
  m(131,131) = 2.666666666666667;
  m(131,132) = -0.3333333333333333;
  m(131,147) = -0.3333333333333333;
  m(131,148) = -0.3333333333333333;
  m(131,149) = -0.3333333333333333;
  m(132,114) = -0.3333333333333333;
  m(132,115) = -0.3333333333333333;
  m(132,116) = -0.3333333333333333;
  m(132,131) = -0.3333333333333333;
  m(132,132) = 2.666666666666667;
  m(132,133) = -0.3333333333333333;
  m(132,148) = -0.3333333333333333;
  m(132,149) = -0.3333333333333333;
  m(132,150) = -0.3333333333333333;
  m(133,115) = -0.3333333333333333;
  m(133,116) = -0.3333333333333333;
  m(133,117) = -0.3333333333333333;
  m(133,132) = -0.3333333333333333;
  m(133,133) = 2.666666666666667;
  m(133,134) = -0.3333333333333333;
  m(133,149) = -0.3333333333333333;
  m(133,150) = -0.3333333333333333;
  m(133,151) = -0.3333333333333333;
  m(134,116) = -0.3333333333333333;
  m(134,117) = -0.3333333333333333;
  m(134,118) = -0.3333333333333333;
  m(134,133) = -0.3333333333333333;
  m(134,134) = 2.666666666666667;
  m(134,135) = -0.3333333333333333;
  m(134,150) = -0.3333333333333333;
  m(134,151) = -0.3333333333333333;
  m(134,152) = -0.3333333333333333;
  m(135,117) = -0.3333333333333333;
  m(135,118) = -0.3333333333333333;
  m(135,134) = -0.3333333333333333;
  m(135,135) = 2.666666666666667;
  m(135,151) = -0.3333333333333333;
  m(135,152) = -0.3333333333333333;
  m(136,136) = 1;
  m(137,137) = 1;
  m(138,121) = -0.3333333333333333;
  m(138,122) = -0.3333333333333333;
  m(138,138) = 2.666666666666667;
  m(138,139) = -0.3333333333333333;
  m(138,155) = -0.3333333333333333;
  m(138,156) = -0.3333333333333333;
  m(139,121) = -0.3333333333333333;
  m(139,122) = -0.3333333333333333;
  m(139,123) = -0.3333333333333333;
  m(139,138) = -0.3333333333333333;
  m(139,139) = 2.666666666666667;
  m(139,140) = -0.3333333333333333;
  m(139,155) = -0.3333333333333333;
  m(139,156) = -0.3333333333333333;
  m(139,157) = -0.3333333333333333;
  m(140,122) = -0.3333333333333333;
  m(140,123) = -0.3333333333333333;
  m(140,124) = -0.3333333333333333;
  m(140,139) = -0.3333333333333333;
  m(140,140) = 2.666666666666667;
  m(140,141) = -0.3333333333333333;
  m(140,156) = -0.3333333333333333;
  m(140,157) = -0.3333333333333333;
  m(140,158) = -0.3333333333333333;
  m(141,123) = -0.3333333333333333;
  m(141,124) = -0.3333333333333333;
  m(141,125) = -0.3333333333333333;
  m(141,140) = -0.3333333333333333;
  m(141,141) = 2.666666666666667;
  m(141,142) = -0.3333333333333333;
  m(141,157) = -0.3333333333333333;
  m(141,158) = -0.3333333333333333;
  m(141,159) = -0.3333333333333333;
  m(142,124) = -0.3333333333333333;
  m(142,125) = -0.3333333333333333;
  m(142,126) = -0.3333333333333333;
  m(142,141) = -0.3333333333333333;
  m(142,142) = 2.666666666666667;
  m(142,143) = -0.3333333333333333;
  m(142,158) = -0.3333333333333333;
  m(142,159) = -0.3333333333333333;
  m(142,160) = -0.3333333333333333;
  m(143,125) = -0.3333333333333333;
  m(143,126) = -0.3333333333333333;
  m(143,127) = -0.3333333333333333;
  m(143,142) = -0.3333333333333333;
  m(143,143) = 2.666666666666667;
  m(143,144) = -0.3333333333333333;
  m(143,159) = -0.3333333333333333;
  m(143,160) = -0.3333333333333333;
  m(143,161) = -0.3333333333333333;
  m(144,126) = -0.3333333333333333;
  m(144,127) = -0.3333333333333333;
  m(144,128) = -0.3333333333333333;
  m(144,143) = -0.3333333333333333;
  m(144,144) = 2.666666666666667;
  m(144,145) = -0.3333333333333333;
  m(144,160) = -0.3333333333333333;
  m(144,161) = -0.3333333333333333;
  m(144,162) = -0.3333333333333333;
  m(145,127) = -0.3333333333333333;
  m(145,128) = -0.3333333333333333;
  m(145,129) = -0.3333333333333333;
  m(145,144) = -0.3333333333333333;
  m(145,145) = 2.666666666666667;
  m(145,146) = -0.3333333333333333;
  m(145,161) = -0.3333333333333333;
  m(145,162) = -0.3333333333333333;
  m(145,163) = -0.3333333333333333;
  m(146,128) = -0.3333333333333333;
  m(146,129) = -0.3333333333333333;
  m(146,130) = -0.3333333333333333;
  m(146,145) = -0.3333333333333333;
  m(146,146) = 2.666666666666667;
  m(146,147) = -0.3333333333333333;
  m(146,162) = -0.3333333333333333;
  m(146,163) = -0.3333333333333333;
  m(146,164) = -0.3333333333333333;
  m(147,129) = -0.3333333333333333;
  m(147,130) = -0.3333333333333333;
  m(147,131) = -0.3333333333333333;
  m(147,146) = -0.3333333333333333;
  m(147,147) = 2.666666666666667;
  m(147,148) = -0.3333333333333333;
  m(147,163) = -0.3333333333333333;
  m(147,164) = -0.3333333333333333;
  m(147,165) = -0.3333333333333333;
  m(148,130) = -0.3333333333333333;
  m(148,131) = -0.3333333333333333;
  m(148,132) = -0.3333333333333333;
  m(148,147) = -0.3333333333333333;
  m(148,148) = 2.666666666666667;
  m(148,149) = -0.3333333333333333;
  m(148,164) = -0.3333333333333333;
  m(148,165) = -0.3333333333333333;
  m(148,166) = -0.3333333333333333;
  m(149,131) = -0.3333333333333333;
  m(149,132) = -0.3333333333333333;
  m(149,133) = -0.3333333333333333;
  m(149,148) = -0.3333333333333333;
  m(149,149) = 2.666666666666667;
  m(149,150) = -0.3333333333333333;
  m(149,165) = -0.3333333333333333;
  m(149,166) = -0.3333333333333333;
  m(149,167) = -0.3333333333333333;
  m(150,132) = -0.3333333333333333;
  m(150,133) = -0.3333333333333333;
  m(150,134) = -0.3333333333333333;
  m(150,149) = -0.3333333333333333;
  m(150,150) = 2.666666666666667;
  m(150,151) = -0.3333333333333333;
  m(150,166) = -0.3333333333333333;
  m(150,167) = -0.3333333333333333;
  m(150,168) = -0.3333333333333333;
  m(151,133) = -0.3333333333333333;
  m(151,134) = -0.3333333333333333;
  m(151,135) = -0.3333333333333333;
  m(151,150) = -0.3333333333333333;
  m(151,151) = 2.666666666666667;
  m(151,152) = -0.3333333333333333;
  m(151,167) = -0.3333333333333333;
  m(151,168) = -0.3333333333333333;
  m(151,169) = -0.3333333333333333;
  m(152,134) = -0.3333333333333333;
  m(152,135) = -0.3333333333333333;
  m(152,151) = -0.3333333333333333;
  m(152,152) = 2.666666666666667;
  m(152,168) = -0.3333333333333333;
  m(152,169) = -0.3333333333333333;
  m(153,153) = 1;
  m(154,154) = 1;
  m(155,138) = -0.3333333333333333;
  m(155,139) = -0.3333333333333333;
  m(155,155) = 2.666666666666667;
  m(155,156) = -0.3333333333333333;
  m(155,172) = -0.3333333333333333;
  m(155,173) = -0.3333333333333333;
  m(156,138) = -0.3333333333333333;
  m(156,139) = -0.3333333333333333;
  m(156,140) = -0.3333333333333333;
  m(156,155) = -0.3333333333333333;
  m(156,156) = 2.666666666666667;
  m(156,157) = -0.3333333333333333;
  m(156,172) = -0.3333333333333333;
  m(156,173) = -0.3333333333333333;
  m(156,174) = -0.3333333333333333;
  m(157,139) = -0.3333333333333333;
  m(157,140) = -0.3333333333333333;
  m(157,141) = -0.3333333333333333;
  m(157,156) = -0.3333333333333333;
  m(157,157) = 2.666666666666667;
  m(157,158) = -0.3333333333333333;
  m(157,173) = -0.3333333333333333;
  m(157,174) = -0.3333333333333333;
  m(157,175) = -0.3333333333333333;
  m(158,140) = -0.3333333333333333;
  m(158,141) = -0.3333333333333333;
  m(158,142) = -0.3333333333333333;
  m(158,157) = -0.3333333333333333;
  m(158,158) = 2.666666666666667;
  m(158,159) = -0.3333333333333333;
  m(158,174) = -0.3333333333333333;
  m(158,175) = -0.3333333333333333;
  m(158,176) = -0.3333333333333333;
  m(159,141) = -0.3333333333333333;
  m(159,142) = -0.3333333333333333;
  m(159,143) = -0.3333333333333333;
  m(159,158) = -0.3333333333333333;
  m(159,159) = 2.666666666666667;
  m(159,160) = -0.3333333333333333;
  m(159,175) = -0.3333333333333333;
  m(159,176) = -0.3333333333333333;
  m(159,177) = -0.3333333333333333;
  m(160,142) = -0.3333333333333333;
  m(160,143) = -0.3333333333333333;
  m(160,144) = -0.3333333333333333;
  m(160,159) = -0.3333333333333333;
  m(160,160) = 2.666666666666667;
  m(160,161) = -0.3333333333333333;
  m(160,176) = -0.3333333333333333;
  m(160,177) = -0.3333333333333333;
  m(160,178) = -0.3333333333333333;
  m(161,143) = -0.3333333333333333;
  m(161,144) = -0.3333333333333333;
  m(161,145) = -0.3333333333333333;
  m(161,160) = -0.3333333333333333;
  m(161,161) = 2.666666666666667;
  m(161,162) = -0.3333333333333333;
  m(161,177) = -0.3333333333333333;
  m(161,178) = -0.3333333333333333;
  m(161,179) = -0.3333333333333333;
  m(162,144) = -0.3333333333333333;
  m(162,145) = -0.3333333333333333;
  m(162,146) = -0.3333333333333333;
  m(162,161) = -0.3333333333333333;
  m(162,162) = 2.666666666666667;
  m(162,163) = -0.3333333333333333;
  m(162,178) = -0.3333333333333333;
  m(162,179) = -0.3333333333333333;
  m(162,180) = -0.3333333333333333;
  m(163,145) = -0.3333333333333333;
  m(163,146) = -0.3333333333333333;
  m(163,147) = -0.3333333333333333;
  m(163,162) = -0.3333333333333333;
  m(163,163) = 2.666666666666667;
  m(163,164) = -0.3333333333333333;
  m(163,179) = -0.3333333333333333;
  m(163,180) = -0.3333333333333333;
  m(163,181) = -0.3333333333333333;
  m(164,146) = -0.3333333333333333;
  m(164,147) = -0.3333333333333333;
  m(164,148) = -0.3333333333333333;
  m(164,163) = -0.3333333333333333;
  m(164,164) = 2.666666666666667;
  m(164,165) = -0.3333333333333333;
  m(164,180) = -0.3333333333333333;
  m(164,181) = -0.3333333333333333;
  m(164,182) = -0.3333333333333333;
  m(165,147) = -0.3333333333333333;
  m(165,148) = -0.3333333333333333;
  m(165,149) = -0.3333333333333333;
  m(165,164) = -0.3333333333333333;
  m(165,165) = 2.666666666666667;
  m(165,166) = -0.3333333333333333;
  m(165,181) = -0.3333333333333333;
  m(165,182) = -0.3333333333333333;
  m(165,183) = -0.3333333333333333;
  m(166,148) = -0.3333333333333333;
  m(166,149) = -0.3333333333333333;
  m(166,150) = -0.3333333333333333;
  m(166,165) = -0.3333333333333333;
  m(166,166) = 2.666666666666667;
  m(166,167) = -0.3333333333333333;
  m(166,182) = -0.3333333333333333;
  m(166,183) = -0.3333333333333333;
  m(166,184) = -0.3333333333333333;
  m(167,149) = -0.3333333333333333;
  m(167,150) = -0.3333333333333333;
  m(167,151) = -0.3333333333333333;
  m(167,166) = -0.3333333333333333;
  m(167,167) = 2.666666666666667;
  m(167,168) = -0.3333333333333333;
  m(167,183) = -0.3333333333333333;
  m(167,184) = -0.3333333333333333;
  m(167,185) = -0.3333333333333333;
  m(168,150) = -0.3333333333333333;
  m(168,151) = -0.3333333333333333;
  m(168,152) = -0.3333333333333333;
  m(168,167) = -0.3333333333333333;
  m(168,168) = 2.666666666666667;
  m(168,169) = -0.3333333333333333;
  m(168,184) = -0.3333333333333333;
  m(168,185) = -0.3333333333333333;
  m(168,186) = -0.3333333333333333;
  m(169,151) = -0.3333333333333333;
  m(169,152) = -0.3333333333333333;
  m(169,168) = -0.3333333333333333;
  m(169,169) = 2.666666666666667;
  m(169,185) = -0.3333333333333333;
  m(169,186) = -0.3333333333333333;
  m(170,170) = 1;
  m(171,171) = 1;
  m(172,155) = -0.3333333333333333;
  m(172,156) = -0.3333333333333333;
  m(172,172) = 2.666666666666667;
  m(172,173) = -0.3333333333333333;
  m(172,189) = -0.3333333333333333;
  m(172,190) = -0.3333333333333333;
  m(173,155) = -0.3333333333333333;
  m(173,156) = -0.3333333333333333;
  m(173,157) = -0.3333333333333333;
  m(173,172) = -0.3333333333333333;
  m(173,173) = 2.666666666666667;
  m(173,174) = -0.3333333333333333;
  m(173,189) = -0.3333333333333333;
  m(173,190) = -0.3333333333333333;
  m(173,191) = -0.3333333333333333;
  m(174,156) = -0.3333333333333333;
  m(174,157) = -0.3333333333333333;
  m(174,158) = -0.3333333333333333;
  m(174,173) = -0.3333333333333333;
  m(174,174) = 2.666666666666667;
  m(174,175) = -0.3333333333333333;
  m(174,190) = -0.3333333333333333;
  m(174,191) = -0.3333333333333333;
  m(174,192) = -0.3333333333333333;
  m(175,157) = -0.3333333333333333;
  m(175,158) = -0.3333333333333333;
  m(175,159) = -0.3333333333333333;
  m(175,174) = -0.3333333333333333;
  m(175,175) = 2.666666666666667;
  m(175,176) = -0.3333333333333333;
  m(175,191) = -0.3333333333333333;
  m(175,192) = -0.3333333333333333;
  m(175,193) = -0.3333333333333333;
  m(176,158) = -0.3333333333333333;
  m(176,159) = -0.3333333333333333;
  m(176,160) = -0.3333333333333333;
  m(176,175) = -0.3333333333333333;
  m(176,176) = 2.666666666666667;
  m(176,177) = -0.3333333333333333;
  m(176,192) = -0.3333333333333333;
  m(176,193) = -0.3333333333333333;
  m(176,194) = -0.3333333333333333;
  m(177,159) = -0.3333333333333333;
  m(177,160) = -0.3333333333333333;
  m(177,161) = -0.3333333333333333;
  m(177,176) = -0.3333333333333333;
  m(177,177) = 2.666666666666667;
  m(177,178) = -0.3333333333333333;
  m(177,193) = -0.3333333333333333;
  m(177,194) = -0.3333333333333333;
  m(177,195) = -0.3333333333333333;
  m(178,160) = -0.3333333333333333;
  m(178,161) = -0.3333333333333333;
  m(178,162) = -0.3333333333333333;
  m(178,177) = -0.3333333333333333;
  m(178,178) = 2.666666666666667;
  m(178,179) = -0.3333333333333333;
  m(178,194) = -0.3333333333333333;
  m(178,195) = -0.3333333333333333;
  m(178,196) = -0.3333333333333333;
  m(179,161) = -0.3333333333333333;
  m(179,162) = -0.3333333333333333;
  m(179,163) = -0.3333333333333333;
  m(179,178) = -0.3333333333333333;
  m(179,179) = 2.666666666666667;
  m(179,180) = -0.3333333333333333;
  m(179,195) = -0.3333333333333333;
  m(179,196) = -0.3333333333333333;
  m(179,197) = -0.3333333333333333;
  m(180,162) = -0.3333333333333333;
  m(180,163) = -0.3333333333333333;
  m(180,164) = -0.3333333333333333;
  m(180,179) = -0.3333333333333333;
  m(180,180) = 2.666666666666667;
  m(180,181) = -0.3333333333333333;
  m(180,196) = -0.3333333333333333;
  m(180,197) = -0.3333333333333333;
  m(180,198) = -0.3333333333333333;
  m(181,163) = -0.3333333333333333;
  m(181,164) = -0.3333333333333333;
  m(181,165) = -0.3333333333333333;
  m(181,180) = -0.3333333333333333;
  m(181,181) = 2.666666666666667;
  m(181,182) = -0.3333333333333333;
  m(181,197) = -0.3333333333333333;
  m(181,198) = -0.3333333333333333;
  m(181,199) = -0.3333333333333333;
  m(182,164) = -0.3333333333333333;
  m(182,165) = -0.3333333333333333;
  m(182,166) = -0.3333333333333333;
  m(182,181) = -0.3333333333333333;
  m(182,182) = 2.666666666666667;
  m(182,183) = -0.3333333333333333;
  m(182,198) = -0.3333333333333333;
  m(182,199) = -0.3333333333333333;
  m(182,200) = -0.3333333333333333;
  m(183,165) = -0.3333333333333333;
  m(183,166) = -0.3333333333333333;
  m(183,167) = -0.3333333333333333;
  m(183,182) = -0.3333333333333333;
  m(183,183) = 2.666666666666667;
  m(183,184) = -0.3333333333333333;
  m(183,199) = -0.3333333333333333;
  m(183,200) = -0.3333333333333333;
  m(183,201) = -0.3333333333333333;
  m(184,166) = -0.3333333333333333;
  m(184,167) = -0.3333333333333333;
  m(184,168) = -0.3333333333333333;
  m(184,183) = -0.3333333333333333;
  m(184,184) = 2.666666666666667;
  m(184,185) = -0.3333333333333333;
  m(184,200) = -0.3333333333333333;
  m(184,201) = -0.3333333333333333;
  m(184,202) = -0.3333333333333333;
  m(185,167) = -0.3333333333333333;
  m(185,168) = -0.3333333333333333;
  m(185,169) = -0.3333333333333333;
  m(185,184) = -0.3333333333333333;
  m(185,185) = 2.666666666666667;
  m(185,186) = -0.3333333333333333;
  m(185,201) = -0.3333333333333333;
  m(185,202) = -0.3333333333333333;
  m(185,203) = -0.3333333333333333;
  m(186,168) = -0.3333333333333333;
  m(186,169) = -0.3333333333333333;
  m(186,185) = -0.3333333333333333;
  m(186,186) = 2.666666666666667;
  m(186,202) = -0.3333333333333333;
  m(186,203) = -0.3333333333333333;
  m(187,187) = 1;
  m(188,188) = 1;
  m(189,172) = -0.3333333333333333;
  m(189,173) = -0.3333333333333333;
  m(189,189) = 2.666666666666667;
  m(189,190) = -0.3333333333333333;
  m(189,206) = -0.3333333333333333;
  m(189,207) = -0.3333333333333333;
  m(190,172) = -0.3333333333333333;
  m(190,173) = -0.3333333333333333;
  m(190,174) = -0.3333333333333333;
  m(190,189) = -0.3333333333333333;
  m(190,190) = 2.666666666666667;
  m(190,191) = -0.3333333333333333;
  m(190,206) = -0.3333333333333333;
  m(190,207) = -0.3333333333333333;
  m(190,208) = -0.3333333333333333;
  m(191,173) = -0.3333333333333333;
  m(191,174) = -0.3333333333333333;
  m(191,175) = -0.3333333333333333;
  m(191,190) = -0.3333333333333333;
  m(191,191) = 2.666666666666667;
  m(191,192) = -0.3333333333333333;
  m(191,207) = -0.3333333333333333;
  m(191,208) = -0.3333333333333333;
  m(191,209) = -0.3333333333333333;
  m(192,174) = -0.3333333333333333;
  m(192,175) = -0.3333333333333333;
  m(192,176) = -0.3333333333333333;
  m(192,191) = -0.3333333333333333;
  m(192,192) = 2.666666666666667;
  m(192,193) = -0.3333333333333333;
  m(192,208) = -0.3333333333333333;
  m(192,209) = -0.3333333333333333;
  m(192,210) = -0.3333333333333333;
  m(193,175) = -0.3333333333333333;
  m(193,176) = -0.3333333333333333;
  m(193,177) = -0.3333333333333333;
  m(193,192) = -0.3333333333333333;
  m(193,193) = 2.666666666666667;
  m(193,194) = -0.3333333333333333;
  m(193,209) = -0.3333333333333333;
  m(193,210) = -0.3333333333333333;
  m(193,211) = -0.3333333333333333;
  m(194,176) = -0.3333333333333333;
  m(194,177) = -0.3333333333333333;
  m(194,178) = -0.3333333333333333;
  m(194,193) = -0.3333333333333333;
  m(194,194) = 2.666666666666667;
  m(194,195) = -0.3333333333333333;
  m(194,210) = -0.3333333333333333;
  m(194,211) = -0.3333333333333333;
  m(194,212) = -0.3333333333333333;
  m(195,177) = -0.3333333333333333;
  m(195,178) = -0.3333333333333333;
  m(195,179) = -0.3333333333333333;
  m(195,194) = -0.3333333333333333;
  m(195,195) = 2.666666666666667;
  m(195,196) = -0.3333333333333333;
  m(195,211) = -0.3333333333333333;
  m(195,212) = -0.3333333333333333;
  m(195,213) = -0.3333333333333333;
  m(196,178) = -0.3333333333333333;
  m(196,179) = -0.3333333333333333;
  m(196,180) = -0.3333333333333333;
  m(196,195) = -0.3333333333333333;
  m(196,196) = 2.666666666666667;
  m(196,197) = -0.3333333333333333;
  m(196,212) = -0.3333333333333333;
  m(196,213) = -0.3333333333333333;
  m(196,214) = -0.3333333333333333;
  m(197,179) = -0.3333333333333333;
  m(197,180) = -0.3333333333333333;
  m(197,181) = -0.3333333333333333;
  m(197,196) = -0.3333333333333333;
  m(197,197) = 2.666666666666667;
  m(197,198) = -0.3333333333333333;
  m(197,213) = -0.3333333333333333;
  m(197,214) = -0.3333333333333333;
  m(197,215) = -0.3333333333333333;
  m(198,180) = -0.3333333333333333;
  m(198,181) = -0.3333333333333333;
  m(198,182) = -0.3333333333333333;
  m(198,197) = -0.3333333333333333;
  m(198,198) = 2.666666666666667;
  m(198,199) = -0.3333333333333333;
  m(198,214) = -0.3333333333333333;
  m(198,215) = -0.3333333333333333;
  m(198,216) = -0.3333333333333333;
  m(199,181) = -0.3333333333333333;
  m(199,182) = -0.3333333333333333;
  m(199,183) = -0.3333333333333333;
  m(199,198) = -0.3333333333333333;
  m(199,199) = 2.666666666666667;
  m(199,200) = -0.3333333333333333;
  m(199,215) = -0.3333333333333333;
  m(199,216) = -0.3333333333333333;
  m(199,217) = -0.3333333333333333;
  m(200,182) = -0.3333333333333333;
  m(200,183) = -0.3333333333333333;
  m(200,184) = -0.3333333333333333;
  m(200,199) = -0.3333333333333333;
  m(200,200) = 2.666666666666667;
  m(200,201) = -0.3333333333333333;
  m(200,216) = -0.3333333333333333;
  m(200,217) = -0.3333333333333333;
  m(200,218) = -0.3333333333333333;
  m(201,183) = -0.3333333333333333;
  m(201,184) = -0.3333333333333333;
  m(201,185) = -0.3333333333333333;
  m(201,200) = -0.3333333333333333;
  m(201,201) = 2.666666666666667;
  m(201,202) = -0.3333333333333333;
  m(201,217) = -0.3333333333333333;
  m(201,218) = -0.3333333333333333;
  m(201,219) = -0.3333333333333333;
  m(202,184) = -0.3333333333333333;
  m(202,185) = -0.3333333333333333;
  m(202,186) = -0.3333333333333333;
  m(202,201) = -0.3333333333333333;
  m(202,202) = 2.666666666666667;
  m(202,203) = -0.3333333333333333;
  m(202,218) = -0.3333333333333333;
  m(202,219) = -0.3333333333333333;
  m(202,220) = -0.3333333333333333;
  m(203,185) = -0.3333333333333333;
  m(203,186) = -0.3333333333333333;
  m(203,202) = -0.3333333333333333;
  m(203,203) = 2.666666666666667;
  m(203,219) = -0.3333333333333333;
  m(203,220) = -0.3333333333333333;
  m(204,204) = 1;
  m(205,205) = 1;
  m(206,189) = -0.3333333333333333;
  m(206,190) = -0.3333333333333333;
  m(206,206) = 2.666666666666667;
  m(206,207) = -0.3333333333333333;
  m(206,223) = -0.3333333333333333;
  m(206,224) = -0.3333333333333333;
  m(207,189) = -0.3333333333333333;
  m(207,190) = -0.3333333333333333;
  m(207,191) = -0.3333333333333333;
  m(207,206) = -0.3333333333333333;
  m(207,207) = 2.666666666666667;
  m(207,208) = -0.3333333333333333;
  m(207,223) = -0.3333333333333333;
  m(207,224) = -0.3333333333333333;
  m(207,225) = -0.3333333333333333;
  m(208,190) = -0.3333333333333333;
  m(208,191) = -0.3333333333333333;
  m(208,192) = -0.3333333333333333;
  m(208,207) = -0.3333333333333333;
  m(208,208) = 2.666666666666667;
  m(208,209) = -0.3333333333333333;
  m(208,224) = -0.3333333333333333;
  m(208,225) = -0.3333333333333333;
  m(208,226) = -0.3333333333333333;
  m(209,191) = -0.3333333333333333;
  m(209,192) = -0.3333333333333333;
  m(209,193) = -0.3333333333333333;
  m(209,208) = -0.3333333333333333;
  m(209,209) = 2.666666666666667;
  m(209,210) = -0.3333333333333333;
  m(209,225) = -0.3333333333333333;
  m(209,226) = -0.3333333333333333;
  m(209,227) = -0.3333333333333333;
  m(210,192) = -0.3333333333333333;
  m(210,193) = -0.3333333333333333;
  m(210,194) = -0.3333333333333333;
  m(210,209) = -0.3333333333333333;
  m(210,210) = 2.666666666666667;
  m(210,211) = -0.3333333333333333;
  m(210,226) = -0.3333333333333333;
  m(210,227) = -0.3333333333333333;
  m(210,228) = -0.3333333333333333;
  m(211,193) = -0.3333333333333333;
  m(211,194) = -0.3333333333333333;
  m(211,195) = -0.3333333333333333;
  m(211,210) = -0.3333333333333333;
  m(211,211) = 2.666666666666667;
  m(211,212) = -0.3333333333333333;
  m(211,227) = -0.3333333333333333;
  m(211,228) = -0.3333333333333333;
  m(211,229) = -0.3333333333333333;
  m(212,194) = -0.3333333333333333;
  m(212,195) = -0.3333333333333333;
  m(212,196) = -0.3333333333333333;
  m(212,211) = -0.3333333333333333;
  m(212,212) = 2.666666666666667;
  m(212,213) = -0.3333333333333333;
  m(212,228) = -0.3333333333333333;
  m(212,229) = -0.3333333333333333;
  m(212,230) = -0.3333333333333333;
  m(213,195) = -0.3333333333333333;
  m(213,196) = -0.3333333333333333;
  m(213,197) = -0.3333333333333333;
  m(213,212) = -0.3333333333333333;
  m(213,213) = 2.666666666666667;
  m(213,214) = -0.3333333333333333;
  m(213,229) = -0.3333333333333333;
  m(213,230) = -0.3333333333333333;
  m(213,231) = -0.3333333333333333;
  m(214,196) = -0.3333333333333333;
  m(214,197) = -0.3333333333333333;
  m(214,198) = -0.3333333333333333;
  m(214,213) = -0.3333333333333333;
  m(214,214) = 2.666666666666667;
  m(214,215) = -0.3333333333333333;
  m(214,230) = -0.3333333333333333;
  m(214,231) = -0.3333333333333333;
  m(214,232) = -0.3333333333333333;
  m(215,197) = -0.3333333333333333;
  m(215,198) = -0.3333333333333333;
  m(215,199) = -0.3333333333333333;
  m(215,214) = -0.3333333333333333;
  m(215,215) = 2.666666666666667;
  m(215,216) = -0.3333333333333333;
  m(215,231) = -0.3333333333333333;
  m(215,232) = -0.3333333333333333;
  m(215,233) = -0.3333333333333333;
  m(216,198) = -0.3333333333333333;
  m(216,199) = -0.3333333333333333;
  m(216,200) = -0.3333333333333333;
  m(216,215) = -0.3333333333333333;
  m(216,216) = 2.666666666666667;
  m(216,217) = -0.3333333333333333;
  m(216,232) = -0.3333333333333333;
  m(216,233) = -0.3333333333333333;
  m(216,234) = -0.3333333333333333;
  m(217,199) = -0.3333333333333333;
  m(217,200) = -0.3333333333333333;
  m(217,201) = -0.3333333333333333;
  m(217,216) = -0.3333333333333333;
  m(217,217) = 2.666666666666667;
  m(217,218) = -0.3333333333333333;
  m(217,233) = -0.3333333333333333;
  m(217,234) = -0.3333333333333333;
  m(217,235) = -0.3333333333333333;
  m(218,200) = -0.3333333333333333;
  m(218,201) = -0.3333333333333333;
  m(218,202) = -0.3333333333333333;
  m(218,217) = -0.3333333333333333;
  m(218,218) = 2.666666666666667;
  m(218,219) = -0.3333333333333333;
  m(218,234) = -0.3333333333333333;
  m(218,235) = -0.3333333333333333;
  m(218,236) = -0.3333333333333333;
  m(219,201) = -0.3333333333333333;
  m(219,202) = -0.3333333333333333;
  m(219,203) = -0.3333333333333333;
  m(219,218) = -0.3333333333333333;
  m(219,219) = 2.666666666666667;
  m(219,220) = -0.3333333333333333;
  m(219,235) = -0.3333333333333333;
  m(219,236) = -0.3333333333333333;
  m(219,237) = -0.3333333333333333;
  m(220,202) = -0.3333333333333333;
  m(220,203) = -0.3333333333333333;
  m(220,219) = -0.3333333333333333;
  m(220,220) = 2.666666666666667;
  m(220,236) = -0.3333333333333333;
  m(220,237) = -0.3333333333333333;
  m(221,221) = 1;
  m(222,222) = 1;
  m(223,206) = -0.3333333333333333;
  m(223,207) = -0.3333333333333333;
  m(223,223) = 2.666666666666667;
  m(223,224) = -0.3333333333333333;
  m(223,240) = -0.3333333333333333;
  m(223,241) = -0.3333333333333333;
  m(224,206) = -0.3333333333333333;
  m(224,207) = -0.3333333333333333;
  m(224,208) = -0.3333333333333333;
  m(224,223) = -0.3333333333333333;
  m(224,224) = 2.666666666666667;
  m(224,225) = -0.3333333333333333;
  m(224,240) = -0.3333333333333333;
  m(224,241) = -0.3333333333333333;
  m(224,242) = -0.3333333333333333;
  m(225,207) = -0.3333333333333333;
  m(225,208) = -0.3333333333333333;
  m(225,209) = -0.3333333333333333;
  m(225,224) = -0.3333333333333333;
  m(225,225) = 2.666666666666667;
  m(225,226) = -0.3333333333333333;
  m(225,241) = -0.3333333333333333;
  m(225,242) = -0.3333333333333333;
  m(225,243) = -0.3333333333333333;
  m(226,208) = -0.3333333333333333;
  m(226,209) = -0.3333333333333333;
  m(226,210) = -0.3333333333333333;
  m(226,225) = -0.3333333333333333;
  m(226,226) = 2.666666666666667;
  m(226,227) = -0.3333333333333333;
  m(226,242) = -0.3333333333333333;
  m(226,243) = -0.3333333333333333;
  m(226,244) = -0.3333333333333333;
  m(227,209) = -0.3333333333333333;
  m(227,210) = -0.3333333333333333;
  m(227,211) = -0.3333333333333333;
  m(227,226) = -0.3333333333333333;
  m(227,227) = 2.666666666666667;
  m(227,228) = -0.3333333333333333;
  m(227,243) = -0.3333333333333333;
  m(227,244) = -0.3333333333333333;
  m(227,245) = -0.3333333333333333;
  m(228,210) = -0.3333333333333333;
  m(228,211) = -0.3333333333333333;
  m(228,212) = -0.3333333333333333;
  m(228,227) = -0.3333333333333333;
  m(228,228) = 2.666666666666667;
  m(228,229) = -0.3333333333333333;
  m(228,244) = -0.3333333333333333;
  m(228,245) = -0.3333333333333333;
  m(228,246) = -0.3333333333333333;
  m(229,211) = -0.3333333333333333;
  m(229,212) = -0.3333333333333333;
  m(229,213) = -0.3333333333333333;
  m(229,228) = -0.3333333333333333;
  m(229,229) = 2.666666666666667;
  m(229,230) = -0.3333333333333333;
  m(229,245) = -0.3333333333333333;
  m(229,246) = -0.3333333333333333;
  m(229,247) = -0.3333333333333333;
  m(230,212) = -0.3333333333333333;
  m(230,213) = -0.3333333333333333;
  m(230,214) = -0.3333333333333333;
  m(230,229) = -0.3333333333333333;
  m(230,230) = 2.666666666666667;
  m(230,231) = -0.3333333333333333;
  m(230,246) = -0.3333333333333333;
  m(230,247) = -0.3333333333333333;
  m(230,248) = -0.3333333333333333;
  m(231,213) = -0.3333333333333333;
  m(231,214) = -0.3333333333333333;
  m(231,215) = -0.3333333333333333;
  m(231,230) = -0.3333333333333333;
  m(231,231) = 2.666666666666667;
  m(231,232) = -0.3333333333333333;
  m(231,247) = -0.3333333333333333;
  m(231,248) = -0.3333333333333333;
  m(231,249) = -0.3333333333333333;
  m(232,214) = -0.3333333333333333;
  m(232,215) = -0.3333333333333333;
  m(232,216) = -0.3333333333333333;
  m(232,231) = -0.3333333333333333;
  m(232,232) = 2.666666666666667;
  m(232,233) = -0.3333333333333333;
  m(232,248) = -0.3333333333333333;
  m(232,249) = -0.3333333333333333;
  m(232,250) = -0.3333333333333333;
  m(233,215) = -0.3333333333333333;
  m(233,216) = -0.3333333333333333;
  m(233,217) = -0.3333333333333333;
  m(233,232) = -0.3333333333333333;
  m(233,233) = 2.666666666666667;
  m(233,234) = -0.3333333333333333;
  m(233,249) = -0.3333333333333333;
  m(233,250) = -0.3333333333333333;
  m(233,251) = -0.3333333333333333;
  m(234,216) = -0.3333333333333333;
  m(234,217) = -0.3333333333333333;
  m(234,218) = -0.3333333333333333;
  m(234,233) = -0.3333333333333333;
  m(234,234) = 2.666666666666667;
  m(234,235) = -0.3333333333333333;
  m(234,250) = -0.3333333333333333;
  m(234,251) = -0.3333333333333333;
  m(234,252) = -0.3333333333333333;
  m(235,217) = -0.3333333333333333;
  m(235,218) = -0.3333333333333333;
  m(235,219) = -0.3333333333333333;
  m(235,234) = -0.3333333333333333;
  m(235,235) = 2.666666666666667;
  m(235,236) = -0.3333333333333333;
  m(235,251) = -0.3333333333333333;
  m(235,252) = -0.3333333333333333;
  m(235,253) = -0.3333333333333333;
  m(236,218) = -0.3333333333333333;
  m(236,219) = -0.3333333333333333;
  m(236,220) = -0.3333333333333333;
  m(236,235) = -0.3333333333333333;
  m(236,236) = 2.666666666666667;
  m(236,237) = -0.3333333333333333;
  m(236,252) = -0.3333333333333333;
  m(236,253) = -0.3333333333333333;
  m(236,254) = -0.3333333333333333;
  m(237,219) = -0.3333333333333333;
  m(237,220) = -0.3333333333333333;
  m(237,236) = -0.3333333333333333;
  m(237,237) = 2.666666666666667;
  m(237,253) = -0.3333333333333333;
  m(237,254) = -0.3333333333333333;
  m(238,238) = 1;
  m(239,239) = 1;
  m(240,223) = -0.3333333333333333;
  m(240,224) = -0.3333333333333333;
  m(240,240) = 2.666666666666667;
  m(240,241) = -0.3333333333333333;
  m(240,257) = -0.3333333333333333;
  m(240,258) = -0.3333333333333333;
  m(241,223) = -0.3333333333333333;
  m(241,224) = -0.3333333333333333;
  m(241,225) = -0.3333333333333333;
  m(241,240) = -0.3333333333333333;
  m(241,241) = 2.666666666666667;
  m(241,242) = -0.3333333333333333;
  m(241,257) = -0.3333333333333333;
  m(241,258) = -0.3333333333333333;
  m(241,259) = -0.3333333333333333;
  m(242,224) = -0.3333333333333333;
  m(242,225) = -0.3333333333333333;
  m(242,226) = -0.3333333333333333;
  m(242,241) = -0.3333333333333333;
  m(242,242) = 2.666666666666667;
  m(242,243) = -0.3333333333333333;
  m(242,258) = -0.3333333333333333;
  m(242,259) = -0.3333333333333333;
  m(242,260) = -0.3333333333333333;
  m(243,225) = -0.3333333333333333;
  m(243,226) = -0.3333333333333333;
  m(243,227) = -0.3333333333333333;
  m(243,242) = -0.3333333333333333;
  m(243,243) = 2.666666666666667;
  m(243,244) = -0.3333333333333333;
  m(243,259) = -0.3333333333333333;
  m(243,260) = -0.3333333333333333;
  m(243,261) = -0.3333333333333333;
  m(244,226) = -0.3333333333333333;
  m(244,227) = -0.3333333333333333;
  m(244,228) = -0.3333333333333333;
  m(244,243) = -0.3333333333333333;
  m(244,244) = 2.666666666666667;
  m(244,245) = -0.3333333333333333;
  m(244,260) = -0.3333333333333333;
  m(244,261) = -0.3333333333333333;
  m(244,262) = -0.3333333333333333;
  m(245,227) = -0.3333333333333333;
  m(245,228) = -0.3333333333333333;
  m(245,229) = -0.3333333333333333;
  m(245,244) = -0.3333333333333333;
  m(245,245) = 2.666666666666667;
  m(245,246) = -0.3333333333333333;
  m(245,261) = -0.3333333333333333;
  m(245,262) = -0.3333333333333333;
  m(245,263) = -0.3333333333333333;
  m(246,228) = -0.3333333333333333;
  m(246,229) = -0.3333333333333333;
  m(246,230) = -0.3333333333333333;
  m(246,245) = -0.3333333333333333;
  m(246,246) = 2.666666666666667;
  m(246,247) = -0.3333333333333333;
  m(246,262) = -0.3333333333333333;
  m(246,263) = -0.3333333333333333;
  m(246,264) = -0.3333333333333333;
  m(247,229) = -0.3333333333333333;
  m(247,230) = -0.3333333333333333;
  m(247,231) = -0.3333333333333333;
  m(247,246) = -0.3333333333333333;
  m(247,247) = 2.666666666666667;
  m(247,248) = -0.3333333333333333;
  m(247,263) = -0.3333333333333333;
  m(247,264) = -0.3333333333333333;
  m(247,265) = -0.3333333333333333;
  m(248,230) = -0.3333333333333333;
  m(248,231) = -0.3333333333333333;
  m(248,232) = -0.3333333333333333;
  m(248,247) = -0.3333333333333333;
  m(248,248) = 2.666666666666667;
  m(248,249) = -0.3333333333333333;
  m(248,264) = -0.3333333333333333;
  m(248,265) = -0.3333333333333333;
  m(248,266) = -0.3333333333333333;
  m(249,231) = -0.3333333333333333;
  m(249,232) = -0.3333333333333333;
  m(249,233) = -0.3333333333333333;
  m(249,248) = -0.3333333333333333;
  m(249,249) = 2.666666666666667;
  m(249,250) = -0.3333333333333333;
  m(249,265) = -0.3333333333333333;
  m(249,266) = -0.3333333333333333;
  m(249,267) = -0.3333333333333333;
  m(250,232) = -0.3333333333333333;
  m(250,233) = -0.3333333333333333;
  m(250,234) = -0.3333333333333333;
  m(250,249) = -0.3333333333333333;
  m(250,250) = 2.666666666666667;
  m(250,251) = -0.3333333333333333;
  m(250,266) = -0.3333333333333333;
  m(250,267) = -0.3333333333333333;
  m(250,268) = -0.3333333333333333;
  m(251,233) = -0.3333333333333333;
  m(251,234) = -0.3333333333333333;
  m(251,235) = -0.3333333333333333;
  m(251,250) = -0.3333333333333333;
  m(251,251) = 2.666666666666667;
  m(251,252) = -0.3333333333333333;
  m(251,267) = -0.3333333333333333;
  m(251,268) = -0.3333333333333333;
  m(251,269) = -0.3333333333333333;
  m(252,234) = -0.3333333333333333;
  m(252,235) = -0.3333333333333333;
  m(252,236) = -0.3333333333333333;
  m(252,251) = -0.3333333333333333;
  m(252,252) = 2.666666666666667;
  m(252,253) = -0.3333333333333333;
  m(252,268) = -0.3333333333333333;
  m(252,269) = -0.3333333333333333;
  m(252,270) = -0.3333333333333333;
  m(253,235) = -0.3333333333333333;
  m(253,236) = -0.3333333333333333;
  m(253,237) = -0.3333333333333333;
  m(253,252) = -0.3333333333333333;
  m(253,253) = 2.666666666666667;
  m(253,254) = -0.3333333333333333;
  m(253,269) = -0.3333333333333333;
  m(253,270) = -0.3333333333333333;
  m(253,271) = -0.3333333333333333;
  m(254,236) = -0.3333333333333333;
  m(254,237) = -0.3333333333333333;
  m(254,253) = -0.3333333333333333;
  m(254,254) = 2.666666666666667;
  m(254,270) = -0.3333333333333333;
  m(254,271) = -0.3333333333333333;
  m(255,255) = 1;
  m(256,256) = 1;
  m(257,240) = -0.3333333333333333;
  m(257,241) = -0.3333333333333333;
  m(257,257) = 2.666666666666667;
  m(257,258) = -0.3333333333333333;
  m(258,240) = -0.3333333333333333;
  m(258,241) = -0.3333333333333333;
  m(258,242) = -0.3333333333333333;
  m(258,257) = -0.3333333333333333;
  m(258,258) = 2.666666666666667;
  m(258,259) = -0.3333333333333333;
  m(259,241) = -0.3333333333333333;
  m(259,242) = -0.3333333333333333;
  m(259,243) = -0.3333333333333333;
  m(259,258) = -0.3333333333333333;
  m(259,259) = 2.666666666666667;
  m(259,260) = -0.3333333333333333;
  m(260,242) = -0.3333333333333333;
  m(260,243) = -0.3333333333333333;
  m(260,244) = -0.3333333333333333;
  m(260,259) = -0.3333333333333333;
  m(260,260) = 2.666666666666667;
  m(260,261) = -0.3333333333333333;
  m(261,243) = -0.3333333333333333;
  m(261,244) = -0.3333333333333333;
  m(261,245) = -0.3333333333333333;
  m(261,260) = -0.3333333333333333;
  m(261,261) = 2.666666666666667;
  m(261,262) = -0.3333333333333333;
  m(262,244) = -0.3333333333333333;
  m(262,245) = -0.3333333333333333;
  m(262,246) = -0.3333333333333333;
  m(262,261) = -0.3333333333333333;
  m(262,262) = 2.666666666666667;
  m(262,263) = -0.3333333333333333;
  m(263,245) = -0.3333333333333333;
  m(263,246) = -0.3333333333333333;
  m(263,247) = -0.3333333333333333;
  m(263,262) = -0.3333333333333333;
  m(263,263) = 2.666666666666667;
  m(263,264) = -0.3333333333333333;
  m(264,246) = -0.3333333333333333;
  m(264,247) = -0.3333333333333333;
  m(264,248) = -0.3333333333333333;
  m(264,263) = -0.3333333333333333;
  m(264,264) = 2.666666666666667;
  m(264,265) = -0.3333333333333333;
  m(265,247) = -0.3333333333333333;
  m(265,248) = -0.3333333333333333;
  m(265,249) = -0.3333333333333333;
  m(265,264) = -0.3333333333333333;
  m(265,265) = 2.666666666666667;
  m(265,266) = -0.3333333333333333;
  m(266,248) = -0.3333333333333333;
  m(266,249) = -0.3333333333333333;
  m(266,250) = -0.3333333333333333;
  m(266,265) = -0.3333333333333333;
  m(266,266) = 2.666666666666667;
  m(266,267) = -0.3333333333333333;
  m(267,249) = -0.3333333333333333;
  m(267,250) = -0.3333333333333333;
  m(267,251) = -0.3333333333333333;
  m(267,266) = -0.3333333333333333;
  m(267,267) = 2.666666666666667;
  m(267,268) = -0.3333333333333333;
  m(268,250) = -0.3333333333333333;
  m(268,251) = -0.3333333333333333;
  m(268,252) = -0.3333333333333333;
  m(268,267) = -0.3333333333333333;
  m(268,268) = 2.666666666666667;
  m(268,269) = -0.3333333333333333;
  m(269,251) = -0.3333333333333333;
  m(269,252) = -0.3333333333333333;
  m(269,253) = -0.3333333333333333;
  m(269,268) = -0.3333333333333333;
  m(269,269) = 2.666666666666667;
  m(269,270) = -0.3333333333333333;
  m(270,252) = -0.3333333333333333;
  m(270,253) = -0.3333333333333333;
  m(270,254) = -0.3333333333333333;
  m(270,269) = -0.3333333333333333;
  m(270,270) = 2.666666666666667;
  m(270,271) = -0.3333333333333333;
  m(271,253) = -0.3333333333333333;
  m(271,254) = -0.3333333333333333;
  m(271,270) = -0.3333333333333333;
  m(271,271) = 2.666666666666667;
  m(272,272) = 1;
  m(273,273) = 1;
  m(274,274) = 1;
  m(275,275) = 1;
  m(276,276) = 1;
  m(277,277) = 1;
  m(278,278) = 1;
  m(279,279) = 1;
  m(280,280) = 1;
  m(281,281) = 1;
  m(282,282) = 1;
  m(283,283) = 1;
  m(284,284) = 1;
  m(285,285) = 1;
  m(286,286) = 1;
  m(287,287) = 1;
  m(288,288) = 1;
  m(289,289) = 1;
  b[1] = 2;
  b[2] = 2.06449445891786;
  b[3] = 2.133148453066826;
  b[4] = 2.206230249420981;
  b[5] = 2.284025416687741;
  b[6] = 2.366837941173797;
  b[7] = 2.454991414618201;
  b[8] = 2.548830298634133;
  b[9] = 2.648721270700128;
  b[10] = 2.755054656960299;
  b[11] = 2.868245957432222;
  b[12] = 2.988737469582292;
  b[13] = 3.117000016612675;
  b[14] = 3.253534787213209;
  b[15] = 3.398875293967098;
  b[16] = 3.553589458062927;
  b[17] = 3.718281828459045;
  b[18] = 2.06449445891786;
  b[19] = 3.456776204194243;
  b[20] = 2.126037049698927;
  b[21] = 2.198928466914802;
  b[22] = 2.276520976643771;
  b[23] = 2.359117773303789;
  b[24] = 2.447041605672743;
  b[25] = 2.540636038036317;
  b[26] = 2.640266792672904;
  b[27] = 2.746323178921356;
  b[28] = 2.859219614415685;
  b[29] = 2.979397244430976;
  b[30] = 3.107325665668133;
  b[31] = 3.243504761213198;
  b[32] = 3.388466653841364;
  b[33] = 6.087513308265885;
  b[34] = 3.782776287376905;
  b[35] = 2.133148453066826;
  b[36] = 2.126037049698927;
  b[37] = -0.008855604410374921;
  b[38] = -0.009141173117793791;
  b[39] = -0.009445159424481514;
  b[40] = -0.0097687511635375;
  b[41] = -0.01011321277671419;
  b[42] = -0.01047989025525068;
  b[43] = -0.01087021639936276;
  b[44] = -0.01128571641694083;
  b[45] = -0.01172801388333296;
  b[46] = -0.01219883708550079;
  b[47] = -0.01270002577533841;
  b[48] = -0.01323353835854286;
  b[49] = -0.01380145954712695;
  b[50] = 3.838500207088791;
  b[51] = 3.851430281525872;
  b[52] = 2.206230249420981;
  b[53] = 2.198928466914802;
  b[54] = -0.009141173117793791;
  b[55] = -0.009426741825212661;
  b[56] = -0.009730728131900384;
  b[57] = -0.01005431987095637;
  b[58] = -0.01039878148413306;
  b[59] = -0.01076545896266956;
  b[60] = -0.01115578510678163;
  b[61] = -0.0115712851243597;
  b[62] = -0.01201358259075183;
  b[63] = -0.01248440579291966;
  b[64] = -0.01298559448275728;
  b[65] = -0.01351910706596173;
  b[66] = -0.01408702825454582;
  b[67] = 3.911391624304666;
  b[68] = 3.924512077880026;
  b[69] = 2.284025416687741;
  b[70] = 2.276520976643771;
  b[71] = -0.009445159424481514;
  b[72] = -0.009730728131900384;
  b[73] = -0.01003471443858811;
  b[74] = -0.01035830617764409;
  b[75] = -0.01070276779082078;
  b[76] = -0.01106944526935728;
  b[77] = -0.01145977141346935;
  b[78] = -0.01187527143104742;
  b[79] = -0.01231756889743955;
  b[80] = -0.01278839209960739;
  b[81] = -0.01328958078944501;
  b[82] = -0.01382309337264946;
  b[83] = -0.01439101456123355;
  b[84] = 3.988984134033635;
  b[85] = 4.002307245146787;
  b[86] = 2.366837941173797;
  b[87] = 2.359117773303789;
  b[88] = -0.0097687511635375;
  b[89] = -0.01005431987095637;
  b[90] = -0.01035830617764409;
  b[91] = -0.01068189791670008;
  b[92] = -0.01102635952987677;
  b[93] = -0.01139303700841326;
  b[94] = -0.01178336315252533;
  b[95] = -0.01219886317010341;
  b[96] = -0.01264116063649554;
  b[97] = -0.01311198383866337;
  b[98] = -0.01361317252850099;
  b[99] = -0.01414668511170544;
  b[100] = -0.01471460630028953;
  b[101] = 4.071580930693652;
  b[102] = 4.085119769632842;
  b[103] = 2.454991414618201;
  b[104] = 2.447041605672743;
  b[105] = -0.01011321277671419;
  b[106] = -0.01039878148413306;
  b[107] = -0.01070276779082078;
  b[108] = -0.01102635952987677;
  b[109] = -0.01137082114305346;
  b[110] = -0.01173749862158995;
  b[111] = -0.01212782476570203;
  b[112] = -0.0125433247832801;
  b[113] = -0.01298562224967223;
  b[114] = -0.01345644545184006;
  b[115] = -0.01395763414167768;
  b[116] = -0.01449114672488213;
  b[117] = -0.01505906791346622;
  b[118] = 4.159504763062606;
  b[119] = 4.173273243077246;
  b[120] = 2.548830298634133;
  b[121] = 2.540636038036317;
  b[122] = -0.01047989025525068;
  b[123] = -0.01076545896266956;
  b[124] = -0.01106944526935728;
  b[125] = -0.01139303700841326;
  b[126] = -0.01173749862158995;
  b[127] = -0.01210417610012645;
  b[128] = -0.01249450224423852;
  b[129] = -0.01291000226181659;
  b[130] = -0.01335229972820872;
  b[131] = -0.01382312293037656;
  b[132] = -0.01432431162021418;
  b[133] = -0.01485782420341863;
  b[134] = -0.01542574539200272;
  b[135] = 4.25309919542618;
  b[136] = 4.267112127093179;
  b[137] = 2.648721270700128;
  b[138] = 2.640266792672904;
  b[139] = -0.01087021639936276;
  b[140] = -0.01115578510678163;
  b[141] = -0.01145977141346935;
  b[142] = -0.01178336315252533;
  b[143] = -0.01212782476570203;
  b[144] = -0.01249450224423852;
  b[145] = -0.01288482838835059;
  b[146] = -0.01330032840592866;
  b[147] = -0.0137426258723208;
  b[148] = -0.01421344907448863;
  b[149] = -0.01471463776432625;
  b[150] = -0.0152481503475307;
  b[151] = -0.01581607153611479;
  b[152] = 4.352729950062767;
  b[153] = 4.367003099159174;
  b[154] = 2.755054656960299;
  b[155] = 2.746323178921356;
  b[156] = -0.01128571641694083;
  b[157] = -0.0115712851243597;
  b[158] = -0.01187527143104742;
  b[159] = -0.01219886317010341;
  b[160] = -0.0125433247832801;
  b[161] = -0.01291000226181659;
  b[162] = -0.01330032840592866;
  b[163] = -0.01371582842350674;
  b[164] = -0.01415812588989887;
  b[165] = -0.0146289490920667;
  b[166] = -0.01513013778190432;
  b[167] = -0.01566365036510877;
  b[168] = -0.01623157155369286;
  b[169] = 4.458786336311219;
  b[170] = 4.473336485419344;
  b[171] = 2.868245957432222;
  b[172] = 2.859219614415685;
  b[173] = -0.01172801388333296;
  b[174] = -0.01201358259075183;
  b[175] = -0.01231756889743955;
  b[176] = -0.01264116063649554;
  b[177] = -0.01298562224967223;
  b[178] = -0.01335229972820872;
  b[179] = -0.0137426258723208;
  b[180] = -0.01415812588989887;
  b[181] = -0.014600423356291;
  b[182] = -0.01507124655845883;
  b[183] = -0.01557243524829645;
  b[184] = -0.0161059478315009;
  b[185] = -0.01667386902008499;
  b[186] = 4.571682771805548;
  b[187] = 4.586527785891268;
  b[188] = 2.988737469582292;
  b[189] = 2.979397244430976;
  b[190] = -0.01219883708550079;
  b[191] = -0.01248440579291966;
  b[192] = -0.01278839209960739;
  b[193] = -0.01311198383866337;
  b[194] = -0.01345644545184006;
  b[195] = -0.01382312293037656;
  b[196] = -0.01421344907448863;
  b[197] = -0.0146289490920667;
  b[198] = -0.01507124655845883;
  b[199] = -0.01554206976062666;
  b[200] = -0.01604325845046429;
  b[201] = -0.01657677103366874;
  b[202] = -0.01714469222225282;
  b[203] = 4.691860401820839;
  b[204] = 4.707019298041337;
  b[205] = 3.117000016612675;
  b[206] = 3.107325665668133;
  b[207] = -0.01270002577533841;
  b[208] = -0.01298559448275728;
  b[209] = -0.01328958078944501;
  b[210] = -0.01361317252850099;
  b[211] = -0.01395763414167768;
  b[212] = -0.01432431162021418;
  b[213] = -0.01471463776432625;
  b[214] = -0.01513013778190432;
  b[215] = -0.01557243524829645;
  b[216] = -0.01604325845046429;
  b[217] = -0.01654444714030191;
  b[218] = -0.01707795972350636;
  b[219] = -0.01764588091209044;
  b[220] = 4.819788823057997;
  b[221] = 4.83528184507172;
  b[222] = 3.253534787213209;
  b[223] = 3.243504761213198;
  b[224] = -0.01323353835854286;
  b[225] = -0.01351910706596173;
  b[226] = -0.01382309337264946;
  b[227] = -0.01414668511170544;
  b[228] = -0.01449114672488213;
  b[229] = -0.01485782420341863;
  b[230] = -0.0152481503475307;
  b[231] = -0.01566365036510877;
  b[232] = -0.0161059478315009;
  b[233] = -0.01657677103366874;
  b[234] = -0.01707795972350636;
  b[235] = -0.01761147230671081;
  b[236] = -0.01817939349529489;
  b[237] = 4.955967918603061;
  b[238] = 4.971816615672254;
  b[239] = 3.398875293967098;
  b[240] = 3.388466653841364;
  b[241] = -0.01380145954712695;
  b[242] = -0.01408702825454582;
  b[243] = -0.01439101456123355;
  b[244] = -0.01471460630028953;
  b[245] = -0.01505906791346622;
  b[246] = -0.01542574539200272;
  b[247] = -0.01581607153611479;
  b[248] = -0.01623157155369286;
  b[249] = -0.01667386902008499;
  b[250] = -0.01714469222225282;
  b[251] = -0.01764588091209044;
  b[252] = -0.01817939349529489;
  b[253] = -0.01874731468387898;
  b[254] = 5.100929811231228;
  b[255] = 5.117157122426143;
  b[256] = 3.553589458062927;
  b[257] = 6.087513308265885;
  b[258] = 3.838500207088791;
  b[259] = 3.911391624304666;
  b[260] = 3.988984134033635;
  b[261] = 4.071580930693652;
  b[262] = 4.159504763062606;
  b[263] = 4.25309919542618;
  b[264] = 4.352729950062767;
  b[265] = 4.458786336311219;
  b[266] = 4.571682771805548;
  b[267] = 4.691860401820839;
  b[268] = 4.819788823057997;
  b[269] = 4.955967918603061;
  b[270] = 5.100929811231228;
  b[271] = 8.718250412337529;
  b[272] = 5.271871286521972;
  b[273] = 3.718281828459045;
  b[274] = 3.782776287376905;
  b[275] = 3.851430281525872;
  b[276] = 3.924512077880026;
  b[277] = 4.002307245146787;
  b[278] = 4.085119769632842;
  b[279] = 4.173273243077246;
  b[280] = 4.267112127093179;
  b[281] = 4.367003099159174;
  b[282] = 4.473336485419344;
  b[283] = 4.586527785891268;
  b[284] = 4.707019298041337;
  b[285] = 4.83528184507172;
  b[286] = 4.971816615672254;
  b[287] = 5.117157122426143;
  b[288] = 5.271871286521972;
  b[289] = 5.43656365691809;

  matrix<long double> DuDv = Uh.DUDV();
  vector<long double> s = Uh.B (f_test_q1, NbIntPts);

  Uh.Dirichlet (DuDv,s, u_test_q1);

  boolean = 1;
  for (int i=1; i<=Uh.GlobalDofNumber(); i++)
    for (int j=1; j<=Uh.GlobalDofNumber(); j++)
      boolean *= (abs (m(i,j) - DuDv(i,j)) <= epsilon_loc);

  if (detail) affiche ("Stifness Matrix", boolean);
  else result *= boolean;

  for (int i=1; i<=289; i++)
    boolean *= (abs (b[i] - s[i]) <= epsilon_loc);

  if (detail) affiche ("Integration right-hand side", boolean);
  else result *= boolean;

  long double l2_error = 0.001199032397725711;
  long double semi_H1_error = 0.0455956004022508;

  vector<long double> uh = gauss (DuDv) * s;
  boolean = (abs (l2_error - Uh.error_L2 (u_test_q1, uh,NbIntPts)) <= epsilon_loc);
  if (detail) affiche ("l2 error", boolean);
  else result *= boolean;

  boolean = (abs (semi_H1_error - Uh.error_semi_H1 (dudx_test_q1, dudy_test_q1, uh,NbIntPts)) <= epsilon_loc);
  if (detail) affiche ("semi h1 error", boolean);
  else result *= boolean;


  cout << "============================================================== \n";
  if (result) cout << green << "                       q12d test passed" << reset;
  else cout << red << "                       q12d test failed" << reset;
  cout << "============================================================== \n";

  return result;
}


#endif
