/***************************************************************
 *                    simula.plus@cemes.fr                     *
 *                   GNU/linux version 3.0.0                   *
 *            software under General Public License            *
 ***************************************************************
 * copyright © 2003 CREUSE Emmanuel
 * copyright © 2012 COLLARD Christophe
 * copyright © 2003,2012 Centre National de la Recherche Scientifique
 * copyright © 2003 Arts et Métiers ParisTech
 * copyright © 2003 Université de Valenciennes et du Hainaut Cambrésis
 * copyright © 2003 Laboratoire de Physique et Mécanique des Matériaux (LPMM - UMR 7554)
 * copyright © 2003 Laboratoire de Mathématiques et ses Applications de Valenciennes (LAMAV - EA 4015)
 * copyright © 2012 Centre d'Elaboration de Matériaux et d'Etudes Structurales (CEMES - CNRS)
 ***************************************************************/

/*
    tetrahedron-test belongs to Mathematical Object Libraries (FEMOL++)
    FEMOL++ is part of Simula+

    Simula+ is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    Simula+ is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with Simula+; if not, write to the Free Software
    Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
*/

#ifndef __cplusplus
#error Must use C++ for the type tetrahedron-test.
#endif

#ifndef __tetrahedron_test_hpp
#define __tetrahedron_test_hpp

#ifndef __iostream
#include <iostream>
#endif

#ifndef __stdio_h
#include <stdio.h>
#endif

#ifndef __stdlib_h
#include <stdlib.h>
#endif

#ifndef __node_hpp
#include "FEMOL++/meshes/node.hpp"
#endif

#ifndef __tetraedron_hpp
#include "FEMOL++/meshes/tetrahedron.hpp"
#endif

#ifndef __affiche_hpp
#include "tests/affiche.hpp"
#endif

using namespace std;
using namespace femol;


//===============================
int test_tetrahedron (int detail)
//===============================
{
  int result = 1;

  if (detail < 0) 
    { cout << "============================================================== \n";
      cout << blue << "                   tetrahedron test skipped" << reset;
      cout << "============================================================== \n";
      return result;
    }

  tetrahedron<long double> T1, T2, T3;
  node<long double> E(3), F(3), G(3), H(3);
  F[1] = G[2] = H[3] = 1;
  E.boundary_condition () = 0;
  F.boundary_condition () = 1;
  G.boundary_condition () = 2;
  H.boundary_condition () = 3;
  T1 = tetrahedron<long double> (E, F, G, H);
  node<long double> ** TAB;
  TAB = new node<long double>* [4];
  TAB[0] = &E;
  TAB[1] = &F;
  TAB[2] = &G;
  TAB[3] = &H;
  T3 = tetrahedron<long double> (TAB);
  T2 = T1;

  if (detail) affiche ("operator =", (T2 == T1) && (T3 == T1));
  else result *= ((T2 == T1) && (T3 == T1));

  T1[1] = E;
  T1[2] = F;
  T1[3] = G;
  T1[4] = H;
  T2[1] = E;
  T2[2] = F;
  T2[3] = G;
  T2[4] = H;
  if (detail) affiche ("operator []", (T2[1] == T1[1]) && (T2[2] == T1[2]) && (T2[3] == T1[3]) && (T2[4] == T1[4]));
  else for(int i=1; i<=4; i++) result *= (T2[i] == T1[i]);

  // Test constructeur par recopie
  tetrahedron<long double> toto (E, F, G, H);
  tetrahedron<long double> titi (toto);

  if (detail) affiche ("copy constructor", titi == toto);
  else result *= (titi == toto);

  if (detail) affiche ("AbsDet", abs (T1.AbsDet() - 1)<=epsilon);
  else result *= (abs (T1.AbsDet() - 1) <= epsilon);

  node<long double> I(3), J(3), K(3), L(3);

  I[1] = 3;
  I[2] = 2;
  I[3] = 1;
  J[1] = 1;
  J[2] = 4;
  J[3] = 6;
  K[1] = 7;
  K[2] = 9;
  K[3] = 12;
  L[1] = L[2] = 0;
  L[3] = 1;

  tetrahedron<long double> tetra (I, J, K, L);

  matrix<long double> Mk_locale (3,3);
  Mk_locale(1,1) = -2;
  Mk_locale(1,2) = 4;
  Mk_locale(1,3) = -3;
  Mk_locale(2,1) = 2;
  Mk_locale(2,2) = 7;
  Mk_locale(2,3) = -2;
  Mk_locale(3,1) = 5;
  Mk_locale(3,2) = 11;
  Mk_locale(3,3) = 0;

  if (detail) affiche ("Mk", Mk_locale == tetra.Mk());
  else result *= (Mk_locale == tetra.Mk());

  if (detail) affiche ("InvMk", Mk_locale.inv() == tetra.InvMk());
  else result *= (Mk_locale.inv() == tetra.InvMk());

  if (detail) affiche ("nb_nodes", 4 == tetra.nb_nodes());
  else result *= (4 == tetra.nb_nodes());

  cout << "============================================================== \n";
  if (result) cout << green << "                   tetrahedron test passed" << reset;
  else cout << red << "                   tetrahedron test failed" << reset;
  cout << "============================================================== \n";

  return result;
}


#endif
