/***************************************************************
 *                    simula.plus@cemes.fr                     *
 *                   GNU/linux version 3.0.0                   *
 *            software under General Public License            *
 ***************************************************************
 * copyright © 2003,2004,2005,2006 CREUSE Emmanuel
 * copyright © 2011,2012 COLLARD Christophe
 * copyright © 2003,2004,2005,2006,2011,2012 Centre National de la Recherche Scientifique
 * copyright © 2003,2004,2005,2006 Laboratoire de Physique et Mécanique des Matériaux (LPMM - UMR 7554)
 * copyright © 2003,2004,2005,2006 Laboratoire de Mathématiques et ses Applications de Valenciennes (LAMAV - EA 4015)
 * copyright © 2011,2012 Centre d'Elaboration de Matériaux et d'Etudes Structurales (CEMES - CNRS)
 ***************************************************************/

/*
    tests-FEMOL++ belongs to Finite Element Method Object Libraries (FEMOL++)
    FEMOL++ is part of Simula+

    Simula+ is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    Simula+ is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with Simula+; if not, write to the Free Software
    Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
*/


#ifndef __cplusplus
#error Must use C++ for the type interface.
#endif

#ifndef __iostream
#include <iostream>
#endif

#ifndef __stdio_h
#include <stdio.h>
#endif

#ifndef __time_h
#include <time.h>
#endif

#ifndef __stdlib_h
#include <stdlib.h>
#endif

#ifndef __convert_test_hpp
#include "meshes/convert-test.hpp"
#endif

#ifndef __node_test_hpp
#include "meshes/node-test.hpp"
#endif

#ifndef __triangle_test_hpp
#include "meshes/triangle-test.hpp"
#endif

#ifndef __rectangle_test_hpp
#include "meshes/rectangle-test.hpp"
#endif

#ifndef __tetrahedron_test_hpp
#include "meshes/tetrahedron-test.hpp"
#endif

#ifndef __mesh_test_hpp
#include "meshes/mesh-test.hpp"
#endif

#ifndef __mesh_tri_2d_test_hpp
#include "meshes/mesh_tri_2d-test.hpp"
#endif

#ifndef __p1c2d_test_hpp
#include "elements/p1c2d-test.hpp"
#endif

#ifndef __tetrap0_test_hpp
#include "elements/tetrap0-test.hpp"
#endif

#ifndef __tetraRT0_test_hpp
#include "elements/tetraRT0-test.hpp"
#endif

#ifndef __p1c3d_test_hpp
#include "elements/p1c3d-test.hpp"
#endif

#ifndef __p1nc2d_test_hpp
#include "elements/p1nc2d-test.hpp"
#endif

#ifndef __q12d_test_hpp
#include "elements/q12d-test.hpp"
#endif

#ifndef __rt02d_test_hpp
#include "elements/rt02d-test.hpp"
#endif
 
#ifndef __p2c2d_test_hpp
#include "elements/p2c2d-test.hpp"
#endif

using namespace std;
using namespace femol;


main()
{
  int detail, result; // parameter to write/hide test procedure
  clock_t start, end;
  clock_t start_main, end_main;

  result = 1;

  detail = 0;
  start = clock();
  if (detail)
    //=======================================================================
    cout << "--------------------------convert-------------------------- \n";
    //=======================================================================
  result *= test_convert(detail);
  end = clock();
  cout << "cpu time : " << (long double)(end-start)/CLOCKS_PER_SEC << endl;
  cout << endl;

  detail = 0;
  start = clock();
  if (detail)
    //=======================================================================
    cout << "----------------------------node--------------------------- \n";
    //=======================================================================
  result *= test_node (detail);
  end = clock();
  cout << "cpu time : " << (long double)(end-start)/CLOCKS_PER_SEC << endl;
  cout << endl;

  detail = 0;
  start = clock();
  if (detail)
    //=======================================================================
    cout << "-------------------------triangle-------------------------- \n";
    //=======================================================================
  result *= test_triangle (detail);
  end = clock();
  cout << "cpu time : " << (long double)(end-start)/CLOCKS_PER_SEC << endl;
  cout << endl;

  detail = 0;
  start = clock();
  if (detail)
    //=======================================================================
    cout << "-------------------------rectangle------------------------- \n";
    //=======================================================================
  result *= test_rectangle (detail);
  end = clock();
  cout << "cpu time : " << (long double)(end-start)/CLOCKS_PER_SEC << endl;
  cout << endl;

  detail = 0;
  start = clock();
  if (detail)
    //=======================================================================
    cout << "------------------------tetrahedron------------------------ \n";
    //=======================================================================
  result *= test_tetrahedron (detail);
  end = clock();
  cout << "cpu time : " << (long double)(end-start)/CLOCKS_PER_SEC << endl;
  cout << endl;

  detail = 0;
  start = clock();
  if (detail)
    //=======================================================================
    cout << "----------------------------mesh--------------------------- \n";
    //=======================================================================
  result *= test_mesh (detail);
  end = clock();
  cout << "cpu time : " << (long double)(end-start)/CLOCKS_PER_SEC << endl;
  cout << endl;

  detail = 0;
  start = clock();
  if (detail)
    //=======================================================================
    cout << "------------------------mesh_tri_2d------------------------ \n";
    //=======================================================================
  result *= test_mesh_tri_2d (detail);
  end = clock();
  cout << "cpu time : " << (long double)(end-start)/CLOCKS_PER_SEC << endl;
  cout << endl;

  detail = 0;
  start = clock();
  if (detail)
    //=======================================================================
    cout << "---------------------------p1c2d--------------------------- \n";
    //=======================================================================
  result *= test_p1c2d(detail);
  end = clock();
  cout << "cpu time : " << (long double)(end-start)/CLOCKS_PER_SEC << endl;
  cout << endl;

  detail = 0;
  start = clock();
  if (detail)
    //=======================================================================
    cout << "--------------------------tetrap0-------------------------- \n";
    //=======================================================================
  result *= test_tetrap0 (detail);
  end = clock();
  cout << "cpu time : " << (long double)(end-start)/CLOCKS_PER_SEC << endl;
  cout << endl;

  detail = 0;
  start = clock();
  if (detail)
    //=======================================================================
    cout << "-------------------------tetraRT0-------------------------- \n";
    //=======================================================================
  result *= test_tetraRT0 (detail);
  end = clock();
  cout << "cpu time : " << (long double)(end-start)/CLOCKS_PER_SEC << endl;
  cout << endl;

  detail = 0;
  start = clock();
  if (detail)
    //=======================================================================
    cout << "---------------------------p1c3d--------------------------- \n";
    //=======================================================================
  result *= test_p1c3d (detail);
  end = clock();
  cout << "cpu time : " << (long double)(end-start)/CLOCKS_PER_SEC << endl;
  cout << endl;

  detail = 0;
  start = clock();
  if (detail)
    //=======================================================================
    cout << "--------------------------p1nc2d--------------------------- \n";
    //=======================================================================
  result *= test_p1nc2d (detail);
  end = clock();
  cout << "cpu time : " << (long double)(end-start)/CLOCKS_PER_SEC << endl;
  cout << endl;

  detail = 0;
  start = clock();
  if (detail)
    //=======================================================================
    cout << "---------------------------q12d---------------------------- \n";
    //=======================================================================
  result *= test_q12d (detail);
  end = clock();
  cout << "cpu time : " << (long double)(end-start)/CLOCKS_PER_SEC << endl;
  cout << endl;

  detail = 0;
  start = clock();
  if (detail)
    //=======================================================================
    cout << "---------------------------rt02d--------------------------- \n";
    //=======================================================================
  result *= test_rt02d (detail);
  end = clock();
  cout << "cpu time : " << (long double)(end-start)/CLOCKS_PER_SEC << endl;
  cout << endl;

  detail = 0;
  start = clock();
  if (detail)
    //=======================================================================
    cout << "---------------------------p2c2d--------------------------- \n";
    //=======================================================================
  result *= test_p2c2d (detail);
  end = clock();
  cout << "cpu time : " << (long double)(end-start)/CLOCKS_PER_SEC << endl;
  cout << endl;

  cout << endl;

  end_main = clock();

  cout << "============================================================== \n";
  if (result) cout << green << "-------OK------------end of FEMOL++ tests------------OK-------" << reset;
  else cout << red << "-----FAILED----------end of FEMOL++ tests----------FAILED-----" << reset;
  cout << "============================================================== \n";

  cout<<"cpu time : " << (long double)(end_main-start_main)/CLOCKS_PER_SEC << endl;
}
