/***************************************************************
 *                    simula.plus@cemes.fr                     *
 *                   GNU/linux version 3.2.0                   *
 *            software under General Public License            *
 ***************************************************************
 * copyright © 2003,2004 CREUSE Emmanuel
 * copyright © 2004 PIRAUT Frédéric
 * copyright © 2011,2012 COLLARD Christophe
 * copyright © 2003,2004,2011,2012 Centre National de la Recherche Scientifique
 * copyright © 2003,2004 Arts et Métiers ParisTech
 * copyright © 2003,2004 Université de Valenciennes et du Hainaut Cambrésis
 * copyright © 2003,2004 Laboratoire de Physique et Mécanique des Matériaux (LPMM - UMR 7554)
 * copyright © 2003,2004 Laboratoire de Mathématiques et ses Applications de Valenciennes (LAMAV - EA 4015)
 * copyright © 2011,2012 Centre d'Elaboration de Matériaux et d'Etudes Structurales (CEMES - CNRS)
 ***************************************************************/

/*
    tetraRT0-test belongs to Mathematical Object Libraries (FEMOL++)
    FEMOL++ is part of Simula+

    Simula+ is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    Simula+ is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with Simula+; if not, write to the Free Software
    Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
*/

#ifndef __cplusplus
#error Must use C++ for the type tetrap0-test
#endif

#ifndef __tetraRT0_test_hpp
#define __tetraRT0_test_hpp

#ifndef __iostream
#include <iostream>
#endif

#ifndef __assert_h
#include <assert.h>
#endif

#ifndef __time_h
#include <time.h>
#endif

#ifndef __vectors_hpp
#include "MOL++/vectors.hpp"
#endif

#ifndef __mesh_hpp
#include "FEMOL++/meshes/mesh.hpp"
#endif

#ifndef __tetraRT0_hpp
#include "FEMOL++/elements/tetraRT0.hpp"
#endif

#ifndef __affiche_hpp
#include "tests/affiche.hpp"
#endif

using namespace std;
using namespace mol;
using namespace femol;


//============================
int test_tetraRT0 (int detail)
//============================
{
  int result = 1;

  if (detail < 0) 
    { cout << "============================================================== \n";
      cout << blue << "                    tetraRT0 test skipped" << reset;
      cout << "============================================================== \n";
      return result;
    }

  tetraRT0<long double> Th ("data/cube1.txt", "data/cube2.txt");
  tetraRT0<long double> Th2 ("data/cube.txt");

  if (detail) affiche ("operator ==", Th == Th2);
  else result *= (Th == Th2);

  tetraRT0<long double> Uh ("data/tetra.txt");
  if (detail) affiche ("operator !=", Th2 != Uh);
  else result *= (Th2 != Uh);

  tetraRT0<long double> Th3 (Th2);
  if (detail) affiche ("copy constructor", Th2 == Th3);
  else result *= (Th2 == Th3);

  tetraRT0<long double> Th4;
  Th4 = Th2;
  if (detail) affiche ("operator =", Th4 == Th2);
  else result *= (Th4 == Th2);

  if (detail) affiche ("DofNumber", Th.DofNumber() == 4);
  else result *= (Th.DofNumber() == 4);

  if (detail) affiche("GlobalDofNumber", Th.GlobalDofNumber() == 18);
  else result *= (Th.GlobalDofNumber() == 18);

  if (detail) affiche ("nbfaces", Th.nbfaces() == 18);
  else result *= (Th.nbfaces() == 18);

  matrix<int> face_of_element_loc (6,4);
  face_of_element_loc(1,1) = 1;
  face_of_element_loc(1,2) = 2;
  face_of_element_loc(1,3) = 3;
  face_of_element_loc(1,4) = 4;
  face_of_element_loc(2,1) = 5;
  face_of_element_loc(2,2) = 6;
  face_of_element_loc(2,3) = 7;
  face_of_element_loc(2,4) = 8;
  face_of_element_loc(3,1) = 9;
  face_of_element_loc(3,2) = 5;
  face_of_element_loc(3,3) = 1;
  face_of_element_loc(3,4) = 10;
  face_of_element_loc(4,1) = 7;
  face_of_element_loc(4,2) = 11;
  face_of_element_loc(4,3) = 12;
  face_of_element_loc(4,4) = 13;
  face_of_element_loc(5,1) = 11;
  face_of_element_loc(5,2) = 2;
  face_of_element_loc(5,3) = 14;
  face_of_element_loc(5,4) = 15;
  face_of_element_loc(6,1) = 16;
  face_of_element_loc(6,2) = 17;
  face_of_element_loc(6,3) = 14;
  face_of_element_loc(6,4) = 18;
  if (detail) affiche ("face_of_element", Th.face_of_element() == face_of_element_loc);
  else result *= (Th.face_of_element() == face_of_element_loc);

  matrix<int> node_of_face_loc(18,3);
  node_of_face_loc(1,1) = 2;
  node_of_face_loc(1,2) = 5;
  node_of_face_loc(1,3) = 7;
  node_of_face_loc(2,1) = 2;
  node_of_face_loc(2,2) = 5;
  node_of_face_loc(2,3) = 8;
  node_of_face_loc(3,1) = 2;
  node_of_face_loc(3,2) = 7;
  node_of_face_loc(3,3) = 8;
  node_of_face_loc(4,1) = 5;
  node_of_face_loc(4,2) = 7;
  node_of_face_loc(4,3) = 8;
  node_of_face_loc(5,1) = 1;
  node_of_face_loc(5,2) = 2;
  node_of_face_loc(5,3) = 5;
  node_of_face_loc(6,1) = 1;
  node_of_face_loc(6,2) = 2;
  node_of_face_loc(6,3) = 6;
  node_of_face_loc(7,1) = 2;
  node_of_face_loc(7,2) = 5;
  node_of_face_loc(7,3) = 6;
  node_of_face_loc(8,1) = 1;
  node_of_face_loc(8,2) = 5;
  node_of_face_loc(8,3) = 6;
  node_of_face_loc(9,1) = 1;
  node_of_face_loc(9,2) = 2;
  node_of_face_loc(9,3) = 7;
  node_of_face_loc(10,1) = 1;
  node_of_face_loc(10,2) = 5;
  node_of_face_loc(10,3) = 7;
  node_of_face_loc(11,1) = 2;
  node_of_face_loc(11,2) = 4;
  node_of_face_loc(11,3) = 5;
  node_of_face_loc(12,1) = 4;
  node_of_face_loc(12,2) = 5;
  node_of_face_loc(12,3) = 6;
  node_of_face_loc(13,1) = 2;
  node_of_face_loc(13,2) = 4;
  node_of_face_loc(13,3) = 6;
  node_of_face_loc(14,1) = 4;
  node_of_face_loc(14,2) = 5;
  node_of_face_loc(14,3) = 8;
  node_of_face_loc(15,1) = 2;
  node_of_face_loc(15,2) = 4;
  node_of_face_loc(15,3) = 8;
  node_of_face_loc(16,1) = 3;
  node_of_face_loc(16,2) = 5;
  node_of_face_loc(16,3) = 8;
  node_of_face_loc(17,1) = 3;
  node_of_face_loc(17,2) = 4;
  node_of_face_loc(17,3) = 5;
  node_of_face_loc(18,1) = 3;
  node_of_face_loc(18,2) = 4;
  node_of_face_loc(18,3) = 8;
  if (detail) affiche ("node_of_face", Th.node_of_face() == node_of_face_loc);
  else result *= (Th.node_of_face() == node_of_face_loc); 

  matrix<int> direction_of_normal_loc(6,4);
  direction_of_normal_loc(1,1) = 1;
  direction_of_normal_loc(1,2) = -1;
  direction_of_normal_loc(1,3) = 1;
  direction_of_normal_loc(1,4) = -1;
  direction_of_normal_loc(2,1) = -1;
  direction_of_normal_loc(2,2) = 1;
  direction_of_normal_loc(2,3) = 1;
  direction_of_normal_loc(2,4) = -1;
  direction_of_normal_loc(3,1) = -1;
  direction_of_normal_loc(3,2) = 1;
  direction_of_normal_loc(3,3) = -1;
  direction_of_normal_loc(3,4) = 1;
  direction_of_normal_loc(4,1) = -1;
  direction_of_normal_loc(4,2) = -1;
  direction_of_normal_loc(4,3) = 1;
  direction_of_normal_loc(4,4) = 1;
  direction_of_normal_loc(5,1) = 1;
  direction_of_normal_loc(5,2) = 1;
  direction_of_normal_loc(5,3) = -1;
  direction_of_normal_loc(5,4) = -1;
  direction_of_normal_loc(6,1) = -1;
  direction_of_normal_loc(6,2) = -1;
  direction_of_normal_loc(6,3) = 1;
  direction_of_normal_loc(6,4) = 1;
  if (detail) affiche ("direction_of_normal", Th.direction_of_normal() == direction_of_normal_loc);
  else result *= (Th.direction_of_normal() == direction_of_normal_loc);

  if (detail) affiche ("operator ()", (Th(2,1) == 5) && (Th(2,2) == 6) && (Th(2,3) == 7) && (Th(3,2) == 5));
  else result *= ((Th(2,1) == 5) && (Th(2,2) == 6) && (Th(2,3) == 7) && (Th(3,2) == 5));

  vector<int> type_of_face_loc(18);
  type_of_face_loc[1] = 0;
  type_of_face_loc[2] = 0;
  type_of_face_loc[3] = 1;
  type_of_face_loc[4] = 1;
  type_of_face_loc[5] = 0;
  type_of_face_loc[6] = 1;
  type_of_face_loc[7] = 0;
  type_of_face_loc[8] = 1;
  type_of_face_loc[9] = 1;
  type_of_face_loc[10] = 1;
  type_of_face_loc[11] = 0;
  type_of_face_loc[12] = 1;
  type_of_face_loc[13] = 1;
  type_of_face_loc[14] = 0;
  type_of_face_loc[15] = 1;
  type_of_face_loc[16] = 1;
  type_of_face_loc[17] = 1;
  type_of_face_loc[18] = 1;
  if (detail) affiche ("type_of_face", Th.type_of_face() == type_of_face_loc);
  else result *= (Th.type_of_face() == type_of_face_loc);

  matrix<long double> matloc(4,4);
  matloc(1,1) = 1.0/3.0;
  matloc(1,2) = 0.;
  matloc(1,3) = -1.0/6.0;
  matloc(1,4) = -1.0/6.0;
  matloc(2,1) = 0;
  matloc(2,2) = 1.0/3.0;
  matloc(2,3) = -1.0/6.0;
  matloc(2,4) = -1.0/6.0;
  matloc(3,1) = -1.0/6.0;
  matloc(3,2) = -1.0/6.0;
  matloc(3,3) = 2.0/3.0;
  matloc(3,4) = 1.0/3.0;
  matloc(4,1) = -1.0/6.0;
  matloc(4,2) = -1.0/6.0;
  matloc(4,3) = 1.0/3.0;
  matloc(4,4) = 2.0/3.0;

  if (detail) affiche ("LocalMassMatrix1", Th.LocalMassMatrix(1) == matloc);
  else result *= (Th.LocalMassMatrix(1) == matloc);

  matrix<long double> matloc4(4,4);
  matloc4(1,1) = 1.0/3.0;
  matloc4(1,2) = -1.0/6.0;
  matloc4(1,3) = 0.0;
  matloc4(1,4) = -1.0/6.0;
  matloc4(2,1) = -1.0/6.0;
  matloc4(2,2) = 2.0/3.0;
  matloc4(2,3) = -1.0/6.0;
  matloc4(2,4) = 1.0/3.0;
  matloc4(3,1) = 0.0;
  matloc4(3,2) = -1.0/6.0;
  matloc4(3,3) = 1.0/3.0;
  matloc4(3,4) = -1.0/6.0;
  matloc4(4,1) = -1.0/6.0;
  matloc4(4,2) = 1.0/3.0;
  matloc4(4,3) = -1.0/6.0;
  matloc4(4,4) = 2.0/3.0;

  if (detail) affiche ("LocalMassMatrix2", Th.LocalMassMatrix(2) == matloc4);
  else result *= (Th.LocalMassMatrix(2) == matloc4);

  matrix<long double> matloc3(4,4);
  matloc3(1,1) = 2.0/3.0;
  matloc3(1,2) = -1.0/6.0;
  matloc3(1,3) = -1.0/6.0;
  matloc3(1,4) = 1.0/3.0;
  matloc3(2,1) = -1.0/6.0;
  matloc3(2,2) = 1.0/3.0;
  matloc3(2,3) = 0.0;
  matloc3(2,4) = -1.0/6.0;
  matloc3(3,1) = -1.0/6.0;
  matloc3(3,2) = 0.0;
  matloc3(3,3) = 1.0/3.0;
  matloc3(3,4) = -1.0/6.0;
  matloc3(4,1) = 1.0/3.0;
  matloc3(4,2) = -1.0/6.0;
  matloc3(4,3) = -1.0/6.0;
  matloc3(4,4) = 2.0/3.0;

  if (detail) affiche ("LocalMassMatrix3", Th.LocalMassMatrix(3) == matloc3);
  else result *= (Th.LocalMassMatrix(3) == matloc3);

  matrix<long double> matloc5(4,4);
  matloc5(1,1) = 1.0/3.0;
  matloc5(1,2) = 0.0;
  matloc5(1,3) = -1.0/6.0;
  matloc5(1,4) = 1.0/6.0;
  matloc5(2,1) = 0.0;
  matloc5(2,2) = 1.0/3.0;
  matloc5(2,3) = 1.0/6.0;
  matloc5(2,4) = -1.0/6.0;
  matloc5(3,1) = -1.0/6.0;
  matloc5(3,2) = 1.0/6.0;
  matloc5(3,3) = 2.0/3.0;
  matloc5(3,4) = -1.0/3.0;
  matloc5(4,1) = 1.0/6.0;
  matloc5(4,2) = -1.0/6.0;
  matloc5(4,3) = -1.0/3.0;
  matloc5(4,4) = 2.0/3.0;

  if (detail) affiche ("LocalMassMatrix4", Th.LocalMassMatrix(4) == matloc5);
  else result *= (Th.LocalMassMatrix(4) == matloc5);

  matrix<long double> matloc1(4,4);
  matloc1(1,1) = 7.0/15.0;
  matloc1(1,2) = -1.0/5.0;
  matloc1(1,3) = -4.0/30.0;
  matloc1(1,4) = 1.0/30.0;
  matloc1(2,1) = -1.0/5.0;
  matloc1(2,2) = 7.0/15.0;
  matloc1(2,3) = -4.0/30.0;
  matloc1(2,4) = 1.0/30.0;
  matloc1(3,1) = -4.0/30.0;
  matloc1(3,2) = -4.0/30.0;
  matloc1(3,3) = 7.0/15.0;
  matloc1(3,4) = -11.0/30.0;
  matloc1(4,1) = 1.0/30.0;
  matloc1(4,2) = 1.0/30.0;
  matloc1(4,3) = -11.0/30.0;
  matloc1(4,4) = 4.0/5.0;

  if (detail) affiche ("LocalMassMatrix5", Th.LocalMassMatrix(5) == matloc1);
  else result *= (Th.LocalMassMatrix(5) == matloc1);

  matrix<long double> matloc2(4,4);
  matloc2(1,1) = 8.0/15.0;
  matloc2(1,2) = -4.0/30.0;
  matloc2(1,3) = -1.0/30.0;
  matloc2(1,4) = 4.0/30.0;
  matloc2(2,1) = -4.0/30.0;
  matloc2(2,2) = 8.0/15.0;
  matloc2(2,3) = -1.0/30.0;
  matloc2(2,4) = 4.0/30.0;
  matloc2(3,1) = -1.0/30.0;
  matloc2(3,2) = -1.0/30.0;
  matloc2(3,3) = 1.0/5.0;
  matloc2(3,4) = 1.0/30.0;
  matloc2(4,1) = 4.0/30.0;
  matloc2(4,2) = 4.0/30.0;
  matloc2(4,3) = 1.0/30.0;
  matloc2(4,4) = 8.0/15.0;

  if (detail) affiche ("LocalMassMatrix6", Th.LocalMassMatrix(6) == matloc2);
  else result *= (Th.LocalMassMatrix(6) == matloc2);

  vector<long double> betatest(6);
  betatest[1] = 1 ; betatest[2] = 2;
  betatest[3] = 3 ; betatest[4] = 4;
  betatest[5] = 5 ; betatest[6] = 6;
  vector<long double> b1(18);
  b1[1] = 2.0;
  b1[2] = -4.0;
  b1[3] = -1.0;
  b1[4] = 1.0;
  b1[5] = -1.0;
  b1[6] = -2.0;
  b1[7] = 2.0;
  b1[8] = 2.0;
  b1[9] = 3.0;
  b1[10] = -3.0;
  b1[11] = -1.0;
  b1[12] = -4.0;
  b1[13] = -4.0;
  b1[14] = -1.0;
  b1[15] = 5.0;
  b1[16] = 6.0;
  b1[17] = 6.0;
  b1[18] = -6.0;
  if (detail) affiche ("B_PB_MIXTE", b1 == Th.B_PB_MIXTE (betatest));
  else result *= (b1 == Th.B_PB_MIXTE (betatest));


  cout << "============================================================== \n";
  if (result) cout << green << "                     tetraRT0 test passed" << reset;
  else cout << red << "                     tetraRT0 test failed" << reset;
  cout << "============================================================== \n";

  return result;
}

#endif
