/***************************************************************
 *                    simula.plus@cemes.fr                     *
 *                   GNU/linux version 3.2.0                   *
 *            software under General Public License            *
 ***************************************************************
 * copyright © 2002,2003,2004,2005,2006 CREUSE Emmanuel
 * copyright © 2002,2003,2004,2005,2006 SOUALEM Nadir
 * copyright © 2002,2003,2012 COLLARD Christophe
 * copyright © 2003 DJADEL Karim
 * copyright © 2002,2003,2004,2005,2006,2012 Centre National de la Recherche Scientifique
 * copyright © 2002,2003,2004,2005,2006 Arts et Métiers ParisTech
 * copyright © 2002,2003,2004,2005,2006 Université de Valenciennes et du Hainaut Cambrésis
 * copyright © 2002,2003,2004,2005,2006 Laboratoire de Physique et Mécanique des Matériaux (LPMM - UMR 7554)
 * copyright © 2002,2003,2004,2005,2006 Laboratoire de Mathématiques et ses Applications de Valenciennes (LAMAV - EA 4015)
 * copyright © 2012 Centre d'Elaboration de Matériaux et d'Etudes Structurales (CEMES - CNRS)
 ***************************************************************/

/*
    node-test belongs to Mathematical Object Libraries (FEMOL++)
    FEMOL++ is part of Simula+

    Simula+ is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    Simula+ is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with Simula+; if not, write to the Free Software
    Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
*/

#ifndef __cplusplus
#error Must use C++ for the type node-test.
#endif

#ifndef __node_test_hpp
#define __node_test_hpp


#ifndef __iostream
#include <iostream>
#endif

#ifndef __stdio_h
#include <stdio.h>
#endif

#ifndef __stdlib_h
#include <stdlib.h>
#endif

#ifndef __vectors_hpp
#include "MOL++/vectors.hpp"
#endif

#ifndef __node_hpp
#include "FEMOL++/meshes/node.hpp"
#endif

#ifndef __affiche_hpp
#include "tests/affiche.hpp"
#endif

using namespace std;
using namespace mol;
using namespace femol;


//========================
int test_node (int detail)
//========================
{
  int result = 1;

  if (detail < 0) 
    { cout << "============================================================== \n";
      cout << blue << "                      node test skipped" << reset;
      cout << "============================================================== \n";
      return result;
    }

  vector<float> u(2);
  vector<float> v;
  u[1] = 0.1;
  u[2] = -0.1;
  node<float> A(2), B(2), C1(u,1), C2(0,u), D, E(3);
  A[1] = 0.1;
  A[2] = -0.1;

  // Test de l'extraction (par conversion implicite) d'un vecteur à partir d'un noeud.
  v = vector<float> (A);
  if (detail) affiche ("vector's extraction for node", v == u);
  else result *= (v == u);

  //test boundary_condition par défaut= -1
  if (detail) affiche ("default boundary_condition", A.boundary_condition() == -1);
  else result *= (A.boundary_condition() == -1);

  //test affectation de boundary_condition
  A.boundary_condition() = 1;
  if (detail) affiche ("boundary_condition affectation", A.boundary_condition() - 1 == 0);
  else result *= (A.boundary_condition() - 1 == 0);

  //Test affectation =
  D = A;
  if (detail) affiche ("operator =", D == A);
  else result *= (D == A);

  //Test operateur - sur les noeuds
  node<float> C3 (A-D, 1);

  if (detail) affiche ("operator - by conversion node vector", (abs (C3[1]) < epsilon) && (abs (C3[2]) < epsilon));
  else result *= (abs (C3[1]) < epsilon) && (abs (C3[2]) < epsilon);

  //Test constructeur par recopie
  node<int> toto (2);
  toto[1] = 123;
  toto[2] = -34;
  toto.boundary_condition() = 2;
  node<int> titi (toto);

  if (detail) affiche ("copy constructor", titi == toto);
  else result *= (titi == toto);

  cout << "============================================================== \n";
  if (result) cout << green << "                       node test passed" << reset;
  else cout << red << "                       node test failed" << reset;
  cout << "============================================================== \n";

  return result;
}


#endif
