/***************************************************************
 *                    simula.plus@cemes.fr                     *
 *                   GNU/linux version 3.2.0                   *
 *            software under General Public License            *
 ***************************************************************
 * copyright © 2004 CREUSE Emmanuel
 * copyright © 2004 KALETA Olivia
 * copyright © 2012 COLLARD Christophe
 * copyright © 2004,2012 Centre National de la Recherche Scientifique
 * copyright © 2004 Arts et Métiers ParisTech
 * copyright © 2004 Université de Valenciennes et du Hainaut Cambrésis
 * copyright © 2004 Laboratoire de Physique et Mécanique des Matériaux (LPMM - UMR 7554)
 * copyright © 2004 Laboratoire de Mathématiques et ses Applications de Valenciennes (LAMAV - EA 4015)
 * copyright © 2012 Centre d'Elaboration de Matériaux et d'Etudes Structurales (CEMES - CNRS)
 ***************************************************************/

/*
    rectangle-test belongs to Mathematical Object Libraries (FEMOL++)
    FEMOL++ is part of Simula+

    Simula+ is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    Simula+ is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with Simula+; if not, write to the Free Software
    Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
*/
 
#ifndef __cplusplus
#error Must use C++ for rectangle-test.
#endif

#ifndef __rectangle_test_hpp
#define __rectangle_test_hpp

#ifndef __iostream
#include <iostream>
#endif

#ifndef __stdio_h
#include <stdio.h>
#endif

#ifndef __stdlib_h
#include <stdlib.h>
#endif

#ifndef __matrix_hpp
#include "MOL++/matrix.hpp"
#endif

#ifndef __rectangle_hpp
#include "FEMOL++/meshes/rectangle.hpp"
#endif

#ifndef __affiche_hpp
#include "tests/affiche.hpp"
#endif

using namespace std;
using namespace mol;
using namespace femol;



//=============================
int test_rectangle (int detail)
//=============================
{
  int result = 1;

  if (detail < 0) 
    { cout << "============================================================== \n";
      cout << blue << "                    rectangle test skipped" << reset;
      cout << "============================================================== \n";
      return result;
    }

  rectangle<long double> D1, D2, D3, D4, E1;
  node<long double> L(2), M(2), N(2), P(2);
  L[1] = -0.7e+6;
  M[1] = -78965.89765443;
  N[1] = -78965.89765443;
  P[1] = -0.7e+6;
  L[2] = 98e-5;
  M[2] = 98e-5;
  N[2] = 6e+4;
  P[2] = 6e+4;
  L.boundary_condition () = 2;
  M.boundary_condition () = 1;
  N.boundary_condition () = 2;
  P.boundary_condition () = 1;
  D1 = rectangle<long double> (L, M, N, P);

  node<long double>** TAB;
  TAB = new node<long double>* [4];
  TAB[0] = &L;
  TAB[1] = &M;
  TAB[2] = &N;
  TAB[3] = &P;
  E1 = rectangle<long double> (TAB);

  D2 = D1;
  D3 = D2;
  D1 = E1;
  if (detail) affiche ("operator =", (D2 == D1) && (D3 == D2) && (D1 == E1));
  else result *= ((D2 == D1) && (D3 == D2) && (D1 == E1));

  D1[1] = L;
  D1[2] = M;
  D1[3] = N;
  D1[4] = P;
  D2[1] = L;
  D2[2] = M;
  D2[3] = N;
  D2[4] = P;

  if (detail) affiche ("operator []", (D2[1] == D1[1]) && (D2[2] == D1[2]) && (D2[3] == D1[3]) && (D2[4] == D1[4]));
  else for(int i=1;i<=4;i++) result *= (D2[i] == D1[i]);

  //Test constructeur par recopie
  rectangle<long double> toto (L, M, N, P);
  rectangle<long double> titi (toto);
  if (detail) affiche ("copy constuctor", titi == toto);
  else result *= (titi == toto);

  node<long double> R1(2), R2(2), R3(2), R4(2);
  R2[1] = R3[1] = R3[2] = R4[2] = 1;
  rectangle<long double> Ref (R1, R2, R3, R4);
  if (detail) affiche ("AbsDet", abs (Ref.AbsDet() - 1) <= epsilon);
  else result *= (abs (Ref.AbsDet() - 1) <= epsilon);

  R1[1] = 2;
  R1[2] = 3;
  R2[1] = 5;
  R2[2] = 3;
  R3[1] = 5;
  R3[2] = 4;
  R4[1] = 2;
  R4[2] = 4;
  rectangle<long double> rec (R1, R2, R3, R4);
  matrix<long double> Mk_locale (2,2);
  Mk_locale (1,1) = 3;
  Mk_locale (2,2) = 1;
  if (detail) affiche ("Mk", Mk_locale == rec.Mk());
  else result *= (Mk_locale == rec.Mk());

  if (detail) affiche ("nb_nodes", 4 == rec.nb_nodes());
  else result *= (4 == rec.nb_nodes());

  cout << "============================================================== \n";
  if (result) cout << green << "                    rectangle test passed" << reset;
  else cout << red << "                    rectangle test failed" << reset;
  cout << "============================================================== \n";

  return result;
}


#endif
