/***************************************************************
 *                    simula.plus@cemes.fr                     *
 *                   GNU/linux version 3.2.0                   *
 *            software under General Public License            *
 ***************************************************************
 * copyright © 2002,2003,2004,2005,2006 CREUSE Emmanuel
 * copyright © 2002,2003,2004,2005,2006 SOUALEM Nadir
 * copyright © 2012 COLLARD Christophe
 * copyright © 2002,2003,2004,2005,2006,2012 Centre National de la Recherche Scientifique
 * copyright © 2002,2003,2004,2005,2006 Arts et Métiers ParisTech
 * copyright © 2002,2003,2004,2005,2006 Université de Valenciennes et du Hainaut Cambrésis
 * copyright © 2002,2003,2004,2005,2006 Laboratoire de Physique et Mécanique des Matériaux (LPMM - UMR 7554)
 * copyright © 2002,2003,2004,2005,2006 Laboratoire de Mathématiques et ses Applications de Valenciennes (LAMAV - EA 4015)
 * copyright © 2012 Centre d'Elaboration de Matériaux et d'Etudes Structurales (CEMES - CNRS)
 ***************************************************************/

/*
    triangle-test belongs to Mathematical Object Libraries (FEMOL++)
    FEMOL++ is part of Simula+

    Simula+ is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    Simula+ is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with Simula+; if not, write to the Free Software
    Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
*/

#ifndef __cplusplus
#error Must use C++ for the type triangle-test.
#endif

#ifndef __triangle_test_hpp
#define __triangle_test_hpp

#ifndef __iostream
#include <iostream>
#endif

#ifndef __stdio_h
#include <stdio.h>
#endif

#ifndef __stdlib_h
#include <stdlib.h>
#endif

#ifndef __triangle_hpp
#include "FEMOL++/meshes/triangle.hpp"
#endif

#ifndef __affiche_hpp
#include "tests/affiche.hpp"
#endif

using namespace std;
using namespace femol;


//============================
int test_triangle (int detail)
//============================
{
  int result = 1;

  if (detail < 0) 
    { cout << "============================================================== \n";
      cout << blue << "                    triangle test skipped" << reset;
      cout << "============================================================== \n";
      return result;
    }

  triangle<int> A1, A2, A3;
  triangle<float> B1, B2, B3;
  triangle<double> C1, C2, C3;
  triangle<long double> D1, D2, D3, E1;
  node<int> O(2), A(2), B(2);
  node<float> C(2), D(2), E(2);
  node<double> F(2), G(2), H(2);
  node<long double> I(2), J(2), K(2);
  A[1]=1; B[1]=0; C[1]=0.3333; D[1]=-.567777; E[1]=5678.345;
  A[2]=0; B[2]=1; C[2]=0.0009; D[2]=-345.789; E[2]=3450.567;
  A.boundary_condition() = 0;
  B.boundary_condition() = 1;
  C.boundary_condition() = 2;
  D.boundary_condition() = 2;
  A.boundary_condition() = 0;
  F[1]=1.123456; G[1]=0.000000145; H[1]=0.7777777777777;
  F[2]=0.456789; G[2]=-0.00000091; H[2]=0.9876546786709;
  F.boundary_condition() = 0;
  G.boundary_condition() = 1;
  H.boundary_condition() = 1;
  I[1]=1.45e+06; J[1]=1.67893e-15; K[1]=3.233398000000045;
  I[2]=3.56e+12; J[2]=-1.6702e-17; K[2]=-0.00093333333338;
  I.boundary_condition() = 2;
  J.boundary_condition() = 1;
  K.boundary_condition() = 2;
  A1 = triangle<int> (O, A, B);
  B1 = triangle<float> (C, D, E);
  C1 = triangle<double> (F, G, H);
  D1 = triangle<long double> (I, J, K);

  node<long double>** TAB;
  TAB = new node<long double>* [3];
  TAB[0] = &I;
  TAB[1] = &J;
  TAB[2] = &K;
  E1 = triangle<long double> (TAB);

  A2 = A1;
  A3 = A2;
  B2 = B1;
  B3 = B2;
  C2 = C1;
  D2 = D1;
  D3 = D2;
  if (detail) affiche ("operator =", (A2 == A1) && (A3 == A2) && (B2 == B1) && (B2 == B3) && (C2==C1) && (D2 == D1) && (D3 == D2) && (D1 == E1));
  else result *= ((A2 == A1) && (A3 == A2) && (B2 == B1) && (B2 == B3) && (C2==C1) && (D2 == D1) && (D3 == D2) && (D1 == E1));

  A1[1] = B;
  A1[2] = O;
  A1[3] = A;
  A2[1] = B;
  A2[2] = O;
  A2[3] = A;

  C1[1] = H;
  C1[2] = F;
  C1[3] = G;
  C2[1] = H;
  C2[2] = F;
  C2[3] = G;

  if (detail) affiche ("operator []", (C2[1] == C1[1]) && (C2[2] == C1[2]) && (C2[3] == C1[3]));
  else for(int i=1;i<=3;i++) result *= (C2[i] == C1[i]);

  //Test constructeur par recopie
  triangle<long double> toto (I, J, K);
  triangle<long double> titi (toto);

  if (detail) affiche ("copy constructor", titi == toto);
  else result *= (titi == toto);

  node<long double> R1(2), R2(2), R3(2);
  R2[1] = 1;
  R3[2] = 1;
  triangle<long double> Ref (R1, R2, R3);

  if (detail) affiche ("AbsDet", abs (Ref.AbsDet() - 1) <= epsilon);
  else result *= (abs (Ref.AbsDet() - 1) <= epsilon);

  R1[1] = 2;
  R1[2] = 4;
  R2[1] = 3;
  R2[2] = 7;
  R3[1] = 8;
  R3[2] = 9;

  triangle<long double> tri (R1, R2, R3);
  matrix<long double> Mk_locale (2, 2);
  Mk_locale (1,1) = 1;
  Mk_locale (1,2) = 6;
  Mk_locale (2,1) = 3;
  Mk_locale (2,2) = 5;

  if (detail) affiche ("Mk", Mk_locale == tri.Mk());
  else result *= (Mk_locale == tri.Mk());

  if (detail) affiche ("InvMk", Mk_locale.inv() == tri.InvMk());
  else result *= (Mk_locale.inv() == tri.InvMk());

  if (detail) affiche ("nb_nodes", 3 == tri.nb_nodes());
  else result *= (3 == tri.nb_nodes());

  node<long double> NEU1(2), NEU2(2), NEU3(2);
  NEU2[1] = 1;
  NEU3[2] = 1;
  triangle<long double> TRI1 = triangle<long double> (NEU1, NEU2, NEU3);
  node<long double> NEU4(2), NEU5(2), NEU6(2);
  NEU4[1] = cos (2 * pi() / 3.);
  NEU4[2] = sin (2 * pi() / 3.);
  NEU5[1] = cos (4 * pi() / 3.);
  NEU5[2] = sin (4 * pi() / 3.);
  NEU6[1] = cos (6 * pi() / 3.);
  NEU6[2] = sin (6 * pi() / 3.);
  triangle<long double> TRI2 = triangle<long double> (NEU4, NEU5, NEU6);

  if (detail) affiche ("diam", (abs (sqrt (2) - TRI1.diam()) <= epsilon) && (abs (2 - TRI2.diam()) <= epsilon));
  else result *= ((abs (sqrt (2) - TRI1.diam()) <= epsilon) && (abs (2 - TRI2.diam()) <= epsilon));


  cout << "============================================================== \n";
  if (result) cout << green << "                     triangle test passed" << reset;
  else cout << red << "                     triangle test failed" << reset;
  cout << "============================================================== \n";

  return result;
}


#endif
