#include <stdio.h>
#include <stdlib.h>
#include <fam.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <unistd.h>
#include <limits.h>
#include <string.h>
#include <signal.h>
#include <sys/socket.h>
#include <sys/time.h>
#include <time.h>
#include <sys/select.h>
#define __USE_GNU
#include <search.h>
#include <libgen.h>
#include <dirent.h>
#include "avl.h"
#include "system.h"
#define WHITESPACE " \f\n\r\t\v"
#define TIME_LIMIT 1	//max seconds I'll spend getting messages from fam before I go back to the main select.
#define SECONDS_UNCHANGED 1 //when a file hasn't changed for this many seconds, I'll consider the previous changes to be finished, and I'll print the filename out to stdout.
struct arguments {
#ifdef ARG_MAX
	char *args[ARG_MAX];
#else
	char **args;
#endif
	int recursive;
	int showdeleted;
	int showchanged;
	int showcreated;
	int showexecuting;
	int showfinishedexecuting;
	int filelist;
	int filestomonitor;
	int hashisnotcomment;
	int filechangetimeout;
	int onefilesystem;
	int showaction;
};
typedef struct
{
	struct stat statbuf;
	char *filename;
	FAMRequest r;
	avl_tree *filetree;
}filenode_type;

/* function prototypes */
void sigHandler ();
int compare_nodes();
void cancel_monitoring();
int receive_fam_notifications();
void monitor_file();
void getopt_usage();
void node_free();
