#include "fileschanged.h"

/* Global Variables */

struct arguments arguments;
avl_tree *filetree=NULL;
FAMConnection c;
// written list code.
	int wl_index=0;
	char* wl[4096];
	int wl_max=0;
	FILE *fileptr=NULL;

int wait_and_handle_fam_events(int secs_to_wait_for_pending, int secs_to_handle_pending)
{
	fd_set rfds;
	int numfds;
	struct timeval *tv_ptr=NULL;
	struct timeval tv;
	int retval;
	tv.tv_sec = secs_to_wait_for_pending; //wait for fam events for 2 seconds.
	tv.tv_usec = 500; //always add a bit here.
	tv_ptr = &tv;
	FD_ZERO(&rfds);
	FD_SET(c.fd,&rfds);
	numfds = select(FD_SETSIZE,&rfds,NULL,NULL,tv_ptr);
	if (numfds == 1)
	{//if a fam event happened,
		retval = receive_fam_notifications(&c,secs_to_handle_pending); //get notifications for 30secs tops.
		if (retval < 0)
		{
			return -1;	
		}
	}
	return 0;
}
void sigHandler (sig) 
int sig;
{
	int retval;
	if ( sig == SIGINT )
	{
		retval = wait_and_handle_fam_events(0,30);	
		if (fileptr != stdin)
			fclose(fileptr);
		//walk the filetree, cancelling requests to monitor files and dirs.
	
		if (filetree)
		{
			avl_walk_postorder(filetree,cancel_monitoring);
			avl_destroy(filetree,node_free);
			filetree=NULL;
		}

		for(wl_index=0;wl_index<wl_max;wl_index++)
		{
			if (wl[wl_index])
				free(wl[wl_index]);
		}
		retval = wait_and_handle_fam_events(0,30);	//just to make sure we're done
		retval = FAMClose(&c);
		exit(0);
	}
	else if (sig == SIGPIPE)
	{
		fprintf(stderr, "ERROR!  Can't communicate with FAM Server\n");
		retval = FAMClose(&c);
		if (fileptr != stdin)
			fclose(fileptr);
		if (filetree)
		{
			avl_destroy(filetree,node_free);
			filetree=NULL;
		}

		for(wl_index=0;wl_index<wl_max;wl_index++)
		{
			if (wl[wl_index])
				free(wl[wl_index]);
		}
		exit(0);
	}
  else  
  {
    signal(sig, SIG_IGN);
    return;
  }

  return; 

}   /* end sigHandler */


void node_free(void *node, void *params)
{
	filenode_type *node_one;
	node_one =(filenode_type*) node;
	if (node_one)
	{
		if (node_one->filename)
		{
			//printf("freeing %s\n",node_one->filename);
			free(node_one->filename);
			node_one->filename = NULL;
			if (node_one->filetree)
			{
				avl_destroy(node_one->filetree,node_free);
				node_one->filetree=NULL;
				//printf("freed filetree\n");
			}
		}
		free(node_one);
		node_one = NULL;
	}
	return;
}
int compare_nodes(const void *node1, const void *node2, void *params)
{
	filenode_type *node_one;
	filenode_type *node_two;
	int retval=0;

	if (!node1)
		return -2; 
	if (!node2)
		return -3;

	node_one =(filenode_type*) node1;
	node_two = (filenode_type*)node2;
	if ((node_one->filename) && (node_two->filename))
		retval = strcmp(node_one->filename,node_two->filename);
	if (retval < 0)
		retval = -1;
	else if (retval > 0)
		retval = 1;

	return retval;
}

int counter=0;
void show_monitoring(void *nodep, void *params)
{
	filenode_type *filenode; 
	if (nodep == NULL)
		return;

	//filenode= *(filenode_type**)nodep;
	filenode= (filenode_type*)nodep;
	//printf("monitored filename is %s\n",filenode->filename);
	return;
}
void cancel_monitoring(void *nodep, void *params)
{  
	int retval;
	filenode_type *filenode; 
	if (nodep == NULL)
		return;

	//filenode= *(filenode_type**)nodep;
	filenode= (filenode_type*)nodep;
	if (filenode)
	{
		if (filenode->filetree)
		{
			//printf("canceling files inside %s\n",filenode->filename);
			avl_walk(filenode->filetree,cancel_monitoring,NULL);
		}
		else
		{
			FAMRequest req;
			//printf("canceling %s\n",filenode->filename);
			req = filenode->r;
			FAMCancelMonitor(&c,&req);
		}
		
		counter++;
	}
	retval = wait_and_handle_fam_events(0,TIME_LIMIT);
	//need this here because fam flips out if
	//nobody talks to it.
	//that means I'd like to delete parts of a tree while traversing it.
	//that's bad.
	return;
}
int receive_fam_notifications(FAMConnection *c, int time_limit)
{
	char altered_filename[FILENAME_MAX];
	FAMEvent e;
	int retval;
	struct stat altered_statbuf;
	time_t ending_time;
	filenode_type *filenode;
	char actionname[32];
	memset(actionname,0,sizeof(actionname));
	ending_time = time(NULL) + time_limit;

	while (ending_time >= time(NULL))
	{
		//printf("getting next FAM event\n");
		if (FAMPending(c))
		{
			//printf("event pending...\n");
			retval = FAMNextEvent(c, &e);
			//printf("got event\n");
			if (retval < 0)
			{
				return -1; //eof from fam server
			}
		}
		else
		{
			//second chance must be here or it will lock on larger filesets.
			usleep(0);
			if (FAMPending(c))
				continue;
			break;
		}
		if ((e.code == FAMExists) || (e.code == FAMEndExist))
		{
			continue;
		}
		if (e.code == FAMAcknowledge)
		{
			//printf("acknowledging event for %s\n",e.filename);
			continue;
		}
		if (filetree == NULL)
			continue;
		filenode= (filenode_type*)e.userdata;
		memset(altered_filename,0,sizeof(altered_filename));
		strcat(altered_filename,filenode->filename);
		if (S_ISDIR(filenode->statbuf.st_mode)) //eg)a monitored dir
		{
			strcat(altered_filename,"/");
			strcat(altered_filename,e.filename);
		}
		//printf("altered filename=%s\n",altered_filename);

		if (e.code != FAMDeleted)
		{
			retval = stat(altered_filename,&altered_statbuf);
			if (retval < 0) //yet another disappearing file.
				continue;
		}

		if (((!(arguments.showchanged)) && (arguments.showcreated) && (e.code == FAMCreated) && (!(S_ISDIR(altered_statbuf.st_mode)))) ||
				((arguments.showchanged) && (e.code == FAMChanged) && (arguments.filechangetimeout < 0) && (!(S_ISDIR(altered_statbuf.st_mode)))))
		{
			//this is for when we don't have to do the timeout waiting for the file to stop changing.
			if (arguments.showaction)
			{
				if (e.code == FAMChanged)
					snprintf(actionname,sizeof(actionname),"changed ");
				else
					snprintf(actionname,sizeof(actionname),"created ");
			}
			printf("%s%s\n",actionname,altered_filename);
		}
		else if (((arguments.showchanged) && (e.code == FAMChanged) && (!(S_ISDIR(altered_statbuf.st_mode)))) ||
					((arguments.showcreated) && (e.code == FAMCreated) && (!(S_ISDIR(altered_statbuf.st_mode)))))

		{
			int i;
			int freespot=-1;
			int duplicate_found=0;
			for (i=0;i<4096;i++)
			{
				if (wl[i] == NULL)
					freespot = i;
				else if (strcmp(wl[i],altered_filename)==0)
				{
					duplicate_found=1;
					break;
				}
			}
			if ((freespot >= 0) && (!duplicate_found))
			{
				wl[freespot] = strdup(altered_filename);
				wl_max++;
			}
			//printf("setting %s to written\n",altered_filename);
		}
		else if ((S_ISDIR(altered_statbuf.st_mode)) && ((e.code == FAMCreated) && (arguments.recursive)))
		{
			//printf("hey new directory!!\n");
			monitor_file(c,altered_filename);
		}
		else if ((arguments.showdeleted) && (e.code == FAMDeleted))
		{
			//
			//if this isn't a directory i'm monitoring then it must be a file.
			//unfortunately the file isn't around anymore to do a stat on.
			//so it's kinda hard to tell if it's a directory or not
			//the only thing left to do is check to see if it's a dir that
			//we're already monitoring.
			//
			char possible_directory_filename[FILENAME_MAX];
			filenode_type directory_node;
			void *ptr;
			snprintf(possible_directory_filename,sizeof(possible_directory_filename),"%s/%s",filenode->filename,e.filename);
			directory_node.filename = possible_directory_filename;
			ptr=avl_find(filetree,(void*)&directory_node);
			if (!ptr) //whoo hoo!  it's not a directory (that we're monitoring)
			{
				if (arguments.showaction)
					snprintf(actionname,sizeof(actionname),"deleted ");
				printf("%s%s\n",actionname,altered_filename);
			}
		}
		else if ((arguments.showexecuting) && (e.code == FAMStartExecuting) && (!(S_ISDIR(altered_statbuf.st_mode))))
		{
			if (arguments.showaction)
				snprintf(actionname,sizeof(actionname),"started-executing ");
			printf("%s%s\n",actionname,altered_filename);
		}
		else if ((arguments.showfinishedexecuting) && (e.code == FAMStopExecuting) && (!(S_ISDIR(altered_statbuf.st_mode))))
		{
			if (arguments.showaction)
				snprintf(actionname,sizeof(actionname),"finished-executing ");
			printf("%s%s\n",actionname,altered_filename);
		}
	}


	return 0;
}

void monitor_file(FAMConnection *c,char *buffer)
{
	char *tmp;
	filenode_type *filenode;
	int retval;
	void *ptr;
	char filename[PATH_MAX]; //used with basename
	char *directory_filename;
	filenode_type *directory_node=NULL;

	tmp = strpbrk(buffer,"\r\n");
	if (tmp)
		tmp[0]='\0';
	//this code removes whitespace.
	retval = strspn(buffer,WHITESPACE);
	if (retval)
	{
		tmp = buffer+retval;
		memmove(buffer,tmp,strlen(tmp)+1);
	}
	//-----------------------------
	
	if (buffer[0] == '\0')
		return;


	if ((buffer[0] == '#') && (!(arguments.hashisnotcomment)))
		return;
	//printf("asked to monitor: %s\n",buffer);

	tmp = realpath(buffer,filename);
	if (!tmp) // the file that we're supposed to monitor just disappeared or didn't exist.
	{
		return;
	}


	filenode = malloc(sizeof(filenode_type));
	if (!filenode)
	{
		perror("malloc failed");
		raise(SIGINT);
		exit(1);
	}
	memset(filenode,0,sizeof(filenode_type));

	filenode->filename = strdup(tmp); //from realpath return value
	if (filenode->filename == NULL)
	{
		perror("bad strdup");
		free(filenode);
		raise(SIGINT);
		exit(1);
	}
	filenode->filetree=NULL;

	retval = stat(filenode->filename,&filenode->statbuf);
	if (retval < 0) //the file that we're supposed to monitor just disappeared.
	{
		node_free(filenode,NULL);
		return;
	}

	if (arguments.onefilesystem)
	{
		static dev_t local_device=0;
		if (local_device == 0)
		{
			char homedir[FILENAME_MAX];
			if (getcwd(homedir,sizeof(homedir)))
			{
				struct stat cwd_stat_buf;
				retval = stat(homedir,&cwd_stat_buf);
				if (retval == 0)
				{
					local_device = cwd_stat_buf.st_dev;
				}
				else
				{
					fprintf(stderr,"Error on stat of current working directory %s.\n",homedir);
					perror("bad stat");
					raise(SIGINT);
					exit(1);
				}
			}
			else
			{
				fprintf(stderr,"Error determining current working directory.\n");
				perror("getcwd failed:");
				raise(SIGINT);
				exit(1);
			}
		}
		if (filenode->statbuf.st_dev != local_device)
		{
			fprintf(stderr,"Skipping %s because it's on a different filesystem\n",filenode->filename);
			node_free(filenode,NULL);
			return;
		}
	}

	//printf("monitoring: %s\n",filenode->filename);
	if (S_ISREG(filenode->statbuf.st_mode))
	{
		tmp = dirname(tmp);
		if (tmp==NULL)
		{
			fprintf(stderr,"error whilst getting dirname of %s\n",tmp);
			node_free(filenode,NULL);
			return;
		}
		directory_filename = strdup(tmp);
		if (directory_filename==NULL)
		{
			fprintf(stderr,"error while taking a strdup of %s\n",tmp);
			free(directory_filename);
			node_free(filenode,NULL);
			raise(SIGINT);
			exit(1);
		}

		directory_node = malloc(sizeof(filenode_type));
		if(directory_node==NULL) 
		{
			perror("malloc failed while creating directory_node");
			node_free(filenode,NULL);
			raise(SIGINT);
			exit(1);
		}
		memset(directory_node,0,sizeof(filenode_type));
		directory_node->filename = directory_filename;
		directory_node->filetree=NULL;
		retval = stat(directory_node->filename,&directory_node->statbuf);
		if (retval < 0) //the directory of the file that we're supposed to monitor just disappeared.
		{
			fprintf(stderr,"error: the directory of the file that we're supposed to monitor just disappeared: %s",directory_node->filename);
			node_free(filenode,NULL);
			node_free(directory_node,NULL);
			return;
		}
		ptr=avl_find(filetree,(void*)directory_node);
		//if (ptr) ptr = (void*)*(filenode_type**)ptr; 

		if (ptr==NULL)
		{
			//the directory wasn't found in our tree, so we couldn't possibly
			//be monitoring the directory or any files in it.

			//add the directory to our tree.
			if (avl_insert(filetree,(void*)directory_node)!=NULL)
			{
				printf("can't insert directory into tree.  it's already there\n");
			}

			//add the filename to the filetree for this directory
			//because we're not monitoring the whole directory.
			directory_node->filetree=avl_create(compare_nodes,NULL);
			ptr=avl_insert(directory_node->filetree,(void*)filenode);
			//if (ptr) ptr = (void*)*(filenode_type**)ptr; 

			//monitor the new file.
			if (ptr==NULL)
				retval = FAMMonitorFile(c,filenode->filename,&filenode->r,filenode);
			else
			{
				node_free(directory_node,NULL);
				node_free(filenode,NULL);
				filenode=NULL;
			}

		}
		else
		{
			filenode_type *dirptr;
			dirptr= (filenode_type*)ptr;
			node_free(directory_node,NULL);
			//okay the directory was found.  does it have a filetree entry
			//or are we monitoring the whole directory?
			if (dirptr->filetree)
			{
				//it's got a filetree entry.
				//are we already monitoring this file?
				ptr=avl_find(dirptr->filetree,(void*)filenode);
				//if (ptr) ptr = (void*)*(filenode_type**)ptr; 
				//printf("result of find: %p\n",ptr);
				if (!ptr)
				{
					//nope.  so monitor the new file.
					//and add the file to the filetree list for this directory.
					ptr=avl_insert(dirptr->filetree,(void*)filenode);
					//if (ptr) ptr = (void*)*(filenode_type**)ptr; 
					if (ptr==NULL)
						retval = FAMMonitorFile(c,filenode->filename,&filenode->r,filenode);
					else
					{
						node_free(filenode,NULL);
				filenode=NULL;
					}
				}
				else
				{
					node_free(filenode,NULL);
				filenode=NULL;
				}
			}
			else
			{
				//no filetree entry for this directory means we're
				//already monitoring the whole directory.
				node_free(filenode,NULL);
				filenode=NULL;
			}
		}

	}
	else if (S_ISDIR(filenode->statbuf.st_mode))
	{
		//are we already monitoring this directory?
		ptr=avl_find(filetree,(void*)filenode);
		//if (ptr) ptr = (void*)*(filenode_type**)ptr; 
		if (ptr == NULL)
		{
			//nope.
			//make an entry for this directory and monitor it.
			ptr= avl_insert(filetree,(void*)filenode);
			//if (ptr) ptr = (void*)*(filenode_type**)ptr; 
			if (ptr==NULL)
			{
				char *s;
				memset(&filenode->r,0,sizeof(filenode->r));
				s=filenode->filename;
				retval = FAMMonitorDirectory(c,s,&filenode->r,filenode);
			}
			else
			{
				node_free(filenode,NULL);
				filenode=NULL;
			}
			//printf("monitored new directory %s\n",filenode->filename);
		}
		else
		{
			filenode_type *dirptr;
			//printf("but we are already monitoring %s\n",filenode->filename);
			//yes we are already monitoring this directory.
			dirptr = (filenode_type*)ptr;
			//printf("dirptr filename says %s\n",dirptr->filename);
			//printf("dirptr filetree says %p\n",dirptr->filetree);
			//printf("how is it that I'm already monitoring this directory??\n");
			//were we monitoring the whole directory or just
			//a few files in the directory?
			if (dirptr->filetree)
			{
				//we were monitoring a few files within the dir.
				//get rid of them and unmonitor those files.
				avl_walk_postorder(dirptr->filetree,cancel_monitoring);
				avl_destroy(dirptr->filetree,node_free);
				dirptr->filetree=NULL;
				//now monitor the whole directory.
				retval = FAMMonitorDirectory(c,filenode->filename,&filenode->r,filenode);
			}
			else
			{
				//printf("unmonitoring %s\n",filenode->filename);
				node_free(filenode,NULL);
				filenode=NULL;
				//we were already monitoring the whole directory.
			}
		}

		//do the recursive search for more directories in directories.
		if ((arguments.recursive) && (filenode))
		{
			DIR *recursive_dir;
			struct dirent *dp;
			struct stat recursive_stat_buf;
			//if there's no time left then we'll finish this second.
			//trying to receive notifications from the fam server.
			retval = wait_and_handle_fam_events(0,TIME_LIMIT);
			if (retval < 0)
			{
				printf("here33\n");
				node_free(filenode,NULL); 
				raise(SIGINT);
				exit(1);
			}

			recursive_dir=opendir(filenode->filename);
			retval=0;
			while (recursive_dir)
			{
				dp=readdir(recursive_dir);
				if (dp == NULL)
					break;
				if ((strcmp(dp->d_name,".")==0) || (strcmp(dp->d_name,"..")==0))
					continue;
				snprintf(filename,sizeof(filename),"%s/%s",filenode->filename,dp->d_name);
				retval = stat(filename,&recursive_stat_buf);
				if (retval < 0)
				{
					fprintf(stderr,"can't stat %s\n",filename);
					perror("can't stat because");
					continue;
				}

				if (S_ISDIR(recursive_stat_buf.st_mode))
				{
					monitor_file(c,filename);
				}
			}
			if (recursive_dir)
				closedir(recursive_dir);

			if (retval < 0)
			{
				node_free(filenode,NULL); 
				retval=0;
			}
		}

	}
	if (retval < 0)
	{
		//node_free(filenode,NULL);
		//node_free(directory_node,NULL);
		printf("a FAM operation failed.\n");
		//not sure what to do here.
	
	}

	return;
}

int arraylen=0;
const char *argp_program_version = PACKAGE " " VERSION;
const char *argp_program_bug_address = "<benasselstine@users.sourceforge.net>";
static char doc[] = "Show altered files (not directories) from the list of filenames given in FILE.  The standard input can be used if FILE is - or absent from the command line.  \tFiles and directories must already exist before they are specified, or they \twill not be monitored.";
static char args_doc[] = "[FILE]...";
const char recursive_option_explanation[]="Monitor subdirectories of directories";
const char showchanged_option_explanation[]="(Default) Show changed files";
const char showcreated_option_explanation[]="(Default) Show newly created files";
const char showexecuting_option_explanation[]="Show executing files";
const char showfinishedexecuting_option_explanation[]="Show files that have stopped executing";
const char showdeleted_option_explanation[]="Show deleted files";
const char filestomonitor_option_explanation[]="Monitor the list of files on the command line";
const char filelist_option_explanation[]="(Default) Monitor the list of filenames in FILE";
const char hashisnotcomment_option_explanation[]="Don't ignore lines in FILE starting with '#'";
const char filechangetimeout_option_explanation[]="Assume changed after N secs of no writes. (Def=2)";
const char onefilesystem_option_explanation[]="Don't monitor files on other filesystems";
const char showaction_option_explanation[]="Report action when reporting altered files";
#ifdef HAVE_ARGP_H
#include <argp.h>



static struct argp_option options[] = {
	{"recursive",   'r',0,0, recursive_option_explanation},
	{"show-deleted", 'd',0,0, showdeleted_option_explanation},
	{"show-changed", 'C',0,0, showchanged_option_explanation},
	{"show-created", 'c',0,0, showcreated_option_explanation},
	{"show-executing", 'e',0,0, showexecuting_option_explanation},
	{"show-executed", 'E',0,0, showfinishedexecuting_option_explanation},
	{"files-to-monitor", 'f',0,0, filestomonitor_option_explanation},
	{"filelist", 'l',0,0, filelist_option_explanation},
	{"hash-is-not-comment", 'H',0,0, hashisnotcomment_option_explanation},
	{"timeout", 't',"seconds",0, filechangetimeout_option_explanation},
	{"one-filesystem", 'x',0,0, onefilesystem_option_explanation},
	{"show-action", 'a',0,0, showaction_option_explanation},
	{ 0 }
};


static error_t parse_opt (int key, char *arg, struct argp_state *state) {
	/* Get the INPUT argument from `argp_parse', which we
		know is a pointer to our arguments structure. */

	struct arguments *arguments = state->input;

	switch (key) { 
		case 'c':
			arguments->showcreated=1;
			break;
		case 'C':
			arguments->showchanged=1;
			break;
		case 'e':
			arguments->showexecuting=1;
			break;
		case 'E':
			arguments->showfinishedexecuting=1;
			break;
		case 'r':
			arguments->recursive=1;
			break;
		case 'd':
			arguments->showdeleted=1;
			break;
		case 'f':
			arguments->filestomonitor=1;
			arguments->filelist=0;
			break;
		case 'l':
			arguments->filelist=1;
			arguments->filestomonitor=0;
			break;
		case 'H':
			arguments->hashisnotcomment=1;
			break;
		case 'a':
			arguments->showaction=1;
			break;
		case 'x':
			arguments->onefilesystem=1;
			break;
		case 't':
			arguments->filechangetimeout=atoi(arg);
			if (arguments->filechangetimeout<=1)
				arguments->filechangetimeout=-1;
			break;
		case ARGP_KEY_ARG:
			arguments->args[state->arg_num] = arg;
			arraylen++; 
			break;
		case ARGP_KEY_END:
			break;
		default:
			return ARGP_ERR_UNKNOWN;
		}
	return 0;
}

static struct argp argp = { options, parse_opt, args_doc, doc }; 
#else
void getopt_usage()
{
				printf("Usage: fileschanged [OPTION...] %s\n",args_doc);
				printf("%s\n\n",doc);
				printf("  -a                         %s\n",showaction_option_explanation);
				printf("  -c                         %s\n",showcreated_option_explanation);
				printf("  -C                         %s\n",showchanged_option_explanation);
				printf("  -d                         %s\n",showdeleted_option_explanation);
				printf("  -e                         %s\n",showexecuting_option_explanation);
				printf("  -E                         %s\n",showfinishedexecuting_option_explanation);
				printf("  -f                         %s\n",filestomonitor_option_explanation);
				printf("  -H                         %s\n",hashisnotcomment_option_explanation);
				printf("  -l                         %s\n",filelist_option_explanation);
				printf("  -r                         %s\n",recursive_option_explanation);
				printf("  -t                         %s\n",filechangetimeout_option_explanation);
				printf("  -x                         %s\n",onefilesystem_option_explanation);
				printf("  -? -h --help               Give this help list\n");
				printf("  -V                         Print program version\n");
				printf("\n");
				printf("Report bugs to %s\n",argp_program_bug_address);
	return;
}
#endif 
int main(argc, argv)
	int argc;
	char **argv;
{
	int retval;
	char buffer[FILENAME_MAX];
	int numfds;
	fd_set rfds;
	time_t lastchecked=0;
	struct timeval *tv_ptr=NULL;
	struct timeval tv;

	int i;
	int totallen=0;
	char *string;
memset(wl,0,sizeof(wl));	
memset(&c,0,sizeof(c));
memset(&arguments,0,sizeof(arguments));

#ifdef HAVE_ARGP_H

	argp_parse (&argp,argc,argv,0,0,&arguments); 
#else

	if (strncmp(argv[1],"--help",7)==0)
	{
		getopt_usage();
		exit(0);
	}

	while ( (i = getopt(argc,argv,"t:acCeErdfHlLx?hV")) != -1 ) { 
		switch(i) { 
			case 'c':
				arguments.showcreated=1;
				break;
			case 'C':
				arguments.showchanged=1;
				break;
			case 'e':
				arguments.showexecuting=1;
				break;
			case 'E':
				arguments.showfinishedexecuting=1;
				break;
			case 'd':
				arguments.showdeleted=1;
				break;
			case 'r': 
				arguments.recursive=1;		
				break;
			case 'f':
				arguments.filestomonitor=1;
				arguments.filelist=0;
				break;
			case 'l':
				arguments.filelist=1;
				arguments.filestomonitor=0;
				break;
			case 'H':
				arguments.hashisnotcomment=1;
				break;
			case 't':
				arguments.filechangetimeout=atoi(optarg);
				if (arguments.filechangetimeout<=1)
					arguments.filechangetimeout=-1;
				break;
			case 'V':
				printf("%s\n",argp_program_version);
				exit(1);
				break;
			case 'a':
				arguments.showaction=1;
				break;
			case 'x':
				arguments.onefilesystem=1;
				break;
			case 'h':
			case '?':
				getopt_usage();
				exit(0);
				break;
			default:
				fprintf(stderr,"Unknown argument %c\n",i);
				exit(1);
		}
	}
	for ( i = optind; i < argc; i++ ) { 
		arguments.args[arraylen] = argv[i]; 
		arraylen++; 
	}
#endif

	//set some default values if options not set
	if ((arguments.showcreated == 0)  &&
		(arguments.showchanged == 0)   &&
		(arguments.showdeleted == 0)   &&
		(arguments.showexecuting == 0) &&
		(arguments.showfinishedexecuting == 0))
	{
		arguments.showcreated=1; // if not showing anything
		arguments.showchanged=1; // then I'm showing "changed" files.
	}

	if (arguments.filechangetimeout == 0)
	{
		arguments.filechangetimeout=2;
	}

	if ((arguments.filestomonitor == 0) && (arguments.filelist == 0))
	{
		arguments.filelist=1;
	}

	if (arguments.filechangetimeout > 0)
	{
		arguments.filechangetimeout--; // a hack to make things line up.
	}

	for ( i = 0; i < arraylen; i++ )  
		totallen +=strlen(arguments.args[i]); 
	string = (char*)malloc(totallen + 1); //this didn't pass valgrind with +1.
	//printf("totallen+2 = %d, string = %p\n",totallen+2,string);
	if (string==NULL)
	{
		perror("malloc failed");
		exit(1);
	}
	string[0]='\0';
	//memset(string,0,totallen+1); 

	if (arguments.filestomonitor)
		fileptr=tmpfile();

	for ( i = 0; i < arraylen; i++ ) 
	{
		//printf("yo: %s\n",arguments.args[i]);
		strncat(string,arguments.args[i],totallen-strlen(string));
		strncat(string," ",2);

		if ((arguments.args[i]) && (arguments.filelist))
			break;
		else if (arguments.filestomonitor)
			fprintf(fileptr,"%s\n",arguments.args[i]);
	}

	if (arguments.filelist)
	{
		if ((strcmp(string,"-")==0) || (string[0]=='\0'))
			fileptr = stdin;
		else
		{
			struct stat filelist_statbuf;
			int retval;
			char filename[FILENAME_MAX];
			char *tmp;

			tmp=strpbrk(string,"\r\n "); //this is a hack to get the first filename
			if (tmp) //need a smarter way to get the first file on the line.
				tmp[0]='\0';

			tmp = realpath(string,filename);
			if (tmp==NULL)
			{
					fprintf(stderr,"ERROR: file listing '%s' not found:  Use -f to monitor files listed on the command line.\n",string);
					free(string);
					exit(1);
			}
			retval = stat(filename,&filelist_statbuf);
			if (retval == 0)
			{
				if (!(S_ISDIR(filelist_statbuf.st_mode)))
				{
					fileptr = fopen(filename,"r");
				}
				else
				{
					fprintf(stderr,"ERROR: file listing not found in '%s'.  It is a directory.  Use -f to monitor files listed on the command line.\n",filename);
					free(string);
					exit(1);
				}
			}
		}
	}
	else
	{
		fflush(fileptr);
		rewind(fileptr); //otherwise it's our temporary file.
	}

	free(string);
	

	/* Main Loop */
      filetree = avl_create (compare_nodes, NULL);
	
	retval = FAMOpen(&c);
	//fprintf(stderr,"the result of FAMOpen is %d\n",retval);
	if (retval < 0)
	{
		fprintf(stderr,"ERROR: Cannot contact FAM server.  Cannot monitor files.\n");
		exit(2);
	}

	if (fileptr == NULL)
	{
		perror("ERROR: bad open");
		exit(1);
	}
	signal(SIGINT,sigHandler);
	signal(SIGPIPE,sigHandler);
	while (1)
	{
		FD_ZERO(&rfds);
		if (!feof(fileptr))
			FD_SET(fileno(fileptr),&rfds);
		FD_SET(c.fd,&rfds);

		if (wl_max > 0)
		{
			tv.tv_sec = TIME_LIMIT;
			tv.tv_usec = 500; //always add a bit here.
			tv_ptr = &tv;
		}
		else
			tv_ptr = NULL;

		numfds = select(FD_SETSIZE,&rfds,NULL,NULL,tv_ptr);

		if ((!feof(fileptr)) && (FD_ISSET(fileno(fileptr),&rfds)) )
		{
			//fprintf(stderr,"fileptr: numfds = %d\n",numfds);
			fgets(buffer,sizeof(buffer),fileptr);
			if (!feof(fileptr))
			{
				//printf("top level monitor file...\n");
				monitor_file(&c,buffer);
				//printf("finished initial recursing.\n");
			}
			numfds--;
		}

		if (FD_ISSET(c.fd,&rfds))
		{
			int time_limit;
			if (tv_ptr)
				time_limit = tv_ptr->tv_sec;
			else
				time_limit = TIME_LIMIT;
			//fprintf(stderr,"FAMPending Event: numfds = %d\n",numfds);
			retval = wait_and_handle_fam_events(0,TIME_LIMIT);
			if (retval < 0)
			{
				raise(SIGINT);
				exit(1);
			}
			numfds--;
		}

		//display files that are 2 seconds old and written_to.
		if (arguments.filechangetimeout > 0)
		{
			if ((lastchecked != time(NULL)) && (wl_max > 0)) //check every sec.
			{
				int retval;
				struct stat statbuf;
				char *filename;
				//printf("searching tree for files that are old and written to...\n");
				for (wl_index=0;wl_index<4096;wl_index++)
				{
					//printf("trying index %d with max %d\n",wl_index,wl_max);
					filename = wl[wl_index];
					if (filename == NULL)
						continue;

					//printf("checking %s...\n",filename);
					retval = stat(filename,&statbuf);
					if ((retval == 0) && (statbuf.st_ctime < (time(NULL)-arguments.filechangetimeout)))
					{
						if (arguments.showaction)
							printf("changed %s\n",filename);
						else
							printf("%s\n", filename);
						//printf("removing\n");
						if (wl[wl_index])
							free(wl[wl_index]);
						wl[wl_index] = NULL;
						wl_max--;
						if (wl_max == 0)
							break;
						wl_index--;
					}
					else if (retval == -1) //can't stat file.  must be gone.
					{
						if (wl[wl_index])
							free(wl[wl_index]);
						wl[wl_index] = NULL;
						wl_max--;
						if (wl_max == 0)
							break;
						wl_index--;
					}
				}
				lastchecked = time(NULL);
			}
		}
		if (numfds != 0)
			fprintf(stderr,"failed sanity check\n");

	}
	if (filetree)
		avl_destroy(filetree,node_free);
	retval = FAMClose(&c);
	//should never get here.
	exit(0);
}
/*
 * pseudocode:
 *
 * when we add a file to the monitoring list:
 *
 * get the basename and see if we have an entry for that directory.
 * if we don't then
 *   make an entry for this directory 
 *   then make a file entry for that directory.
 * if we do then
 *   check to see if we have file entries.
 *   if we do then (we're not monitoring the directory, just some files in it)
 *     add the file to the filetree for this directory.
 *   if we don't then (we're already monitoring the dir)
 *     throw out the file
 *
 * when we add a directory:
 *
 * check to see if we have an entry for the directory.
 * if we don't then
 *   make an entry for this directory.
 * if we do then
 *   check to see if we're monitoring files in this directory
 *   if we are then (monitoring this whole dir overrides those files)
 *     empty the filetree associated with this dir.
 *   if we aren't then (we're already monitoring this dir)
 *      throw out the dir
 *
 * when I get a message from the Fam Server:
 *
 * while there are messages pending from the Fam Server,
 * 	get a fam event
 * 	figure out the filename that the event is for
 * 	if the event is a changed or created event then
 * 	  check to see if it was a file
 * 	  if it is a file:
 * 	    show the filename to stdout
 * 	  if it is a directory created then (it's a new directory)
 * 	    if I'm in recursive mode then monitor it.
 * 	if it was a moved or deleted event and I'm in show-deleted mode then
 * 	   if it's a file then show the filename to stderr. 
 *
 *
 * (revamped) when I get a message from the Fam Server:
 * start timer
 * while there are messages pending from the Fam Server and this loop hasn't been going too long,
 *   get a fam event
 *   figure out the filename the event is for
 *   if the event is a changed or created event then
 *     if it was a file then
 *       add it to the list of "recently changed files" list
 *     if it was a new directory and I'm in recursive mode then
 *     	monitor the file
 *   if the event is a moved or deleted and I'm in show-deleted mode then
 *     if it was a file then
 *     	show the filename on stderr
 *
 * when I'm done the loop, go back to the select
 *
 * ---
 * elsewhere the "recently changed files" list is checked every second
 * for files that are X seconds old that have been changed.
 * it's such a kludge, but it shows the idea.
 * ---
 * here are some notes and thoughts on the "recently changed files" list.
 * (herein called written list)
 *
 * what I want is to see when files change.
 * when they're done changing that is.
 * so if a file was changed, and then changed again, and then afterwards it's been a second since and no further writes have occurred...
 * then I want to say that it's been changed.
 * how do I implement this?
 *
 * keep a list.
 * when a file is changed, it goes on the list.
 * then while there are files on that list,
 * every second I check that list to see if the file has been modified more than a second ago.
 * how do I implement this?
 *
 * throw together a list of filenames
 * check them periodically with stat
 * if any of them are "old" then they get shown to stdout.
 * and taken off the list.
 * char* wl[4096], wl_index, wl_max keep track of things.
 *
 * */
