#include <string.h>
#include <stdlib.h>
#include "node.h"
#include "xrealpath.h"
void node_free(struct node_t *node)
{
	free(node->filename); node->filename=NULL;
	return;
}
int node_copy(struct node_t *dst, struct node_t *src)
{
	memcpy(dst,src,sizeof(struct node_t));
	dst->filename = strdup(src->filename);
	if (!dst->filename)
		return -1;
	return 0;
}
int node_new(struct node_t *node, char *filename)
{
	int retval;
	if ((!node) || (!filename))
		return -1;
	memset(node,0,sizeof(struct node_t));
	node->filename = xrealpath(filename);
	if (!node->filename)
		return -2;
	retval = stat(node->filename,&node->statbuf);
	if (retval != 0)
	{
		free(node->filename);
		return -2;
	}
	return 0;
}
int node_compare(struct node_t *n1, struct node_t *n2)
{
	if ((!n1) || (!n2))
		return 0;
	if ((!(n1->filename)) || (!(n2->filename)))
		return 0;
	return strcmp(n1->filename,n2->filename);
}
int node_is_empty(struct node_t *node)
{
	if (!(node->filename))
		return 1;
	return 0;
}
