#include <argp.h>
#include <stdlib.h>
#include <string.h>
#include <dlfcn.h>
#include "config.h"
#include "opts.h"
const char *argp_program_version = PACKAGE_NAME " " PACKAGE_VERSION;
const char *argp_program_bug_address = "<" PACKAGE_BUGREPORT ">";
static char doc[] = "Monitors FILEs for alterations.  Display the filenames of FILEs that were created, changed, deleted, started execution or finished executing.\vFILEs must already exist before they are monitored, or they will not be monitored.";
static char args_doc[] = "[FILE]...";
const char recursive_option_explanation[]="Monitor subdirectories of directories";
const char showchanged_option_explanation[]="(Default) Display changed files";
const char showcreated_option_explanation[]="(Default) Display newly created files";
const char showexecuting_option_explanation[]="Display executing files";
const char showfinishedexecuting_option_explanation[]="Display files that have stopped executing";
const char showdeleted_option_explanation[]="Display deleted files";
const char showall_option_explanation[]="Same as -c -C -d -e -E -p";
const char filestomonitor_option_explanation[]="(Default) Monitor the FILEs on the command line";
const char filelist_option_explanation[]="Monitor the list of filenames inside FILE";
const char filechangetimeout_option_explanation[]="Delay showing changed files for N seconds (Def=2)";
const char showaction_option_explanation[]="Also display action when displaying altered files";

struct arguments_t arguments;
static struct argp_option options[] = 
{
	{"recursive",   'r',0,0, recursive_option_explanation, 4},
	{"show-all", 'a',0,0, showall_option_explanation, 2},
	{"show-deleted", 'd',0,0, showdeleted_option_explanation, 1},
	{"show-changed", 'C',0,0, showchanged_option_explanation, 1},
	{"show-created", 'c',0,0, showcreated_option_explanation, 1},
	{"show-executing", 'e',0,0, showexecuting_option_explanation, 1},
	{"show-executed", 'E',0,0, showfinishedexecuting_option_explanation, 1},
	{"files-to-monitor", 'f',0,0, filestomonitor_option_explanation, 3},
	{"filelist", 'l',"FILENAME",0, filelist_option_explanation, 3},
	{"timeout", 't',"N",0, filechangetimeout_option_explanation, 4},
	{"prepend-action", 'p',0,0, showaction_option_explanation, 5},
	{ 0 }
};


void free_arguments()
{
	free(arguments.fileschanged.filelist_filename);
	if (arguments.args)
		free(arguments.args);
}
static error_t parse_opt (int key, char *arg, struct argp_state *state) {
	/* Get the INPUT argument from `argp_parse', which we
		know is a pointer to our arguments structure. */

	struct arguments_t *arguments = state->input;

	switch (key) { 
		case 'a':
			arguments->fileschanged.showcreated=1;
			arguments->fileschanged.showchanged=1;
			arguments->fileschanged.showdeleted=1;
			arguments->fileschanged.showexecuting=1;
			arguments->fileschanged.showfinishedexecuting=1;
			arguments->fileschanged.showaction=1;
			break;
		case 'c':
			arguments->fileschanged.showcreated=1;
			break;
		case 'C':
			arguments->fileschanged.showchanged=1;
			break;
		case 'e':
			arguments->fileschanged.showexecuting=1;
			break;
		case 'E':
			arguments->fileschanged.showfinishedexecuting=1;
			break;
		case 'r':
			arguments->fileschanged.recursive=1;
			break;
		case 'd':
			arguments->fileschanged.showdeleted=1;
			break;
		case 'f':
			arguments->fileschanged.filestomonitor=1;
			arguments->fileschanged.filelist=0;
			break;
		case 'l':
			arguments->fileschanged.filelist=1;
			arguments->fileschanged.filestomonitor=0;
			arguments->fileschanged.filelist_filename=strdup(arg);
			break;
		case 'p':
			arguments->fileschanged.showaction=1;
			break;
		case 't':
			arguments->fileschanged.filechangetimeout=atoi(arg);
			if (arguments->fileschanged.filechangetimeout<=1)
				arguments->fileschanged.filechangetimeout=-1;
			break;
		case ARGP_KEY_INIT:
			free_arguments();
			arguments->args = (char**) malloc(1 * sizeof(char**));
			break;
		case ARGP_KEY_ARG:
			arguments->arraylen++; 
			arguments->args =(char **)realloc(arguments->args, arguments->arraylen * sizeof(char*));
			arguments->args[state->arg_num] = arg;
			break;
		case ARGP_KEY_END:
			break;
		default:
			return ARGP_ERR_UNKNOWN;
		}
	return 0;
}

void set_default_arguments(struct fileschanged_arguments_t *fileschanged)
{
	//set some default values if options not set
	if ((fileschanged->showcreated == 0)  &&
		(fileschanged->showchanged == 0)   &&
		(fileschanged->showdeleted == 0)   &&
		(fileschanged->showexecuting == 0) &&
		(fileschanged->showfinishedexecuting == 0))
	{
		fileschanged->showcreated=1; // if not showing anything
		fileschanged->showchanged=1; // then I'm showing "changed" files.
	}

	if (fileschanged->filechangetimeout == 0)
	{
		fileschanged->filechangetimeout=2;
	}

	if ((fileschanged->filestomonitor == 0) && (fileschanged->filelist == 0))
	{
		fileschanged->filestomonitor=1;
	}

	if (fileschanged->filechangetimeout > 0)
	{
		fileschanged->filechangetimeout--; // a hack to make things line up.
	}
	return;
}

struct argp argp = { options, parse_opt, args_doc, doc }; 
void parse_opts(int argc, char **argv, struct arguments_t *arguments)
{
	int retval;
	setenv("ARGP_HELP_FMT", "no-dup-args-note", 1);
	retval = argp_parse (&argp,argc,argv,0,0,arguments); 
	if (retval < 0)
	{
		argv[1] = "--help";
		retval = argp_parse (&argp,2,argv,0,0,arguments); 
		//doesn't get here.
	}
	atexit(free_arguments);
	set_default_arguments(&arguments->fileschanged);
	return;
}

