#include <string.h>
#include <stdlib.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <unistd.h>
#include <time.h>
#include "wl.h"
#include "handlers.h"
#include "opts.h"
/*
 * this code is more than a little embarassing.
 *
 */
int wl_index=0;
char* wl[WL_MAX];
int wl_max=0;

extern struct arguments_t arguments;
void wl_init()
{
	return;
}
void wl_add_file(char *filename)
{
	int i;
	int freespot=-1;
	int duplicate_found=0;
	for (i=0;i<WL_MAX;i++)
	{
		if (wl[i] == NULL)
			freespot = i;
		else if (strcmp(wl[i],filename)==0)
		{
			duplicate_found=1;
			break;
		}
	}
	if ((freespot >= 0) && (!duplicate_found))
	{
		wl[freespot] = strdup(filename);
		wl_max++;
	}
	return;
}

void wl_destroy()
{
	for(wl_index=0;wl_index<wl_max;wl_index++)
	{
		if (wl[wl_index])
			free(wl[wl_index]);
	}
	return;
}

void wl_show_changed_files()
{
	static time_t lastchecked;
	if ((lastchecked != time(NULL)) && (wl_max > 0)) //check every sec.
	{
		int retval;
		struct stat statbuf;
		char *filename;
		//printf("searching tree for files that are old and written to...\n");
		for (wl_index=0;wl_index<WL_MAX;wl_index++)
		{
			//printf("trying index %d with max %d\n",wl_index,wl_max);
			filename = wl[wl_index];
			if (filename == NULL)
				continue;

			//printf("checking %s...\n",filename);
			retval = stat(filename,&statbuf);
			if ((retval == 0) && (statbuf.st_ctime < (time(NULL)-arguments.fileschanged.filechangetimeout)))
			{
				if (arguments.fileschanged.showchanged)
				{
					show_event(FC_CHANGED_FILE, filename);
				}
				//printf("removing\n");
				if (wl[wl_index])
					free(wl[wl_index]);
				wl[wl_index] = NULL;
				wl_max--;
				if (wl_max == 0)
					break;
				wl_index--;
			}
			else if (retval == -1) //can't stat file.  must be gone.
			{
				if (wl[wl_index])
					free(wl[wl_index]);
				wl[wl_index] = NULL;
				wl_max--;
				if (wl_max == 0)
					break;
				wl_index--;
			}
		}
		lastchecked = time(NULL);
	}
	return;
}
