/*
  Copyright (C) 2008 Ben Asselstine
  Written by Ben Asselstine

  This file is part of fileschanged.

  fileschanged is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 2 of the License, or
  (at your option) any later version.

  fileschanged is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with fileschanged; if not, write to the Free Software
  Foundation, Inc., 51 Franklin Street, Fifth Floor Boston, MA 02110-1301  USA
*/
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <sys/types.h>
#include <dirent.h>
#include "listdirs.h"
#include "list.h"
#include "xvasprintf.h"

static int 
_listdirs (struct node_t *dir, void *dirs, void *ancestors, int deref_symlinks)
{
  struct dirent **namelist = NULL;
  struct node_t *found = NULL;
  struct node_t newdir;
  int n;
  unsigned int count;
  int i;
  int retval;
  char *d = NULL;
  list_find (ancestors, dir, &found);
  if (found)
    return 0;
  list_add (ancestors, dir);
  list_add (dirs, dir);
  n = scandir (dir->filename, &namelist, 0, alphasort);
  for(i = 0; i < n; i++)
    {
      if (strcmp (namelist[i]->d_name, ".") == 0)
	continue;
      if (strcmp (namelist[i]->d_name, "..") == 0)
	continue;
      if ((d = xasprintf ("%s/%s", dir->filename, namelist[i]->d_name)) == NULL)
	return -1;
      retval = node_new (&newdir, d, deref_symlinks);
      free (d); d = NULL;
      if (retval == 0)
	{
	  if (S_ISDIR (newdir.statbuf.st_mode))
	    retval = _listdirs (&newdir, dirs,ancestors, deref_symlinks);
	  node_free (&newdir);
	}
      free (namelist[i]);
    }
  free (namelist);
  list_count (ancestors, &count);
  list_remove_element (ancestors, count - 1);

  return 0;
}

int 
listdirs (struct node_t *dir ,void *dirs, int deref_symlinks)
{
  int retval;
  void *ancestors = NULL;
  list_init (&ancestors);
  retval = _listdirs (dir, dirs, ancestors, deref_symlinks);
  list_free (ancestors);
  return retval;
}
