// Free Image Manipulator - a program to massive image manipulation.
// Copyright (C) 2006 Kacper Bielecki
// 
// This program is free software; you can redistribute it and/or modify it 
// under the terms of the GNU General Public License as published by the Free 
// Software Foundation; either version 2 of the License, or (at your option) 
// any later version.
// 
// This program is distributed in the hope that it will be useful, but WITHOUT
// ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or 
// FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public License for 
// more details.
// 
// You should have received a copy of the GNU General Public License along 
// with this program; if not, write to the Free Software Foundation, Inc., 
// 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA
// 
/**
 * Klasa reprezentuje pojedyńczy obrazek. Posiada możliwość wczytania obrazka,
 * konwersji, zmiany rozmiaru oraz napisania na nim tekstu w półprzezroczystej
 * ramce.
 * @copyright Kacper Bielecki
 * @version 0.0.2
 * @license GNU GPL
 */

#ifndef IMAGE_H
#define IMAGE_H

#include <gdfontt.h>
#include <gdfonts.h>
#include <gdfontmb.h>
#include <gdfontl.h>
#include <gdfontg.h>
#include <gd.h>
#include <cstdlib>
#include <iostream>

#include <string>

class ImageError
{
	public:
	
	enum ImageErrorID
	{
		BadName, LoadError, NoImage
	} code;
	ImageError(ImageErrorID error_code): code(error_code) {}
};

enum ImageFormat
{
	jpeg, png, gif, bmp, none
};

/**
 * Pojedyńczy obraz.
 */
class Image
{
	private:
		
		ImageFormat image_format;
		gdImagePtr image;
		bool created;
  /**
   * Creates new true color image with given size. Background is 
   * transparent.
   * @param x width
   * @param y height
   */
      gdImagePtr newImage(int x, int y);

	public:
		
		Image();
		Image(Image &new_in);
		~Image();
		
		/**
		 * Wczytanie obrazka z pliku. Rodzaj obrazka wykrywany jest poprzez
		 * jego rozszerzenie. Kiedy wystąpi błąd wyrzucony jest wyjątek.
		 * @param ścieżka dostępu do obrazka.
		 */
		void load_from_file(const std::string &file_path);

		/**
		 * Zapisanie obrazka do pliku. 
		 * @param ścieżka do pliku
		 */
		void save_to_file(
				const std::string &file_path, 
				ImageFormat format = none,
				const int quality = 80);

		/**
		 * Zmiana rozmiaru obrazka.
		 * @param maksymalna szerokość.
		 * @param maksymalna wysokość.
		 */
		bool resize(const int max_x, const int max_y);

		/**
		 * Nadrukowywuje na obrazek napis.
		 * @param rozmiar teksu
		 * @param tekst do nadrukowania.
		 * @param margins marginesy górny, prawy, dolny,lewy
		 * @param border podobnie jak wyżej odległość od boku obrazka. Ustawiona powinna być tylko
		 * wartość 0 lub 2 i 1 lub 3 a pozostałe wynoszą -1.
		 */
		void print_string(const double size, const std::string &tekst, 
								const std::string &font_path, 
								int color[3], int opacity, int margins[4], int border[4],
								int font_color[3], int font_opacity);
		
		ImageFormat getImageFormat();
		void setImageFormat(const ImageFormat format);
		
		gdImagePtr getImage();
		
		bool isCreated();
};

#endif
