// Free Image Manipulator - a program to massive image manipulation.
// Copyright (C) 2006 Kacper Bielecki
// 
// This program is free software; you can redistribute it and/or modify it 
// under the terms of the GNU General Public License as published by the Free 
// Software Foundation; either version 2 of the License, or (at your option) 
// any later version.
// 
// This program is distributed in the hope that it will be useful, but WITHOUT
// ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or 
// FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public License for 
// more details.
// 
// You should have received a copy of the GNU General Public License along 
// with this program; if not, write to the Free Software Foundation, Inc., 
// 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA
// 
//
// C++ Interface: mainwindow
//
// Description: 
//
//
// Author: Kacper <kazjote@stud.ics.p.lodz.pl>, (C) 2006
//
// Copyright: See COPYING file that comes with this distribution
//
//
#ifndef MAINWINDOW_H
#define MAINWINDOW_H

#include <QMainWindow>
#include "ui_main.h"

class Image;
class Image_ext;
class Images;
class TreeModel;
class QColor;
class QMouseEvent;
class transOptions;
class QValidator;
class QString;

/**
@author Kacper
*/
class MainWindow : public QMainWindow
{
	Q_OBJECT
public:
    MainWindow();
	 
	 transOptions getOptions() const;

    ~MainWindow();
	 
private:
	Images *images;
	TreeModel *treemodel;
	Ui::MainWindow mainWindow;
	
	QColor *bgColor;
	QColor *fontColor;
	
	QButtonGroup *TBGroup;
	QButtonGroup *LRGroup;
	
	void saveOptions( QString filePath );
	transOptions loadOptions( QString filePath );
	void restoreOptions( const transOptions &options );
 
   QString configFile;
   QString addDir;
   QString configDir;
   QString procDir;
	
	static void QColorToRgb(const QColor &color, unsigned char rgb[3]);
	
	QIntValidator *sizeValidator;
	
private slots:
	void addFiles();
	void delFiles();
	void drawPreview(Image * image);
	void makePrevConnection( Image_ext *image);
	void imageClicked( const QModelIndex & index );
	void chooseBgColor();
	void chooseFontColor();
	void process();
	void showAbout();
   void saveConfig();
   void loadConfig();
   void saveConfigAs();
	
};

#endif
