// Free Image Manipulator - a program to massive image manipulation.
// Copyright (C) 2006 Kacper Bielecki
// 
// This program is free software; you can redistribute it and/or modify it 
// under the terms of the GNU General Public License as published by the Free 
// Software Foundation; either version 2 of the License, or (at your option) 
// any later version.
// 
// This program is distributed in the hope that it will be useful, but WITHOUT
// ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or 
// FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public License for 
// more details.
// 
// You should have received a copy of the GNU General Public License along 
// with this program; if not, write to the Free Software Foundation, Inc., 
// 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA
// 
//
// C++ Interface: process
//
// Description: 
//
//
// Author: Kacper <kazjote@stud.ics.p.lodz.pl>, (C) 2006
//
// Copyright: See COPYING file that comes with this distribution
//
//
#ifndef PROCESS_H
#define PROCESS_H

#include <qobject.h>

/**
 * Preview width
 */
const int PREV_WIDTH = 280;
/**
 * Preview height
 */
const int PREV_HEIGHT = 280;

class Image;

/**
@author Kacper
*/

struct transOptions
{
	int h;
	int w;
	QString text;
	QString fontPath;
	int text_size;
	int lr_margin;
	int tb_margin;
	int pos_right;
	int pos_left;
	int pos_top;
	int pos_bottom;
	int opacity;
	int fontColor[3];
	int bgColor[3];
	int bgOpacity;
   int quality;
};

enum ThreadSort
{
	thread_preview,
	thread_process
};

class process : public QObject
{
Q_OBJECT
		
	private:
		Image *&im;
		Image *&pre;
		transOptions options;
		ThreadSort threadSort;
	public:
		process(Image* &image, 
				  Image* &preview, 
				  QObject *parent, 
				  const transOptions *n_options,
				  ThreadSort sort = thread_preview);
		
		void run();

    	~process();

};

#endif
