// Free Image Manipulator - a program to massive image manipulation.
// Copyright (C) 2006 Kacper Bielecki
// 
// This program is free software; you can redistribute it and/or modify it 
// under the terms of the GNU General Public License as published by the Free 
// Software Foundation; either version 2 of the License, or (at your option) 
// any later version.
// 
// This program is distributed in the hope that it will be useful, but WITHOUT
// ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or 
// FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public License for 
// more details.
// 
// You should have received a copy of the GNU General Public License along 
// with this program; if not, write to the Free Software Foundation, Inc., 
// 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA
// 

//
// C++ Implementation: treemodel
//
// Description: 
//
//
// Author: Kacper <kazjote@stud.ics.p.lodz.pl>, (C) 2006
//
// Copyright: See COPYING file that comes with this distribution
//
//
#include "treemodel.h"
#include "image_ext.h"

TreeModel::~TreeModel()
{
}


void TreeModel::addRequest( Image_ext * image )
{
	int i = rowCount();
	insertRow(i, QModelIndex());
	QModelIndex parent;
	QModelIndex in = index(i, 0, parent);
	setData(in, image->getPath(), Qt::DisplayRole);
	in = in.sibling(i, 1);
	switch(image->getFormat())
	{
		case 0: 
			setData(in, "jpeg", Qt::DisplayRole);
			break;
		case 1:
			setData(in, "png", Qt::DisplayRole);
			break;
		case 2:
			setData(in, "gif", Qt::DisplayRole);
			break;
		case 3:
			setData(in, "bmp", Qt::DisplayRole);
			break;
		case 4:
			setData(in, "none", Qt::DisplayRole);
			break;
	}
	in = in.sibling(i, 2);
	setData(in, image->getWidth(), Qt::DisplayRole);
	in = in.sibling(i, 3);
	setData(in, image->getHeight(), Qt::DisplayRole);
}

TreeModel::TreeModel( int rows, int cols, QObject * parent ) :
		QStandardItemModel(rows, cols, parent)
{
}

