// Free Image Manipulator - a program to massive image manipulation.
// Copyright (C) 2006 Kacper Bielecki
// 
// This program is free software; you can redistribute it and/or modify it 
// under the terms of the GNU General Public License as published by the Free 
// Software Foundation; either version 2 of the License, or (at your option) 
// any later version.
// 
// This program is distributed in the hope that it will be useful, but WITHOUT
// ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or 
// FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public License for 
// more details.
// 
// You should have received a copy of the GNU General Public License along 
// with this program; if not, write to the Free Software Foundation, Inc., 
// 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA
// 
//
// C++ Implementation: image_ext
//
// Description: 
//
//
// Author: Kacper <kazjote@stud.ics.p.lodz.pl>, (C) 2006
//
// Copyright: See COPYING file that comes with this distribution
//
//
#include "image_ext.h"
#include <QString>
#include <iostream>

Image_ext::~Image_ext()
{
	if (thread)
	{
		if (thread->isFinished())
			delete thread;
		else
		{
			thread->wait(5000);
			delete thread;
		}
	}
	if (image)
		delete image;
	if (preview)
		delete preview;
}

bool Image_ext::open(QString filePath)
{
	path = filePath;
	is_preview = false;
	std::cout << "w8" << std::endl;
	lock = true;
	image = new Image();
	std::cout << "Stworzylem obrazek" << std::endl;
	try
	{
		image->load_from_file(filePath.toLocal8Bit().constData());
	}
	catch (...)
	{
		delete image;
		image = 0;
		std::cout << "Blad" << std::endl;
		return false;
	}
	
	format = image->getImageFormat();
	width = image->getImage()->sx;
	height = image->getImage()->sy;
	image->resize(PREV_WIDTH, PREV_HEIGHT);
	is_preview = false;
	lock = false;
	std::cout << "Koniec konstruktora" << std::endl;
	return true;
}

void Image_ext::preview_request(transOptions *options)
{
	if (!lock)
	{
		lock = true;
		std::cout << "W preview_request" << std::endl;
		if (is_preview)
			delete preview;
		preview = 0;
		thread = new prevThread(image, preview, this, options);
		std::cout << "Stworzylem watek" << std::endl;
		connect(thread, SIGNAL(finished()), this, SLOT(prev_finished()));
		std::cout << "Sygnal" << std::endl;
		thread->start();
		std::cout << "Uruchomilem watek" << std::endl;
	}
}

Image_ext::prevThread::prevThread( 
		Image * &image,
 		Image * &preview, 
		QObject *parent,
		transOptions *n_options)
	: proc(image, preview, parent, n_options, thread_preview)
{
}

void Image_ext::prevThread::run( )
{
	proc.run();
}

void Image_ext::prev_finished()
{
	if (preview)
		is_preview = true;
	std::cout << "W prev_finished" << std::endl;
	lock = false;
	if (thread->isFinished())
		delete thread;
	thread = 0;
	std::cout << "Skasowalem watek" << std::endl;
	if (!preview)
		std::cout << "Nie ma obrazka" << std::endl;

	if (preview->isCreated())
	{
		std::cout << "Wysylam sygnal previewed" << std::endl;
		emit previewed(preview);
	}
	else
	{
		std::cout << "Wysylam sygnal previewed(0)" << std::endl;
		emit previewed(0);
	}
}

Image_ext::Image_ext( ) 
{
	image = 0;
	preview = 0;
	thread = 0;
}

QString Image_ext::getPath( ) const
{
	return path;
}

ImageFormat Image_ext::getFormat( ) const
{
	if (image)
		return format;
	else return none;
}

int Image_ext::getWidth( ) const
{
	if (image)
		return width;
	else
		return 0;
}

int Image_ext::getHeight( ) const
{
	if (image)
		return height;
	else return 0;
}

void Image_ext::saveToFile( QString new_path, int quality, ImageFormat format, 			const transOptions &options )
{
	Image orginal;
	orginal.load_from_file(path.toLocal8Bit().constData());
	Image *to_save;
	Image *orginal_p = &orginal;
	process proc(orginal_p, to_save, 0, &options, thread_process);
	proc.run();
	/**
	 * TODO
	 * Dać try-catch z propagowaniem błędów.
	 */
	to_save->save_to_file(new_path.toLocal8Bit().constData(), format, quality);
	delete to_save;
}



