// Free Image Manipulator - a program to massive image manipulation.
// Copyright (C) 2006 Kacper Bielecki
// 
// This program is free software; you can redistribute it and/or modify it 
// under the terms of the GNU General Public License as published by the Free 
// Software Foundation; either version 2 of the License, or (at your option) 
// any later version.
// 
// This program is distributed in the hope that it will be useful, but WITHOUT
// ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or 
// FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public License for 
// more details.
// 
// You should have received a copy of the GNU General Public License along 
// with this program; if not, write to the Free Software Foundation, Inc., 
// 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA
// 
//
// C++ Implementation: images
//
// Description: 
//
//
// Author: Kacper <kazjote@stud.ics.p.lodz.pl>, (C) 2006
//
// Copyright: See COPYING file that comes with this distribution
//
//
#include "images.h"
#include "image_ext.h"



Images::Images(QObject *parent)
	: QObject(parent)
{
	im_iter.first=false;
}


Images::~Images()
{
	for(
			std::vector<Image_ext*>::iterator iter = images.begin();
			iter != images.end();
			iter++
		)
		delete *iter;
}

Image_ext * Images::operator [ ]( const int i )
{
	return images[i];
}

void Images::addRequest( QString filepath )
{
	Image_ext *new_im = new Image_ext;
	if (new_im->open(filepath))
	{
		images.push_back(new_im);
		im_iter.first=false;
		emit added(new_im);
	} 
	else
		delete new_im;
}

void Images::delRequest( int i )
{
	images.erase(images.begin()+i);
	std::cout << "Skasowalem !! " << std::endl;
	im_iter.first=false;
	emit deleted(i);
}

void Images::clear( )
{
	while (images.size() > 0)
	{
		delRequest(0);
	}
	im_iter.first=false;
}

void Images::resetIter( )
{
	im_iter.first=false;
}

Image_ext *Images::getIter( )
{
	if (im_iter.first==false)
	{
		im_iter.second=images.begin();
		im_iter.first=true;
	}
	else
		im_iter.second++;
	
	if (im_iter.second==images.end())
	{ 
		return 0;
	}
	
	std::cout << "IM ITER: " << *(im_iter.second) << std::endl;
	return *(im_iter.second);
}

int Images::count( )
{
	return images.size();
}


