// Free Image Manipulator - a program to massive image manipulation.
// Copyright (C) 2006 Kacper Bielecki
// 
// This program is free software; you can redistribute it and/or modify it 
// under the terms of the GNU General Public License as published by the Free 
// Software Foundation; either version 2 of the License, or (at your option) 
// any later version.
// 
// This program is distributed in the hope that it will be useful, but WITHOUT
// ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or 
// FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public License for 
// more details.
// 
// You should have received a copy of the GNU General Public License along 
// with this program; if not, write to the Free Software Foundation, Inc., 
// 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA
// 
//
// C++ Implementation: preview
//
// Description: 
//
//
// Author: Kacper <kazjote@stud.ics.p.lodz.pl>, (C) 2006
//
// Copyright: See COPYING file that comes with this distribution
//
//
#include "preview.h"
#include <gd.h>
#include <QPainter>
#include <iostream>

preview::preview(QWidget *parent)
	: QFrame(parent), logo(":/logo_big.png", "png")
{
	setFrameStyle(QFrame::Panel | QFrame::Plain);
	image = 0;
}


preview::~preview()
{
}

void preview::paintEvent( QPaintEvent * event )
{
	QFrame::paintEvent( event );
	QPainter painter(this);
	painter.drawImage(QPointF((width()-250)/2, (height()-253)/2), logo);
	if (image)
	{
		unsigned char *rgb;
		int k = 0;
		int max_i = image->sx;
		int max_j = image->sy;
		for(int i = 0; i<max_i; i++)
			for (int j = 0; j<max_j; j++)
			{
				rgb = reinterpret_cast<unsigned char*>(&(k = (gdImageGetPixel(image, i, j))));
				painter.setPen(QColor((int)rgb[2], (int)rgb[1], (int)rgb[0]));
				painter.drawPoint(i+(width()-max_i)/2,j+ (height()-max_j)/2);
			}
	}
}


