//
// C++ Interface: additionalimages
//
// Description: 
//
//
// Author: Kacper <kazjote@stud.ics.p.lodz.pl>, (C) 2006
//
// Copyright: See COPYING file that comes with this distribution
//
//
#ifndef ADDITIONALIMAGES_H
#define ADDITIONALIMAGES_H

#include <vector>

#include <qobject.h>
#include "process.h"

class QComboBox;
class QSpinBox;
class QRadioButton;
class QString;
class QDataStream;

/**
 * Klasa reprezentuje cieki do obrazkw, a take ustawione ich opcje.
 * 
 * Klasa posiada take wskaniki do elementw GUI, a take sloty i sygnay do 
 * porozumiewania si z tymi elementami.
 * 
 * @author Kacper
*/
class additionalImages : public QObject
{
Q_OBJECT
      
private:
   
   // Wskaniki do poszczeglnych elementw GUI
   typedef transOptions::additionalOptions ImagesOptions;
   std::vector<ImagesOptions> images;
   
   QComboBox *imagesCombo;
   QSpinBox *opacitySpin;
   
   QRadioButton *lRadioButton;
   QRadioButton *rRadioButton;
   QRadioButton *tRadioButton;
   QRadioButton *bRadioButton;
   
   QComboBox *widthCombo;
   QComboBox *heightCombo;
   
   QSpinBox *leftPosSpin;
   QSpinBox *rightPosSpin;
   QSpinBox *topPosSpin;
   QSpinBox *bottomPosSpin;
   
   QString lastDir;
   
   bool allowActualisation;
   
public:
    additionalImages(QObject *parent,
                     QComboBox *imagesCombo,
                     QSpinBox *opacitySpin,
   
                     QRadioButton *lRadioButton,
                     QRadioButton *rRadioButton,
                     QRadioButton *tRadioButton,
                     QRadioButton *bRadioButton,
   
                     QComboBox *widthCombo,
                     QComboBox *heightCombo,
                     
                     QSpinBox *leftPosSpin,
                     QSpinBox *rightPosSpin,
                     QSpinBox *topPosSpin,
                     QSpinBox *bottomPosSpin
                    
                    );

    void getOptions( std::vector<transOptions::additionalOptions> &options );
    
    friend QDataStream &operator<<( QDataStream &, additionalImages & );
    friend QDataStream &operator>>( QDataStream &, additionalImages & );
    
    ~additionalImages();

private slots:
   void changeSelection( int pos );
      
public slots:
   
   void addImage();
   void delImage();
   /**
    * Wczytuje ustawienia biecego obrazka z Widgetw.
    */
   void actualizeWithGUI( );
   
};

QDataStream &operator<<( QDataStream &, additionalImages & );

QDataStream &operator>>( QDataStream &, additionalImages & );

#endif
