// Free Image Manipulator - a program to massive image manipulation.
// Copyright (C) 2006 Kacper Bielecki
// 
// This program is free software; you can redistribute it and/or modify it 
// under the terms of the GNU General Public License as published by the Free 
// Software Foundation; either version 2 of the License, or (at your option) 
// any later version.
// 
// This program is distributed in the hope that it will be useful, but WITHOUT
// ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or 
// FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public License for 
// more details.
// 
// You should have received a copy of the GNU General Public License along 
// with this program; if not, write to the Free Software Foundation, Inc., 
// 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA
// 
//
// C++ Interface: image_ext
//
// Description: 
//
//
// Author: Kacper <kazjote@stud.ics.p.lodz.pl>, (C) 2006
//
// Copyright: See COPYING file that comes with this distribution
//
//
#ifndef IMAGE_EXT_H
#define IMAGE_EXT_H



#include <image.h>
#include <QObject>
#include <QThread>
#include "process.h"



class QString;



/**
 * @author Kacper
*/
class Image_ext : public QObject
{
	Q_OBJECT
private:
	Image *image;
	bool is_preview;
	Image *preview;
	bool lock;
	QString path;
	int width, height;
	ImageFormat format;
	
	class prevThread : public QThread
	{
		private:
			process proc;
			
		protected:
			void run();
		public:
			prevThread(Image* &image, 
						  Image* &preview, 
						  QObject *parent, 
						  transOptions *n_options);
} *thread;
	
public:
	
	
	bool open(QString filePath);
	void preview_request(transOptions *options);
	QString getPath() const ; 
	ImageFormat getFormat() const;
	int getWidth() const;
	int getHeight() const;
	
	void saveToFile(QString new_path, int quality, ImageFormat format, const transOptions &options);
	
	Image_ext();
   ~Image_ext();
	
signals:
	void previewed(Image* prev);
	void processed(Image* proc);

public slots:
	void prev_finished();
	
};

#endif
