// Copyright (C) 2005 Javier Amor Garcia

// This program is free software; you can redistribute it and/or
// modify it under the terms of the GNU General Public License
// as published by the Free Software Foundation; either version 2
// of the License, or (at your option) any later version.

// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.

// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.


#ifndef READER_HH
#define READER_HH


#include <time.h>
#include  <boost/thread.hpp>
#include <vector>
class TextSource;
class View;
using namespace boost;


class Reader
{
public:

  Reader ();
  ~Reader();
  
  void setView (View *v);
  
  void addSource(TextSource *source);
  void switchSource(bool forward=true);
  

  void startRead();
  void stopRead();
  void switchReadState();

  bool getReading();
  
  void rewind(int elements);
  void forward(int elements);
  void seek(int elements);

  bool readElement();
  
  void increaseSpeed(unsigned int dwpm);
  void decreaseSpeed(unsigned int dwpm);
  void setSpeed(unsigned int wpm);
  unsigned int getSpeed();
  const struct timespec* getPeriod();
  

private:  
  
  void setPeriod();
  void showText();
  
  
  std::vector<TextSource*> sources;
  int sourceIndex;
  

  View *view;

  struct timespec period;
  unsigned int wpm;
  bool reading;
  thread* showTextThread;
  
};





#endif
