// Copyright (C) 2005 Javier Amor Garcia

// This program is free software; you can redistribute it and/or
// modify it under the terms of the GNU General Public License
// as published by the Free Software Foundation; either version 2
// of the License, or (at your option) any later version.

// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.

// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.


#include "Screen.hh"
#include "DataWindow.hh"
#include "StatusWindow.hh"
#include "ControlWindow.hh"
#include "Window.hh"
#include <assert.h>
#include <stdio.h>


Screen::Screen() 
{

  initCurses();


  status = new StatusWindow(COLS-1, 0, 0);
  data = new DataWindow(5, COLS-1, LINES/2-1, 0);  


}


void Screen::initCurses()
{
  SCREEN *term = NULL;	/* for newterm() */
  FILE *fd_in=NULL, *fd_out=NULL;
  char *tty = NULL;	/* name (path) of current tty */
  /* setting up ncurses to use terminal directly so stdin doesn't mess with key handling */
  
    tty = ttyname(1);
    if (!tty) {
	exit (3);
    }
    fd_in = fopen(tty, "r");
    if (!fd_in) {
	exit (3);
    }
    fd_out = fopen(tty, "w");
    if (!fd_out) {
	exit (3);
    }
    term = newterm(NULL, fd_out, fd_in);	/* initscr normally calls this, so initscr is not needed ! */
    set_term(term);

    cbreak();			/* Line buffering disabled, Pass on
				 * everty thing to me 		*/
  keypad(stdscr, TRUE);	
  noecho();
  curs_set(0);
  

  refresh();        
  
}


Screen::~Screen()
{
  delete data;
  //  delete controls;
  delete status;
  
  endwin();
}




void Screen::displayTextData(char *text)
{
  
  data->displayText(text);
}

void Screen::displayFilename(char *name)
{
  
  status->setFilename(name);
}

void Screen::displayPosition(pair<int,int> pos)
{
  status->setPosition(pos);
  
}

void Screen::displaySpeed(int wpm)
{
  assert(wpm >= 0);
  assert (status != NULL);
  
  status->setSpeed(wpm);
  
}
