// Copyright (C) 2005 Javier Amor Garcia

// This program is free software; you can redistribute it and/or
// modify it under the terms of the GNU General Public License
// as published by the Free Software Foundation; either version 2
// of the License, or (at your option) any later version.

// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.

// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.


#include "StatusWindow.hh"
//XXX quitar stdio.h
#include <stdio.h>
#include <assert.h>





StatusWindow::StatusWindow(int width, int starty, int startx) :  Window(4,  width,  starty,  startx)
{
  
}


void StatusWindow::setFilename(string filename)
{
  clearLine(TITLE_LINE);
  displayHorizontalCenteredText (TITLE_LINE,  (char*) filename.c_str());
}

void StatusWindow::setSpeed(int speed)
{
  const int X_OR = COLS -PERCENT_DIGITS -SPEED_DIGITS -5 -3;
  string text = "WPM: " + smallint2str(speed, SPEED_DIGITS);
  displayText (INFO_LINE, X_OR,  "          ");   
  displayText (INFO_LINE, X_OR,  (char*) text.c_str());
}



void StatusWindow::setPosition(pair<int,int> pos)
{
  const int X_OR = COLS -PERCENT_DIGITS -3;
  assert (pos.first <= pos.second);
  int percent;
  if (pos.second != 0)
    percent  = (pos.first*100)/pos.second;
  else
    percent=100;
  
  assert(percent>=0 && percent <= 100);
  string text = smallint2str(percent, PERCENT_DIGITS) + "%%";
  
  
  displayText (INFO_LINE, X_OR,  "     ");   //N WHITESPACEs = PERCENT_DIGITS+1
  displayText (INFO_LINE, X_OR,  (char*) text.c_str());
    
}

string StatusWindow::smallint2str (int num, int digits)
{
  char buf[digits+1];
  snprintf(buf, digits+1, "%u", num);
  return string(buf);
}
