// Copyright (C) 2005 Javier Amor Garcia

// This program is free software; you can redistribute it and/or
// modify it under the terms of the GNU General Public License
// as published by the Free Software Foundation; either version 2
// of the License, or (at your option) any later version.

// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.

// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.


#ifndef STATUSWINDOW_HH
#define STATUSWINDOW_HH

#include "Window.hh"
#include <curses.h>
#include <string>
#include <utility>
using namespace std;


class StatusWindow : public  Window
{
public:
  StatusWindow(int width, int starty, int startx);
  void setFilename(string filename);
  void setPosition(pair<int,int> pos);
  void setSpeed(int speed);
  

private:
  string smallint2str (int num, int digits);
  
  static const int PERCENT_DIGITS=4;
  static const int SPEED_DIGITS=5;
  static const int TITLE_LINE=1;
  static const int INFO_LINE=2;
  

  
};


#endif
