// Copyright (C) 2005 Javier Amor Garcia

// This program is free software; you can redistribute it and/or
// modify it under the terms of the GNU General Public License
// as published by the Free Software Foundation; either version 2
// of the License, or (at your option) any later version.

// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.

// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.



#include "Reader.hh"
#include <string>
#include <vector>
#include <utility>
#include <time.h>
#include "DummyView.hh"
#include <boost/tuple/tuple.hpp>
#include <boost/test/unit_test.hpp>

using namespace std;
using namespace boost;
using namespace boost::unit_test;

namespace TestReader
{
  


  void tcSetWpm()
  {
    const int MAX_RANGE = 999999999;
    DummyView view;
    
    vector<pair<unsigned int, long> > speedAndPeriods;
    
    speedAndPeriods.push_back(pair<unsigned int, long>(150, 400000000));
    speedAndPeriods.push_back(pair<unsigned int, long>(300, 200000000));
    speedAndPeriods.push_back(pair<unsigned int, long>(600, 100000000));
    speedAndPeriods.push_back(pair<unsigned int, long>(1200, 50000000));
    speedAndPeriods.push_back(pair<unsigned int, long>(50, 1200000000));
    speedAndPeriods.push_back(pair<unsigned int, long>(1, MAX_RANGE)); //overflow
    speedAndPeriods.push_back(pair<unsigned int, long>(2, MAX_RANGE)); //overflow
    speedAndPeriods.push_back(pair<unsigned int, long>(0, MAX_RANGE)); //overflow
    
    Reader r;
    r.setView((View*) &view);
    
    for (int i =0; i < speedAndPeriods.size(); i++)
      {
	pair<unsigned int, long> sp = speedAndPeriods[i];
	r.setSpeed(sp.first);
	BOOST_CHECK_EQUAL(sp.second, r.getPeriod()->tv_nsec);
      }
  }
    

  void tcIncreaseAndDecreaseWpm()
  {
    const int MAX_RANGE = 999999999;
    DummyView view;
    
    vector<boost::tuple<bool, unsigned int, long> > commandAndPeriods; // increase?, quantity, awaited period
    
    
    commandAndPeriods.push_back(tuple<bool, unsigned int, long>(false, 50,   600000000));  //wpm = 100
    commandAndPeriods.push_back(tuple<bool, unsigned int, long>(false, 50,  1200000000));  //wpm = 50
    commandAndPeriods.push_back(tuple<bool, unsigned int, long>(false, 50,  MAX_RANGE));  //wpm = 0
    commandAndPeriods.push_back(tuple<bool, unsigned int, long>(false, 50,  MAX_RANGE));  //wpm = 0
    commandAndPeriods.push_back(tuple<bool, unsigned int, long>(false, 1,  MAX_RANGE));  //wpm = 0
    commandAndPeriods.push_back(tuple<bool, unsigned int, long>(true, 50,  1200000000));  //wpm = 50
    commandAndPeriods.push_back(tuple<bool, unsigned int, long>(true, 50,   600000000));  //wpm = 100  
    

    Reader r;
    r.setView((View*) &view);
    r.setSpeed(150);
    
    for (int i =0; i < commandAndPeriods.size(); i++)
      {
	tuple<bool,unsigned int, long > cp = commandAndPeriods[i];
	if (cp.get<0>())
	  r.increaseSpeed(cp.get<1>());
	else
	  r.decreaseSpeed(cp.get<1>());
	BOOST_CHECK_EQUAL(cp.get<2>(), r.getPeriod()->tv_nsec);
      }
  }

  test_suite* suite()
  {
    test_suite* test= BOOST_TEST_SUITE( "Reader class test" );
    test->add(BOOST_TEST_CASE(&TestReader::tcSetWpm));
    test->add(BOOST_TEST_CASE(&TestReader::tcIncreaseAndDecreaseWpm));
    return test;
  }
  
}

    


  

  

