// Copyright (C) 2005 Javier Amor Garcia

// This program is free software; you can redistribute it and/or
// modify it under the terms of the GNU General Public License
// as published by the Free Software Foundation; either version 2
// of the License, or (at your option) any later version.

// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.

// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.



#include "FileTextSource.hh"
#include <string>
#include <vector>
using namespace std;
#include <boost/test/unit_test.hpp>
using namespace boost::unit_test;




namespace TestTextSource
{
  

    void tcReadElement()
    {
      vector<string> elements;
      elements.push_back(string("uno"));
      elements.push_back(string("dos"));
      elements.push_back(string("tres;"));
      elements.push_back(string("cuatro"));
      elements.push_back(string("cinco,"));
      elements.push_back(string("seis"));
      elements.push_back(string("siete:"));
      elements.push_back(string("ocho."));
      elements.push_back(string("nueve"));
      elements.push_back(string("EOF")); //this last element is program generated


      FileTextSource ts("testdata.txt");

      

      for (int i=0; i < elements.size(); i++)  
	{
	  string awaited = elements[i] + "|";
	  string getted = ts.readElement() + "|";
	  BOOST_CHECK_EQUAL(awaited, getted);
	  
	}
      
    }
    

  test_suite* suite()
  {
    test_suite* test= BOOST_TEST_SUITE( "TextSource class test" );
    test->add(BOOST_TEST_CASE(&TestTextSource::tcReadElement));
    return test;
  }

    
}


