// Copyright (C) 2005 Javier Amor Garcia

// This program is free software; you can redistribute it and/or
// modify it under the terms of the GNU General Public License
// as published by the Free Software Foundation; either version 2
// of the License, or (at your option) any later version.

// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.

// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.


#ifndef TEXTSOURCE_HH
#define TEXTSOURCE_HH

#include <string>
#include <fstream>
#include <iostream>
#include <vector>
#include <utility>
#include <boost/thread.hpp>
#include <boost/bind.hpp>

using namespace std;

class TextSource
{
public:

  TextSource (string sourcename);
  virtual ~TextSource();
  
  std::string  readElement();
  void rewind(int elements);
  void forward(int elements);
  void seek (int elements);

  const std::string getName();
  pair<int,int> getPosition();

  bool getFullyReaded();

protected:
  
  void startReadAhead();
  virtual string getTextLine()=0;
  virtual bool eof()=0;
  virtual bool bad()=0;
  

private:

  void readAhead();
  bool parseLine();  

  std::istream* inputStream;
  
  int elementsIndex;
  std::vector<std::string> elements;
  
  const std::string name;
  bool fullyReaded;
  
  
  boost::thread* readAheadThread;
  

  static const std::string delims;
  static const std::string noPrintableDelims;
  
  
};


#endif
