// Copyright (C) 2005 Javier Amor Garcia

// This program is free software; you can redistribute it and/or
// modify it under the terms of the GNU General Public License
// as published by the Free Software Foundation; either version 2
// of the License, or (at your option) any later version.

// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.

// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.


#ifndef WINDOW_HH
#define WINDOW_HH

#include <curses.h>
#include <boost/tuple/tuple.hpp>

using namespace boost;

typedef boost::tuple<short int,short int,short int> colorType;


class Window
{
public:
  Window(int height, int width, int starty, int startx);
  //  ~window();

  protected:
  void refresh();
  void displayText (int y, int x, char *text);  
  void clearCurrentLine();

  //XXX Centered?? is an english word?? if not change it
  void displayVerticalCenteredText(int x, char *text);  
  void displayHorizontalCenteredText(int y, char *text);
  void displayCenteredText(char *text);  

  void clearLine(int y);
  void clearCentralLine();

  
  int getHeight();
  int getWidth();
  int getStartX();
  int getStartY();
  
  

private:

  void setColor();
  
  WINDOW *win;
  int height, width;
  int startx, starty;
  int mediumX, mediumY;
   
};


#endif
