/* 
   Copyright (C) 2009, 2010, 2011 German A. Arias <german@xelalug.org>

   This file is part of FísicaLab application

   FísicaLab is free software; you can redistribute it and/or
   modify it under the terms of the GNU General Public
   License as published by the Free Software Foundation; either
   version 3 of the License, or (at your option) any later version.
 
   This application is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   Library General Public License for more details.
 
   You should have received a copy of the GNU General Public
   License along with this library; if not, write to the Free
   Software Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111 USA.
*/

#import <AppKit/AppKit.h>
#import <Renaissance/Renaissance.h>
#import "MIInformacion.h"
#import "MIPizarra.h"

@interface MIPizarra (Private)
- (BOOL) validacion: (int) codigo;
@end

@implementation MIPizarra (Private)
- (BOOL) validacion: (int) codigo
{
BOOL desicion ;

if (objetos == -1)
     {
     objetos = floor(codigo/50) ;
     desicion = YES ;
     }
else
     {
          if(objetos == floor(codigo/50))
          {
          desicion = YES ;
          } 
          else
          {
          desicion = NO ;
          }
     }
return desicion ;     
}
@end

@implementation MIPizarra

-(void) drawRect: (NSRect) frame
{
    NSBezierPath *marco = [NSBezierPath bezierPathWithRect: [self bounds]];
    [[NSColor blackColor] set];
    [marco fill];
}   

- (void) nuevoObjeto: (id)sender
{
  /* insert your code here */
  moveObjeto = NO ;
  imagenIcono = nil;
  [[NSCursor arrowCursor] set] ;
  BOOL permiso ;
  
  permiso = [self validacion: [sender tag]] ;
  
  if (permiso)
    {  
      [[NSCursor openHandCursor] set] ; 
      imagenIcono = [sender image] ;
      codigoObjeto = [sender tag] ;
      newObjeto = YES ;
    }
}

- (void) calcular: (id) sender
{
  newObjeto = NO;
  moveObjeto = NO;
  imagenIcono = nil;
  [[NSCursor arrowCursor] set] ;
  [informacion calcular: self] ;
}

- (int) codigo: (id)sender
{
  return objetos ;
}

- (void) limpiar: (id)sender
{
  /* insert your code here */
  newObjeto = NO;
  moveObjeto = NO;
  imagenIcono = nil;
  [[NSCursor arrowCursor] set] ;
  int x ;
  int cantidad = [[self subviews] count] ;
  
  for (x = 0; x <= cantidad - 1; x = x + 1)
  {
  [[[self subviews] objectAtIndex: x ] setImage: nil] ;
  [[[self subviews] objectAtIndex: x ] setTag: 0] ;
  } 
  
  [self setNeedsDisplay: YES] ;
  [informacion borrarObjetos: YES] ;
  objetos = -1 ;
  conteo = 0 ;
}


- (void)clicCell: (id) sender
{
int key = [[[self window] currentEvent ] modifierFlags] ;

 if ((newObjeto) && ([sender image] == nil))
   {
     [sender setImage: imagenIcono] ;
     [[NSCursor arrowCursor] set] ;
     [sender setTag: codigoObjeto] ;
     [informacion agregarObjeto: sender] ;
     conteo = conteo + 1 ;
     newObjeto = NO ; 
     imagenIcono = nil;
   }
 else
   {
     if ((moveObjeto) && ([sender image] == nil))
       {
	 [sender setImage: imagenIcono] ;
	 [[NSCursor arrowCursor] set] ;
	 [sender setTag: codigoObjeto] ;
	 moveObjeto = NO ; 
	 imagenIcono = nil;
       }
     else
       {        
	 if ((key == NSControlKeyMask) && ([sender image] != nil) && (imagenIcono == nil))
	   {
	     imagenIcono = [sender image] ;
	     codigoObjeto = [sender tag] ;
	     [sender setImage: nil] ;
	     [sender setTag: 0] ;
	     //  [[NSCursor pointingHandCursor] set] ;
	     [[NSCursor closedHandCursor] set] ;
	     moveObjeto = YES ;
	   }
	 else
	   {
	     if ((key == NSShiftKeyMask) && ([sender image] != nil) && (imagenIcono == nil))
	       {
		 [sender setImage: nil] ;
		 [informacion borrarObjeto: [sender tag]] ;
		 [sender setTag: 0] ;
		 conteo = conteo - 1 ;
		 if (conteo == 0)
		   {
		     objetos = -1 ;
		   }
	       }
	   }
       }
   }

 if ((!newObjeto) && ([sender image] != nil))
   {
     [informacion selecObjeto: [sender tag]] ;
   }
}

- (void) controlCursor: (id) sender
{
  newObjeto = NO;
  moveObjeto = NO;
  imagenIcono = nil;
  [[NSCursor arrowCursor] set] ;
  
  if (conteo == 0)
    {
      objetos = -1 ;
    }
}

- (void) awakeFromGSMarkup
{
    double ancho, alto, x, y ;
    ancho = 26 ;
    alto = 18 ;
    NSButton *botonCell ;
       
    for(y = 1; y <= alto; y = y + 1)
    {
        for(x = 0; x < ancho; x = x + 1)
        {
        botonCell = [[NSButton alloc] initWithFrame: NSMakeRect(x*50, 900 - y*50, 50, 50)] ;  
        [botonCell setTarget: self] ;
        [botonCell setAction: @selector(clicCell:)] ;
	[botonCell setTitle: @""] ;
        [botonCell setImagePosition: NSImageOnly] ;
        [botonCell setBordered: NO] ;
        [self addSubview: botonCell] ; 
        RELEASE(botonCell) ; 
        }
    } 
    moveObjeto = NO ;
    
    objetos = -1 ;
    conteo = 0 ;
}

@end
