/* 
   Copyright (C) 2009, 2010, 2011 German A. Arias <german@xelalug.org>

   This file is part of FísicaLab application

   FísicaLab is free software; you can redistribute it and/or
   modify it under the terms of the GNU General Public
   License as published by the Free Software Foundation; either
   version 3 of the License, or (at your option) any later version.
 
   This application is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   Library General Public License for more details.
 
   You should have received a copy of the GNU General Public
   License along with this library; if not, write to the Free
   Software Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111 USA.
*/

#import <AppKit/AppKit.h>
#import <Renaissance/Renaissance.h>
#import "controlAyuda.h"

@implementation controlAyuda

- (void) awakeFromGSMarkup
{
  [[tabla window] center];
  carpeta = [NSBundle mainBundle] ;
  [texto readRTFDFromFile: [carpeta pathForResource: @"bienvenida" ofType: @"rtfd"]] ;
  [tabla selectRow: 0 byExtendingSelection: NO];
}

- (void) outlineViewSelectionDidChange: (NSNotification*)aNotification
{
  id item = [[aNotification object] itemAtRow: [[aNotification object] selectedRow]];

  if ([item isEqual: _(@"Bienvenida e Introduccion")])
    {
      [texto readRTFDFromFile: [carpeta pathForResource: @"bienvenida" ofType: @"rtfd"]] ;
    }
  else if ([item isEqual: _(@"Cinematica lineal de particulas")])
    {
      [texto readRTFDFromFile: [carpeta pathForResource: @"mod_cinema" ofType: @"rtfd"]] ;
    }
  else if ([item isEqual: _(@"Ejemplos de Cinematica lineal")])
    {
      [texto readRTFDFromFile: [carpeta pathForResource: @"ejem_mod_cinema" ofType: @"rtfd"]] ;
    }
  else if ([item isEqual: _(@"Cinematica del movimiento circular de particulas")])
    {
      [texto readRTFDFromFile: [carpeta pathForResource: @"mod_cinema_circ" ofType: @"rtfd"]] ;
    }
  else if ([item isEqual: _(@"Ejemplos de Cinematica del movimiento circular")])
    {
      [texto readRTFDFromFile: [carpeta pathForResource: @"ejem_mod_cinema_circ" ofType: @"rtfd"]] ;
    }
  else if ([item isEqual: _(@"Estatica de particulas")])
    {
      [texto readRTFDFromFile: [carpeta pathForResource: @"mod_estat" ofType: @"rtfd"]] ;
    }
  else if ([item isEqual: _(@"Ejemplos de Estatica de particulas")])
    {
      [texto readRTFDFromFile: [carpeta pathForResource: @"ejem_mod_estat" ofType: @"rtfd"]] ;
    }
  else if ([item isEqual: _(@"Estatica de cuerpos rigidos")])
      {
        [texto readRTFDFromFile: [carpeta pathForResource: @"mod_estat_rig" ofType: @"rtfd"]] ;
      }
  else if ([item isEqual: _(@"Ejemplos de Estatica de cuerpos rigidos")])
    {
      [texto readRTFDFromFile: [carpeta pathForResource: @"ejem_mod_estat_rig" ofType: @"rtfd"]] ;
    }
  else if ([item isEqual: _(@"Dinamica lineal de particulas")])
    {
      [texto readRTFDFromFile: [carpeta pathForResource: @"mod_dinami" ofType: @"rtfd"]] ;
    }
  else if ([item isEqual: _(@"Ejemplos de Dinamica lineal")])
    {
      [texto readRTFDFromFile: [carpeta pathForResource: @"ejem_mod_dinami" ofType: @"rtfd"]] ;
    }
  else if ([item isEqual: _(@"Dilatacion, gases ideales y calorimetria")])
    {
      [texto readRTFDFromFile: [carpeta pathForResource: @"mod_cal_gas" ofType: @"rtfd"]] ;
    }
  else if ([item isEqual: _(@"Ejemplos de Dilatacion, gases ...")])
    {
      [texto readRTFDFromFile: [carpeta pathForResource: @"ejem_mod_cal_gas" ofType: @"rtfd"]] ;
    }
  else if ([item isEqual: _(@"GNU Free Documentation License")])
    {
      [texto readRTFDFromFile: [carpeta pathForResource: @"COPYING" ofType: @"rtfd"]] ;
    }

  [texto scrollPoint: NSMakePoint(0.0,0.0)];
}

- (id) outlineView: (NSOutlineView*)outlineView child: (int)index ofItem: (id)item
{
  if ([item isEqual: _(@"Cinematica")])
    {
      switch(index)
	{
	case 0:
	  return _(@"Cinematica lineal de particulas");
	case 1:
	  return _(@"Ejemplos de Cinematica lineal");
	case 2:
	  return _(@"Cinematica del movimiento circular de particulas");
	case 3:
	  return _(@"Ejemplos de Cinematica del movimiento circular");
	default:
	  break;
	}
    }
  else if ([item isEqual: _(@"Estatica")])
    {
      switch(index)
	{
	case 0:
	  return _(@"Estatica de particulas");
	case 1:
	  return _(@"Ejemplos de Estatica de particulas");
	case 2:
	  return _(@"Estatica de cuerpos rigidos");
	case 3:
	  return _(@"Ejemplos de Estatica de cuerpos rigidos");
	default:
	  break;
	}
    }
  else if ([item isEqual: _(@"Dinamica")])
    {
      switch(index)
	{
	case 0:
	  return _(@"Dinamica lineal de particulas");
	case 1:
	  return _(@"Ejemplos de Dinamica lineal");
	default:
	  break;
	}
    }
  else if ([item isEqual: _(@"Termodinamica")])
    {
      switch(index)
	{
	case 0:
	  return _(@"Dilatacion, gases ideales y calorimetria");
	case 1:
	  return _(@"Ejemplos de Dilatacion, gases ...");
	default:
	  break;
	}
    }
  else if (item == nil && index == 0)
    {
      return _(@"Bienvenida e Introduccion");
    }
  else if (item == nil && index == 1)
    {
      return _(@"Cinematica");
    }
  else if (item == nil && index == 2)
    {
      return _(@"Estatica");
    }
  else if (item == nil && index == 3)
    {
      return _(@"Dinamica");
    }
  else if (item == nil && index == 4)
    {
      return _(@"Termodinamica");
    }
  else if (item == nil && index == 5)
    {
      return _(@"GNU Free Documentation License");
    }

  return nil;
}

- (BOOL) outlineView: (NSOutlineView*)outlineView isItemExpandable: (id)item
{
  if ([item isEqual: _(@"Cinematica")] ||
      [item isEqual: _(@"Estatica")] ||
      [item isEqual: _(@"Dinamica")] ||
      [item isEqual: _(@"Termodinamica")])
    {
      return YES;
    }
  
  return NO;
}

- (int) outlineView: (NSOutlineView*)outlineView numberOfChildrenOfItem: (id)item
{
  if (item == nil)
    {
      return 6;
    }
  else if ([item isEqual: _(@"Cinematica")])
    {
      return 4;
    }
  else if ([item isEqual: _(@"Estatica")])
    {
      return 4;
    }
  else if ([item isEqual: _(@"Dinamica")])
    {
      return 2;
    }
  else if ([item isEqual: _(@"Termodinamica")])
    {
      return 2;
    }
  
  return 0;
}

- (id) outlineView: (NSOutlineView*)outlineView objectValueForTableColumn: (NSTableColumn*)tableColumn byItem: (id)item
{
  return item;  
}

- (void) dealloc
{
RELEASE(carpeta) ;
[super dealloc] ;
}

@end
