/* 
   Copyright (C) 2009 German A. Arias <german@xelalug.org>

   This file is part of FísicaLab application

   FísicaLab is free software; you can redistribute it and/or
   modify it under the terms of the GNU General Public
   License as published by the Free Software Foundation; either
   version 3 of the License, or (at your option) any later version.
 
   This application is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   Library General Public License for more details.
 
   You should have received a copy of the GNU General Public
   License along with this library; if not, write to the Free
   Software Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111 USA.
*/

#include <AppKit/AppKit.h>
#include "MIPizarra.h"

@implementation MIPizarra

-(void) drawRect: (NSRect) frame
{
    NSBezierPath *marco = [NSBezierPath bezierPathWithRect: [self bounds]];
    [[NSColor blackColor] set];
    [marco fill];
}   

- (void) nuevoObjeto: (id)sender
{
  /* insert your code here */
BOOL permiso ;

permiso = [self validacion: [sender tag]] ;

if (permiso)
    {  
    [[NSCursor openHandCursor] set] ; 
    imagenIcono = [sender image] ;
    codigoObjeto = [sender tag] ;
    newObjeto = YES ;
    }
    
}

- (BOOL) validacion: (int) codigo
{
BOOL desicion ;

if (objetos == -1)
     {
     objetos = floor(codigo/50) ;
     desicion = YES ;
     }
else
     {
          if(objetos == floor(codigo/50))
          {
          desicion = YES ;
          } 
          else
          {
          desicion = NO ;
          }
     }
return desicion ;     
}

- (void) calcular: (id) sender
{
[informacion calcular: self] ;
}

- (int) codigo: (id)sender
{
return objetos ;
}

- (void) limpiar: (id)sender
{
  /* insert your code here */
  int x ;
  int cantidad = [[self subviews] count] ;
  
  for (x = 0; x <= cantidad - 1; x = x + 1)
  {
  [[[self subviews] objectAtIndex: x ] setImage: nil] ;
  [[[self subviews] objectAtIndex: x ] setTag: 0] ;
  } 
  
  [self setNeedsDisplay: YES] ;
  [informacion borrarObjetos: YES] ;
  objetos = -1 ;
  conteo = 0 ;
}


-(void)clicCell: (id) sender
{
int key = [ [[self window] currentEvent ] modifierFlags] ;

if ((newObjeto) && ([sender image] == nil))
    {
    [sender setImage: imagenIcono] ;
    [[NSCursor arrowCursor] set] ;
    [sender setTag: codigoObjeto] ;
    [informacion agregarObjeto: sender] ;
    conteo = conteo + 1 ;
    newObjeto = NO ; 
    }
if ((moveObjeto) && ([sender image] == nil))
    {
    [sender setImage: imagenIcono] ;
    [[NSCursor arrowCursor] set] ;
    [sender setTag: codigoObjeto] ;
    moveObjeto = NO ; 
    }        
if ((key == NSControlKeyMask) && ([sender image] != nil))
    {
    imagenIcono = [sender image] ;
    codigoObjeto = [sender tag] ;
    [sender setImage: nil] ;
    [sender setTag: 0] ;
//    [[NSCursor pointingHandCursor] set] ;
    [[NSCursor closedHandCursor] set] ;
    moveObjeto = YES ;
    }
if ((key == NSShiftKeyMask) && ([sender image] != nil))
    {
    [sender setImage: nil] ;
    [informacion borrarObjeto: [sender tag]] ;
    [sender setTag: 0] ;
    conteo = conteo - 1 ;
    if (conteo == 0)
       {
       objetos = -1 ;
       }
    }
if ((!newObjeto) && ([sender image] != nil))
    {
    [informacion selecObjeto: [sender tag]] ;
    }
}

- (void) awakeFromNib
{
    double ancho, alto, x, y ;
    ancho = 16 ;
    alto = 13 ;
    NSButton *botonCell ;
       
    for(y = 1; y <= alto; y = y + 1)
    {
        for(x = 0; x < ancho; x = x + 1)
        {
        botonCell = [[NSButton alloc] initWithFrame: NSMakeRect(x*50, 650 - y*50, 50, 50)] ;  
        [botonCell setTarget: self] ;
        [botonCell setAction: @selector(clicCell:)] ;
        [botonCell setImagePosition: NSImageOnly] ;
        [botonCell setBordered: NO] ;
        [botonCell setKeyEquivalentModifierMask: NSCommandKeyMask] ;
        [self addSubview: botonCell] ; 
        RELEASE(botonCell) ; 
        }
    } 
    moveObjeto = NO ;
    
    objetos = -1 ;
    conteo = 0 ;
}

@end
