/*
 * Fisoco, a FInding SOrting and COnverting free software
 * Copyright 2015 Félicien PILLOT <felicien.pillot@member.fsf.org>
 *
 * This file is part of Fisoco.
 *
 * Fisoco is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * Fisoco is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with Fisoco.  If not, see <http://www.gnu.org/licenses/>.
 *
 *//////////////////////////////////////
/****************
 *    gui.h     *
 *    ~~~~~~    *
 ****************/

#ifndef GTKMM_GUI_H
#define GTKMM_GUI_H

#if HAVE_CONFIG_H
#  include <config.h>
#endif /* HAVE_CONFIG_H */
#if HAVE_UNISTD_H
#  include <unistd.h>
#endif /* HAVE_UNISTD_H */
#include <iostream>
#include <gtkmm/window.h>
#include <gtkmm/box.h>
#include <gtkmm/button.h>
#include <gtkmm/colorbutton.h>
#include <gtkmm/buttonbox.h>
#include <gtkmm/menubar.h>
#include <gtkmm/builder.h>
#include <gtkmm/progressbar.h>
#include <gtkmm/scrolledwindow.h>
#include <gtkmm/treemodel.h>
#include <gtkmm/treemodelcolumn.h>
#include <gtkmm/treeview.h>
#include <gtkmm/treestore.h>
#include <gtkmm/textview.h>
#include <giomm/simpleaction.h>
#include <giomm/simpleactiongroup.h>
#include <glibmm/dispatcher.h>
#include <glibmm/threads.h>
#include "search.h"
// i18n
#include "../include/gettext.h"

class Gui : public Gtk::Window
{
public:
  Gui ();

  // Called from the worker thread.
  void notify ();
  void notify (std::list<std::string> founded_files, std::string founded_dir);
  void error_dialog (std::string message);

private:

  /* Menubar function */
  void init_menubar ();
  
  /* Signal handlers */
  void menu_add_device ();
  void menu_manual ();
  void menu_about ();
  void menu_quit ();
  void on_treeview_row_activated (const Gtk::TreeModel::Path& path,
			    Gtk::TreeViewColumn* column);
  void selected_row_callback (const Gtk::TreeModel::iterator& iter);
  void on_start_button_clicked ();
  void on_stop_button_clicked ();
  void on_quit_button_clicked ();
  void update_start_stop_buttons ();
  void clean_results ();
  void update_results ();

  // Dispatcher handler.
  void on_notification_from_worker_thread ();

    // Tree model column
  class ModelColumns : public Gtk::TreeModelColumnRecord {
  public:
    ModelColumns ()
    {
      add(m_col_id);
      add(m_col_type);
      add(m_col_name);
    }
    
    Gtk::TreeModelColumn<int> m_col_id;
    Gtk::TreeModelColumn<Glib::ustring> m_col_type;
    Gtk::TreeModelColumn<Glib::ustring> m_col_name;
  };
  
  ModelColumns gui_columns;
  
  // Member data.
  Gtk::Box gui_VBox;
  Gtk::ButtonBox gui_ButtonBox, gui_search_button_box;
  Gtk::ColorButton gui_ButtonQuit;
  Gtk::Button gui_search_button, cancel_button_;
  Gtk::ProgressBar gui_ProgressBar;
  Gtk::TreeView gui_TreeView;
  Glib::RefPtr<Gtk::TreeStore> gui_refTreeModel;
  Gtk::ScrolledWindow gui_ScrolledWindow;
  Gtk::TextView gui_TextView;
  Gtk::Label gui_text_top;
  Gtk::Entry gui_search_entry, gui_set_location_entry;

  Glib::RefPtr<Gtk::Builder> m_refBuilder;
  Glib::RefPtr<Gio::SimpleActionGroup> refActionGroup;
  Glib::RefPtr<Gio::Menu> gmenu;
  Gtk::MenuBar* menubar;

  std::list<std::string> Rfiles;
  std::string Rdir;

  Glib::Dispatcher gui_Dispatcher;
  Search gui_Worker;
  Glib::Threads::Thread* gui_WorkerThread;
};

#endif // GTKMM_GUI_H
